/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: e2864039-62f4-4d9d-aac4-4e76e566f321
 *
 */

#include "ConfigWGetSource.h"
#include <iostream>
#include <stdexcept>
#include <getopt++/GetOption.h>
#include <getopt++/StringOption.h>
#include <getopt++/BoolOption.h>
#include <cassert>
#include <fstream>


using namespace std;


ConfigWGetSource::ConfigWGetSource(string const &aUrl) : theUrl(aUrl) , decompress()
{
    if (theUrl.find("http://") != 0 &&
        theUrl.find("ftp://") != 0)
      throw new runtime_error("Unsupported url for ConfigWGetSource " + theUrl);
    
    if (theUrl.find("http://") == 0) {
        scheme = "http://";
        urlPart = theUrl.substr(7);
    } else if (theUrl.find("ftp:/") == 0) {
        scheme = "ftp://";
        urlPart = theUrl.substr(6);
    }

    if (theUrl.rfind(".bz2") == theUrl.size() - 4)
      decompress = "bunzip2 -d -c";
    else if (theUrl.rfind(".gz") == theUrl.size() - 3)
      decompress = "gunzip -d -c";
    else if (theUrl.rfind(".tar") == theUrl.size() -4)
      decompress = "cat";
}

string
ConfigWGetSource::url(bool const &stripScheme) const
{
    return (stripScheme ? "" : scheme) + urlPart;
}

void

ConfigWGetSource::get
    (string const &where) const throw(exception *)
{
    // grab the file. extract to a temp dir. move the first dir in the temp dir to the final location.
  // will silently fail on tarballs that have more than one directory root in the tar.
  // but as this isn't made for arbitrary Do The Right Thing, that isn't an issue today.

    string command = "cd `dirname " + where + "` && mkdir ,,cm-working && cd ,,cm-working &&  wget -O ,,cm-extract " + theUrl + " && " + decompress + " ,,cm-extract | tar x && rm ,,cm-extract";
    command += " && mv * ../`basename " + where + "` && cd .. && rmdir ,,cm-working";

    run (command, "wget");
}

void

ConfigWGetSource::update
    (string const &where) const throw(exception *)
{
    cout << "ConfigWGetSource::update: cannot update a tarball grabbed project at this point: suggestions on appropriate behaviour are solicated" << endl;
}

int 
ConfigWGetSource::changes
    (string const &where) const throw(exception *)
{
    cout << "ConfigWGetSource::changes: cannot get changes against a tarball grabbed project at this point: suggestions on appropriate behaviour are solicated." << endl;
    return 2;
}

int 
ConfigWGetSource::missing
    (string const &where) const throw(exception *)
{
    cout << "ConfigWGetSource::missing: cannot get missing against a tarball grabbed project at this point: suggestions on appropriate behaviour are solicated." << endl;
    return 2;
}


string
ConfigWGetSource::treeVersion(string const &where) const
{
  if (Verbose())
        cout << "getting treeVersion for URL at " << where << endl;

  return theUrl;
}

void
ConfigWGetSource::ignore (ConfigSource const *, string const &where) const throw (std::exception *)
{
}
