/*  2004-2007  Yap Chun Wei <yapchunwei@users.sourceforge.net>
 *       2011 Jonathan Alvarsson <jonalv@users.sourceforge.net>
 *
 *  Contact: cdk-devel@lists.sourceforge.net
 *
 *  The content of this file is released as public domain.
 */
package org.openscience.cdk.fingerprint;


/**
 * SMARTS based substructure fingerprint based on <b>Chemical substructures
 * that enrich for biological activity</b> {@cdk.cite Klekota01112008}.
 *
 * Presence of 4860 substructures
 *
 * @author yapchunwei
 * @cdk.module fingerprint
 * @cdk.githash
 */
public class KlekotaRothFingerprinter extends SubstructureFingerprinter {

    public KlekotaRothFingerprinter() {
        super(
                new String[]{
                        "[!#1][CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])[CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])[CH]([!#1])C([CH3])([CH3])[CH3]",
                        "[!#1][CH]([!#1])[CH](C(=O)O[CH3])C(=O)O[CH3]",
                        "[!#1][CH]([!#1])[CH]1[CH2][CH]([CH]([!#1])[!#1])[CH]([CH]1C(=O)[!#1])C(=O)[OH]",
                        "[!#1][CH]([!#1])[CH2][CH]([CH]([CH2][CH]([!#1])[!#1])C(=O)[!#1])C(=O)[!#1]",
                        "[!#1][CH]([!#1])[CH2][CH2][CH3]",
                        "[!#1][CH]([!#1])[CH2][CH2]C([!#1])([!#1])[CH3]",
                        "[!#1][CH]([!#1])[CH2]C(=N[NH]C(=S)[NH2])[CH2][CH3]",
                        "[!#1][CH]([!#1])[CH2]C(=O)[!#1]",
                        "[!#1][CH]([!#1])[CH2]C(=O)[CH2][CH3]",
                        "[!#1][CH]([!#1])[CH2]C(=O)[CH3]",
                        "[!#1][CH]([!#1])[CH2]N([!#1])[CH2][CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])[CH3]",
                        "[!#1][CH]([!#1])[N+](=O)[O-]",
                        "[!#1][CH]([!#1])[NH]C(=O)[!#1]",
                        "[!#1][CH]([!#1])[OH]",
                        "[!#1][CH]([!#1])C([!#1])([!#1])[!#1]",
                        "[!#1][CH]([!#1])C([!#1])([CH3])[CH3]",
                        "[!#1][CH]([!#1])C(=O)[!#1]",
                        "[!#1][CH]([!#1])C(=O)[CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])C(=O)[CH2]C([CH3])([CH3])[CH2]C([!#1])([!#1])[!#1]",
                        "[!#1][CH]([!#1])C(=O)[CH3]",
                        "[!#1][CH]([!#1])C(=O)[NH][NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH]([!#1])C(=O)[OH]",
                        "[!#1][CH]([!#1])C(=O)c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH]([!#1])C(=O)c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][CH]([!#1])C(=O)c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH]([!#1])C(=O)c1c([CH3])[cH]c([CH3])[nH]c1=O",
                        "[!#1][CH]([!#1])C(=O)c1c([CH3])[nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH]([!#1])C(=O)c1c([OH])[cH]c([CH3])oc1=O",
                        "[!#1][CH]([!#1])C(=O)O[CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1Cl",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1F",
                        "[!#1][CH]([!#1])c1[cH][cH][cH][cH]c1N([!#1])c2[cH][cH][cH][cH]c2[CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1][CH]([!#1])c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH][cH]n[cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH][cH]o1",
                        "[!#1][CH]([!#1])c1[cH][cH][cH]s1",
                        "[!#1][CH]([!#1])c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]c([!#1])o1",
                        "[!#1][CH]([!#1])c1[cH][cH]c([cH][cH]1)[CH]([!#1])[!#1]",
                        "[!#1][CH]([!#1])c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][CH]([!#1])c1[cH][cH]c([cH][cH]1)N([!#1])[CH3]",
                        "[!#1][CH]([!#1])c1[cH][cH]c([CH3])[cH]c1[CH3]",
                        "[!#1][CH]([!#1])c1[cH][cH]c([CH3])o1",
                        "[!#1][CH]([!#1])c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1][CH]([!#1])c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][CH]([!#1])c1[cH][cH]n[cH][cH]1",
                        "[!#1][CH]([!#1])c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH]([!#1])c1[cH]c([!#1])nn1[!#1]",
                        "[!#1][CH]([!#1])c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1][CH]([!#1])c1[cH]c(Br)[cH]c(Br)c1[OH]",
                        "[!#1][CH]([!#1])C1=C([OH])[CH2]C([CH3])([CH3])[CH2]C1=O",
                        "[!#1][CH]([!#1])c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH]([!#1])c1c2[cH][cH][cH][cH]c2[cH]c3[cH][cH][cH][cH]c13",
                        "[!#1][CH]([!#1])c1sc2[cH][cH][cH][cH]c2[n+]1[CH2][CH2][CH2]S(=O)(=O)[OH]",
                        "[!#1][CH]([!#1])N([!#1])[CH3]",
                        "[!#1][CH]([!#1])N([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH]([!#1])N([CH3])[CH3]",
                        "[!#1][CH]([!#1])N1[CH2][CH2]O[CH2][CH2]1",
                        "[!#1][CH]([!#1])O[CH2][CH2]N([CH3])[CH3]",
                        "[!#1][CH]([!#1])OC(=O)[!#1]",
                        "[!#1][CH]([!#1])S(=O)(=O)[!#1]",
                        "[!#1][CH]([CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1][CH]([CH]=[CH]c1[cH][cH]c(Cl)[cH]c1Cl)C([CH3])([CH3])[CH3]",
                        "[!#1][CH]([CH2][CH2]C(=O)[OH])C(=O)[OH]",
                        "[!#1][CH]([CH2][CH2]S[CH3])C(=O)[OH]",
                        "[!#1][CH]([CH2][N+](=O)[O-])SC(=O)[CH3]",
                        "[!#1][CH]([CH2]C(=N[NH]C(=O)[!#1])[!#1])C(=O)[OH]",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][CH]([CH2]C(=O)[!#1])C(=O)N([!#1])c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH]([CH2]C(=O)[NH2])C(=O)[OH]",
                        "[!#1][CH]([CH2]C(=O)[OH])[NH]C(=O)C(F)(F)F",
                        "[!#1][CH]([CH2]C(=O)[OH])C(=O)[OH]",
                        "[!#1][CH]([CH3])[CH2][CH3]",
                        "[!#1][CH]([CH3])[CH3]",
                        "[!#1][CH]([CH3])[NH]C(=O)[!#1]",
                        "[!#1][CH]([CH3])[NH]C(=O)[NH][CH2]C(=O)O[CH2][CH3]",
                        "[!#1][CH]([CH3])[NH]C(=S)[!#1]",
                        "[!#1][CH]([CH3])[NH]C(=S)[NH]C([!#1])([!#1])[!#1]",
                        "[!#1][CH]([CH3])[NH]S(=O)(=O)[!#1]",
                        "[!#1][CH]([CH3])C(=O)[!#1]",
                        "[!#1][CH]([CH3])C(=O)[OH]",
                        "[!#1][CH]([CH3])C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1][CH]([CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH]([CH3])N([!#1])C(=O)[!#1]",
                        "[!#1][CH]([NH]C(=O)[!#1])[NH]C(=O)[!#1]",
                        "[!#1][CH]([NH]C(=O)[!#1])C(=O)[OH]",
                        "[!#1][CH]([NH]C(=O)[!#1])C(Br)(Br)Br",
                        "[!#1][CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH]([NH]C(=O)[CH2][CH2][CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][CH]([NH]S(=O)(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH]([NH2])[CH2][CH3]",
                        "[!#1][CH]([NH2])[CH2]C(=O)[OH]",
                        "[!#1][CH]([NH2])C(=O)[OH]",
                        "[!#1][CH]([OH])[CH]([NH2])[CH2][OH]",
                        "[!#1][CH]([OH])[CH2][NH]C(=O)[!#1]",
                        "[!#1][CH]([OH])[CH2][NH2]",
                        "[!#1][CH]([OH])[CH2][OH]",
                        "[!#1][CH]([OH])C(=N[NH]C(=O)[!#1])[!#1]",
                        "[!#1][CH]([OH])C(Cl)(Cl)Cl",
                        "[!#1][CH]([OH])C(F)(F)F",
                        "[!#1][CH]([OH])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH](C(=O)[CH3])C(=O)[CH3]",
                        "[!#1][CH](C(=O)O[CH2][CH3])C(=O)O[CH2][CH3]",
                        "[!#1][CH](C(=O)O[CH3])C(=O)O[CH3]",
                        "[!#1][CH](F)C(F)(F)F",
                        "[!#1][CH](F)OC(F)(F)F",
                        "[!#1][CH](OC(=O)[CH3])OC(=O)[CH3]",
                        "[!#1][CH]=[CH][!#1]",
                        "[!#1][CH]=[CH][CH]([!#1])C([CH3])([CH3])[CH3]",
                        "[!#1][CH]=[CH][CH]=C1SC(=S)N([!#1])C1=O",
                        "[!#1][CH]=[CH][CH]=N[!#1]",
                        "[!#1][CH]=[CH][CH]=N[NH]C(=O)[!#1]",
                        "[!#1][CH]=[CH]C(=N[NH]C(=O)[!#1])[!#1]",
                        "[!#1][CH]=[CH]C(=N[NH]C(=O)[!#1])[CH3]",
                        "[!#1][CH]=[CH]C(=O)[!#1]",
                        "[!#1][CH]=[CH]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1][CH]=[CH]C(=O)[NH]C(=S)[!#1]",
                        "[!#1][CH]=[CH]C(=O)[OH]",
                        "[!#1][CH]=[CH]N([!#1])[CH3]",
                        "[!#1][CH]=[CH2]",
                        "[!#1][CH]=C([NH]C(=O)[!#1])C(=O)[!#1]",
                        "[!#1][CH]=C([NH]C(=O)[!#1])C(=O)[NH][CH2][CH2][CH2]N([CH3])[CH3]",
                        "[!#1][CH]=C(C#N)C#N",
                        "[!#1][CH]=C(C#N)C(=O)[NH2]",
                        "[!#1][CH]=C(C#N)C(=O)O[CH2][CH3]",
                        "[!#1][CH]=C(Cl)Cl",
                        "[!#1][CH]=C1[CH2]N([!#1])[CH2]C(=[CH][!#1])C1=O",
                        "[!#1][CH]=c1[nH]c(=O)c(=[CH][!#1])[nH]c1=O",
                        "[!#1][CH]=C1C(=NN(C1=O)c2[cH][cH]c([!#1])[cH][cH]2)[!#1]",
                        "[!#1][CH]=C1C(=O)[NH]C(=O)[NH]C1=O",
                        "[!#1][CH]=C1C(=O)[NH]C(=O)N([!#1])C1=O",
                        "[!#1][CH]=C1C(=O)[NH]C(=O)N(C1=O)c2[cH][cH][cH]c3[cH][cH][cH][cH]c23",
                        "[!#1][CH]=C1C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1][CH]=C1C(=O)N(N=C1c2[cH][cH][cH][cH][cH]2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1][CH]=C1C(=O)OC([!#1])([CH3])OC1=O",
                        "[!#1][CH]=C1N=C(OC1=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]=C1OC(=O)c2c1[cH]c([!#1])[nH]c2=O",
                        "[!#1][CH]=C1SC(=N[!#1])[NH]C1=O",
                        "[!#1][CH]=C1SC(=O)N([!#1])C1=O",
                        "[!#1][CH]=C1SC(=S)[NH]C1=O",
                        "[!#1][CH]=C1SC(=S)N([!#1])C1=O",
                        "[!#1][CH]=C1SC(=S)N(C1=O)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1][CH]=N[!#1]",
                        "[!#1][CH]=N[CH]([!#1])[CH3]",
                        "[!#1][CH]=N[CH2][CH2][CH2][CH2][CH2][CH2]N=[CH][!#1]",
                        "[!#1][CH]=N[CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH]=N[CH2][CH2]N=[CH][!#1]",
                        "[!#1][CH]=N[NH]C(=[NH])[NH][N+](=O)[O-]",
                        "[!#1][CH]=N[NH]C(=[NH])[NH2]",
                        "[!#1][CH]=N[NH]C(=O)[!#1]",
                        "[!#1][CH]=N[NH]C(=O)[CH]([!#1])[CH3]",
                        "[!#1][CH]=N[NH]C(=O)[CH]([!#1])[NH]C(=O)[!#1]",
                        "[!#1][CH]=N[NH]C(=O)[CH]([!#1])[OH]",
                        "[!#1][CH]=N[NH]C(=O)[CH2][CH2][CH]([CH3])[OH]",
                        "[!#1][CH]=N[NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH]=N[NH]C(=O)[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH]=N[NH]C(=O)[CH2][NH]C(=O)[!#1]",
                        "[!#1][CH]=N[NH]C(=O)[CH2][OH]",
                        "[!#1][CH]=N[NH]C(=O)[CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][CH]=N[NH]C(=O)[NH2]",
                        "[!#1][CH]=N[NH]C(=O)C(=O)[NH]N=[CH][!#1]",
                        "[!#1][CH]=N[NH]C(=O)O[CH2][CH3]",
                        "[!#1][CH]=N[NH]C(=S)[NH2]",
                        "[!#1][CH]=N[NH]C(=S)S[CH3]",
                        "[!#1][CH]=N[NH]S(=O)(=O)[!#1]",
                        "[!#1][CH]=N[OH]",
                        "[!#1][CH]=NC(=N[NH]C(=O)[!#1])[!#1]",
                        "[!#1][CH]=NN([!#1])[CH3]",
                        "[!#1][CH]=NN=[CH][!#1]",
                        "[!#1][CH]=NOC(=O)[!#1]",
                        "[!#1][CH]=O",
                        "[!#1][CH]1[CH]([!#1])[CH]2[CH2][CH]1[CH]=[CH]2",
                        "[!#1][CH]1[CH]([!#1])[CH]2c3[cH][cH][cH][cH]c3[CH]1c4[cH][cH][cH][cH]c24",
                        "[!#1][CH]1[CH]([CH]2[CH2][CH]1[CH]=[CH]2)C(=O)[OH]",
                        "[!#1][CH]1[CH]([CH]2c3[cH][cH][cH][cH]c3[CH]1c4[cH][cH][cH][cH]c24)C(=O)[OH]",
                        "[!#1][CH]1[CH]([OH])O[CH]([CH2][OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][CH]1[CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2][CH]1[CH2]3",
                        "[!#1][CH]1[CH]2[CH2][CH2][CH2][CH2][CH]12",
                        "[!#1][CH]1[CH]2S[CH2]C1([!#1])[CH2][CH2][CH]2[!#1]",
                        "[!#1][CH]1[CH2][CH]([CH3])[CH2][CH2][CH]1[CH]([CH3])[CH3]",
                        "[!#1][CH]1[CH2][CH]=[CH][CH2][CH]1[!#1]",
                        "[!#1][CH]1[CH2][CH]=[CH][CH2][CH]1C(=O)[OH]",
                        "[!#1][CH]1[CH2][CH]1[!#1]",
                        "[!#1][CH]1[CH2][CH]1c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]1[CH2][CH]2[CH2][CH2][CH]([CH2]1)N2[!#1]",
                        "[!#1][CH]1[CH2][CH]2[CH2][CH2][CH]([CH2]1)N2[CH3]",
                        "[!#1][CH]1[CH2][CH]2[CH2][CH2][CH]1[CH2]2",
                        "[!#1][CH]1[CH2][CH]2[CH2][CH2]N1[CH2][CH]2[CH]=[CH2]",
                        "[!#1][CH]1[CH2][CH2][CH]([!#1])[CH]([!#1])[CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH]([!#1])[CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH]([CH2][CH2]1)C([CH3])([CH3])[CH3]",
                        "[!#1][CH]1[CH2][CH2][CH]2[CH2][CH2][CH2][NH][CH]2[CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH2][CH]([!#1])N1[!#1]",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2][CH]1[!#1]",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2][NH]C1=O",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2]C1=O",
                        "[!#1][CH]1[CH2][CH2][CH2][CH2]N1[!#1]",
                        "[!#1][CH]1[CH2][CH2][CH2]C1=N[NH]C(=S)[NH2]",
                        "[!#1][CH]1[CH2][CH2][CH2]c2c1[nH]c3[cH][cH]c([!#1])[cH]c23",
                        "[!#1][CH]1[CH2][CH2][CH2]c2c1[nH]c3[cH][cH]c([cH]c23)c4[cH][cH][cH][cH][cH]4",
                        "[!#1][CH]1[CH2][CH2][CH2]c2c1[nH]c3[cH][cH]c([CH3])[cH]c23",
                        "[!#1][CH]1[CH2][CH2][CH2]N([!#1])[CH2]1",
                        "[!#1][CH]1[CH2][CH2][CH2]N1[!#1]",
                        "[!#1][CH]1[CH2][CH2][CH2]O1",
                        "[!#1][CH]1[CH2][CH2][NH][CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2][NH]C(=O)[NH]1",
                        "[!#1][CH]1[CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2]C([!#1])(C(=O)[OH])C1([!#1])[CH3]",
                        "[!#1][CH]1[CH2][CH2]C([CH3])(C(=O)[OH])C1([CH3])[CH3]",
                        "[!#1][CH]1[CH2][CH2]c2c([!#1])c([!#1])sc2C1=O",
                        "[!#1][CH]1[CH2][CH2]N([!#1])[CH2][CH2]1",
                        "[!#1][CH]1[CH2][CH2]OC1=O",
                        "[!#1][CH]1[CH2][CH2]S(=O)(=O)[CH2]1",
                        "[!#1][CH]1[CH2][NH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH]1[CH2]C([!#1])([CH]([!#1])[CH2]N1[!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]1[CH2]C([!#1])([CH3])[NH]C([!#1])([CH3])[CH2]1",
                        "[!#1][CH]1[CH2]C([CH3])([CH3])[NH]C([CH3])([CH3])[CH2]1",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH][cH]c([!#1])[cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH][cH]c(Cl)[cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH][cH]c3[cH][cH][cH][cH]c23",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH]c(Br)[cH][cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH]c(Cl)[cH][cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(C1=O)c2[cH][cH]c(O[CH3])[cH][cH]2",
                        "[!#1][CH]1[CH2]C(=O)N(N([CH3])[CH3])C1=O",
                        "[!#1][CH]1[CH2]C(=O)O[CH]1c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]1[CH2]C1([!#1])[CH3]",
                        "[!#1][CH]1[CH2]C1([CH3])[CH3]",
                        "[!#1][CH]1[CH2]C1(c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1][CH]1[CH2]C1(c2[cH][cH]c([!#1])[cH][cH]2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1][CH]1[CH2]C1(c2[cH][cH]c([CH3])[cH][cH]2)c3[cH][cH]c([CH3])[cH][cH]3",
                        "[!#1][CH]1[CH2]C2([!#1])[CH2]C([!#1])([CH2][CH]([!#1])C2=O)C1=O",
                        "[!#1][CH]1[CH2]c2[cH][cH][cH]c3[cH][cH][cH]c1c23",
                        "[!#1][CH]1[CH2]C21[CH2][CH2][CH2]2",
                        "[!#1][CH]1[CH2]c2c([nH]c3[cH][cH][cH][cH]c23)[CH]([!#1])[NH]1",
                        "[!#1][CH]1[CH2]c2c([nH]c3[cH][cH][cH][cH]c23)[CH]([NH]1)c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1][CH]1[CH2]N2[CH2][CH2][CH]1[CH2][CH]2[!#1]",
                        "[!#1][CH]1[CH2]O[CH]([!#1])O1",
                        "[!#1][CH]1[CH2]O1",
                        "[!#1][CH]1[CH2]OC([!#1])([CH3])O1",
                        "[!#1][CH]1[CH2]OC2([CH2][CH2][CH2][CH2][CH2]2)O1",
                        "[!#1][CH]1[CH2]Oc2[cH][cH][cH][cH]c2O1",
                        "[!#1][CH]1[CH2]S(=O)(=O)[CH]=[CH]1",
                        "[!#1][CH]1[CH2]S(=O)(=O)[CH2][CH]1[!#1]",
                        "[!#1][CH]1[CH2]S(=O)(=O)[CH2][CH]1[OH]",
                        "[!#1][CH]1[CH2]S[CH]([NH]1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1][CH]1[CH2]S[CH](N1[!#1])c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1][CH]1[CH2]S[CH2][CH]1[!#1]",
                        "[!#1][CH]1[NH][CH2][CH2]n2[cH][cH][cH]c12",
                        "[!#1][CH]1[NH]c2[cH][cH][cH][cH]c2[NH]C1=O",
                        "[!#1][CH]1C(=NN(C1=O)c2[cH][cH][cH][cH][cH]2)[!#1]",
                        "[!#1][CH]1C(=NN(C1=O)c2c([!#1])c([!#1])c([!#1])c([!#1])c2[!#1])[!#1]",
                        "[!#1][CH]1C(=NN(C1=O)c2c(F)c(F)c(F)c(F)c2F)[CH3]",
                        "[!#1][CH]1C(=O)[CH2]C([!#1])([CH3])[CH2]C1=O",
                        "[!#1][CH]1C(=O)[CH2]C([CH3])([CH3])[CH2]C1=O",
                        "[!#1][CH]1C(=O)[NH]C(=O)[NH]C1=O",
                        "[!#1][CH]1C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1][CH]1c2[cH][cH][cH][cH]c2-c3[cH][cH][cH][cH]c13",
                        "[!#1][CH]1c2[cH][cH][cH][cH]c2Oc3[cH][cH][cH][cH]c13",
                        "[!#1][CH]1N([!#1])[CH2][CH2]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH]1N(C(=O)N([!#1])C1([!#1])[CH3])c2[cH][cH][cH]c3[cH][cH][cH][cH]c23",
                        "[!#1][CH]1N(C(=O)N([!#1])C1([!#1])[CH3])c2[cH][cH]c([!#1])c([!#1])[cH]2",
                        "[!#1][CH]1N(C(=O)N([!#1])C1([CH3])[CH3])c2[cH][cH][cH]c3[cH][cH][cH][cH]c23",
                        "[!#1][CH]1N2[CH2][CH2][CH]([CH2][CH2]2)C1=O",
                        "[!#1][CH]1O[CH]([!#1])[CH]([!#1])[CH]([!#1])[CH]1[!#1]",
                        "[!#1][CH]1O[CH]([CH]([!#1])[CH]1[!#1])n2[cH][cH]c(=O)[nH]c2=O",
                        "[!#1][CH]1O[CH]([CH]([!#1])[CH]1[!#1])n2[cH]nc3c([!#1])n[cH]nc23",
                        "[!#1][CH]1O[CH]([CH2][OH])[CH]([OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][CH]1O[CH]([CH2][OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][CH]1O[CH]([CH3])[CH]([OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][CH]1O[CH2][CH2]O[CH]1[!#1]",
                        "[!#1][CH]1OC([!#1])([CH3])O[CH]1[!#1]",
                        "[!#1][CH]1S(=O)(=O)[CH2][CH]([CH2]S1(=O)=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH]1S(c2[cH][cH][cH][cH]c2[NH]C1=O)", // [!#1][CH]1Sc2[cH][cH][cH][cH]c2[NH]C1=O
                        "[!#1][CH2][!#1]",
                        "[!#1][CH2][CH]([!#1])[!#1]",
                        "[!#1][CH2][CH]([!#1])[CH3]",
                        "[!#1][CH2][CH]([!#1])[OH]",
                        "[!#1][CH2][CH]([!#1])C#[CH]",
                        "[!#1][CH2][CH]([!#1])C(=O)[!#1]",
                        "[!#1][CH2][CH]([!#1])C(=O)[NH][!#1]",
                        "[!#1][CH2][CH]([!#1])C(=O)[OH]",
                        "[!#1][CH2][CH]([!#1])C(=O)O[CH2][CH3]",
                        "[!#1][CH2][CH]([CH2][CH3])[NH]C(=O)[!#1]",
                        "[!#1][CH2][CH]([CH3])[CH3]",
                        "[!#1][CH2][CH]([CH3])[NH][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH]([CH3])[NH]C(=O)[!#1]",
                        "[!#1][CH2][CH]([CH3])[NH2]",
                        "[!#1][CH2][CH]([CH3])[OH]",
                        "[!#1][CH2][CH]([CH3])O[!#1]",
                        "[!#1][CH2][CH]([CH3])S[CH2][CH3]",
                        "[!#1][CH2][CH]([NH]C(=O)[!#1])C(=O)[NH][!#1]",
                        "[!#1][CH2][CH]([NH]C(=O)[!#1])C(=O)[OH]",
                        "[!#1][CH2][CH]([NH]C(=O)[!#1])C(=O)O[CH2][CH3]",
                        "[!#1][CH2][CH]([NH]C(=O)[!#1])C(=O)O[CH3]",
                        "[!#1][CH2][CH]([NH]C(=O)[CH2]O[!#1])C(=O)[OH]",
                        "[!#1][CH2][CH]([NH]C(=O)[CH2]O[!#1])C(=O)O[CH3]",
                        "[!#1][CH2][CH]([NH]C(=O)[CH3])C(=O)[OH]",
                        "[!#1][CH2][CH]([NH]C(=O)[CH3])C(=O)O[CH2][CH3]",
                        "[!#1][CH2][CH]([NH]C(=O)OC([CH3])([CH3])[CH3])C(=O)O[!#1]",
                        "[!#1][CH2][CH]([NH]S(=O)(=O)[!#1])C(=O)[OH]",
                        "[!#1][CH2][CH]([NH]S(=O)(=O)[!#1])C(=O)O[CH3]",
                        "[!#1][CH2][CH]([NH2])C(=O)[OH]",
                        "[!#1][CH2][CH]([OH])[CH2][!#1]",
                        "[!#1][CH2][CH]([OH])[CH2][NH][!#1]",
                        "[!#1][CH2][CH]([OH])[CH2][OH]",
                        "[!#1][CH2][CH]([OH])[CH2]Br",
                        "[!#1][CH2][CH]([OH])[CH2]Cl",
                        "[!#1][CH2][CH]([OH])[CH2]N([!#1])[!#1]",
                        "[!#1][CH2][CH]([OH])[CH2]N([!#1])[CH3]",
                        "[!#1][CH2][CH]([OH])[CH2]N([CH2][CH2][OH])[CH2][CH2][OH]",
                        "[!#1][CH2][CH]([OH])[CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][CH2][CH]([OH])[CH2]N([CH3])[CH3]",
                        "[!#1][CH2][CH]([OH])[CH2]O[!#1]",
                        "[!#1][CH2][CH](O[CH3])O[CH3]",
                        "[!#1][CH2][CH]=[CH][!#1]",
                        "[!#1][CH2][CH]=[CH2]",
                        "[!#1][CH2][CH]1[CH2]OC2([CH2][CH2][CH2][CH2][CH2]2)O1",
                        "[!#1][CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][CH]([CH3])[CH3]",
                        "[!#1][CH2][CH2][CH]=C([CH3])[CH3]",
                        "[!#1][CH2][CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][CH2][CH]([CH2]O[!#1])O[!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2][CH2][CH2][CH2][CH2]C(=O)N([!#1])[CH2][!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][CH2][CH2][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2][CH2][NH]C(=S)[NH][CH3]",
                        "[!#1][CH2][CH2][CH2][CH2][OH]",
                        "[!#1][CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2][CH2][CH2][CH2]C(=O)O[CH3]",
                        "[!#1][CH2][CH2][CH2][CH2]N([!#1])C(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2][CH2]S[!#1]",
                        "[!#1][CH2][CH2][CH2][CH3]",
                        "[!#1][CH2][CH2][CH2][NH][!#1]",
                        "[!#1][CH2][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2][NH]S(=O)(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2][NH2]",
                        "[!#1][CH2][CH2][CH2][OH]",
                        "[!#1][CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2][CH2][CH2]C(=O)O[CH3]",
                        "[!#1][CH2][CH2][CH2]Cl",
                        "[!#1][CH2][CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][CH2][CH2][CH2]N([CH3])[CH3]",
                        "[!#1][CH2][CH2][CH2]O[!#1]",
                        "[!#1][CH2][CH2][CH2]OC(=O)[!#1]",
                        "[!#1][CH2][CH2][CH2]OC(=O)C([!#1])([!#1])[OH]",
                        "[!#1][CH2][CH2][CH2]OC(=O)C([CH3])([CH3])[CH3]",
                        "[!#1][CH2][CH2][CH2]S(=O)(=O)[OH]",
                        "[!#1][CH2][CH2][CH2]S(=O)(=O)O[Na]",
                        "[!#1][CH2][CH2][CH2]S[!#1]",
                        "[!#1][CH2][CH2][CH3]",
                        "[!#1][CH2][CH2][NH][!#1]",
                        "[!#1][CH2][CH2][NH][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2][NH]C([!#1])([!#1])[!#1]",
                        "[!#1][CH2][CH2][NH]C(=C1C(=O)O[CH](C1=O)c2[cH][cH][cH][cH][cH]2)[CH3]",
                        "[!#1][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH]([!#1])[CH3]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH]=[CH][!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH2][!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH2][CH2][!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH2]O[!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)[CH3]",
                        "[!#1][CH2][CH2][NH]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2][NH]C(=O)O[CH2][CH2]Cl",
                        "[!#1][CH2][CH2][NH]S(=O)(=O)[!#1]",
                        "[!#1][CH2][CH2][NH2]",
                        "[!#1][CH2][CH2][OH]",
                        "[!#1][CH2][CH2]C#N",
                        "[!#1][CH2][CH2]C(=N[OH])[!#1]",
                        "[!#1][CH2][CH2]C(=O)[!#1]",
                        "[!#1][CH2][CH2]C(=O)[CH3]",
                        "[!#1][CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1][CH2][CH2]C(=O)[NH][NH]S(=O)(=O)[!#1]",
                        "[!#1][CH2][CH2]C(=O)[NH][NH2]",
                        "[!#1][CH2][CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][CH2][CH2]C(=O)[NH2]",
                        "[!#1][CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2][CH2]C(=O)O[!#1]",
                        "[!#1][CH2][CH2]C(=O)O[CH2][CH3]",
                        "[!#1][CH2][CH2]C(=O)O[CH3]",
                        "[!#1][CH2][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2][CH2]c1[cH][cH]c(O[!#1])c(O[!#1])[cH]1",
                        "[!#1][CH2][CH2]c1c(nc2[cH][cH][cH][cH]c2c1[NH][!#1])N([!#1])[CH2]c3[cH][cH][cH][cH][cH]3",
                        "[!#1][CH2][CH2]c1c(nc2[cH][cH][cH][cH]c2c1[NH][!#1])N([!#1])[CH3]",
                        "[!#1][CH2][CH2]N([!#1])[CH]1[CH2][CH2][CH2]c2c1n([!#1])c3[cH][cH]c([CH3])[cH]c23",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2][NH][!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH2][CH]([!#1])[!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH2][CH]([OH])[CH2]O[!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH2]C(=O)[!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH2]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])[CH3]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH][cH][cH]c1O[!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH][cH][cH]n1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]N([!#1])c1n[cH][cH][cH]n1",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH2]O[!#1]",
                        "[!#1][CH2][CH2]N([!#1])[CH2][CH3]",
                        "[!#1][CH2][CH2]N([!#1])[CH3]",
                        "[!#1][CH2][CH2]N([!#1])[NH2]",
                        "[!#1][CH2][CH2]N([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2][CH2]N([CH2][!#1])[CH2][!#1]",
                        "[!#1][CH2][CH2]N([CH2][CH2]O[!#1])C(=O)[!#1]",
                        "[!#1][CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][CH2][CH2]N([CH3])[CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2]N([CH3])[CH3]",
                        "[!#1][CH2][CH2]N=[CH][!#1]",
                        "[!#1][CH2][CH2]O[!#1]",
                        "[!#1][CH2][CH2]O[CH2][CH]([OH])[CH2][!#1]",
                        "[!#1][CH2][CH2]O[CH2][CH]([OH])[CH2][NH2]",
                        "[!#1][CH2][CH2]OC(=O)[!#1]",
                        "[!#1][CH2][CH2]OC(=O)[CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2][CH2]OC(=O)[CH3]",
                        "[!#1][CH2][CH2]OC(=O)[NH][CH]([!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2][CH2]OC(=O)[NH][CH]([NH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2][CH2]P(=O)([!#1])[CH2][CH3]",
                        "[!#1][CH2][CH2]S(=O)(=O)[!#1]",
                        "[!#1][CH2][CH2]S(=O)(=O)[CH2][CH2][!#1]",
                        "[!#1][CH2][CH2]S(=O)(=O)[CH2][CH2]C(=O)[NH2]",
                        "[!#1][CH2][CH2]S(=O)(=O)O[!#1]",
                        "[!#1][CH2][CH2]S(=O)[!#1]",
                        "[!#1][CH2][CH2]S[!#1]",
                        "[!#1][CH2][CH2]S[CH2][!#1]",
                        "[!#1][CH2][CH2]S[CH2][CH2][!#1]",
                        "[!#1][CH2][CH2]S[CH2][CH2]S[CH2][CH2][!#1]",
                        "[!#1][CH2][CH2]S[CH2]C(=O)[OH]",
                        "[!#1][CH2][CH2]SC(=[NH])[NH2]",
                        "[!#1][CH2][CH2]SC(=O)[CH3]",
                        "[!#1][CH2][CH2]SC(=S)[!#1]",
                        "[!#1][CH2][CH3]",
                        "[!#1][CH2][NH][!#1]",
                        "[!#1][CH2][NH][CH]([CH2][!#1])C(=O)[OH]",
                        "[!#1][CH2][NH][CH]([CH3])[CH2][CH3]",
                        "[!#1][CH2][NH][CH]([CH3])[CH3]",
                        "[!#1][CH2][NH][CH]([NH]C(=O)[!#1])C(Br)(Br)Br",
                        "[!#1][CH2][NH][CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2][NH][CH]=C1C(=O)[CH2][NH]C1=O",
                        "[!#1][CH2][NH][CH]=C1C(=O)[NH]C(=O)[NH]C1=O",
                        "[!#1][CH2][NH][CH]=C1C(=O)[NH]C(=O)N([!#1])C1=O",
                        "[!#1][CH2][NH][CH2][!#1]",
                        "[!#1][CH2][NH]C([CH3])([CH3])[CH3]",
                        "[!#1][CH2][NH]C(=[NH])[NH]C(=[NH])[NH2]",
                        "[!#1][CH2][NH]C(=N[OH])[!#1]",
                        "[!#1][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH2][NH]C(=O)[CH]([!#1])[CH2][!#1]",
                        "[!#1][CH2][NH]C(=O)[CH]=[CH]C(=O)[OH]",
                        "[!#1][CH2][NH]C(=O)[CH2][!#1]",
                        "[!#1][CH2][NH]C(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2][NH]C(=O)[CH2]Cl",
                        "[!#1][CH2][NH]C(=O)[CH2]O[!#1]",
                        "[!#1][CH2][NH]C(=O)[CH3]",
                        "[!#1][CH2][NH]C(=O)[NH][!#1]",
                        "[!#1][CH2][NH]C(=O)C(=[CH][!#1])[NH]C(=O)[!#1]",
                        "[!#1][CH2][NH]C(=S)[NH][!#1]",
                        "[!#1][CH2][NH]C(=S)[NH]C(=O)[!#1]",
                        "[!#1][CH2][NH]S(=O)(=O)[!#1]",
                        "[!#1][CH2][NH2]",
                        "[!#1][CH2][OH]",
                        "[!#1][CH2]Br",
                        "[!#1][CH2]C#C[!#1]",
                        "[!#1][CH2]C([CH3])([CH3])[CH3]",
                        "[!#1][CH2]C(=[CH2])[CH3]",
                        "[!#1][CH2]C(=N[NH][!#1])[CH3]",
                        "[!#1][CH2]C(=N[NH]C(=O)[!#1])[CH3]",
                        "[!#1][CH2]C(=N[NH]C(=O)[!#1])C(=O)[OH]",
                        "[!#1][CH2]C(=N[NH]C(=O)[CH2]O[!#1])[CH3]",
                        "[!#1][CH2]C(=N[OH])[!#1]",
                        "[!#1][CH2]C(=O)[!#1]",
                        "[!#1][CH2]C(=O)[CH3]",
                        "[!#1][CH2]C(=O)[NH][!#1]",
                        "[!#1][CH2]C(=O)[NH][CH]([!#1])[CH3]",
                        "[!#1][CH2]C(=O)[NH][CH]([!#1])C(=O)[NH][!#1]",
                        "[!#1][CH2]C(=O)[NH][CH]([!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2]C(=O)[NH][CH]([NH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2]C(=O)[NH][CH]([NH]C(=S)[NH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2]C(=O)[NH][CH](S[!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2]C(=O)[NH][CH2][CH2][OH]",
                        "[!#1][CH2]C(=O)[NH][CH2][CH2]S(=O)(=O)[OH]",
                        "[!#1][CH2]C(=O)[NH][NH][!#1]",
                        "[!#1][CH2]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1][CH2]C(=O)[NH][NH2]",
                        "[!#1][CH2]C(=O)[NH][OH]",
                        "[!#1][CH2]C(=O)[NH]N([!#1])[CH3]",
                        "[!#1][CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][CH2]C(=O)[NH]N=[CH][CH]([!#1])[!#1]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1Br",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]c(I)[cH]1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]o1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]s1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])[cH]c1[OH]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]c1[OH]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH]c2[cH][cH][cH][cH]c2nc1Cl",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1[cH]c2O[CH2]Oc2[cH]c1[N+](=O)[O-]",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]C(=O)[NH]N=[CH]c1c(Cl)[cH][cH][cH]c1Cl",
                        "[!#1][CH2]C(=O)[NH]N=C([!#1])[CH3]",
                        "[!#1][CH2]C(=O)[NH]N=C([CH3])c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][CH2]C(=O)[NH]N=C1[CH2][CH2][CH2]c2c1non2=O",
                        "[!#1][CH2]C(=O)[NH]S(=O)(=O)[!#1]",
                        "[!#1][CH2]C(=O)[NH2]",
                        "[!#1][CH2]C(=O)[OH]",
                        "[!#1][CH2]C(=O)C([CH3])([CH3])[CH3]",
                        "[!#1][CH2]C(=O)c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2]C(=O)c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][CH2]C(=O)c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1][CH2]C(=O)c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1][CH2]C(=O)N([!#1])[CH3]",
                        "[!#1][CH2]C(=O)N([CH3])[CH]([!#1])C(=O)[NH][!#1]",
                        "[!#1][CH2]C(=O)N=[CH][NH][NH][!#1]",
                        "[!#1][CH2]C(=O)O[!#1]",
                        "[!#1][CH2]C(=O)O[CH2][CH2][CH2][CH3]",
                        "[!#1][CH2]C(=O)O[CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][CH2]C(=O)O[CH2][CH3]",
                        "[!#1][CH2]C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1][CH2]C(=O)O[CH3]",
                        "[!#1][CH2]C(=O)O[Na]",
                        "[!#1][CH2]C(=S)[!#1]",
                        "[!#1][CH2]C1([CH2][CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2]1)[CH2]3",
                        "[!#1][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][CH2]c1[cH][cH][cH][cH]c1Br",
                        "[!#1][CH2]c1[cH][cH][cH][cH]c1C(F)(F)F",
                        "[!#1][CH2]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1][CH2]c1[cH][cH][cH][cH]c1F",
                        "[!#1][CH2]c1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c([OH])[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c(Cl)c1Cl",
                        "[!#1][CH2]c1[cH][cH][cH]c(F)[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c(O[!#1])[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]c1[cH][cH][cH]n[cH]1",
                        "[!#1][CH2]c1[cH][cH][cH]o1",
                        "[!#1][CH2]c1[cH][cH][cH]s1",
                        "[!#1][CH2]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][CH2]c1[cH][cH]c([cH][cH]1)C(F)(F)F",
                        "[!#1][CH2]c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c(Br)s1",
                        "[!#1][CH2]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1][CH2]c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c(F)[cH]c1F",
                        "[!#1][CH2]c1[cH][cH]c(O[!#1])[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c(O[!#1])c(O[!#1])[cH]1",
                        "[!#1][CH2]c1[cH][cH]c(S[CH3])[cH][cH]1",
                        "[!#1][CH2]c1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1][CH2]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][CH2]c1[cH][cH]o[cH]1",
                        "[!#1][CH2]c1[cH][cH]s[cH]1",
                        "[!#1][CH2]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]c1[cH]c([CH2][!#1])c([OH])c([!#1])n1",
                        "[!#1][CH2]c1c([!#1])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]c1c([NH][!#1])sc2[CH2][CH2][CH2][CH2]c12",
                        "[!#1][CH2]c1nc2[cH][cH][cH][cH]c2[nH]1",
                        "[!#1][CH2]Cl",
                        "[!#1][CH2]N([!#1])[CH2][!#1]",
                        "[!#1][CH2]N([!#1])[CH2][CH2][OH]",
                        "[!#1][CH2]N([!#1])[CH2][CH3]",
                        "[!#1][CH2]N([!#1])[CH3]",
                        "[!#1][CH2]N([!#1])[NH]C(=O)[CH2][!#1]",
                        "[!#1][CH2]N([!#1])C(=O)[!#1]",
                        "[!#1][CH2]N([!#1])C(=O)[CH2][CH2]C(=O)[!#1]",
                        "[!#1][CH2]N([!#1])C(=O)[CH2]O[!#1]",
                        "[!#1][CH2]N([!#1])C(=O)[CH3]",
                        "[!#1][CH2]N([!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1][CH2]N([!#1])C(=O)c1[cH]c([cH][cH]c1C(=O)[!#1])[N+](=O)[O-]",
                        "[!#1][CH2]N([!#1])C(=O)c1[cH]c(Br)[cH][cH]c1C(=O)[!#1]",
                        "[!#1][CH2]N([!#1])c1[cH][cH][cH][cH]c1C(=O)C(=O)[!#1]",
                        "[!#1][CH2]N([!#1])N=[CH][!#1]",
                        "[!#1][CH2]N([!#1])S(=O)(=O)[NH]C(=O)[NH][!#1]",
                        "[!#1][CH2]N([CH2][!#1])[CH2][!#1]",
                        "[!#1][CH2]N([CH2][!#1])C(=O)[!#1]",
                        "[!#1][CH2]N([CH2][!#1])C(=O)[NH][!#1]",
                        "[!#1][CH2]N([CH2][!#1])S(=O)(=O)[!#1]",
                        "[!#1][CH2]N([CH2][CH]([OH])[CH2]O[!#1])C([CH3])([CH3])[CH3]",
                        "[!#1][CH2]N([CH2][CH]=[CH2])[CH2][CH]=[CH2]",
                        "[!#1][CH2]N([CH2][CH2][OH])[CH2][CH2][OH]",
                        "[!#1][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][CH2]N([CH2]C(=O)[OH])[CH2]C(=O)[OH]",
                        "[!#1][CH2]N([CH3])[CH3]",
                        "[!#1][CH2]N([CH3])C(=O)[!#1]",
                        "[!#1][CH2]N([CH3])S(=O)(=O)[!#1]",
                        "[!#1][CH2]N([OH])[CH2][!#1]",
                        "[!#1][CH2]N(C([CH3])([CH3])[CH3])S(=O)(=O)[!#1]",
                        "[!#1][CH2]N(C(=O)[!#1])C([CH3])([CH3])[CH3]",
                        "[!#1][CH2]N(C(=O)[CH2][CH2]C(=O)[OH])C([CH3])([CH3])[CH3]",
                        "[!#1][CH2]N=[CH][!#1]",
                        "[!#1][CH2]N=c1[cH][cH]n([!#1])[cH][cH]1",
                        "[!#1][CH2]N1[CH2][CH2][CH]([!#1])[CH2][CH2]1",
                        "[!#1][CH2]N1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1][CH2]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1][CH2]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH]n2",
                        "[!#1][CH2]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c(Cl)[cH][cH]2",
                        "[!#1][CH2]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c(F)[cH][cH]2",
                        "[!#1][CH2]N1[CH2][CH2]O[CH2][CH2]1",
                        "[!#1][CH2]N1C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1][CH2]n1nnc2[cH][cH][cH][cH]c12",
                        "[!#1][CH2]O[!#1]",
                        "[!#1][CH2]O[CH2][!#1]",
                        "[!#1][CH2]O[CH2][CH]([OH])[CH2][!#1]",
                        "[!#1][CH2]O[CH2][CH]([OH])[CH2][NH][CH]([CH3])[CH3]",
                        "[!#1][CH2]O[CH2][CH3]",
                        "[!#1][CH2]O[CH3]",
                        "[!#1][CH2]OC([!#1])([!#1])[!#1]",
                        "[!#1][CH2]OC(=O)[!#1]",
                        "[!#1][CH2]OC(=O)[CH]([CH]([!#1])S[CH2][!#1])[N+](=O)[O-]",
                        "[!#1][CH2]OC(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1][CH2]OC(=O)[CH2][CH3]",
                        "[!#1][CH2]OC(=O)[CH3]",
                        "[!#1][CH2]OC(=O)[NH][!#1]",
                        "[!#1][CH2]OC(=O)[NH][CH]([NH]C(=S)[NH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][CH2]OP(=S)(O[CH2][CH3])O[CH2][CH3]",
                        "[!#1][CH2]OS(=O)(=O)[!#1]",
                        "[!#1][CH2]S(=O)(=O)[!#1]",
                        "[!#1][CH2]S(=O)(=O)[NH][!#1]",
                        "[!#1][CH2]S[!#1]",
                        "[!#1][CH2]S[CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][CH2]S[CH2]S[CH2][!#1]",
                        "[!#1][CH2]SC(=[NH])[NH2]",
                        "[!#1][CH3]",
                        "[!#1][N]([CH3])([CH3])[CH3]",
                        "[!#1][N+]([CH3])([CH3])[CH3]",
                        "[!#1][N+](=O)[O-]",
                        "[!#1][n+]1[cH][cH][cH][cH][cH]1",
                        "[!#1][n+]1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1][n+]1c([CH3])sc2[cH][cH]c(O[CH3])[cH]c12",
                        "[!#1][NH](=O)[OH]",
                        "[!#1][NH][!#1]",
                        "[!#1][NH][CH]([!#1])[!#1]",
                        "[!#1][NH][CH]([!#1])[CH]([CH3])[CH3]",
                        "[!#1][NH][CH]([!#1])[CH2][CH]([!#1])[CH3]",
                        "[!#1][NH][CH]([!#1])[CH2][CH2][CH3]",
                        "[!#1][NH][CH]([!#1])[CH2]C(=O)[!#1]",
                        "[!#1][NH][CH]([!#1])[CH3]",
                        "[!#1][NH][CH]([!#1])C(Br)(Br)Br",
                        "[!#1][NH][CH]([!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([!#1])P(=O)(O[CH]([CH3])[CH3])O[CH]([CH3])[CH3]",
                        "[!#1][NH][CH]([!#1])P(=O)(O[CH2][CH3])O[CH2][CH3]",
                        "[!#1][NH][CH]([!#1])P(=O)(O[CH3])O[CH3]",
                        "[!#1][NH][CH]([CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1][NH][CH]([CH2][CH]([CH3])[CH3])C(=O)[!#1]",
                        "[!#1][NH][CH]([CH2][CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1][NH][CH]([CH2][CH2][OH])C(=O)[NH][!#1]",
                        "[!#1][NH][CH]([CH2][CH2]S[CH3])C(=O)[OH]",
                        "[!#1][NH][CH]([CH2][CH3])C(=O)[OH]",
                        "[!#1][NH][CH]([CH2]C([!#1])([CH3])[CH3])[CH2]C([CH3])([CH3])[NH][!#1]",
                        "[!#1][NH][CH]([CH2]C(=O)[OH])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH][CH]([CH2]c1[cH][cH][cH][cH][cH]1)C(=O)[!#1]",
                        "[!#1][NH][CH]([CH2]c1[cH][cH][cH][cH][cH]1)C(=O)[OH]",
                        "[!#1][NH][CH]([CH2]c1[cH][cH]c([OH])[cH][cH]1)C(=O)[!#1]",
                        "[!#1][NH][CH]([CH2]c1[cH][nH]c2[cH][cH][cH][cH]c12)C(=O)[!#1]",
                        "[!#1][NH][CH]([CH2]c1[cH][nH]c2[cH][cH][cH][cH]c12)C(=O)[OH]",
                        "[!#1][NH][CH]([CH3])[CH2][CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][NH][CH]([CH3])[CH2][CH3]",
                        "[!#1][NH][CH]([CH3])[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH][CH]([CH3])[CH2]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][NH][CH]([CH3])[CH3]",
                        "[!#1][NH][CH]([CH3])C(=O)[!#1]",
                        "[!#1][NH][CH]([CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH][CH]([NH]C(=O)[!#1])C(=O)[!#1]",
                        "[!#1][NH][CH]([NH]C(=O)[!#1])C(Br)(Br)Br",
                        "[!#1][NH][CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[CH]([CH3])[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[CH2]F)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[NH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=O)[NH][CH]([NH][!#1])C(Cl)(Cl)Cl)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1[N+](=O)[O-])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1[OH])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1C(=O)[OH])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH][cH]c1O[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c([cH]1)C(=O)[OH])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c([CH3])[cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c([OH])[cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH][cH]c2[cH][cH][cH]nc12)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c([cH][cH]1)C(=O)[OH])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c([CH3])[cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c([NH][!#1])[cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH]c2[CH3])[cH]c1[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c(O[!#1])[cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH][cH]c(O[!#1])[cH]c1[N+](=O)[O-])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH]c([cH][cH]c1Cl)C(F)(F)F)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH]c([cH][cH]c1O[!#1])[N+](=O)[O-])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1[cH]c(Cl)[cH][cH]c1Cl)C(Cl)(Cl)Cl",
                        "[!#1][NH][CH]([NH]C(=S)[NH]c1sc2[CH2][CH2][CH2][CH2]c2c1C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH][CH](c1[cH][cH][cH][cH][cH]1)C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH][CH](c1[cH][cH][cH][cH][cH]1)c2c([OH])[cH][cH]c3[cH][cH][cH][cH]c23",
                        "[!#1][NH][CH](c1[cH][cH][cH][cH]c1[!#1])c2[cH][cH][cH][cH]c2O[!#1]",
                        "[!#1][NH][CH]=[CH][!#1]",
                        "[!#1][NH][CH]=C1C(=O)[CH2][NH]C1=O",
                        "[!#1][NH][CH]=C1C(=O)[CH2]C([!#1])([CH3])[CH]([!#1])C1=O",
                        "[!#1][NH][CH]=C1C(=O)[CH2]C([!#1])([CH3])[CH2]C1=O",
                        "[!#1][NH][CH]1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1][NH][CH]1[CH2][CH2][CH2][CH2]1",
                        "[!#1][NH][CH]1[CH2][CH2]1",
                        "[!#1][NH][CH]1[CH2][CH2]S(=O)(=O)[CH2]1",
                        "[!#1][NH][CH]1O[CH]([CH2][OH])[CH]([OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][NH][CH]1O[CH2][CH]([OH])[CH]([OH])[CH]1[OH]",
                        "[!#1][NH][CH2][CH]([!#1])[!#1]",
                        "[!#1][NH][CH2][CH]([CH3])[CH3]",
                        "[!#1][NH][CH2][CH]([OH])[CH]([OH])[CH]([OH])[CH2][OH]",
                        "[!#1][NH][CH2][CH]([OH])[CH2]O[!#1]",
                        "[!#1][NH][CH2][CH]=[CH2]",
                        "[!#1][NH][CH2][CH2][CH2][CH2][CH2][CH2][NH][!#1]",
                        "[!#1][NH][CH2][CH2][CH2][CH2][CH2][CH2][OH]",
                        "[!#1][NH][CH2][CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][NH][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1][NH][CH2][CH2][CH2][CH2][OH]",
                        "[!#1][NH][CH2][CH2][CH2][CH3]",
                        "[!#1][NH][CH2][CH2][CH2][NH2]",
                        "[!#1][NH][CH2][CH2][CH2][OH]",
                        "[!#1][NH][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][NH][CH2][CH2][CH2]O[CH3]",
                        "[!#1][NH][CH2][CH2][CH3]",
                        "[!#1][NH][CH2][CH2][NH][!#1]",
                        "[!#1][NH][CH2][CH2][NH2]",
                        "[!#1][NH][CH2][CH2][OH]",
                        "[!#1][NH][CH2][CH2]C#N",
                        "[!#1][NH][CH2][CH2]C(=O)[!#1]",
                        "[!#1][NH][CH2][CH2]C(=O)[OH]",
                        "[!#1][NH][CH2][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH][CH2][CH2]c1[cH][cH]c(O[!#1])[cH][cH]1",
                        "[!#1][NH][CH2][CH2]c1[cH][cH]c(O[!#1])c(O[!#1])[cH]1",
                        "[!#1][NH][CH2][CH2]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1][NH][CH2][CH2]c1[cH][nH]c2[cH][cH]c(O[!#1])[cH]c12",
                        "[!#1][NH][CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][NH][CH2][CH2]O[!#1]",
                        "[!#1][NH][CH2][CH2]S(=O)(=O)[OH]",
                        "[!#1][NH][CH2][CH3]",
                        "[!#1][NH][CH2][NH][!#1]",
                        "[!#1][NH][CH2]C(=O)[!#1]",
                        "[!#1][NH][CH2]C(=O)[NH][!#1]",
                        "[!#1][NH][CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][NH][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1][NH][CH2]C(=O)[NH]N=[CH]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][NH][CH2]C(=O)[NH]N=[CH]c1[cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]c1[OH]",
                        "[!#1][NH][CH2]C(=O)[NH]N=[CH]c1[cH]c2[cH][cH][cH][cH]c2nc1Cl",
                        "[!#1][NH][CH2]C(=O)[OH]",
                        "[!#1][NH][CH2]C(=O)C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH][CH2]C(=O)O[CH2][CH2][CH2][CH3]",
                        "[!#1][NH][CH2]C(=O)O[CH2][CH3]",
                        "[!#1][NH][CH2]C(=O)O[CH3]",
                        "[!#1][NH][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH][CH2]c1[cH][cH][cH]n[cH]1",
                        "[!#1][NH][CH2]c1[cH][cH][cH]o1",
                        "[!#1][NH][CH2]c1[cH][cH][cH]s1",
                        "[!#1][NH][CH2]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][NH][CH2]c1[cH]c(Br)[cH]c(Br)c1O[!#1]",
                        "[!#1][NH][CH2]c1[cH]c(Br)[cH]c(C(=O)[OH])c1O[!#1]",
                        "[!#1][NH][CH2]c1c(O[!#1])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][NH][CH3]",
                        "[!#1][NH][NH][!#1]",
                        "[!#1][NH][NH][CH]=O",
                        "[!#1][NH][NH]C(=O)[!#1]",
                        "[!#1][NH][NH]C(=O)[CH2][CH2][CH3]",
                        "[!#1][NH][NH]C(=O)[CH3]",
                        "[!#1][NH][NH]C(=O)[NH][!#1]",
                        "[!#1][NH][NH]C(=S)[NH][!#1]",
                        "[!#1][NH][NH]C(=S)[NH2]",
                        "[!#1][NH][NH]S(=O)(=O)[!#1]",
                        "[!#1][NH][NH2]",
                        "[!#1][NH]C([!#1])([!#1])[!#1]",
                        "[!#1][NH]C([!#1])([!#1])[CH3]",
                        "[!#1][NH]C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH]C([!#1])([!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[CH]([!#1])[!#1]",
                        "[!#1][NH]C([!#1])([CH3])[CH2][CH3]",
                        "[!#1][NH]C([!#1])([CH3])[CH3]",
                        "[!#1][NH]C([CH3])([CH3])[CH2][CH]([!#1])[CH2]C([!#1])([CH3])[CH3]",
                        "[!#1][NH]C([CH3])([CH3])[CH2][OH]",
                        "[!#1][NH]C([CH3])([CH3])[CH3]",
                        "[!#1][NH]C(=[NH])[NH]C(=[NH])[NH][!#1]",
                        "[!#1][NH]C(=[NH])[NH]C(=[NH])N([CH3])[CH3]",
                        "[!#1][NH]C(=[NH])[NH]C(=O)[NH2]",
                        "[!#1][NH]C(=[NH])[NH2]",
                        "[!#1][NH]C(=C(S(=O)(=O)[CH2][CH3])S(=O)(=O)[CH2][CH3])[NH][!#1]",
                        "[!#1][NH]C(=C1C(=O)[CH2]SC1=O)[CH3]",
                        "[!#1][NH]C(=C1C(=O)[NH]C(=O)N([!#1])C1=O)[CH3]",
                        "[!#1][NH]C(=N[!#1])[NH][!#1]",
                        "[!#1][NH]C(=N[!#1])SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)[CH]([!#1])[!#1]",
                        "[!#1][NH]C(=O)[CH]([!#1])[CH]([CH3])[CH3]",
                        "[!#1][NH]C(=O)[CH]([!#1])[CH3]",
                        "[!#1][NH]C(=O)[CH]([!#1])C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[CH]([!#1])C(=O)O[CH2][CH3]",
                        "[!#1][NH]C(=O)[CH]([CH](C(=O)[OH])C(=O)O[!#1])C(=O)O[!#1]",
                        "[!#1][NH]C(=O)[CH]([CH2][CH2][CH3])[CH2][CH2][CH3]",
                        "[!#1][NH]C(=O)[CH]([CH3])[CH2][SH](=O)=O",
                        "[!#1][NH]C(=O)[CH]([CH3])[NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)[CH]([CH3])Br",
                        "[!#1][NH]C(=O)[CH](C(=O)[!#1])S(=O)(=O)[!#1]",
                        "[!#1][NH]C(=O)[CH](OC(=O)[!#1])[CH](OC(=O)[!#1])C(=O)[OH]",
                        "[!#1][NH]C(=O)[CH]=[CH][!#1]",
                        "[!#1][NH]C(=O)[CH]=[CH][CH3]",
                        "[!#1][NH]C(=O)[CH]=[CH]C(=O)[OH]",
                        "[!#1][NH]C(=O)[CH]=[CH]C(=O)O[CH2]C(F)(F)[CH](F)F",
                        "[!#1][NH]C(=O)[CH]=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH]C(=O)[CH]=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1][NH]C(=O)[CH2][CH]([!#1])[NH]C(=O)C(F)(F)F",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2][CH3]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2]C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2]C(=O)O[!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2]C(=O)O[CH2]C#[CH]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH2]O[!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2][CH3]",
                        "[!#1][NH]C(=O)[CH2][CH2]C([CH3])([CH3])C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1][NH]C(=O)[CH2][CH2]C(=O)O[!#1]",
                        "[!#1][NH]C(=O)[CH2][CH2]C(=O)O[CH2][CH]=[CH2]",
                        "[!#1][NH]C(=O)[CH2][CH2]C(=O)O[CH2]C(=C(Cl)Cl)Cl",
                        "[!#1][NH]C(=O)[CH2][CH2]C(=O)O[CH3]",
                        "[!#1][NH]C(=O)[CH2][CH2]Cl",
                        "[!#1][NH]C(=O)[CH2][CH3]",
                        "[!#1][NH]C(=O)[CH2][NH][CH]([CH3])[CH3]",
                        "[!#1][NH]C(=O)[CH2][NH]C([CH3])([CH3])[CH3]",
                        "[!#1][NH]C(=O)[CH2][SH]",
                        "[!#1][NH]C(=O)[CH2]C(=N[NH]C(=O)[!#1])[CH3]",
                        "[!#1][NH]C(=O)[CH2]C(=O)[!#1]",
                        "[!#1][NH]C(=O)[CH2]C(=O)[CH3]",
                        "[!#1][NH]C(=O)[CH2]C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[CH2]Cl",
                        "[!#1][NH]C(=O)[CH2]N([CH2][CH2][CH2][CH3])[CH2][CH2][CH2][CH3]",
                        "[!#1][NH]C(=O)[CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1][NH]C(=O)[CH2]N([CH3])[CH3]",
                        "[!#1][NH]C(=O)[CH2]O[!#1]",
                        "[!#1][NH]C(=O)[CH2]S[!#1]",
                        "[!#1][NH]C(=O)[CH2]S[CH2][CH2][NH2]",
                        "[!#1][NH]C(=O)[CH2]SC(=O)[!#1]",
                        "[!#1][NH]C(=O)[CH3]",
                        "[!#1][NH]C(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[NH][CH]([!#1])[CH3]",
                        "[!#1][NH]C(=O)[NH][CH]([CH2]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=O)[NH][CH2][CH2][CH2][OH]",
                        "[!#1][NH]C(=O)[NH][CH2][CH2][OH]",
                        "[!#1][NH]C(=O)[NH][CH3]",
                        "[!#1][NH]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)[NH][NH]C(=O)[CH2]O[!#1]",
                        "[!#1][NH]C(=O)[NH][NH]C(=O)O[CH3]",
                        "[!#1][NH]C(=O)[NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)[NH]C(=O)[CH2]O[!#1]",
                        "[!#1][NH]C(=O)[NH]C(=O)[NH2]",
                        "[!#1][NH]C(=O)[NH]C(=O)C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=O)[NH]N=[CH][!#1]",
                        "[!#1][NH]C(=O)[NH]N=C([!#1])[CH3]",
                        "[!#1][NH]C(=O)[NH]S(=O)(=O)[!#1]",
                        "[!#1][NH]C(=O)[NH]S(=O)(=O)[NH][!#1]",
                        "[!#1][NH]C(=O)[NH2]",
                        "[!#1][NH]C(=O)C([!#1])([!#1])[NH][!#1]",
                        "[!#1][NH]C(=O)C([!#1])([!#1])[OH]",
                        "[!#1][NH]C(=O)C([!#1])(F)F",
                        "[!#1][NH]C(=O)C([CH3])([CH3])[CH3]",
                        "[!#1][NH]C(=O)C(=[CH][!#1])[NH]C(=O)[CH3]",
                        "[!#1][NH]C(=O)C(=[CH]c1[cH][cH][cH][cH][cH]1)[NH]C(=O)[CH3]",
                        "[!#1][NH]C(=O)C(=[CH2])[CH3]",
                        "[!#1][NH]C(=O)C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH][cH][cH]c12",
                        "[!#1][NH]C(=O)C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=O)C(F)(F)C(F)(F)F",
                        "[!#1][NH]C(=O)C(F)(F)F",
                        "[!#1][NH]C(=O)C(F)(F)OC(F)(F)C(F)(F)OC(F)(F)F",
                        "[!#1][NH]C(=O)C(F)(OC(F)(F)C(F)(F)C(F)(F)F)C(F)(F)F",
                        "[!#1][NH]C(=O)N([!#1])[OH]",
                        "[!#1][NH]C(=O)N([CH]([CH3])[CH3])[CH]([CH3])[CH3]",
                        "[!#1][NH]C(=O)O[!#1]",
                        "[!#1][NH]C(=O)O[CH]([CH3])[CH3]",
                        "[!#1][NH]C(=O)O[CH2][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)O[CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1][NH]C(=O)O[CH2][CH2][NH]C(=O)O[CH3]",
                        "[!#1][NH]C(=O)O[CH2][CH2][NH]S(=O)(=O)[!#1]",
                        "[!#1][NH]C(=O)O[CH2][CH2]O[CH3]",
                        "[!#1][NH]C(=O)O[CH2][CH3]",
                        "[!#1][NH]C(=O)O[CH3]",
                        "[!#1][NH]C(=O)ON=[CH][!#1]",
                        "[!#1][NH]C(=O)ON=C([CH3])[CH3]",
                        "[!#1][NH]C(=O)S[CH2]C(=O)[!#1]",
                        "[!#1][NH]C(=S)[!#1]",
                        "[!#1][NH]C(=S)[NH][!#1]",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH]([!#1])[!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH]([CH3])[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH]=[CH][!#1])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH]=[CH]c1[cH][cH][cH][cH][cH]1)C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2][CH]([CH3])[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2][CH2][CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2][CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH2]F)C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH]([NH]C(=O)C([CH3])([CH3])[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH][CH](N=C([!#1])O[CH3])C(Cl)(Cl)Cl",
                        "[!#1][NH]C(=S)[NH]C(=C(C(F)(F)F)C(F)(F)F)C(F)(F)C(F)(F)F",
                        "[!#1][NH]C(=S)[NH]C(=N[CH2]S(=O)(=O)[!#1])[!#1]",
                        "[!#1][NH]C(=S)[NH]C(=O)[!#1]",
                        "[!#1][NH]C(=S)[NH]C(=O)[CH]=[CH][!#1]",
                        "[!#1][NH]C(=S)[NH]C(=O)[CH]=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH]C(=S)[NH]C(=O)[CH]=[CH]c1[cH][cH][cH]o1",
                        "[!#1][NH]C(=S)[NH]C(=O)[CH]=[CH]c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1][NH]C(=S)[NH]C(=O)[CH]=[CH]c1[cH][cH]c(O[CH3])c(O[CH3])[cH]1",
                        "[!#1][NH]C(=S)[NH]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1][NH]C(=S)[NH]N=[CH][!#1]",
                        "[!#1][NH]C(=S)[NH]N=C([!#1])[CH3]",
                        "[!#1][NH]C(=S)[NH2]",
                        "[!#1][NH]C(=S)O[CH2][CH2][CH3]",
                        "[!#1][NH]C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH]C1([CH2][CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2]1)[CH2]3",
                        "[!#1][NH]C1([CH2][CH2][CH2][CH2][CH2]1)C(=O)[!#1]",
                        "[!#1][NH]C1([CH2][CH2][CH2][CH2][CH2]1)c2nnnn2[!#1]",
                        "[!#1][NH]C1([CH2][CH2][CH2][CH2]1)C(=O)[!#1]",
                        "[!#1][NH]C1([CH3])C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1][NH]C1(C(=O)c2[cH][cH][cH][cH]c2C1=O)c3[cH][cH][cH][cH][cH]3",
                        "[!#1][NH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[CH2][CH3]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[CH3]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[NH][!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1Br",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C([OH])([CH2]C(=N[NH]C(=O)[CH2]O[!#1])[CH3])C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C(=N[!#1])C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C(=O)[OH]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1C(F)(F)F",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1F",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1I",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1O[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]c1S[CH]([CH2]C(=O)[!#1])C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH][cH]n1",
                        "[!#1][NH]c1[cH][cH][cH]c([!#1])[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)[CH]([!#1])[!#1]",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)C(=O)[CH3]",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)C(=O)[OH]",
                        "[!#1][NH]c1[cH][cH][cH]c([cH]1)C(F)(F)F",
                        "[!#1][NH]c1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c([CH3])c1[CH3]",
                        "[!#1][NH]c1[cH][cH][cH]c([NH][!#1])[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c([OH])[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c(Cl)c1[CH3]",
                        "[!#1][NH]c1[cH][cH][cH]c(Cl)c1Cl",
                        "[!#1][NH]c1[cH][cH][cH]c(F)[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c(O[!#1])[cH]1",
                        "[!#1][NH]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1][NH]c1[cH][cH][cH]c2[cH][cH][cH]nc12",
                        "[!#1][NH]c1[cH][cH][cH]c2c([NH][!#1])[cH][cH][cH]c12",
                        "[!#1][NH]c1[cH][cH][cH]c2C(=O)c3[cH][cH][cH][cH]c3C(=O)c12",
                        "[!#1][NH]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c([!#1])[cH]c1[CH3]",
                        "[!#1][NH]c1[cH][cH]c([!#1])[cH]c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([!#1])c([cH]1)S(=O)(=O)c2[cH]c([NH][!#1])[cH][cH]c2[!#1]",
                        "[!#1][NH]c1[cH][cH]c([CH]([!#1])[!#1])c([cH]1)S(=O)(=O)[OH]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)[CH]([!#1])[!#1]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)[CH]([CH3])[CH3]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)C(=O)[CH3]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1][NH]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH]c([cH]c1[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([cH]c1[N+](=O)[O-])C(=O)[OH]",
                        "[!#1][NH]c1[cH][cH]c([cH]c1C(=N[NH]C(=O)[CH2]O[!#1])C(=O)[!#1])[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([CH2][CH2]c2[cH][cH][cH][cH]c2[!#1])c([NH][!#1])[cH]1",
                        "[!#1][NH]c1[cH][cH]c([CH2]c2[cH][cH]c([NH][!#1])[cH][cH]2)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c([CH3])[cH]c1[CH3]",
                        "[!#1][NH]c1[cH][cH]c([CH3])[cH]c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c([CH3])c([CH3])[cH]1",
                        "[!#1][NH]c1[cH][cH]c([CH3])c([NH][!#1])[cH]1",
                        "[!#1][NH]c1[cH][cH]c([N+](=O)[O-])c2nonc12",
                        "[!#1][NH]c1[cH][cH]c([NH][!#1])[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(Br)[cH]c1C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH]c(Br)[cH]n1",
                        "[!#1][NH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(Cl)[cH]c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c(Cl)[cH]c1C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1][NH]c1[cH][cH]c(Cl)[cH]n1",
                        "[!#1][NH]c1[cH][cH]c(Cl)c([cH]1)[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1][NH]c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(F)c(Cl)[cH]1",
                        "[!#1][NH]c1[cH][cH]c(I)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(N([!#1])[CH2][CH3])c2c([cH][cH][cH]c12)C(=O)[!#1]",
                        "[!#1][NH]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH]c2[CH3])[cH]c1[CH3]",
                        "[!#1][NH]c1[cH][cH]c(O[!#1])[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]c(O[!#1])[cH]c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c(O[CH3])nn1",
                        "[!#1][NH]c1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1][NH]c1[cH][cH]c2[cH][cH][cH]c([OH])c2n1",
                        "[!#1][NH]c1[cH][cH]c2[CH2][CH2]c3[cH][cH][cH][cH]c3N([!#1])c2[cH]1",
                        "[!#1][NH]c1[cH][cH]c2c([cH]1)oc3[cH][cH][cH][cH]c32",
                        "[!#1][NH]c1[cH][cH]c2nc([!#1])[nH]c2[cH]1",
                        "[!#1][NH]c1[cH][cH]c2nonc2c1[N+](=O)[O-]",
                        "[!#1][NH]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1][NH]c1[cH][cH]c2oc([!#1])nc2[cH]1",
                        "[!#1][NH]c1[cH][cH]n[cH][cH]1",
                        "[!#1][NH]c1[cH][cH]nc2[cH]c3[cH][cH][cH][cH]c3[cH]c12",
                        "[!#1][NH]c1[cH]c([!#1])nc2[cH][cH][cH][cH]c12",
                        "[!#1][NH]c1[cH]c([cH][cH]c1[CH3])[N+](=O)[O-]",
                        "[!#1][NH]c1[cH]c([cH][cH]c1C(=O)[OH])[N+](=O)[O-]",
                        "[!#1][NH]c1[cH]c([cH][cH]c1Cl)C(F)(F)F",
                        "[!#1][NH]c1[cH]c([cH]c([cH]1)[N+](=O)[O-])C(=O)[OH]",
                        "[!#1][NH]c1[cH]c([cH]c([cH]1)C(=O)[OH])C(=O)[OH]",
                        "[!#1][NH]c1[cH]c([CH3])[cH][cH]c1[CH3]",
                        "[!#1][NH]c1[cH]c([CH3])[cH][cH]n1",
                        "[!#1][NH]c1[cH]c([CH3])[cH]c([CH3])[cH]1",
                        "[!#1][NH]c1[cH]c([CH3])nc2[cH][cH][cH][cH]c12",
                        "[!#1][NH]c1[cH]c(Cl)[cH][cH]c1Cl",
                        "[!#1][NH]c1[cH]c(Cl)[cH][cH]c1O[!#1]",
                        "[!#1][NH]c1[cH]c(O[!#1])c(O[!#1])[cH]c1C(=O)[!#1]",
                        "[!#1][NH]c1[cH]c(O[CH3])nc(O[CH3])n1",
                        "[!#1][NH]c1[cH]nc2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1][NH]c1[nH]nc([CH3])c1[N+](=O)[O-]",
                        "[!#1][NH]C1=[CH]C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1][NH]c1c([cH][cH]c2nonc12)[N+](=O)[O-]",
                        "[!#1][NH]c1c([cH]c([cH]c1[N+](=O)[O-])[N+](=O)[O-])C(=O)[OH]",
                        "[!#1][NH]c1c([cH]c([cH]c1[N+](=O)[O-])C(=O)[OH])[N+](=O)[O-]",
                        "[!#1][NH]c1c([cH]c([N+](=O)[O-])c2[cH][cH][cH][cH]c12)[N+](=O)[O-]",
                        "[!#1][NH]c1c([CH3])[cH][cH][cH]c1[CH3]",
                        "[!#1][NH]c1c([CH3])[cH]c([CH3])[cH]c1[CH3]",
                        "[!#1][NH]c1c([CH3])c([CH2][CH3])nc2[cH][cH][cH][cH]c12",
                        "[!#1][NH]c1c([CH3])n([!#1])n([!#1])c1=O",
                        "[!#1][NH]c1c([N+](=O)[O-])c(=O)oc2[cH][cH][cH][cH]c12",
                        "[!#1][NH]c1c2[cH][cH][cH][cH]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1][NH]c1c2[CH2][CH2][CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1][NH]c1c2[CH2][CH2][CH2]c2nc3[CH2][CH2][CH2][CH2]c13",
                        "[!#1][NH]c1n[cH][cH][cH]n1",
                        "[!#1][NH]c1n[cH][cH]nc1O[CH3]",
                        "[!#1][NH]c1n[cH][cH]s1",
                        "[!#1][NH]c1n[cH][nH]n1",
                        "[!#1][NH]c1n[cH]nc2n([!#1])[cH]nc12",
                        "[!#1][NH]c1n[cH]nc2sc3[CH2][CH2][CH2][CH2]c3c12",
                        "[!#1][NH]c1n[nH]c(=O)[nH]c1=O",
                        "[!#1][NH]c1nc([!#1])[cH]s1",
                        "[!#1][NH]c1nc([!#1])nc([!#1])n1",
                        "[!#1][NH]c1nc([!#1])nc(Cl)n1",
                        "[!#1][NH]c1nc([!#1])nc(n1)N2[CH2][CH2]O[CH2][CH2]2",
                        "[!#1][NH]c1nc([!#1])nc(O[CH](C(F)(F)F)C(F)(F)F)n1",
                        "[!#1][NH]c1nc([cH]s1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1][NH]c1nc([cH]s1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1][NH]c1nc([CH3])[cH]c([CH3])n1",
                        "[!#1][NH]c1nc(Cl)nc(Cl)n1",
                        "[!#1][NH]c1nc(O[CH](C(F)(F)F)C(F)(F)F)nc(O[CH](C(F)(F)F)C(F)(F)F)n1",
                        "[!#1][NH]c1nc2[cH][cH][cH][cH]c2n1[!#1]",
                        "[!#1][NH]c1nc2[cH][cH][cH][cH]c2nc1[!#1]",
                        "[!#1][NH]c1nc2[cH][cH][cH][cH]c2nc1[NH][!#1]",
                        "[!#1][NH]c1nc2[cH][cH][cH][cH]c2s1",
                        "[!#1][NH]c1nc2[CH2][CH2][CH2][CH2]c2s1",
                        "[!#1][NH]c1nc2nonc2nc1[!#1]",
                        "[!#1][NH]c1nnc([CH2][CH3])s1",
                        "[!#1][NH]c1nnc([CH3])s1",
                        "[!#1][NH]c1sc([CH3])c([CH3])c1C(=O)[!#1]",
                        "[!#1][NH]c1sc2[CH2][CH2][CH2][CH2]c2c1C(=O)[!#1]",
                        "[!#1][NH]N([!#1])[!#1]",
                        "[!#1][NH]N=[CH][!#1]",
                        "[!#1][NH]N=C([!#1])[!#1]",
                        "[!#1][NH]N=C([!#1])[CH3]",
                        "[!#1][NH]N=C([!#1])N=N[!#1]",
                        "[!#1][NH]N=C1C(=N[NH]C1=O)[!#1]",
                        "[!#1][NH]N=C1C(=NN(C1=O)c2[cH][cH][cH][cH][cH]2)[!#1]",
                        "[!#1][NH]N=C1C(=NN(C1=O)c2nc([cH]s2)c3[cH][cH][cH][cH][cH]3)[!#1]",
                        "[!#1][NH]N=C1C(=O)[NH]C(=O)[NH]C1=O",
                        "[!#1][NH]N=C1C(=O)[NH]C(=S)[NH]C1=O",
                        "[!#1][NH]N=N[!#1]",
                        "[!#1][NH]n1[cH]nn[cH]1",
                        "[!#1][NH]P(=O)(O[CH]([CH3])[CH3])O[CH]([CH3])[CH3]",
                        "[!#1][NH]P(=O)(O[CH2][CH]([CH3])[CH3])O[CH2][CH]([CH3])[CH3]",
                        "[!#1][NH]P(=O)(O[CH2][CH3])O[CH2][CH3]",
                        "[!#1][NH]S(=O)(=O)[!#1]",
                        "[!#1][NH]S(=O)(=O)[CH2][CH]=[CH2]",
                        "[!#1][NH]S(=O)(=O)[CH3]",
                        "[!#1][NH]S(=O)(=O)[NH]C([CH3])([CH3])[CH3]",
                        "[!#1][NH]S(=O)(=O)[NH]C(=O)N([!#1])[CH3]",
                        "[!#1][NH]S(=O)[!#1]",
                        "[!#1][NH]S[!#1]",
                        "[!#1][NH2]",
                        "[!#1][O-]",
                        "[!#1][OH]",
                        "[!#1][SH]",
                        "[!#1]Br",
                        "[!#1]C#C[!#1]",
                        "[!#1]C#CC([CH3])([CH3])[OH]",
                        "[!#1]C#N",
                        "[!#1]C([!#1])([!#1])[!#1]",
                        "[!#1]C([!#1])([!#1])[CH2][CH3]",
                        "[!#1]C([!#1])([!#1])[CH3]",
                        "[!#1]C([!#1])([!#1])[OH]",
                        "[!#1]C([!#1])([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C([!#1])([CH3])[CH2][CH3]",
                        "[!#1]C([!#1])([CH3])[CH3]",
                        "[!#1]C([!#1])([CH3])[OH]",
                        "[!#1]C([!#1])([OH])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C([!#1])(C#N)C#N",
                        "[!#1]C([!#1])(Cl)C([!#1])([!#1])[N+](=O)[O-]",
                        "[!#1]C([!#1])(Cl)Cl",
                        "[!#1]C([CH3])([CH3])[CH2][CH]([CH3])[OH]",
                        "[!#1]C([CH3])([CH3])[CH2][CH]([CH3])OC(=O)C([CH3])([CH3])[CH3]",
                        "[!#1]C([CH3])([CH3])[CH2][CH]=C([CH3])[CH2][CH2][CH]=C([CH3])[CH3]",
                        "[!#1]C([CH3])([CH3])[CH2][CH3]",
                        "[!#1]C([CH3])([CH3])[CH2][OH]",
                        "[!#1]C([CH3])([CH3])[CH2]C([CH3])([CH3])[CH3]",
                        "[!#1]C([CH3])([CH3])[CH2]N([CH3])[CH3]",
                        "[!#1]C([CH3])([CH3])[CH3]",
                        "[!#1]C([OH])([CH2][CH]=[CH2])[CH2][CH]=[CH2]",
                        "[!#1]C([OH])(C(=O)O[CH2][CH3])C(F)(F)F",
                        "[!#1]C([OH])(C(=O)O[CH3])C(F)(F)F",
                        "[!#1]C([OH])(C(F)(F)F)C(F)(F)F",
                        "[!#1]C(=[CH]C(=O)[CH3])[CH3]",
                        "[!#1]C(=[CH]C(=O)O[CH2][CH3])[CH3]",
                        "[!#1]C(=N[NH]C(=O)[!#1])[!#1]",
                        "[!#1]C(=N[NH]C(=O)[!#1])[CH3]",
                        "[!#1]C(=N[NH]C(=O)[NH2])[CH3]",
                        "[!#1]C(=N[NH]S(=O)(=O)[!#1])[CH3]",
                        "[!#1]C(=N[OH])[!#1]",
                        "[!#1]C(=N[OH])[CH2][CH]([CH3])[CH3]",
                        "[!#1]C(=N[OH])[CH2][CH3]",
                        "[!#1]C(=N[OH])[CH3]",
                        "[!#1]C(=N[OH])N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=NN=C([!#1])[CH3])[CH3]",
                        "[!#1]C(=NO[CH2][CH3])[CH2][CH2][CH3]",
                        "[!#1]C(=NO[CH2]ON=C([!#1])[CH3])[CH3]",
                        "[!#1]C(=NOC(=O)[!#1])[CH3]",
                        "[!#1]C(=O)[!#1]",
                        "[!#1]C(=O)[CH]([CH]1[CH2][CH2][CH2][CH2][CH2]1)C(=O)[!#1]",
                        "[!#1]C(=O)[CH]([CH3])[CH3]",
                        "[!#1]C(=O)[CH]([CH3])c1[cH][cH]c([CH2][CH]([CH3])[CH3])[cH][cH]1",
                        "[!#1]C(=O)[CH]([CH3])N([CH3])[CH3]",
                        "[!#1]C(=O)[CH](c1[cH][cH][cH][cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)[CH](F)F",
                        "[!#1]C(=O)[CH]1[CH]([CH]2c3[cH][cH][cH][cH]c3[CH]1c4[cH][cH][cH][cH]c24)C(=O)[OH]",
                        "[!#1]C(=O)[CH]1[CH]2[CH2][CH2][CH2][CH2][CH]12",
                        "[!#1]C(=O)[CH]1[CH2][CH]1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)[CH]1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)[CH]1[CH2][CH2]1",
                        "[!#1]C(=O)[CH]1[CH2][CH2]C([CH3])(C(=O)[OH])C1([CH3])[CH3]",
                        "[!#1]C(=O)[CH]1[CH2]C1([CH3])[CH3]",
                        "[!#1]C(=O)[CH]1[CH2]C1(c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C(=O)[CH]1[CH2]C1(c2[cH][cH]c([CH3])[cH][cH]2)c3[cH][cH]c([CH3])[cH][cH]3",
                        "[!#1]C(=O)[CH]1[CH2]C21[CH2][CH2][CH2]2",
                        "[!#1]C(=O)[CH]1C(=O)C([!#1])([!#1])C(=O)[CH2]C1([CH3])[CH3]",
                        "[!#1]C(=O)[CH2][CH]([CH3])[CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH]([CH3])[CH3]",
                        "[!#1]C(=O)[CH2][CH]([NH2])C(Cl)(Cl)Cl",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[CH2][CH2][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2]Br",
                        "[!#1]C(=O)[CH2][CH2]C([CH3])([CH3])C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[CH2][CH2]C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][CH2]C(=O)O[CH3]",
                        "[!#1]C(=O)[CH2][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[CH2][CH2]c1[cH][cH]c([CH3])o1",
                        "[!#1]C(=O)[CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=O)[CH2][CH2]N([CH3])[CH3]",
                        "[!#1]C(=O)[CH2][CH3]",
                        "[!#1]C(=O)[CH2][NH][CH2][CH2][OH]",
                        "[!#1]C(=O)[CH2][NH][CH2][CH3]",
                        "[!#1]C(=O)[CH2][NH]C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)[CH2][NH]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2][NH2]",
                        "[!#1]C(=O)[CH2]C([!#1])([OH])C(F)(F)[CH](F)F",
                        "[!#1]C(=O)[CH2]C([!#1])([OH])C(F)(F)F",
                        "[!#1]C(=O)[CH2]C(=N[NH]c1[cH][cH][cH][cH][cH]1)[CH3]",
                        "[!#1]C(=O)[CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2]C(=O)[CH3]",
                        "[!#1]C(=O)[CH2]C(=O)O[CH2][CH3]",
                        "[!#1]C(=O)[CH2]C1([CH2][CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2]1)[CH2]3",
                        "[!#1]C(=O)[CH2]C1(C(=O)c2[cH][cH][cH][cH]c2C1=O)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C(=O)[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[CH2]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)[CH2]Cl",
                        "[!#1]C(=O)[CH2]F",
                        "[!#1]C(=O)[CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=O)[CH2]N([CH3])[CH3]",
                        "[!#1]C(=O)[CH2]OC(=O)[!#1]",
                        "[!#1]C(=O)[CH2]OC(=O)[CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[CH2]OC(=O)[CH2][CH2]C(=O)C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2]OC(=O)[CH2][CH2]S(=O)(=O)[!#1]",
                        "[!#1]C(=O)[CH2]OC(=O)C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1]C(=O)[CH2]SC(=S)[!#1]",
                        "[!#1]C(=O)[CH2]SS(=O)(=O)[OH]",
                        "[!#1]C(=O)[CH3]",
                        "[!#1]C(=O)[NH][CH]([CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH]([CH2][CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH]([CH2][CH]([CH3])[CH3])C(=O)O[CH3]",
                        "[!#1]C(=O)[NH][CH]([CH2][CH2][CH2][NH]C(=[NH])[NH2])C(=O)[NH2]",
                        "[!#1]C(=O)[NH][CH]([CH2][OH])[CH]([CH3])[CH3]",
                        "[!#1]C(=O)[NH][CH]([CH2]C(=O)O[CH3])C(=O)O[CH3]",
                        "[!#1]C(=O)[NH][CH]([CH3])[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH]([CH3])[CH2][CH3]",
                        "[!#1]C(=O)[NH][CH]([CH3])[CH3]",
                        "[!#1]C(=O)[NH][CH]([CH3])C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH]([NH]C([CH3])([CH3])[CH3])C(Cl)(Cl)Cl",
                        "[!#1]C(=O)[NH][CH](N([CH2][CH3])[CH2][CH3])C(Cl)(Cl)Cl",
                        "[!#1]C(=O)[NH][CH2][CH]([CH3])[CH3]",
                        "[!#1]C(=O)[NH][CH2][CH]=[CH2]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH2][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2][OH]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH2]N([CH3])[CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH][CH2][CH2][OH]",
                        "[!#1]C(=O)[NH][CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2][CH2]OC(=O)[!#1]",
                        "[!#1]C(=O)[NH][CH2][CH2]OC(=O)[CH3]",
                        "[!#1]C(=O)[NH][CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[NH][CH2]C(=O)O[CH2][CH3]",
                        "[!#1]C(=O)[NH][CH2]C(=O)O[CH3]",
                        "[!#1]C(=O)[NH][CH2]OC(=O)[!#1]",
                        "[!#1]C(=O)[NH][CH3]",
                        "[!#1]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH][NH]C(=O)[CH]=[CH]C(=O)[OH]",
                        "[!#1]C(=O)[NH][NH]C(=O)[CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH][NH]C(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1]C(=O)[NH][NH]C(=O)[CH3]",
                        "[!#1]C(=O)[NH][NH]C(=O)C(F)(F)F",
                        "[!#1]C(=O)[NH][NH]C(=S)[NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH][NH]C(=S)[NH2]",
                        "[!#1]C(=O)[NH][NH]S(=O)(=O)[!#1]",
                        "[!#1]C(=O)[NH][NH2]",
                        "[!#1]C(=O)[NH][OH]",
                        "[!#1]C(=O)[NH]C([!#1])([!#1])[CH3]",
                        "[!#1]C(=O)[NH]C([CH2][OH])([CH2][OH])[CH2][OH]",
                        "[!#1]C(=O)[NH]C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)[NH]C(=S)[!#1]",
                        "[!#1]C(=O)[NH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[NH]c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1]C(=O)[NH]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)[NH]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1]C(=O)[NH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]C(=O)[NH]c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1]C(=O)[NH]c1nc([CH3])[cH]c([CH3])n1",
                        "[!#1]C(=O)[NH]c1nc([CH3])nc(O[CH3])n1",
                        "[!#1]C(=O)[NH]N=[CH][CH]=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH][CH]=N[NH]C(=O)[!#1]",
                        "[!#1]C(=O)[NH]N=[CH][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1F",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1O[CH3]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH][nH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH]c([CH2][CH]=[CH2])c1[OH]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH]n[cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH]o1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH][cH]s1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([!#1])[cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([cH][cH]1)N([CH3])[CH3]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([CH3])o1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])c(O[CH3])[cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(O[CH3])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(O[CH3])[cH]c1O[CH3]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(O[CH3])c(O[CH3])[cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(o1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c(s1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c2n([CH2][CH3])c3[cH][cH][cH][cH]c3c2[cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][cH]n[cH][cH]1",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c([CH3])[cH][cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c(Cl)[cH][cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c(Cl)[cH]c(Cl)c1O[CH3]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c2O[CH2]Oc2[cH]c1[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=[CH]c1[cH]c2O[CH2]Oc2[cH]c1Br",
                        "[!#1]C(=O)[NH]N=[CH]c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)[NH]N=[CH]c1nc2[cH][cH][cH][cH]c2[nH]1",
                        "[!#1]C(=O)[NH]N=C([!#1])[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH]N=C([!#1])[CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH]N=C([!#1])[CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH]N=C([!#1])[CH2][CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH]=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH]1[CH2][CH2]1",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH2][CH]([CH3])[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH2][CH2][CH]=[CH2]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH2][NH]C(=O)[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH2]C(=O)[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])C(=N[OH])[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH][cH]c([NH2])[cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH][cH]o1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c([cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c([NH2])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(Cl)s1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(O[CH3])[cH][cH]1",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH][cH]c(O[CH3])[cH]c1O[CH3]",
                        "[!#1]C(=O)[NH]N=C([CH3])c1[cH]c([OH])[cH][cH]c1[OH]",
                        "[!#1]C(=O)[NH]N=C1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)[NH]N=C1[CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)[NH]N=C1[CH2]C(=O)[CH2]C([CH3])([CH3])[CH2]1",
                        "[!#1]C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH]c([!#1])[cH]c12",
                        "[!#1]C(=O)[NH]N=c1c(=O)c2[cH][cH][cH][cH]c2c1=O",
                        "[!#1]C(=O)[NH]N=C1c2nn([!#1])nc2C(=N[NH]C(=O)[!#1])c3nn([!#1])nc13",
                        "[!#1]C(=O)[NH]S(=O)(=O)[!#1]",
                        "[!#1]C(=O)[NH2]",
                        "[!#1]C(=O)[OH]",
                        "[!#1]C(=O)C([!#1])([!#1])[CH3]",
                        "[!#1]C(=O)C([!#1])([!#1])[OH]",
                        "[!#1]C(=O)C([!#1])([!#1])C#N",
                        "[!#1]C(=O)C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]C(=O)C([CH2][CH3])([CH2][CH3])C(=O)[!#1]",
                        "[!#1]C(=O)C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)C([OH])(c1[cH][cH][cH][cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)C([OH])(c1[cH][cH]c(Br)[cH][cH]1)c2[cH][cH]c(Br)[cH][cH]2",
                        "[!#1]C(=O)C(=N[NH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-])C(=O)[!#1]",
                        "[!#1]C(=O)C(=N[NH]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[OH])C(=O)[!#1]",
                        "[!#1]C(=O)C(=N[OH])C(=O)O[CH2][CH3]",
                        "[!#1]C(=O)C(=O)[!#1]",
                        "[!#1]C(=O)C(Cl)(Cl)Cl",
                        "[!#1]C(=O)C(F)(F)C(F)(F)F",
                        "[!#1]C(=O)C(F)(F)F",
                        "[!#1]C(=O)C(F)(F)OC(F)(F)C(F)(F)OC(F)(F)F",
                        "[!#1]C(=O)C(F)(OC(F)(F)C(F)(F)C(F)(F)F)C(F)(F)F",
                        "[!#1]C(=O)C1([CH2][CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2]1)[CH2]3",
                        "[!#1]C(=O)C1([CH2][CH]2[CH2][CH]3[CH2]1)[CH2][CH]([CH2]2)[CH2][CH2]3",
                        "[!#1]C(=O)c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1[CH3]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1Br",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1C(=O)[OH]",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1Cl",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1F",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]c1I",
                        "[!#1]C(=O)c1[cH][cH][cH][cH]n1",
                        "[!#1]C(=O)c1[cH][cH][cH]c([!#1])[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH][cH]c([cH]1)C(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH][cH]c([cH]1)S(=O)(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c(F)[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c(I)[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)c1[cH][cH][cH]n[cH]1",
                        "[!#1]C(=O)c1[cH][cH][cH]o1",
                        "[!#1]C(=O)c1[cH][cH][cH]s1",
                        "[!#1]C(=O)c1[cH][cH][n+]([O-])[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c([!#1])c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c([cH][cH]1)C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)c1[cH][cH]c([cH][cH]1)C(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH]c([cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C(=O)c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH]c([cH]c1[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c([cH]c1C(=O)[OH])[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c([CH3])c([cH]1)S(=O)(=O)[!#1]",
                        "[!#1]C(=O)c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(Br)c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c(Br)o1",
                        "[!#1]C(=O)c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1]C(=O)c1[cH][cH]c(Cl)c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(F)c(F)[cH]1",
                        "[!#1]C(=O)c1[cH][cH]c(o1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1]C(=O)c1[cH][cH]c2n([!#1])c([CH3])c([CH3])c2[cH]1",
                        "[!#1]C(=O)c1[cH][cH]n[cH][cH]1",
                        "[!#1]C(=O)c1[cH]c([cH][cH]c1Cl)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH]c([cH]c([cH]1)[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH]c([cH]c([cH]1)C([CH3])([CH3])[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)c1[cH]c([N+](=O)[O-])c([CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1]C(=O)c1[cH]c(Cl)[cH][cH]c1[OH]",
                        "[!#1]C(=O)c1[cH]c(Cl)[cH]c(Cl)[cH]1",
                        "[!#1]C(=O)c1[cH]c2[cH][cH][cH][cH]c2oc1=O",
                        "[!#1]C(=O)c1[cH]n([!#1])nc1[!#1]",
                        "[!#1]C(=O)c1c([!#1])[cH]nn1[!#1]",
                        "[!#1]C(=O)c1c([!#1])n([!#1])c2nc3[cH][cH][cH][cH]c3nc12",
                        "[!#1]C(=O)c1c([cH][cH][cH]c1[N+](=O)[O-])C(=O)[OH]",
                        "[!#1]C(=O)c1c([cH]nn1[!#1])[N+](=O)[O-]",
                        "[!#1]C(=O)c1c([OH])c2[cH][cH][cH][cH]c2oc1=O",
                        "[!#1]C(=O)c1c(F)[cH][cH][cH]c1F",
                        "[!#1]C(=O)c1c(n[cH]n1[!#1])[N+](=O)[O-]",
                        "[!#1]C(=O)c1n[cH][cH]nc1C(=O)[OH]",
                        "[!#1]C(=O)c1nn([!#1])[cH]c1Br",
                        "[!#1]C(=O)c1sc([!#1])nc1[!#1]",
                        "[!#1]C(=O)c1sc2[cH][cH][cH][cH]c2c1Cl",
                        "[!#1]C(=O)N([CH]([CH3])[CH3])[CH]([CH3])[CH3]",
                        "[!#1]C(=O)N([CH2][CH2][CH2][CH2][CH3])[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)N([CH2][CH2]C(=O)[OH])[CH2]C(=O)[OH]",
                        "[!#1]C(=O)N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=O)N([CH3])[CH3]",
                        "[!#1]C(=O)n1[cH]nc2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)N1[CH2][CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)N1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)N1[CH2][CH2][CH2][CH2]1",
                        "[!#1]C(=O)N1[CH2][CH2]c2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)N1[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]C(=O)n1nnc2[cH][cH][cH][cH]c12",
                        "[!#1]C(=O)O[CH]([CH3])[CH3]",
                        "[!#1]C(=O)O[CH]([CH3])C(=C(Cl)Cl)Cl",
                        "[!#1]C(=O)O[CH2][CH]([CH3])[CH3]",
                        "[!#1]C(=O)O[CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)O[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)O[CH2][CH2][CH2][CH3]",
                        "[!#1]C(=O)O[CH2][CH2][CH2]N([CH3])[CH3]",
                        "[!#1]C(=O)O[CH2][CH2][CH3]",
                        "[!#1]C(=O)O[CH2][CH2][NH2]",
                        "[!#1]C(=O)O[CH2][CH2][OH]",
                        "[!#1]C(=O)O[CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]C(=O)O[CH2][CH2]N([CH3])[CH3]",
                        "[!#1]C(=O)O[CH2][CH3]",
                        "[!#1]C(=O)O[CH2]C#[CH]",
                        "[!#1]C(=O)O[CH2]C(=C(Cl)Cl)Cl",
                        "[!#1]C(=O)O[CH2]C(F)(F)C(F)(F)F",
                        "[!#1]C(=O)O[CH3]",
                        "[!#1]C(=O)OC([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)ON=[CH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]C(=O)ON=C([CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]C(=O)ON=C([CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]C(=S)[NH][CH2]C(=[CH2])[CH3]",
                        "[!#1]C(=S)[NH2]",
                        "[!#1]C(=S)S[CH2][CH2]C(=O)[OH]",
                        "[!#1]C(Cl)(Cl)Cl",
                        "[!#1]C(F)(F)[CH](F)F",
                        "[!#1]C(F)(F)C(F)(F)[CH](F)F",
                        "[!#1]C(F)(F)C(F)(F)F",
                        "[!#1]C(F)(F)F",
                        "[!#1]C1([!#1])[CH]2[CH2][CH2]C([CH3])(C1=O)C2([CH3])[CH3]",
                        "[!#1]C1([!#1])[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C1([!#1])[CH2][CH2][CH2][CH2]1",
                        "[!#1]C1([!#1])C(=NN(C1=O)c2[cH][cH]c([cH][cH]2)[N+](=O)[O-])[CH3]",
                        "[!#1]C1([!#1])C(=O)[CH2]C([CH3])([CH3])[CH2]C1=O",
                        "[!#1]C1([!#1])C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]C1([!#1])C(=O)N(N=C1c2[cH][cH][cH][cH][cH]2)c3[cH][cH]c([cH][cH]3)[N+](=O)[O-]",
                        "[!#1]C1([!#1])C(=O)OC([CH3])([CH3])OC1=O",
                        "[!#1]C1([!#1])S(c2[cH][cH][cH][cH]c2C1=O)", // [!#1]C1([!#1])Sc2[cH][cH][cH][cH]c2C1=O
                        "[!#1]C1([CH2][CH]2[CH2][CH]3[CH2][CH]([CH2]2)[CH2]1)[CH2]3",
                        "[!#1]C1([CH2][CH]2[CH2][CH]3[CH2][CH]2[CH2]1)[CH2]3",
                        "[!#1]C1([CH2][CH]2[CH2][CH]3[CH2]1)[CH2][CH]([CH2]2)[CH2][CH2]3",
                        "[!#1]C1([CH2][CH]2[CH2][CH]3[CH2]1)[CH2]C([!#1])([CH2]2)[CH2]3",
                        "[!#1]C1([CH2][CH]2[CH2][CH]3[CH2]1)[CH2]C([OH])([CH2]2)[CH2]3",
                        "[!#1]C1([CH2][CH3])C(=[NH])[NH]C(=O)[NH]C1=O",
                        "[!#1]C1([CH2]N2[CH2]N3[CH2]1)C(=O)C([!#1])([CH2]2)[CH2]3",
                        "[!#1]C1([CH3])O[CH2][CH2]O1",
                        "[!#1]C1([OH])[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]C1([OH])[CH2][CH2][CH2][CH2]1",
                        "[!#1]C1([OH])C(=O)[NH]c2[cH][cH][cH][cH]c21",
                        "[!#1]C1([OH])N(C(=O)[NH]c2[cH][cH][cH][cH]c21)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C1(C(=O)c2[cH][cH][cH][cH]c2C1=O)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C1(C(=O)N(c2[cH][cH][cH][cH]c21)c3[cH][cH][cH][cH][cH]3)C(F)(F)F",
                        "[!#1]C1(F)OC([!#1])(F)C([!#1])(F)C1([!#1])F",
                        "[!#1]C1(F)OC(F)(F)C(F)(F)C1(F)F",
                        "[!#1]C1(O[CH]2[CH]=[CH]1)[CH]3[CH]2C(=O)N(C3=O)c4[cH][cH][cH][cH][cH]4",
                        "[!#1]C1(Oc2[cH][cH][cH][cH]c2O1)C(Cl)(Cl)Cl",
                        "[!#1]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]c1[cH][cH][cH][cH][n+]1[!#1]",
                        "[!#1]c1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1]c1[cH][cH][cH][cH]c1[CH2][CH3]",
                        "[!#1]c1[cH][cH][cH][cH]c1[CH3]",
                        "[!#1]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]c1[cH][cH][cH][cH]c1[NH2]",
                        "[!#1]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]c1[cH][cH][cH][cH]c1Br",
                        "[!#1]c1[cH][cH][cH][cH]c1C#N",
                        "[!#1]c1[cH][cH][cH][cH]c1C(=O)[CH3]",
                        "[!#1]c1[cH][cH][cH][cH]c1C(=O)[OH]",
                        "[!#1]c1[cH][cH][cH][cH]c1C(=O)c2[cH]c([!#1])nnc2[!#1]",
                        "[!#1]c1[cH][cH][cH][cH]c1C(F)(F)F",
                        "[!#1]c1[cH][cH][cH][cH]c1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH][cH][cH]c1c2[cH][cH][cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH][cH][cH]c1c2n[nH]c(=S)[nH]c2=O",
                        "[!#1]c1[cH][cH][cH][cH]c1c2nc3[cH][cH][cH][cH]c3c(=O)[nH]2",
                        "[!#1]c1[cH][cH][cH][cH]c1c2nc3[cH][cH][cH][cH]c3s2",
                        "[!#1]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1]c1[cH][cH][cH][cH]c1F",
                        "[!#1]c1[cH][cH][cH][cH]c1I",
                        "[!#1]c1[cH][cH][cH][cH]c1N2C(=O)[CH]=[CH]C2=O",
                        "[!#1]c1[cH][cH][cH][cH]c1N2C(=O)[CH]3[CH]([CH]([CH]=[CH][CH]3c4[cH][cH][cH][cH][cH]4)c5[cH][cH][cH][cH][cH]5)C2=O",
                        "[!#1]c1[cH][cH][cH][cH]c1O[CH3]",
                        "[!#1]c1[cH][cH][cH][cH]n1",
                        "[!#1]c1[cH][cH][cH][nH]1",
                        "[!#1]c1[cH][cH][cH]c([!#1])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([!#1])c1[!#1]",
                        "[!#1]c1[cH][cH][cH]c([!#1])c1n2nnnc2C3([!#1])[CH2][CH2][CH2][CH2][CH2]3",
                        "[!#1]c1[cH][cH][cH]c([!#1])n1",
                        "[!#1]c1[cH][cH][cH]c([CH]=[CH]C(=O)[OH])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([cH]1)[CH]2[CH2]C(=N[CH2][CH2]S2)c3c([!#1])[cH]c([!#1])oc3=O",
                        "[!#1]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH][cH]c([cH]1)C(=O)[CH3]",
                        "[!#1]c1[cH][cH][cH]c([cH]1)C(=O)[OH]",
                        "[!#1]c1[cH][cH][cH]c([cH]1)C(F)(F)F",
                        "[!#1]c1[cH][cH][cH]c([cH]1)c2[cH]nc3[cH][cH][cH][cH]c3n2",
                        "[!#1]c1[cH][cH][cH]c([cH]1)c2nc3[cH][cH][cH][cH]c3o2",
                        "[!#1]c1[cH][cH][cH]c([cH]1)c2nc3[cH]c([!#1])[cH][cH]c3o2",
                        "[!#1]c1[cH][cH][cH]c([cH]1)N2[CH2][CH2][CH2]C2=O",
                        "[!#1]c1[cH][cH][cH]c([cH]1)N2C(=O)c3[cH][cH][cH][cH]c3C2=O",
                        "[!#1]c1[cH][cH][cH]c([cH]1)S(=O)(=O)[!#1]",
                        "[!#1]c1[cH][cH][cH]c([CH2][CH3])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([CH2][OH])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([CH3])c1[CH3]",
                        "[!#1]c1[cH][cH][cH]c([CH3])n1",
                        "[!#1]c1[cH][cH][cH]c([N+](=O)[O-])c1[!#1]",
                        "[!#1]c1[cH][cH][cH]c([NH2])[cH]1",
                        "[!#1]c1[cH][cH][cH]c([OH])[cH]1",
                        "[!#1]c1[cH][cH][cH]c(Br)[cH]1",
                        "[!#1]c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1]c1[cH][cH][cH]c(Cl)c1[CH3]",
                        "[!#1]c1[cH][cH][cH]c(Cl)c1Cl",
                        "[!#1]c1[cH][cH][cH]c(F)[cH]1",
                        "[!#1]c1[cH][cH][cH]c(I)[cH]1",
                        "[!#1]c1[cH][cH][cH]c(O[CH3])[cH]1",
                        "[!#1]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH][cH]c2[cH][cH][cH]c([!#1])c12",
                        "[!#1]c1[cH][cH][cH]c2[cH][cH][cH]nc12",
                        "[!#1]c1[cH][cH][cH]c2[CH2][CH2][CH2][CH2]c12",
                        "[!#1]c1[cH][cH][cH]c2c([!#1])[cH][cH][cH]c12",
                        "[!#1]c1[cH][cH][cH]c2c(=O)[nH][nH]c(=O)c12",
                        "[!#1]c1[cH][cH][cH]c2C(=O)c3[cH][cH][cH][cH]c3C(=O)c12",
                        "[!#1]c1[cH][cH][cH]c2C(=O)c3[cH][cH][cH]c([!#1])c3C(=O)c12",
                        "[!#1]c1[cH][cH][cH]c2c3[CH2][CH2][CH2][CH2]c3oc12",
                        "[!#1]c1[cH][cH][cH]c2n[cH][cH][cH]c12",
                        "[!#1]c1[cH][cH][cH]c2nsnc12",
                        "[!#1]c1[cH][cH][cH]n[cH]1",
                        "[!#1]c1[cH][cH][cH]nc1[!#1]",
                        "[!#1]c1[cH][cH][cH]nc1c2[cH]c([!#1])c([!#1])c([!#1])[cH]2",
                        "[!#1]c1[cH][cH][cH]nc1c2n[cH][cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH][cH]o1",
                        "[!#1]c1[cH][cH][cH]s1",
                        "[!#1]c1[cH][cH][n+]([!#1])[cH][cH]1",
                        "[!#1]c1[cH][cH][n+]([!#1])c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH][n+]([O-])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([!#1])[cH]c1S(=O)(=O)c2[cH]c([!#1])[cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH]c([!#1])[n+]([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1[cH][cH]c([!#1])c([!#1])n1",
                        "[!#1]c1[cH][cH]c([!#1])c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([!#1])c([cH]1)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c([!#1])c([cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH]c([!#1])c([cH]1)c2nc3[cH][cH][cH][cH]c3s2",
                        "[!#1]c1[cH][cH]c([!#1])c([CH3])[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])c([OH])[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]c([!#1])c2c([!#1])[cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]c([!#1])c2n[cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]c([!#1])c2nonc12",
                        "[!#1]c1[cH][cH]c([!#1])n[cH]1",
                        "[!#1]c1[cH][cH]c([!#1])n1c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1[cH][cH]c([!#1])nn1",
                        "[!#1]c1[cH][cH]c([!#1])o1",
                        "[!#1]c1[cH][cH]c([!#1])s1",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]([CH3])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]2[CH]3[CH2][CH]4[CH2][CH]([CH2]3)[CH2][CH]2[CH2]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]2[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]2[NH]c3[cH][cH]c4n[cH][cH][cH]c4c3C5=C2C(=O)[CH2][CH2][CH2]5",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]2N([CH2][CH2]N2c3[cH][cH][cH][cH][cH]3)c4[cH][cH][cH][cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[CH]2N=NC(=[CH][CH]2c3[cH][cH][cH][cH][cH]3)[CH]4C(=O)c5[cH][cH][cH][cH]c5C4=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)[NH](=O)[OH]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C([!#1])([CH3])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C(=N[NH]c2[cH][cH]c([cH]c2[N+](=O)[O-])[N+](=O)[O-])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C(=N[OH])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C(=O)[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C(=O)C(=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C2([!#1])C(=O)c3[cH][cH][cH][cH]c3C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C2([CH2][CH]3[CH2][CH]4[CH2][CH]([CH2]3)[CH2]2)[CH2]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C2([NH]C(=O)c3[cH][cH][cH][cH]c32)c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C2(c3[cH][cH][cH][cH]c3-c4[cH][cH][cH][cH]c42)c5[cH][cH]c([!#1])[cH][cH]5",
                        "[!#1]c1[cH][cH]c([cH][cH]1)C2(OC(=O)c3[cH][cH][cH][cH]c32)c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH][cH][cH]c(n2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH][cH]c([cH][cH]2)S(=O)(=O)[!#1]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH]c(nc(n2)c3[cH][cH][cH][cH][cH]3)c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH]nc(n[cH]2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2[cH]nc3[cH][cH][cH][cH]c3n2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2n[cH][cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc([!#1])[cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc([!#1])[cH]c([!#1])c2[!#1]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc(c3[cH][cH]c([!#1])[cH][cH]3)c4[cH][cH][cH][cH]c4n2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH][cH][cH]c3[nH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH][cH][cH]c3nc2c4[cH][cH][cH][cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH][cH][cH]c3nc2c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH][cH][cH]c3o2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH][cH][cH]c3s2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH]c([!#1])[cH]c3[nH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH]c([!#1])[cH]c3o2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH]c([!#1])[cH]c3s2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH][cH]c([cH]c3[nH]2)c4nc5[cH][cH]c([!#1])[cH]c5[nH]4",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH]c([!#1])[cH][cH]c3[nH]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2nc3[cH]c([!#1])[cH][cH]c3o2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)c2sc(c(c2c3[cH][cH][cH][cH][cH]3)c4[cH][cH][cH][cH][cH]4)c5[cH][cH]c([!#1])[cH][cH]5",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N([CH3])[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2[CH2][CH2][CH2]C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2[CH2][CH2]C(=N2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2[CH2][CH2]O[CH2][CH2]2",
                        "[!#1]c1[cH][cH]c([cH][cH]1)n2c([CH3])[cH][cH]c2[CH3]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH]=[CH]C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH]3[CH]4[CH2][CH]([CH]=[CH]4)[CH]3C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH2][CH](N3[CH2][CH2][CH2][CH2][CH2]3)C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH2][CH](N3[CH2][CH2][CH2][CH2]3)C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH2][CH](N3[CH2][CH2]N([CH2][CH2]3)[CH]4[CH2]C(=O)N(C4=O)c5[cH][cH]c([!#1])[cH][cH]5)C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH2][CH](N3[CH2][CH2]N([CH2][CH2]3)c4n[cH][cH][cH]n4)C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)[CH2][CH](N3[CH2][CH2]O[CH2][CH2]3)C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)c3[cH][cH][cH][cH]c3C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)c3[cH][cH][cH]c([!#1])c3C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)c3[cH][cH]c([!#1])[cH]c3C2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)N2C(=O)c3[cH][cH]c([cH]c3C2=O)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)n2c(=O)c3[cH]c4c(=O)n(c5[cH][cH]c([!#1])[cH][cH]5)c(=O)c4[cH]c3c2=O",
                        "[!#1]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[NH2]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)S(=O)(=O)[OH]",
                        "[!#1]c1[cH][cH]c([cH][cH]1)S(=O)(=O)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1[cH][cH]c([CH]=[CH]c2[cH][cH][cH][cH][cH]2)[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH]=[CH]c2[cH][cH]c([!#1])[cH]c2S(=O)(=O)[OH])c([cH]1)S(=O)(=O)[OH]",
                        "[!#1]c1[cH][cH]c([CH]=N[NH]c2[cH][cH]c([cH][cH]2)S(=O)(=O)[OH])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH]=N[NH]c2nc([!#1])nc([!#1])n2)o1",
                        "[!#1]c1[cH][cH]c([CH]=O)[cH][cH]1",
                        "[!#1]c1[cH][cH]c([cH]c1[!#1])[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH]c1[!#1])C(=O)[OH]",
                        "[!#1]c1[cH][cH]c([cH]c1[!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH]c([cH]c1[!#1])c2[cH][cH]c([!#1])c([!#1])[cH]2",
                        "[!#1]c1[cH][cH]c([cH]c1[!#1])c2n[cH][cH][cH]c2[!#1]",
                        "[!#1]c1[cH][cH]c([cH]c1[CH3])[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH]c1[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH][cH]c([cH]c1[CH3])c2[cH][cH]c([!#1])c([CH3])[cH]2",
                        "[!#1]c1[cH][cH]c([cH]c1[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH]c1[N+](=O)[O-])C(F)(F)F",
                        "[!#1]c1[cH][cH]c([cH]c1[N+](=O)[O-])S(=O)(=O)[!#1]",
                        "[!#1]c1[cH][cH]c([cH]c1Br)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH]c1C(=O)[OH])[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([cH]c1Cl)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([CH2][CH2][CH3])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH2][CH3])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH2]c2[cH][cH]c([!#1])[cH][cH]2)[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([CH3])[cH]c1[CH3]",
                        "[!#1]c1[cH][cH]c([CH3])[cH]c1[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([CH3])[cH]c1[OH]",
                        "[!#1]c1[cH][cH]c([CH3])[cH]c1Br",
                        "[!#1]c1[cH][cH]c([CH3])[cH]n1",
                        "[!#1]c1[cH][cH]c([CH3])c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([CH3])c([CH3])[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])c([NH2])[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])c(Br)[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])c(I)[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])n[cH]1",
                        "[!#1]c1[cH][cH]c([CH3])o1",
                        "[!#1]c1[cH][cH]c([N+](=O)[O-])c([CH3])[cH]1",
                        "[!#1]c1[cH][cH]c([N+](=O)[O-])c2nonc12",
                        "[!#1]c1[cH][cH]c([NH2])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([NH2])c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]c1[cH][cH]c([OH])[cH]c1[OH]",
                        "[!#1]c1[cH][cH]c([OH])c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c([OH])c([cH]1)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c([OH])c([OH])[cH]1",
                        "[!#1]c1[cH][cH]c(=S)[nH]n1",
                        "[!#1]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(Br)[cH]c1[!#1]",
                        "[!#1]c1[cH][cH]c(Br)[cH]c1Br",
                        "[!#1]c1[cH][cH]c(Br)[cH]n1",
                        "[!#1]c1[cH][cH]c(Br)c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c(Br)c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c(Br)c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c(Br)c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]c(Br)o1",
                        "[!#1]c1[cH][cH]c(C(=O)[OH])c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c(C(=O)[OH])c([cH]1)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(Cl)[cH]c1[!#1]",
                        "[!#1]c1[cH][cH]c(Cl)[cH]c1[CH3]",
                        "[!#1]c1[cH][cH]c(Cl)[cH]c1[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c(Cl)[cH]c1Br",
                        "[!#1]c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1]c1[cH][cH]c(Cl)[cH]n1",
                        "[!#1]c1[cH][cH]c(Cl)c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c(Cl)c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c(Cl)c([CH3])[cH]1",
                        "[!#1]c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c(Cl)c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]c(F)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(F)[cH]c1F",
                        "[!#1]c1[cH][cH]c(F)c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c(F)c(F)[cH]1",
                        "[!#1]c1[cH][cH]c(I)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=[CH]c2[cH][cH][cH][cH]c2[OH])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=[CH]c2[cH][cH]c([cH][cH]2)[N+](=O)[O-])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=[CH]c2[cH]c([cH][cH]c2[OH])[N+](=O)[O-])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=[CH]c2c([OH])[cH][cH]c3[cH][cH][cH][cH]c23)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=[N+]=[N-])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(N=Nc2[cH][cH][cH][cH]c2[CH3])[cH]c1[CH3]",
                        "[!#1]c1[cH][cH]c(N2[CH2][CH2][CH2]C2=O)c([!#1])[cH]1",
                        "[!#1]c1[cH][cH]c(O[CH3])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(O[CH3])[cH]c1[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c(O[CH3])[cH]c1Br",
                        "[!#1]c1[cH][cH]c(O[CH3])[cH]c1O[CH3]",
                        "[!#1]c1[cH][cH]c(O[CH3])c(Cl)[cH]1",
                        "[!#1]c1[cH][cH]c(O[CH3])c(O[CH3])[cH]1",
                        "[!#1]c1[cH][cH]c(O[CH3])nn1",
                        "[!#1]c1[cH][cH]c(o1)[CH]2[CH2][CH]2[CH]3[CH2][CH2]3",
                        "[!#1]c1[cH][cH]c(o1)c2[cH][cH][cH]c([!#1])[cH]2",
                        "[!#1]c1[cH][cH]c(o1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1[cH][cH]c(S[CH2][CH2]c2[cH][cH]n[cH][cH]2)[cH][cH]1",
                        "[!#1]c1[cH][cH]c(S[CH3])[cH][cH]1",
                        "[!#1]c1[cH][cH]c(s1)C(=O)[OH]",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH][cH]c2[n+]1[!#1]",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH][cH]c2c1[!#1]",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH][cH]c2c1Br",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH][cH]c2n1",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH]c([!#1])c2n1",
                        "[!#1]c1[cH][cH]c2[cH][cH][cH]c([OH])c2n1",
                        "[!#1]c1[cH][cH]c2[cH][cH]c([!#1])[cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[CH]3c4[cH][cH][cH][cH]c4[CH](c5[cH][cH][cH][cH]c35)c2[cH]1",
                        "[!#1]c1[cH][cH]c2[CH]3c4[cH][cH][cH][cH]c4[CH](c5[cH][cH]c([!#1])[cH]c35)c2[cH]1",
                        "[!#1]c1[cH][cH]c2[cH]c([!#1])[cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[cH]c([!#1])c(=O)oc2[cH]1",
                        "[!#1]c1[cH][cH]c2[cH]c([OH])[cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[CH2][CH2]c3[cH][cH][cH][cH]c3[NH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[CH2][CH2]c3[cH][cH][cH]c1c32",
                        "[!#1]c1[cH][cH]c2[CH2]OC(=O)c2[cH]1",
                        "[!#1]c1[cH][cH]c2[n+]([!#1])[cH][cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[n+]([!#1])c([!#1])[cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[nH]c(=O)[nH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2[NH]C(=O)C(=O)c2[cH]1",
                        "[!#1]c1[cH][cH]c2[nH]c(=O)oc2[cH]1",
                        "[!#1]c1[cH][cH]c2[nH]c3C(=O)[CH2][CH2][CH2]c3c2[cH]1",
                        "[!#1]c1[cH][cH]c2[nH]c3C(=O)[NH][CH2][CH2]c3c2[cH]1",
                        "[!#1]c1[cH][cH]c2c([!#1])[cH]c(=O)oc2[cH]1",
                        "[!#1]c1[cH][cH]c2c([!#1])[n+]([!#1])[cH][cH]n12",
                        "[!#1]c1[cH][cH]c2c([!#1])c([!#1])[cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2c([!#1])nc([!#1])nc2[cH]1",
                        "[!#1]c1[cH][cH]c2c([cH]1)-c3[cH]c([!#1])[cH][cH]c3S2(=O)=O",
                        "[!#1]c1[cH][cH]c2c([cH]1)nc3c4[cH][cH]c([!#1])c5[cH][cH][cH]c(c(=O)n23)c54",
                        "[!#1]c1[cH][cH]c2c([cH]1)oc3[cH][cH][cH][cH]c32",
                        "[!#1]c1[cH][cH]c-2c([CH2]c3[cH][cH][cH][cH]c32)[cH]1",
                        "[!#1]c1[cH][cH]c-2c([CH2]c3[cH]c([!#1])[cH][cH]c32)[cH]1",
                        "[!#1]c1[cH][cH]c2c([CH3])[cH]c(=O)oc2[cH]1",
                        "[!#1]c1[cH][cH]c2c(=O)c([!#1])[cH]oc2[cH]1",
                        "[!#1]c1[cH][cH]c2c(=O)c([!#1])c([!#1])oc2[cH]1",
                        "[!#1]c1[cH][cH]c2c(=O)c([!#1])c([CH3])oc2[cH]1",
                        "[!#1]c1[cH][cH]c2c(=O)c([cH]oc2[cH]1)c3[cH][cH]c4O[CH2][CH2]Oc4[cH]3",
                        "[!#1]c1[cH][cH]c2C(=O)c3[cH][cH][cH][cH]c3C(=O)c2[cH]1",
                        "[!#1]c1[cH][cH]c2C(=O)c3[cH][cH][cH][cH]c3-c2[cH]1",
                        "[!#1]c1[cH][cH]c2C(=O)N(C(=O)c2[cH]1)c3[cH][cH][cH][cH]c3[!#1]",
                        "[!#1]c1[cH][cH]c2C(=O)N(C(=O)c2[cH]1)c3[cH][cH][cH]c([!#1])[cH]3",
                        "[!#1]c1[cH][cH]c2C(=O)N(C(=O)c2[cH]1)c3[cH][cH][cH]c(n3)N4C(=O)c5[cH][cH]c([!#1])[cH]c5C4=O",
                        "[!#1]c1[cH][cH]c2C(=O)N(C(=O)c2[cH]1)c3[cH][cH][cH]c4[cH][cH][cH][cH]c34",
                        "[!#1]c1[cH][cH]c2C(=O)OC(=O)c2[cH]1",
                        "[!#1]c1[cH][cH]c2-c3[cH][cH]c([!#1])[cH]c3S(=O)(=O)c2[cH]1",
                        "[!#1]c1[cH][cH]c2n([!#1])c([CH3])c([CH3])c2[cH]1",
                        "[!#1]c1[cH][cH]c2n([!#1])c(=O)oc2[cH]1",
                        "[!#1]c1[cH][cH]c2n([!#1])c3[cH][cH][cH][cH]c3c2[cH]1",
                        "[!#1]c1[cH][cH]c2n([!#1])c3[cH][cH]c([!#1])[cH]c3c2[cH]1",
                        "[!#1]c1[cH][cH]c2N([CH2][CH3])C(=O)c3[cH][cH][cH]c1c23",
                        "[!#1]c1[cH][cH]c2n[cH][cH][cH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2n[cH][nH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2n[cH]nc3-c4[cH][cH][cH][cH]c4C(=O)c1c32",
                        "[!#1]c1[cH][cH]c2N=C(c3[cH][cH][cH][cH][cH]3)c4[cH]c([!#1])[cH][cH]c4N=C(c5[cH][cH][cH][cH][cH]5)c2[cH]1",
                        "[!#1]c1[cH][cH]c2n3[CH2][CH2][CH2]c3nc2[cH]1",
                        "[!#1]c1[cH][cH]c2n3[CH2][CH2][NH][CH]4[CH2][CH2][CH2]c(c43)c2[cH]1",
                        "[!#1]c1[cH][cH]c2nc([CH3])[nH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2nc(nc(c3[cH][cH][cH][cH][cH]3)c2[cH]1)c4[cH][cH]c([cH][cH]4)c5nc(c6[cH][cH][cH][cH][cH]6)c7[cH]c([!#1])[cH][cH]c7n5",
                        "[!#1]c1[cH][cH]c2nc(oc(=O)c2[cH]1)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH][cH]c2nc3[cH][cH][cH][cH]c3[n+]([!#1])c2[cH]1",
                        "[!#1]c1[cH][cH]c2nc3[CH2][CH2][CH2][CH2]c3n2[cH]1",
                        "[!#1]c1[cH][cH]c2nc3c([cH]c2[cH]1)n([!#1])c4[cH][cH][cH][cH]c43",
                        "[!#1]c1[cH][cH]c2nc3c(=O)[nH]c(=O)nc3[nH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2nc3c(=O)n([!#1])c(=O)[nH]c3nc2[cH]1",
                        "[!#1]c1[cH][cH]c2nn(nc2[cH]1)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH][cH]c2nn[nH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2nonc2c1[!#1]",
                        "[!#1]c1[cH][cH]c2nsnc2c1[N+](=O)[O-]",
                        "[!#1]c1[cH][cH]c2o[cH]nc2[cH]1",
                        "[!#1]c1[cH][cH]c2O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]Oc2[cH]1",
                        "[!#1]c1[cH][cH]c2O[CH2][CH2]Oc2[cH]1",
                        "[!#1]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH][cH][cH]c3[!#1]",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH][cH]n[cH]3",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH]c([!#1])c([!#1])[cH]3",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH]c([CH2][CH3])[cH][cH]3",
                        "[!#1]c1[cH][cH]c2oc(nc2[cH]1)c3[cH][cH]c(c4nc5[cH]c([!#1])[cH][cH]c5o4)c6[cH][cH][cH][cH]c36",
                        "[!#1]c1[cH][cH]c2oc3[cH][cH]c([!#1])[cH]c3c2[cH]1",
                        "[!#1]c1[cH][cH]c2S(=O)c3[cH][cH][cH][cH]c3[NH]c2[cH]1",
                        "[!#1]c1[cH][cH]c2sc([CH3])nc2[cH]1",
                        "[!#1]c1[cH][cH]n([!#1])n1",
                        "[!#1]c1[cH][cH]n(n1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][cH]n[cH][cH]1",
                        "[!#1]c1[cH][cH]n[nH]1",
                        "[!#1]c1[cH][cH]nc([!#1])[cH]1",
                        "[!#1]c1[cH][cH]nc([!#1])n1",
                        "[!#1]c1[cH][cH]nc2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][cH]nc2[cH]c3[cH][cH][cH][cH]c3[cH]c12",
                        "[!#1]c1[cH][cH]nn1[!#1]",
                        "[!#1]c1[cH][cH]nn1[CH3]",
                        "[!#1]c1[cH][cH]o[cH]1",
                        "[!#1]c1[cH][cH]s[cH]1",
                        "[!#1]c1[cH][cH]sc1[!#1]",
                        "[!#1]c1[cH][cH]sc1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH][nH]c(=O)[nH]c1=O",
                        "[!#1]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH][nH]c2[cH][cH][cH]nc12",
                        "[!#1]c1[cH][nH]c2[cH][cH]c([!#1])[cH]c12",
                        "[!#1]c1[cH][nH]c2[cH][cH]c(O[CH3])[cH]c12",
                        "[!#1]c1[cH][nH]c2c([!#1])[cH][cH][cH]c12",
                        "[!#1]c1[cH][nH]nc1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH]c([!#1])[cH]c([!#1])[cH]1",
                        "[!#1]c1[cH]c([!#1])[cH]c([cH]1)N2C(=O)c3[cH][cH][cH][cH]c3C2=O",
                        "[!#1]c1[cH]c([!#1])[cH]c([CH3])[cH]1",
                        "[!#1]c1[cH]c([!#1])[nH]c(=O)n1",
                        "[!#1]c1[cH]c([!#1])[nH]n1",
                        "[!#1]c1[cH]c([!#1])c([!#1])[cH]c1[!#1]",
                        "[!#1]c1[cH]c([!#1])c([!#1])c([!#1])[cH]1",
                        "[!#1]c1[cH]c([!#1])c([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1[cH]c([!#1])c([!#1])c([!#1])n1",
                        "[!#1]c1[cH]c([!#1])c([!#1])c(=O)[nH]1",
                        "[!#1]c1[cH]c([!#1])c([!#1])c(=O)o1",
                        "[!#1]c1[cH]c([!#1])c([!#1])s1",
                        "[!#1]c1[cH]c([!#1])c([OH])c(n1)C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH]c([!#1])c2[cH][cH][cH][cH]c2c1[!#1]",
                        "[!#1]c1[cH]c([!#1])c2[cH][cH][cH][cH]c2n1",
                        "[!#1]c1[cH]c([!#1])c2[cH][cH][cH]nc2c1[!#1]",
                        "[!#1]c1[cH]c([!#1])c2n([!#1])n[cH][n+]2n1",
                        "[!#1]c1[cH]c([!#1])n([!#1])c(=O)c1[!#1]",
                        "[!#1]c1[cH]c([!#1])n([!#1])c(=O)n1",
                        "[!#1]c1[cH]c([!#1])n([!#1])n1",
                        "[!#1]c1[cH]c([!#1])n(n1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH]c([!#1])nc([!#1])n1",
                        "[!#1]c1[cH]c([!#1])on1",
                        "[!#1]c1[cH]c([cH][cH]c1[CH3])[CH]([CH3])[CH3]",
                        "[!#1]c1[cH]c([cH][cH]c1[CH3])[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH][cH]c1[OH])S(=O)(=O)c2[cH][cH]c([OH])c([!#1])[cH]2",
                        "[!#1]c1[cH]c([cH][cH]c1C(=O)[OH])[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH][cH]c1C(=O)[OH])C(=O)[OH]",
                        "[!#1]c1[cH]c([cH][cH]c1Cl)[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH][cH]c1Cl)C(F)(F)F",
                        "[!#1]c1[cH]c([cH][cH]c1O[CH3])[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH]c([cH]1)[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1]c1[cH]c([cH]c([cH]1)C([CH3])([CH3])[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH]c([cH]c([cH]1)C(=O)[OH])C(=O)[OH]",
                        "[!#1]c1[cH]c([cH]c(c1[OH])C([CH3])([CH3])[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH]c([CH3])[cH][cH]c1[CH]([CH3])[CH3]",
                        "[!#1]c1[cH]c([CH3])[cH][cH]c1[CH3]",
                        "[!#1]c1[cH]c([CH3])[cH][cH]n1",
                        "[!#1]c1[cH]c([CH3])[cH]c([CH3])[cH]1",
                        "[!#1]c1[cH]c([CH3])c(Br)[cH]c1[CH]([CH3])[CH3]",
                        "[!#1]c1[cH]c([CH3])c(Cl)c([CH3])[cH]1",
                        "[!#1]c1[cH]c([CH3])n[nH]1",
                        "[!#1]c1[cH]c([CH3])nc([!#1])c1[OH]",
                        "[!#1]c1[cH]c([CH3])nc2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH]c([N+](=O)[O-])c([CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1]c1[cH]c([N+](=O)[O-])c(Cl)[cH]c1Cl",
                        "[!#1]c1[cH]c([nH]n1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH]c([OH])[cH][cH]c1[OH]",
                        "[!#1]c1[cH]c([OH])[cH]c([OH])[cH]1",
                        "[!#1]c1[cH]c(=O)[nH]c([!#1])n1",
                        "[!#1]c1[cH]c(=O)oc2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH]c(=O)oc2[cH][cH]c([cH]c12)[N+](=O)[O-]",
                        "[!#1]c1[cH]c(Br)[cH]c(Br)c1[!#1]",
                        "[!#1]c1[cH]c(Br)[cH]c(Br)c1[OH]",
                        "[!#1]c1[cH]c(Br)[cH]c(C(=O)[OH])c1[!#1]",
                        "[!#1]c1[cH]c(Br)c([OH])c(Br)[cH]1",
                        "[!#1]c1[cH]c(c([OH])c([cH]1)C([CH3])([CH3])[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]c1[cH]c(C(=O)[OH])c([!#1])[cH]c1C(=O)[OH]",
                        "[!#1]c1[cH]c(Cl)[cH][cH]c1[OH]",
                        "[!#1]c1[cH]c(Cl)[cH][cH]c1Cl",
                        "[!#1]c1[cH]c(Cl)[cH]c(Cl)[cH]1",
                        "[!#1]c1[cH]c(Cl)[cH]c(Cl)c1O[CH3]",
                        "[!#1]c1[cH]c(Cl)c([!#1])c(Cl)[cH]1",
                        "[!#1]c1[cH]c(Cl)c(Cl)[cH]c1Cl",
                        "[!#1]c1[cH]c(n[nH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH]c(n[nH]1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1[cH]c(nc2[cH][cH][cH][cH]c12)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH]c(nc2[cH][cH][cH][cH]c12)N([CH3])[CH3]",
                        "[!#1]c1[cH]c(nn1c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH]c(nn1c2[cH][cH][cH][cH][cH]2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]c1[cH]c(O[CH3])[cH][cH]c1O[CH3]",
                        "[!#1]c1[cH]c(O[CH3])[cH]c(O[CH3])[cH]1",
                        "[!#1]c1[cH]c(O[CH3])c(O[CH3])[cH]c1[!#1]",
                        "[!#1]c1[cH]c(O[CH3])c(O[CH3])c(O[CH3])[cH]1",
                        "[!#1]c1[cH]c(O[CH3])nc(O[CH3])n1",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2[cH]c1[!#1]",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2[cH]c1[OH]",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2[cH]c1O[CH3]",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2[nH]1",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2nc1[!#1]",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2o1",
                        "[!#1]c1[cH]c2[cH][cH][cH][cH]c2oc1=O",
                        "[!#1]c1[cH]c2C(=N[OH])[CH2][CH2][CH2][CH2]c2s1",
                        "[!#1]c1[cH]c2nc3[cH][cH][cH][cH]c3nc2[cH]c1[!#1]",
                        "[!#1]c1[cH]c2O[CH2][CH2]Oc2[cH]c1[!#1]",
                        "[!#1]c1[cH]c2O[CH2]Oc2[cH]c1[!#1]",
                        "[!#1]c1[cH]n([!#1])c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH]n([!#1])c2[cH][cH]c([!#1])[cH]c12",
                        "[!#1]c1[cH]n([!#1])nc1[!#1]",
                        "[!#1]c1[cH]n(C(=O)[CH3])c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[cH]n(nc1c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1[cH]n[cH]c([!#1])[cH]1",
                        "[!#1]c1[cH]n[cH]c(Br)[cH]1",
                        "[!#1]c1[cH]n[nH]c1[!#1]",
                        "[!#1]c1[cH]n2[cH][cH][cH][cH]c2n1",
                        "[!#1]c1[cH]n2[CH2][CH2][CH2]c2n1",
                        "[!#1]c1[cH]n2c(n1)n([!#1])c3[cH][cH][cH][cH]c32",
                        "[!#1]c1[cH]nc([!#1])c([!#1])[cH]1",
                        "[!#1]c1[cH]nc([!#1])n[cH]1",
                        "[!#1]c1[cH]nc([!#1])n1[!#1]",
                        "[!#1]c1[cH]nc([!#1])o1",
                        "[!#1]c1[cH]nc2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1]c1[cH]nc2[cH][cH][cH][cH]c2n1",
                        "[!#1]c1[cH]nn([!#1])c1[!#1]",
                        "[!#1]c1[cH]nn([cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1[cH]oc2[cH][cH]c([!#1])c([!#1])c12",
                        "[!#1]c1[cH]oc2c1[cH]c([!#1])c3[cH][cH][cH][cH]c23",
                        "[!#1]c1[cH]sc([!#1])n1",
                        "[!#1]c1[cH]sc([NH2])n1",
                        "[!#1]c1[n+]([!#1])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]c1[nH]c([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1[nH]c2[cH][cH][cH][cH]c2c1[!#1]",
                        "[!#1]c1[nH]c2[cH][cH]c([!#1])[cH]c2c1[!#1]",
                        "[!#1]c1[nH]n[cH]c1I",
                        "[!#1]c1[nH]nc([CH3])c1[N+](=O)[O-]",
                        "[!#1]c1[nH]nc([CH3])c1Br",
                        "[!#1]C1=[CH][CH2][CH2][CH2][CH2]1",
                        "[!#1]C1=[CH][NH][CH]2[CH]=[CH][CH]=[CH][CH]21",
                        "[!#1]C1=[CH]C(=O)[CH]=[CH]C1=O",
                        "[!#1]C1=[CH]C(=O)[CH2]C([!#1])([CH3])[CH2]1",
                        "[!#1]C1=[CH]C(=O)[CH2]C([CH3])([CH3])[CH2]1",
                        "[!#1]C1=[CH]C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]C1=[CH]C(=O)OC21[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]C1=[CH]O[CH2][CH2]O1",
                        "[!#1]C1=C([!#1])[CH]([NH]C(=O)[NH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]C1=C([!#1])[CH]([NH]C(=O)[NH]1)c2[cH][cH][cH]c([!#1])[cH]2",
                        "[!#1]C1=C([!#1])[CH](C2=C([CH2]C([!#1])([CH3])[CH2]C2=O)[NH]1)c3[cH][cH][cH]c([!#1])[cH]3",
                        "[!#1]C1=C([!#1])C(=O)[CH2]C([!#1])([CH3])[CH2]1",
                        "[!#1]C1=C([!#1])C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]C1=C([OH])[CH2]C([CH3])([CH3])[CH2]C1=O",
                        "[!#1]C1=C([OH])C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]C1=C(C(=O)c2[cH][cH][cH][cH]c12)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C1=C2[NH]c3[cH][cH][cH][cH]c3N2[CH2][CH2]C1=O",
                        "[!#1]C1=N[CH2][CH2][NH]1",
                        "[!#1]C1=N[CH2][CH2]c2[cH][cH][cH][cH]c12",
                        "[!#1]C1=N[CH2][CH2]n2[cH][cH][cH]c12",
                        "[!#1]C1=N[NH]C([CH2]1)(c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]C1=Nc2[cH][cH][cH][cH]c2[CH2][CH2][CH2]1",
                        "[!#1]C12[CH2][CH2][CH2][CH]2[CH]3[CH2][CH2][CH]1[CH2]3",
                        "[!#1]c1c([!#1])c([!#1])c([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1c([!#1])c(=O)n(c2[cH][cH][cH][cH][cH]2)n1[!#1]",
                        "[!#1]c1c([!#1])c2[cH][cH][cH][cH]c2n1[!#1]",
                        "[!#1]c1c([!#1])c2[cH][cH][cH][cH]c2oc1=O",
                        "[!#1]c1c([!#1])c2[cH][cH][cH][cH]c2sc1=O",
                        "[!#1]c1c([!#1])c2[cH]c([!#1])[cH][cH]c2n1[!#1]",
                        "[!#1]c1c([!#1])c2[cH]c([!#1])[cH][cH]c2n1c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1c([!#1])c2[cH]c([!#1])c([!#1])[cH]c2n1[!#1]",
                        "[!#1]c1c([cH][cH][cH]c1[N+](=O)[O-])C(=O)[OH]",
                        "[!#1]c1c([cH][cH]c2nonc12)[N+](=O)[O-]",
                        "[!#1]c1c([cH]c([cH]c1[CH]([CH3])[CH3])[CH]([CH3])[CH3])[CH]([CH3])[CH3]",
                        "[!#1]c1c([cH]c([cH]c1[N+](=O)[O-])C(=O)[OH])[N+](=O)[O-]",
                        "[!#1]c1c([cH]c([cH]c1[N+](=O)[O-])C(F)(F)F)[N+](=O)[O-]",
                        "[!#1]c1c([cH]c([CH3])[cH]c1[N+](=O)[O-])[N+](=O)[O-]",
                        "[!#1]c1c([cH]c([N+](=O)[O-])c2[cH][cH][cH]nc12)[N+](=O)[O-]",
                        "[!#1]c1c([cH]nn1[CH3])[N+](=O)[O-]",
                        "[!#1]c1c([CH3])[cH][cH][cH]c1[CH3]",
                        "[!#1]c1c([CH3])[cH][cH]c([CH3])c1[CH3]",
                        "[!#1]c1c([CH3])[cH]c([CH3])[cH]c1[CH3]",
                        "[!#1]c1c([CH3])[cH]c([CH3])c([CH]=N[OH])c1[CH3]",
                        "[!#1]c1c([CH3])[cH]c(Br)[cH]c1[CH3]",
                        "[!#1]c1c([CH3])[nH]c2[cH][cH][cH][cH]c12",
                        "[!#1]c1c([CH3])c([CH2][CH3])nc2[cH][cH][cH][cH]c12",
                        "[!#1]c1c([CH3])n([!#1])n([!#1])c1=O",
                        "[!#1]c1c([CH3])n([CH3])n(c2[cH][cH][cH][cH][cH]2)c1=O",
                        "[!#1]c1c([CH3])nn([!#1])c1[CH3]",
                        "[!#1]c1c([N+](=O)[O-])c([!#1])c([N+](=O)[O-])c([!#1])c1[N+](=O)[O-]",
                        "[!#1]c1c([nH]c2[cH][cH]c([!#1])[cH]c12)C(=O)[OH]",
                        "[!#1]c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]c1c([OH])[cH]c([OH])[cH]c1[OH]",
                        "[!#1]c1c([OH])c2[cH][cH][cH][cH]c2oc1=O",
                        "[!#1]c1c([OH])c2[cH][cH][cH][cH]c2sc1=O",
                        "[!#1]c1c(Br)[cH]c(Br)[cH]c1Br",
                        "[!#1]c1c(Br)[cH]c(Br)c2[cH][cH][cH]nc12",
                        "[!#1]c1c(c2[cH][cH][cH][cH][cH]2)c3[cH]c([!#1])[cH][cH]c3n1[!#1]",
                        "[!#1]c1c(Cl)[cH][cH][cH]c1Cl",
                        "[!#1]c1c(Cl)[cH]c(Cl)[cH]c1Cl",
                        "[!#1]c1c(F)[cH][cH][cH]c1F",
                        "[!#1]c1c(F)c(F)c([!#1])c(F)c1F",
                        "[!#1]c1c(F)c(F)c(F)c(F)c1F",
                        "[!#1]c1c(n[cH]n1[CH3])[N+](=O)[O-]",
                        "[!#1]c1c(nc([CH3])n1[!#1])[N+](=O)[O-]",
                        "[!#1]c1c2[CH]([OH])[CH2]C([CH3])([CH3])[CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[cH][cH][cH][cH]c2[cH]c3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[cH][cH][cH][cH]c2c([!#1])c3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[cH][cH][cH][cH]c2n3c([CH3])nc4[cH][cH][cH][cH]c4c13",
                        "[!#1]c1c2[cH][cH][cH][cH]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[CH2][CH2][CH2][CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[CH2][CH2][CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2[CH2][CH2][CH2]c2nc3[CH2][CH2][CH2][CH2]c13",
                        "[!#1]c1c2[CH2][CH2][CH2]c2nc3[CH2][CH2][CH2]c31",
                        "[!#1]c1c2[CH2][CH2]N([CH3])c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2C(=O)[CH2]C([!#1])([CH3])[CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1c2C(=O)[CH2]C([CH3])([CH3])[CH2]c2nc3[cH][cH][cH][cH]c13",
                        "[!#1]c1n([!#1])c2[cH][cH][cH][cH]c2[n+]1[!#1]",
                        "[!#1]c1n([!#1])c2[cH][cH]c([!#1])[cH]c2[n+]1[!#1]",
                        "[!#1]c1n([CH3])c2[cH][cH][cH][cH]c2[n+]1[CH3]",
                        "[!#1]c1n[cH][cH][cH]c1[CH3]",
                        "[!#1]c1n[cH][cH][cH]c1[OH]",
                        "[!#1]c1n[cH][cH][cH]n1",
                        "[!#1]c1n[cH][cH]c(n1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1n[cH][cH]n1[!#1]",
                        "[!#1]c1n[cH][cH]nc1[!#1]",
                        "[!#1]c1n[cH][cH]nc1C(=O)[OH]",
                        "[!#1]c1n[cH][cH]nc1O[CH3]",
                        "[!#1]c1n[cH][cH]s1",
                        "[!#1]c1n[cH][nH]c1[!#1]",
                        "[!#1]c1n[cH][nH]n1",
                        "[!#1]c1n[cH]c(s1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1n[cH]n([!#1])c1[!#1]",
                        "[!#1]c1n[cH]n[nH]1",
                        "[!#1]c1n[cH]nc([!#1])c1[!#1]",
                        "[!#1]c1n[cH]nc2[nH][cH]nc12",
                        "[!#1]c1n[cH]nc2n[cH][nH]c12",
                        "[!#1]c1n[cH]nc2sc([CH3])c([CH3])c12",
                        "[!#1]c1n[cH]nc2sc3[CH2][CH2][CH2][CH2]c3c12",
                        "[!#1]c1n[nH]c([!#1])c1[!#1]",
                        "[!#1]c1n[nH]c([!#1])n1",
                        "[!#1]c1n[nH]c([NH2])n1",
                        "[!#1]c1n[nH]c(=O)[nH]c1=O",
                        "[!#1]c1n[nH]c(=O)c2[cH][cH][cH][cH]c12",
                        "[!#1]c1n[nH]c(=S)[nH]c1=O",
                        "[!#1]c1n[nH]c2[CH2][CH2][CH2][CH2]c12",
                        "[!#1]c1nc([!#1])c([!#1])[nH]1",
                        "[!#1]c1nc([!#1])c([!#1])c([!#1])n1",
                        "[!#1]c1nc([!#1])c([!#1])s1",
                        "[!#1]c1nc([!#1])c2[cH][cH][cH][cH]c2n1",
                        "[!#1]c1nc([!#1])c2c3[CH2][CH2][CH2][CH2]c3sc2n1",
                        "[!#1]c1nc([!#1])n([!#1])n1",
                        "[!#1]c1nc([!#1])nc([!#1])n1",
                        "[!#1]c1nc([!#1])nc([NH][CH3])n1",
                        "[!#1]c1nc([!#1])nc([NH]N=[CH]c2[cH][cH][cH]c([N+](=O)[O-])c2[OH])n1",
                        "[!#1]c1nc([!#1])nc(Cl)n1",
                        "[!#1]c1nc([!#1])nc(n1)N2[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]c1nc([!#1])nc(n1)N2[CH2][CH2][NH][CH2][CH2]2",
                        "[!#1]c1nc([!#1])nc(n1)N2[CH2][CH2]O[CH2][CH2]2",
                        "[!#1]c1nc([!#1])nc(O[CH](C(F)(F)F)C(F)(F)F)n1",
                        "[!#1]c1nc([!#1])nc(O[CH3])n1",
                        "[!#1]c1nc([cH]c(n1)c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1nc([cH]s1)C2([CH2][CH]3[CH2][CH]4[CH2][CH]([CH2]3)[CH2]2)[CH2]4",
                        "[!#1]c1nc([cH]s1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nc([cH]s1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1nc([cH]s1)c2[cH][cH]c([!#1])c([!#1])[cH]2",
                        "[!#1]c1nc([CH3])[cH][cH]c1[OH]",
                        "[!#1]c1nc([CH3])[cH]c([CH3])n1",
                        "[!#1]c1nc([CH3])[cH]s1",
                        "[!#1]c1nc([CH3])nc(O[CH3])n1",
                        "[!#1]c1nc([CH3])nc2sc3[CH2][CH2][CH2][CH2]c3c12",
                        "[!#1]c1nc([NH2])nc(Cl)n1",
                        "[!#1]c1nc([OH])[cH]c(=O)[nH]1",
                        "[!#1]c1nc(=O)c([!#1])c([!#1])[nH]1",
                        "[!#1]c1nc(c([!#1])s1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nc(c([!#1])s1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1nc(Cl)nc(Cl)n1",
                        "[!#1]c1nc(I)[cH][cH]c1[OH]",
                        "[!#1]c1nc(nc(n1)N2[CH2][CH2]O[CH2][CH2]2)N3[CH2][CH2][CH2][CH2][CH2]3",
                        "[!#1]c1nc(nc(n1)N2[CH2][CH2]O[CH2][CH2]2)N3[CH2][CH2]O[CH2][CH2]3",
                        "[!#1]c1nc(O[CH3])nc(O[CH3])n1",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2[nH]1",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2[nH]c1=O",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2c([!#1])c1[!#1]",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2c(=O)[nH]1",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2c(=O)n1c3[cH][cH][cH][cH][cH]3",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2c(=O)o1",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2c3[cH][cH][cH][cH]c13",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2n1[!#1]",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2nc1[!#1]",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2o1",
                        "[!#1]c1nc2[cH][cH][cH][cH]c2s1",
                        "[!#1]c1nc2[cH][cH][cH][cH]n2c1[!#1]",
                        "[!#1]c1nc2[cH][cH]c([!#1])[cH]c2[nH]1",
                        "[!#1]c1nc2[cH][cH]c([!#1])[cH]c2o1",
                        "[!#1]c1nc2[cH][cH]c([!#1])[cH]c2s1",
                        "[!#1]c1nc2[cH][cH]c([CH3])[cH]c2s1",
                        "[!#1]c1nc2[cH]c([!#1])[cH][cH]c2[nH]1",
                        "[!#1]c1nc2[cH]c([!#1])[cH][cH]c2o1",
                        "[!#1]c1nc2[cH]c([!#1])[cH][cH]c2s1",
                        "[!#1]c1nc2[cH]c(Cl)[cH][cH]c2o1",
                        "[!#1]c1nc2n([!#1])c(=O)[nH]c(=O)c2n1[!#1]",
                        "[!#1]c1nc2n([!#1])c(=O)n([!#1])c(=O)c2n1[!#1]",
                        "[!#1]c1nc2nc([!#1])[cH]c([!#1])n2n1",
                        "[!#1]c1nc2nc([cH]c(c3[cH][cH][cH][cH][cH]3)n2n1)c4[cH][cH][cH][cH][cH]4",
                        "[!#1]c1nc2nc([CH3])[cH]c([CH3])n2n1",
                        "[!#1]c1nc2nonc2nc1[!#1]",
                        "[!#1]c1nc2sc3[CH2][CH2][CH2][CH2]c3c2c(=O)n1[!#1]",
                        "[!#1]c1nc2sc3[CH2][CH2][CH2][CH2]c3c2s1",
                        "[!#1]c1nn([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1nn([CH3])[cH]c1Br",
                        "[!#1]c1nn(c([!#1])c1[!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nn(c([!#1])c1[!#1])c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]c1nn[cH][nH]1",
                        "[!#1]c1nn[cH]n1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nnc([!#1])n1[!#1]",
                        "[!#1]c1nnc([!#1])n1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nnc([!#1])o1",
                        "[!#1]c1nnc([!#1])s1",
                        "[!#1]c1nnc([CH2][CH3])s1",
                        "[!#1]c1nnc([CH3])s1",
                        "[!#1]c1nnc([NH2])s1",
                        "[!#1]c1nnc2c([!#1])nc3nonc3n12",
                        "[!#1]c1nnc2c3[cH][cH][cH][cH]c3[nH]c2n1",
                        "[!#1]c1nnn[nH]1",
                        "[!#1]c1nnnn1[!#1]",
                        "[!#1]c1nnnn1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1nnnn1c2c([!#1])[cH][cH][cH]c2[!#1]",
                        "[!#1]c1nnnn1c2c([CH3])[cH][cH][cH]c2[CH3]",
                        "[!#1]c1no[n+]([!#1])c1[!#1]",
                        "[!#1]c1nonc1[!#1]",
                        "[!#1]c1oc2[cH][cH][cH][cH]c2[n+]1[!#1]",
                        "[!#1]c1oc2[cH][cH]c([!#1])[cH]c2c1[!#1]",
                        "[!#1]c1oc2[cH][cH]c([!#1])c([!#1])c2c1[!#1]",
                        "[!#1]c1oc2[cH]c([!#1])c([!#1])[cH]c2c1[!#1]",
                        "[!#1]c1oc2c([!#1])c([!#1])c([!#1])[cH]c2c1[!#1]",
                        "[!#1]c1s[cH][n+]([!#1])c1[!#1]",
                        "[!#1]c1s[cH][n+]([!#1])c1[CH3]",
                        "[!#1]c1s[cH]c(c1[!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1sc([!#1])c([!#1])c1[!#1]",
                        "[!#1]c1sc([!#1])c(c1[!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]c1sc([CH3])c([CH3])c1[!#1]",
                        "[!#1]c1sc2[cH][cH][cH][cH]c2[n+]1[!#1]",
                        "[!#1]c1sc2[cH][cH][cH][cH]c2c1[!#1]",
                        "[!#1]c1sc2[cH][cH][cH][cH]c2c1Cl",
                        "[!#1]c1sc2[cH][cH]c([!#1])[cH]c2[n+]1[!#1]",
                        "[!#1]c1sc2[cH][cH]c3[cH][cH][cH][cH]c3c2[n+]1[!#1]",
                        "[!#1]c1sc2[cH]c([!#1])[cH][cH]c2c1[!#1]",
                        "[!#1]c1sc2[cH]c(F)[cH][cH]c2c1Cl",
                        "[!#1]c1sc2[CH2][CH2][CH2][CH2]c2c1[!#1]",
                        "[!#1]c1sc2[CH2][CH2][CH2][CH2]c2c1C(=O)[NH2]",
                        "[!#1]c1sc2c([!#1])[cH][cH][cH]c2c1[!#1]",
                        "[!#1]c1sc2c([!#1])c([!#1])[cH][cH]c2c1[!#1]",
                        "[!#1]c1sc2C(=N[OH])[CH2][CH2][CH2]c2c1[!#1]",
                        "[!#1]c1sc2C(=O)[CH2][CH2][CH2]c2c1[!#1]",
                        "[!#1]c1sc2n[cH]nc([!#1])c2c1[!#1]",
                        "[!#1]Cl",
                        "[!#1]F",
                        "[!#1]I",
                        "[!#1]N([!#1])[!#1]",
                        "[!#1]N([!#1])[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N([!#1])[CH3]",
                        "[!#1]N([!#1])C(=O)[!#1]",
                        "[!#1]N([!#1])C(=O)O[CH2][CH3]",
                        "[!#1]N([!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N([!#1])c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N([CH]([CH]([CH3])[CH3])C(=O)[!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]N([CH]([CH]([CH3])[CH3])C(=O)[OH])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH]([CH2]c1[cH][cH][cH][cH][cH]1)C(=O)[!#1])C(=O)c2[cH][cH][cH][cH]c2C(=O)[!#1]",
                        "[!#1]N([CH]([CH2]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-])C(=O)[!#1])C(=O)c2[cH][cH][cH][cH]c2C(=O)[!#1]",
                        "[!#1]N([CH]([CH3])[CH3])[CH]([CH3])[CH3]",
                        "[!#1]N([CH]1[CH2][CH2][CH2][CH2][CH2]1)[CH]2[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]N([CH2][CH2][CH2][CH2][CH2]C(=O)[!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2][CH3])[CH2][CH2][CH2][CH3]",
                        "[!#1]N([CH2][CH2][CH2][CH3])C(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2]C(=O)[!#1])[CH2]C(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2]C(=O)[!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2]C(=O)[!#1])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2]C(=O)[!#1])c1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1]N([CH2][CH2][CH2]S(=O)(=O)[OH])c1[cH][cH][cH][cH]c1SC([!#1])([!#1])[!#1]",
                        "[!#1]N([CH2][CH2][OH])[CH2][CH2][OH]",
                        "[!#1]N([CH2][CH2]C(=O)[!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]N([CH2][CH2]C(=O)[!#1])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2][CH2]C(=O)[OH])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2][CH3])[CH2][CH2][OH]",
                        "[!#1]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]N([CH2][CH3])C(=O)[!#1]",
                        "[!#1]N([CH2][CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N([CH2]C([CH3])([CH3])[CH2][CH]=C([CH3])[CH3])C(=O)[CH3]",
                        "[!#1]N([CH2]C(=O)[!#1])C(=O)c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]N([CH2]C(=O)[!#1])C(=O)c1[cH][cH][cH]c2[cH][cH][cH]c(C(=O)[!#1])c12",
                        "[!#1]N([CH2]C(=O)[!#1])C(=O)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2]C(=O)[!#1])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2]C(=O)[OH])[CH2]C(=O)[OH]",
                        "[!#1]N([CH2]C(=O)[OH])C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2]c1[cH][cH][cH][cH][cH]1)[CH2]c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N([CH2]c1[cH][cH][cH][cH][cH]1)C([CH3])([CH3])[CH3]",
                        "[!#1]N([CH2]c1[cH][cH][cH][cH][cH]1)C(=S)SC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH2]c1[cH][cH]c(Cl)[cH]c1Cl)c2[cH][cH][cH]c(Cl)[cH]2",
                        "[!#1]N([CH2]c1[cH][cH]c(F)[cH][cH]1)c2[cH][cH]c(I)[cH][cH]2",
                        "[!#1]N([CH3])[CH2][CH2][OH]",
                        "[!#1]N([CH3])[CH2]C(=O)[OH]",
                        "[!#1]N([CH3])[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N([CH3])[CH3]",
                        "[!#1]N([CH3])C(=[NH])[NH]C(=[NH])[NH2]",
                        "[!#1]N([CH3])C(=O)[!#1]",
                        "[!#1]N([CH3])C(=O)[CH3]",
                        "[!#1]N([CH3])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N([CH3])c1[cH][cH][cH][cH]c1C([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]N([CH3])c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]N([CH3])c1[cH]c([!#1])c2[cH][cH][cH][cH]c2n1",
                        "[!#1]N([CH3])S(=O)(=O)[!#1]",
                        "[!#1]N(C(=O)[!#1])S(=O)(=O)[!#1]",
                        "[!#1]N(C(=O)[CH]([CH2]C(=O)[!#1])S[CH2]C(=O)[!#1])c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1]N(C(=O)[CH2][CH2][CH3])S(=O)(=O)[!#1]",
                        "[!#1]N(C(=O)[CH3])C(=O)[CH3]",
                        "[!#1]N(C(=O)c1[cH]c([cH][cH]c1C(=O)[!#1])C(=O)[!#1])c2[cH][cH]c([cH][cH]2)C(=O)[!#1]",
                        "[!#1]N(C(=O)c1[cH]c([cH][cH]c1C(=O)[!#1])C(=O)[OH])c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]N(C(=S)SC([!#1])([!#1])C(=O)[!#1])c1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1]N(c1[cH][cH][cH][cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N=[CH][CH]([!#1])[!#1]",
                        "[!#1]N=[CH][CH]=N[!#1]",
                        "[!#1]N=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]N=[CH]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]N=[CH]c1[cH][cH][cH][cH]c1F",
                        "[!#1]N=[CH]c1[cH][cH][cH][nH]1",
                        "[!#1]N=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]N=[CH]c1[cH][cH][cH]c([OH])[cH]1",
                        "[!#1]N=[CH]c1[cH][cH][cH]c(Cl)[cH]1",
                        "[!#1]N=[CH]c1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N=[CH]c1[cH][cH][cH]n[cH]1",
                        "[!#1]N=[CH]c1[cH][cH][cH]o1",
                        "[!#1]N=[CH]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c([!#1])o1",
                        "[!#1]N=[CH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]N=[CH]c1[cH][cH]c([cH][cH]1)N([!#1])[CH2][CH3]",
                        "[!#1]N=[CH]c1[cH][cH]c([cH][cH]1)N([!#1])[CH3]",
                        "[!#1]N=[CH]c1[cH][cH]c([CH]=N[!#1])[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c([CH3])o1",
                        "[!#1]N=[CH]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c([OH])[cH]c1[OH]",
                        "[!#1]N=[CH]c1[cH][cH]c([OH])c([OH])[cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c(Br)s1",
                        "[!#1]N=[CH]c1[cH][cH]c(C#Cc2[cH][cH][cH][cH][cH]2)[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1]N=[CH]c1[cH][cH]c(s1)[N+](=O)[O-]",
                        "[!#1]N=[CH]c1[cH][cH]c2n([!#1])c3[cH][cH][cH][cH]c3c2[cH]1",
                        "[!#1]N=[CH]c1[cH][cH]c2O[CH2]Oc2[cH]1",
                        "[!#1]N=[CH]c1[cH][nH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N=[CH]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1]N=[CH]c1[cH]c(Br)[cH][cH]c1[OH]",
                        "[!#1]N=[CH]c1[cH]c(Br)[cH]c(c1[OH])C([CH3])([CH3])[CH3]",
                        "[!#1]N=[CH]c1[cH]c(c([OH])c([cH]1)C([CH3])([CH3])[CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]N=[CH]c1[cH]c(Cl)[cH]c(Cl)c1[OH]",
                        "[!#1]N=[CH]c1[cH]c2O[CH2]Oc2[cH]c1[N+](=O)[O-]",
                        "[!#1]N=[CH]c1c([CH3])[nH]n([!#1])c1=O",
                        "[!#1]N=[CH]c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N=[CH]c1c2[cH][cH][cH][cH]c2[cH]c3[cH][cH][cH][cH]c13",
                        "[!#1]N=[CH]c1s[cH][cH]c1[CH3]",
                        "[!#1]N=[CH]N([CH3])[CH3]",
                        "[!#1]N=[N+]([!#1])[O-]",
                        "[!#1]N=[N+]=[N-]",
                        "[!#1]N=C([CH]([!#1])[!#1])[CH]([!#1])[!#1]",
                        "[!#1]N=C([CH3])N([CH3])[CH3]",
                        "[!#1]N=C(O[CH3])c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1]N=C(OC(=O)C([!#1])([!#1])[!#1])c1[cH][cH][cH][cH][cH]1",
                        "[!#1]N=C1[CH](C(=O)c2[cH][cH][cH][cH]c12)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]N=c1[cH][cH]n([!#1])[cH][cH]1",
                        "[!#1]N=C1[CH2][CH2][CH2]c2[cH][cH][cH][cH]c2[NH]1",
                        "[!#1]N=C1[NH]C(=[NH])c2[cH][cH][cH][cH]c12",
                        "[!#1]N=C1C(=O)[NH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N=c1s[cH]c([!#1])n1[!#1]",
                        "[!#1]N=c1s[cH]c(c2[cH][cH]c([!#1])[cH][cH]2)n1[!#1]",
                        "[!#1]N=N[!#1]",
                        "[!#1]N=O",
                        "[!#1]N1[CH]([CH3])[CH2][CH2][CH2][CH]1[CH3]",
                        "[!#1]N1[CH](S[CH2]C1=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]n1[cH][cH][cH][cH]c1=[NH]",
                        "[!#1]n1[cH][cH][cH]c([CH3])c1=[NH]",
                        "[!#1]n1[cH][cH][cH]c1[CH]=O",
                        "[!#1]n1[cH][cH][cH]n1",
                        "[!#1]n1[cH][cH][cH]nc1=[NH]",
                        "[!#1]n1[cH][cH]c([CH3])n1",
                        "[!#1]n1[cH][cH]c(=[NH])[cH][cH]1",
                        "[!#1]n1[cH][cH]c(=N[CH2]c2[cH][cH][cH][cH][cH]2)[cH][cH]1",
                        "[!#1]n1[cH][cH]c(=O)[nH]c1=O",
                        "[!#1]n1[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]n1[cH][cH]n[cH]1",
                        "[!#1]n1[cH][cH]nc1[CH3]",
                        "[!#1]n1[cH][cH]nc1[N+](=O)[O-]",
                        "[!#1]n1[cH][cH]sc1=[NH]",
                        "[!#1]n1[cH]c(Br)[cH][cH]c1=[NH]",
                        "[!#1]n1[cH]n[cH]n1",
                        "[!#1]n1[cH]n[n+]([!#1])[cH]1",
                        "[!#1]n1[cH]nc([cH]1)[N+](=O)[O-]",
                        "[!#1]n1[cH]nc(=O)[cH]n1",
                        "[!#1]n1[cH]nc2[cH][cH][cH][cH]c12",
                        "[!#1]n1[cH]nn[cH]1",
                        "[!#1]N1[CH2][CH]([CH2]C1=O)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N1[CH2][CH]([CH3])C([OH])([CH2][CH]1[CH3])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N1[CH2][CH2][CH]([CH2]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N1[CH2][CH2][CH]([CH2]c2[cH][cH][cH][cH][cH]2)[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][CH]([CH3])[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][CH]=[CH][CH2]1",
                        "[!#1]N1[CH2][CH2][CH2][CH]1C(=O)[OH]",
                        "[!#1]N1[CH2][CH2][CH2][CH2][CH]1[CH2][CH3]",
                        "[!#1]N1[CH2][CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][CH2]C1=O",
                        "[!#1]N1[CH2][CH2][CH2]c2[cH][cH][cH][cH]c12",
                        "[!#1]N1[CH2][CH2][CH2]c2c([!#1])c3[cH][cH][cH][cH]c3nc12",
                        "[!#1]N1[CH2][CH2][CH2]N([!#1])[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2][NH][CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]C(=[CH][CH2]1)[!#1]",
                        "[!#1]N1[CH2][CH2]C(=O)[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]C2([CH2][CH2]1)O[CH2][CH2]O2",
                        "[!#1]N1[CH2][CH2]c2[cH][cH][cH][cH]c12",
                        "[!#1]N1[CH2][CH2]c2c([CH2]1)c3[cH][cH][cH][cH]c3n2[!#1]",
                        "[!#1]N1[CH2][CH2]c2c1nc3[cH][cH][cH][cH]c3c2[!#1]",
                        "[!#1]N1[CH2][CH2]c2c1nc3[cH][cH]c([!#1])[cH]c3c2[!#1]",
                        "[!#1]N1[CH2][CH2]N([!#1])[CH]1c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]N1[CH2][CH2]N([!#1])[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]N([CH2][CH]=[CH]c2[cH][cH][cH][cH][cH]2)[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)[CH]2[CH2]C(=O)N(C2=O)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)[CH]2[CH2]C(=O)N(C2=O)c3[cH][cH][cH]c([!#1])[cH]3",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)[CH]2[CH2]C(=O)N(C2=O)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)C(=O)[!#1]",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH]c2[!#1]",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH]c2O[CH3]",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH][cH][cH]n2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c([cH][cH]2)[N+](=O)[O-]",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c(Cl)[cH][cH]2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c(F)[cH][cH]2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)c2[cH][cH]c3[cH][cH][cH][cH]c3n2",
                        "[!#1]N1[CH2][CH2]N([CH2][CH2]1)S(=O)(=O)[!#1]",
                        "[!#1]N1[CH2][CH2]N([CH3])[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]N2[CH2][CH2][CH2][CH]2[CH2]1",
                        "[!#1]N1[CH2][CH2]n2c3[CH]1[CH2][CH2][CH2]c3c4[cH]c([!#1])[cH][cH]c24",
                        "[!#1]N1[CH2][CH2]n2c3[CH]1[CH2][CH2][CH2]c3c4[cH]c([CH3])[cH][cH]c24",
                        "[!#1]N1[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]O[CH2][CH2]O[CH2][CH2][NH][CH2][CH2]O[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]O[CH2][CH2]O[CH2][CH2]N([!#1])[CH2][CH2]O[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]N1[CH2][CH2]SC1=[NH]",
                        "[!#1]N1[CH2]C([!#1])([!#1])C(=O)C([!#1])([!#1])[CH2]1",
                        "[!#1]N1[CH2]C(=O)[NH]c2[cH][cH][cH][cH]c12",
                        "[!#1]N1[CH2]C(=O)N([!#1])C(=O)[CH2]1",
                        "[!#1]N1[CH2]c2[cH][cH][cH][cH]c2[CH2]1",
                        "[!#1]N1[CH2]c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]n1c([CH3])[cH][cH]c1[CH3]",
                        "[!#1]n1c([CH3])[cH]c([CH3])nc1=O",
                        "[!#1]n1c([CH3])n[cH]c1[N+](=O)[O-]",
                        "[!#1]n1c([CH3])nc2[cH][cH][cH][cH]c12",
                        "[!#1]n1c(=[NH])n([!#1])c2[cH][cH][cH][cH]c12",
                        "[!#1]n1c(=[NH])sc2[cH][cH][cH][cH]c12",
                        "[!#1]N1C(=O)[CH]=[CH]C1=O",
                        "[!#1]N1C(=O)[CH]2[CH]([CH]3[CH]=[CH][CH]2[CH]4[CH]3C(=O)N([!#1])C4=O)C1=O",
                        "[!#1]N1C(=O)[CH]2[CH]([CH]3[CH]=[CH][CH]2[CH]4[CH2][CH]43)C1=O",
                        "[!#1]N1C(=O)[CH]2[CH]([CH]3c4[cH][cH][cH][cH]c4[CH]2c5[cH][cH][cH][cH]c35)C1=O",
                        "[!#1]N1C(=O)[CH]2[CH]3[CH2][CH]([CH]=[CH]3)[CH]2C1=O",
                        "[!#1]N1C(=O)[CH]2[CH]3OC([!#1])([CH]=[CH]3)[CH]2C1=O",
                        "[!#1]N1C(=O)[CH2][CH2]C1=O",
                        "[!#1]N1C(=O)[CH2][NH][CH2]C1=O",
                        "[!#1]N1C(=O)[CH2]SC1=S",
                        "[!#1]N1C(=O)[NH]C2([CH2][CH2][CH2][CH2][CH2]2)C1=O",
                        "[!#1]N1C(=O)[NH]C2([CH2][CH2][CH2][CH2]2)C1=O",
                        "[!#1]N1C(=O)C([!#1])([OH])c2[cH][cH][cH][cH]c12",
                        "[!#1]N1C(=O)C(=[CH]c2[cH][cH][cH][cH][cH]2)SC1=S",
                        "[!#1]N1C(=O)C(=[CH]c2[cH][cH]c(Cl)[cH][cH]2)SC1=S",
                        "[!#1]N1C(=O)C(=[CH]c2[cH][cH]c(F)[cH][cH]2)SC1=S",
                        "[!#1]N1C(=O)C(=[CH]c2[cH][cH]c(O[CH3])[cH][cH]2)SC1=S",
                        "[!#1]N1C(=O)C(=C2C(=O)[NH]c3[cH][cH][cH][cH]c23)SC1=S",
                        "[!#1]N1C(=O)C(=C2SC(=S)N([!#1])C2=O)SC1=S",
                        "[!#1]N1C(=O)C(=C2S(c3[cH][cH][cH][cH]c3N2[!#1])SC1=S)", // [!#1]N1C(=O)C(=C2Sc3[cH][cH][cH][cH]c3N2[!#1])SC1=S
                        "[!#1]N1C(=O)C(=O)c2[cH][cH][cH][cH]c12",
                        "[!#1]N1C(=O)C(=O)c2[cH]c([!#1])[cH][cH]c12",
                        "[!#1]N1C(=O)c2[cH][cH][cH][cH]c2C1=O",
                        "[!#1]N1C(=O)c2[cH][cH][cH]c3[cH][cH][cH]c(C1=O)c23",
                        "[!#1]N1C(=O)c2[cH][cH][cH]c3c([!#1])[cH][cH]c(C1=O)c23",
                        "[!#1]N1C(=O)c2[cH][cH][cH]c3c([!#1])[cH][cH]c1c23",
                        "[!#1]N1C(=O)c2[cH][cH][cH]c3c([cH][cH]c(C1=O)c23)N4[CH2][CH2]O[CH2][CH2]4",
                        "[!#1]N1C(=O)c2[cH][cH]c([!#1])[cH]c2C1=O",
                        "[!#1]N1C(=O)c2[cH][cH]c([cH]c2C1=O)[N+](=O)[O-]",
                        "[!#1]N1C(=O)c2[cH][cH]c([cH]c2C1=O)C(=O)[OH]",
                        "[!#1]N1C(=O)c2[cH][cH]c([cH]c2C1=O)c3[cH][cH]c4C(=O)N([!#1])C(=O)c4[cH]3",
                        "[!#1]N1C(=O)c2[cH][cH]c(Br)[cH]c2C1=O",
                        "[!#1]n1c(=O)c2[cH]c3c(=O)n([!#1])c(=O)c3[cH]c2c1=O",
                        "[!#1]N1C(=O)N([!#1])C(=O)C([!#1])([!#1])C1=O",
                        "[!#1]n1c(=O)n([!#1])c(=O)n([!#1])c1=O",
                        "[!#1]n1c(=O)oc2[cH][cH][cH][cH]c12",
                        "[!#1]n1c(=O)oc2[cH]c(Br)[cH][cH]c12",
                        "[!#1]n1c(=O)oc2[cH]c(Cl)[cH][cH]c12",
                        "[!#1]n1c(=S)n([!#1])c2[cH][cH][cH][cH]c12",
                        "[!#1]n1c(=S)oc2[cH][cH][cH][cH]c12",
                        "[!#1]n1c(=S)sc2[cH][cH][cH][cH]c12",
                        "[!#1]N1c2[cH][cH][cH][cH]c2[CH]=[CH]c3[cH][cH][cH][cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2[CH]=[CH]c3[cH][cH]c([!#1])[cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2[CH2][CH2]c3[cH][cH][cH][cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2[CH2][CH2]c3[cH][cH]c([!#1])[cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2[CH2][CH2]c3[cH][cH]c([NH]C(=O)[!#1])[cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2C([CH3])([CH3])C1([!#1])[!#1]",
                        "[!#1]n1c2[cH][cH][cH][cH]c2c(=O)c3[cH][cH][cH][cH]c13",
                        "[!#1]n1c2[cH][cH][cH][cH]c2c3[cH][cH][cH][cH]c13",
                        "[!#1]n1c2[cH][cH][cH][cH]c2c3nc4[cH][cH]c([cH]c4[cH]c13)[N+](=O)[O-]",
                        "[!#1]N1c2[cH][cH][cH][cH]c2Oc3nnc(Cl)[cH]c13",
                        "[!#1]N1c2[cH][cH][cH][cH]c2SC1([!#1])[!#1]",
                        "[!#1]N1c2[cH][cH][cH][cH]c2S(c3[cH][cH][cH][cH]c13)", // [!#1]N1c2[cH][cH][cH][cH]c2Sc3[cH][cH][cH][cH]c13
                        "[!#1]N1c2[cH][cH][cH][cH]c2S(c3[cH][cH]c([!#1])[cH]c13)", // [!#1]N1c2[cH][cH][cH][cH]c2Sc3[cH][cH]c([!#1])[cH]c13
                        "[!#1]N1c2[cH][cH][cH][cH]c2S(c3[cH][cH]c([cH]c13)C(F)(F)F)", // [!#1]N1c2[cH][cH][cH][cH]c2Sc3[cH][cH]c([cH]c13)C(F)(F)F
                        "[!#1]N1c2[cH][cH][cH][cH]c2S(c3[cH][cH]c([NH]C(=O)[!#1])[cH]c13)", // [!#1]N1c2[cH][cH][cH][cH]c2Sc3[cH][cH]c([NH]C(=O)[!#1])[cH]c13
                        "[!#1]n1c2[cH][cH]c(Br)[cH]c2c3[cH]c(Br)[cH][cH]c13",
                        "[!#1]n1c2[cH][cH]c(Cl)[cH]c2c3[cH]c(Cl)[cH][cH]c13",
                        "[!#1]n1c2[CH2][CH2][CH2][CH2]c2sc1=[NH]",
                        "[!#1]n1c2[CH2][CH2][CH2]c2c(=[NH])c3[cH][cH][cH][cH]c13",
                        "[!#1]n1c2[CH2][CH2][CH2]c2c3[cH][cH][cH][cH]c13",
                        "[!#1]n1c-2c([CH2][CH2]c3c2[cH]nn3c4[cH][cH][cH][cH][cH]4)c5[cH][cH][cH][cH]c15",
                        "[!#1]n1c2C(=O)[CH2][CH2][CH2]c2c3[cH]c([CH3])[cH][cH]c13",
                        "[!#1]n1c2c(n([!#1])c3[cH][cH][cH][cH]c23)c4[cH][cH][cH][cH]c14",
                        "[!#1]n1n[cH][n+]2nc([CH3])[cH]c([OH])c12",
                        "[!#1]N1N=C([CH2][CH](C1=O)c2[cH][nH]c3[cH][cH][cH][cH]c23)c4[cH][cH][cH][cH][cH]4",
                        "[!#1]N1N=C([CH2][CH](C1=O)c2[cH]n([!#1])c3[cH][cH][cH][cH]c23)c4[cH][cH][cH][cH][cH]4",
                        "[!#1]N1N=C2[CH]([CH2][CH2]c3[cH][cH]c([!#1])[cH]c23)[CH]1c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]N1N=C2[CH]([CH2][CH2]c3[cH]c([!#1])[cH][cH]c23)[CH]1c4[cH][cH]c([!#1])[cH][cH]4",
                        "[!#1]n1nc([CH3])[cH]c1[CH3]",
                        "[!#1]n1nc([CH3])c(Br)c1[CH3]",
                        "[!#1]n1nc(c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH]c3c1c4[cH][cH][cH][cH][cH]4",
                        "[!#1]n1nc(nc1c2[cH][cH][cH][cH][cH]2)c3[cH][cH][cH][cH][cH]3",
                        "[!#1]n1nc2[cH][cH][cH][cH]c2n1",
                        "[!#1]n1nc2C(=N[NH][CH3])c3nn([!#1])nc3C(=N[NH][CH3])c2n1",
                        "[!#1]n1nc2C(=N[OH])c3nn([!#1])nc3C(=N[OH])c2n1",
                        "[!#1]n1nc2C(=NN=C([CH3])[CH3])c3nn([!#1])nc3C(=NN=C([CH3])[CH3])c2n1",
                        "[!#1]n1nc2C(=NOC(=O)[CH3])c3nn([!#1])nc3C(=NOC(=O)[CH3])c2n1",
                        "[!#1]n1nnc2[cH][cH][cH][cH]c12",
                        "[!#1]n1nnc2c(=O)oc3[cH][cH][cH][cH]c3c12",
                        "[!#1]n1nnnc1C2([!#1])[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]n1nnnc1C2([!#1])[CH2][CH2][CH2][CH2]2",
                        "[!#1]n1nnnc1c2[cH][cH][cH][cH][cH]2",
                        "[!#1]O[!#1]",
                        "[!#1]O[CH]([!#1])[!#1]",
                        "[!#1]O[CH]([CH]([!#1])[CH2][CH]1[CH2][CH2]N([!#1])[CH2][CH]1[CH]([!#1])[!#1])c2[cH][cH]nc3[cH][cH][cH][cH]c23",
                        "[!#1]O[CH]([CH3])[CH3]",
                        "[!#1]O[CH]([CH3])C([!#1])([!#1])Cl",
                        "[!#1]O[CH]([CH3])C(=O)[NH][NH2]",
                        "[!#1]O[CH]([CH3])C(=O)[NH]N=[CH][!#1]",
                        "[!#1]O[CH]([CH3])C(=O)[NH]N=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]O[CH]([CH3])C(=O)[NH]N=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH]([CH3])C(=O)[NH]N=[CH]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1]O[CH]([CH3])C(=O)[OH]",
                        "[!#1]O[CH]([NH]C(=O)[!#1])C(Br)(Br)Br",
                        "[!#1]O[CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1]O[CH](C(F)(F)F)C(F)(F)F",
                        "[!#1]O[CH](F)F",
                        "[!#1]O[CH]1[CH2][CH]([CH3])[CH2][CH2][CH]1[CH]([CH3])[CH3]",
                        "[!#1]O[CH]1[CH2][CH2][CH]([CH2][CH2]1)C([CH3])([CH3])[CH3]",
                        "[!#1]O[CH2][CH]([!#1])[!#1]",
                        "[!#1]O[CH2][CH]([CH3])[CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2][NH][CH]([CH3])[CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2][NH]C([CH3])([CH3])[CH2]C([CH3])([CH3])[CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2][NH]C([CH3])([CH3])[CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2][NH]S(=O)(=O)[OH]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([!#1])[CH2][CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([!#1])[CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([CH2][CH3])S(=O)(=O)[OH]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([CH3])[CH2][CH]([OH])[CH2][NH]S(=O)(=O)[OH]",
                        "[!#1]O[CH2][CH]([OH])[CH2]N([CH3])S(=O)(=O)[OH]",
                        "[!#1]O[CH2][CH]=[CH2]",
                        "[!#1]O[CH2][CH]1O[CH]([!#1])[CH](O[!#1])[CH]1O[!#1]",
                        "[!#1]O[CH2][CH2][CH]([CH3])[CH3]",
                        "[!#1]O[CH2][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]O[CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]O[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]O[CH2][CH2][CH2][CH3]",
                        "[!#1]O[CH2][CH2][CH2]C(=O)[!#1]",
                        "[!#1]O[CH2][CH2][CH3]",
                        "[!#1]O[CH2][CH2][NH]C(=O)[!#1]",
                        "[!#1]O[CH2][CH2][NH2]",
                        "[!#1]O[CH2][CH2][OH]",
                        "[!#1]O[CH2][CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]O[CH2][CH2]Cl",
                        "[!#1]O[CH2][CH2]F",
                        "[!#1]O[CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]O[CH2][CH2]O[!#1]",
                        "[!#1]O[CH2][CH2]OC(=O)[!#1]",
                        "[!#1]O[CH2][CH2]S(=O)(=O)[!#1]",
                        "[!#1]O[CH2][CH3]",
                        "[!#1]O[CH2]C#[CH]",
                        "[!#1]O[CH2]C([!#1])([!#1])Cl",
                        "[!#1]O[CH2]C(=O)[!#1]",
                        "[!#1]O[CH2]C(=O)[CH3]",
                        "[!#1]O[CH2]C(=O)[NH][CH]([!#1])[CH3]",
                        "[!#1]O[CH2]C(=O)[NH][CH]([CH2][CH2]S[CH3])C(=O)O[CH3]",
                        "[!#1]O[CH2]C(=O)[NH][CH2][CH2]N([CH3])[CH3]",
                        "[!#1]O[CH2]C(=O)[NH][NH]C(=O)[!#1]",
                        "[!#1]O[CH2]C(=O)[NH][NH]C(=O)[CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]O[CH2]C(=O)[NH][NH2]",
                        "[!#1]O[CH2]C(=O)[NH]C(=O)O[!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH][CH]([!#1])[!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH][CH]=[CH][!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH][CH]=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1Cl",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH][cH]c1O[CH3]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]c([!#1])[cH]1",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([!#1])[cH]c1[OH]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([CH3])o1",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c([OH])c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(Cl)c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(O[CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH][cH]c(s1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH]c([cH][cH]c1[OH])[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH]c(I)[cH]c([!#1])c1[OH]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH]c(N=Nc2[cH][cH][cH][cH][cH]2)[cH][cH]c1[OH]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH]c2[cH][cH][cH][cH]c2nc1Cl",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1[cH]c2O[CH2]Oc2[cH]c1[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1c([OH])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1c(Cl)[cH][cH][cH]c1Cl",
                        "[!#1]O[CH2]C(=O)[NH]N=[CH]c1c(O[CH3])[cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]O[CH2]C(=O)[NH]N=C([!#1])[CH3]",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])[CH]([!#1])[!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])[CH]=[CH][!#1]",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])[CH]=[CH]c1[cH][cH][cH]o1",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])c1[cH][cH][cH]s1",
                        "[!#1]O[CH2]C(=O)[NH]N=C([CH3])c1[cH][cH]c(Br)s1",
                        "[!#1]O[CH2]C(=O)[NH]N=C(C(=O)[!#1])c1[cH]c(Br)[cH][cH]c1N([!#1])[CH3]",
                        "[!#1]O[CH2]C(=O)[NH]N=C1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]O[CH2]C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH][cH][cH]c12",
                        "[!#1]O[CH2]C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH]c([!#1])[cH]c12",
                        "[!#1]O[CH2]C(=O)[NH]N=C1C(=O)[NH]c2[cH][cH]c([cH]c12)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)[NH]N=C1C(=O)N([!#1])c2[cH][cH]c([!#1])[cH]c12",
                        "[!#1]O[CH2]C(=O)[NH]N=C1C(=O)N([CH3])c2[cH][cH]c(Br)[cH]c12",
                        "[!#1]O[CH2]C(=O)[NH2]",
                        "[!#1]O[CH2]C(=O)[OH]",
                        "[!#1]O[CH2]C(=O)c1[cH][cH][cH][cH][cH]1",
                        "[!#1]O[CH2]C(=O)c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]O[CH2]C(=O)c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]O[CH2]C(=O)c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]O[CH2]C(=O)c1[cH][cH]c(O[!#1])[cH][cH]1",
                        "[!#1]O[CH2]C(=O)N([!#1])[CH2][CH3]",
                        "[!#1]O[CH2]C(=O)N([!#1])[CH3]",
                        "[!#1]O[CH2]C(=O)N([CH2][CH3])[CH2][CH3]",
                        "[!#1]O[CH2]C(=O)O[!#1]",
                        "[!#1]O[CH2]C(=O)O[CH2]C(=O)[!#1]",
                        "[!#1]O[CH2]C(=O)O[CH3]",
                        "[!#1]O[CH2]C(=O)ON=[CH]c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]O[CH2]C(=O)ON=C([CH3])C([CH3])([CH3])[CH3]",
                        "[!#1]O[CH2]C(F)(F)F",
                        "[!#1]O[CH2]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]O[CH3]",
                        "[!#1]OC([!#1])([!#1])C(=O)[!#1]",
                        "[!#1]OC([!#1])([!#1])c1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]OC([!#1])([!#1])c1[cH][cH][cH][cH]c1C(=O)C([!#1])([!#1])c2[cH][cH][cH][cH][cH]2",
                        "[!#1]OC([!#1])([!#1])c1[cH]c([CH3])[nH]c(=O)c1C(=O)[!#1]",
                        "[!#1]OC([CH3])([CH3])[CH3]",
                        "[!#1]OC(=O)[!#1]",
                        "[!#1]OC(=O)[CH]([CH3])[NH]C(=O)OC([CH3])([CH3])[CH3]",
                        "[!#1]OC(=O)[CH]=[CH][!#1]",
                        "[!#1]OC(=O)[CH]=[CH]c1[cH][cH][cH][cH][cH]1",
                        "[!#1]OC(=O)[CH2][CH2][CH2]C(=O)O[!#1]",
                        "[!#1]OC(=O)[CH2][CH2][CH3]",
                        "[!#1]OC(=O)[CH2][CH2]C(=O)O[CH3]",
                        "[!#1]OC(=O)[CH2][CH3]",
                        "[!#1]OC(=O)[CH2]C(=O)[CH3]",
                        "[!#1]OC(=O)[CH3]",
                        "[!#1]OC(=O)[NH][CH3]",
                        "[!#1]OC(=O)[NH]C(=O)[CH2][CH2]Br",
                        "[!#1]OC(=O)[NH2]",
                        "[!#1]OC(=O)C(=[CH2])[CH3]",
                        "[!#1]OC(=O)C(F)(F)F",
                        "[!#1]OC(=O)C(F)(OC(F)(F)C(F)(F)C(F)(F)F)C(F)(F)F",
                        "[!#1]OC(=O)O[CH3]",
                        "[!#1]OC(C(=O)[!#1])(c1[cH][cH][cH][cH][cH]1)c2[cH][cH][cH][cH][cH]2",
                        "[!#1]OC(F)(F)[CH](F)Cl",
                        "[!#1]OC(F)(F)[CH](F)F",
                        "[!#1]OC1([CH2][CH2][CH2][CH2][CH2]1)C([!#1])([!#1])[!#1]",
                        "[!#1]Oc1[cH][cH][cH][cH][cH]1",
                        "[!#1]Oc1[cH][cH][cH][cH]c1[!#1]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1[NH]C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1[OH]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1F",
                        "[!#1]Oc1[cH][cH][cH][cH]c1N([!#1])C(=O)[CH]([!#1])[CH2]C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH][cH][cH]c1O[!#1]",
                        "[!#1]Oc1[cH][cH][cH]c([!#1])[cH]1",
                        "[!#1]Oc1[cH][cH][cH]c([CH]=N[!#1])c1[OH]",
                        "[!#1]Oc1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]Oc1[cH][cH][cH]c([cH]1)C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH][cH]c([CH3])[cH]1",
                        "[!#1]Oc1[cH][cH][cH]c2[cH][cH][cH][cH]c12",
                        "[!#1]Oc1[cH][cH][cH]c2[cH][cH][cH]nc12",
                        "[!#1]Oc1[cH][cH][cH]nc1[!#1]",
                        "[!#1]Oc1[cH][cH]c([!#1])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([!#1])[cH]c1[!#1]",
                        "[!#1]Oc1[cH][cH]c([!#1])[cH]c1Br",
                        "[!#1]Oc1[cH][cH]c([!#1])[cH]c1O[!#1]",
                        "[!#1]Oc1[cH][cH]c([!#1])c([cH]1)[N+](=O)[O-]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)[CH]([!#1])[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C([CH3])([CH3])[CH3]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C([CH3])([CH3])c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C([CH3])([CH3])c2[cH][cH]c(O[!#1])[cH][cH]2",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C(c2[cH][cH][cH][cH]c2[!#1])(c3[cH][cH][cH][cH]c3[!#1])c4[cH][cH]c(O[!#1])[cH][cH]4",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)C(O[!#1])(c2[cH][cH][cH][cH][cH]2)c3[cH][cH]c([!#1])[cH][cH]3",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)N([!#1])[CH2]c2[cH][cH]c(Br)[cH][cH]2",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)N([!#1])[CH2]c2[cH][cH]c(F)[cH][cH]2",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)N([!#1])C(=O)[CH]([!#1])[CH2]C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)N([!#1])C(=O)[CH]([CH2]C(=O)[!#1])S[CH2]C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)S(=O)(=O)[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH][cH]1)S(=O)(=O)c2[cH][cH]c([!#1])[cH][cH]2",
                        "[!#1]Oc1[cH][cH]c([CH]=N[!#1])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([CH]=N[!#1])[cH]c1[OH]",
                        "[!#1]Oc1[cH][cH]c([CH]=N[!#1])[cH]c1O[!#1]",
                        "[!#1]Oc1[cH][cH]c([CH]=N[!#1])c(O[!#1])[cH]1",
                        "[!#1]Oc1[cH][cH]c([CH]=O)[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([cH]c1O[!#1])[CH]([!#1])[!#1]",
                        "[!#1]Oc1[cH][cH]c([cH]c1O[!#1])C(=O)[!#1]",
                        "[!#1]Oc1[cH][cH]c([CH2][CH2]N([!#1])[CH3])[cH]c1O[!#1]",
                        "[!#1]Oc1[cH][cH]c([CH2]C(=O)[!#1])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([CH2]C(=O)[!#1])[cH]c1O[!#1]",
                        "[!#1]Oc1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([CH3])[cH]c1[CH3]",
                        "[!#1]Oc1[cH][cH]c([CH3])[cH]c1[N+](=O)[O-]",
                        "[!#1]Oc1[cH][cH]c([CH3])c([CH3])[cH]1",
                        "[!#1]Oc1[cH][cH]c([NH]C(=O)[!#1])[cH]c1Cl",
                        "[!#1]Oc1[cH][cH]c([NH2])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c([OH])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c(C(=O)[OH])c([cH]1)C(=O)[OH]",
                        "[!#1]Oc1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c(Cl)[cH]c1Cl",
                        "[!#1]Oc1[cH][cH]c(O[!#1])[cH][cH]1",
                        "[!#1]Oc1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1]Oc1[cH][cH]c2[cH][cH][cH][cH]c2c1[CH2]c3c(O[!#1])[cH][cH]c4[cH][cH][cH][cH]c34",
                        "[!#1]Oc1[cH][cH]c2[cH][cH][cH][cH]c2c1Br",
                        "[!#1]Oc1[cH][cH]c2c([CH3])[cH]c(=O)oc2[cH]1",
                        "[!#1]Oc1[cH][cH]c2c(=O)c([!#1])[cH]oc2[cH]1",
                        "[!#1]Oc1[cH][cH]c2c(=O)c([!#1])c([CH3])oc2[cH]1",
                        "[!#1]Oc1[cH][cH]c2C(=O)OC(=O)c2[cH]1",
                        "[!#1]Oc1[cH]c([cH][cH]c1[!#1])[CH]([!#1])[!#1]",
                        "[!#1]Oc1[cH]c([cH][cH]c1[OH])[CH]([!#1])[!#1]",
                        "[!#1]Oc1[cH]c([CH]=N[!#1])[cH][cH]c1[OH]",
                        "[!#1]Oc1[cH]c([cH]c(O[!#1])c1O[!#1])C(=O)[!#1]",
                        "[!#1]Oc1[cH]c([CH3])[cH]c(O[!#1])[cH]1",
                        "[!#1]Oc1[cH]c(Br)[cH]c([CH]=N[!#1])c1[OH]",
                        "[!#1]Oc1c([!#1])[cH][cH][cH]c1[CH]([!#1])[!#1]",
                        "[!#1]Oc1c([CH3])[cH]c(Br)[cH]c1[CH3]",
                        "[!#1]Oc1c(Br)[cH]c(Br)c2[cH][cH][cH]nc12",
                        "[!#1]Oc1c(Cl)[cH]c(Cl)[cH]c1C(=O)[!#1]",
                        "[!#1]Oc1c(F)c(F)c([!#1])c(F)c1F",
                        "[!#1]OP(=O)([OH])O[!#1]",
                        "[!#1]OP(=O)(O[!#1])O[!#1]",
                        "[!#1]OS(=O)(=O)[!#1]",
                        "[!#1]OS(=O)(=O)[CH2][CH2]S(=O)(=O)[!#1]",
                        "[!#1]OS(=O)(=O)[CH2][CH2]S[!#1]",
                        "[!#1]OS(=O)(=O)[CH3]",
                        "[!#1]OS(=O)(=O)[OH]",
                        "[!#1]P(=O)([OH])O[CH2][CH3]",
                        "[!#1]P(=O)(O[CH3])O[CH3]",
                        "[!#1]P1(=O)O[CH2][CH2][CH2]O1",
                        "[!#1]S(=O)(=O)[!#1]",
                        "[!#1]S(=O)(=O)[CH]1[CH2][CH2]S(=O)(=O)[CH2]1",
                        "[!#1]S(=O)(=O)[CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]S(=O)(=O)[CH2][CH2][OH]",
                        "[!#1]S(=O)(=O)[CH2][CH2]C(=O)[CH3]",
                        "[!#1]S(=O)(=O)[CH2][CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[CH2][CH2]C(=O)O[CH2][CH3]",
                        "[!#1]S(=O)(=O)[CH2][CH2]C(=O)O[CH3]",
                        "[!#1]S(=O)(=O)[CH2][CH3]",
                        "[!#1]S(=O)(=O)[CH2]Br",
                        "[!#1]S(=O)(=O)[CH2]C(=N[NH]C(=S)[NH2])[CH3]",
                        "[!#1]S(=O)(=O)[CH2]C(=O)[CH3]",
                        "[!#1]S(=O)(=O)[CH2]C(=O)[NH2]",
                        "[!#1]S(=O)(=O)[CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[CH2]OC(=O)[CH3]",
                        "[!#1]S(=O)(=O)[CH3]",
                        "[!#1]S(=O)(=O)[NH][CH]([CH]([CH3])[CH3])C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH]([CH2][CH2][CH3])C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH]([CH3])[CH3]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][CH2][CH2][CH2][CH3]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][CH2][CH3]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][CH2][OH]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2][OH]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH2][CH2]OC(=O)[NH][CH2][CH2][CH2][CH3]",
                        "[!#1]S(=O)(=O)[NH][CH2]C(=O)[OH]",
                        "[!#1]S(=O)(=O)[NH][CH2]C(=O)O[CH2][CH3]",
                        "[!#1]S(=O)(=O)[NH][CH3]",
                        "[!#1]S(=O)(=O)[NH]C([CH3])([CH3])[CH3]",
                        "[!#1]S(=O)(=O)[NH]C(=O)[CH3]",
                        "[!#1]S(=O)(=O)[NH]C(=O)[NH2]",
                        "[!#1]S(=O)(=O)[NH]C(=O)O[CH2][CH2]N([CH2][CH3])[CH2][CH3]",
                        "[!#1]S(=O)(=O)[NH2]",
                        "[!#1]S(=O)(=O)[OH]",
                        "[!#1]S(=O)(=O)C([CH3])([CH3])[CH2]C(=O)[CH3]",
                        "[!#1]S(=O)(=O)C([CH3])([CH3])[CH3]",
                        "[!#1]S(=O)(=O)C(F)(F)F",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH][cH][cH]1",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH][cH]c1[N+](=O)[O-]",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH][cH]c1Cl",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c([cH]1)[N+](=O)[O-]",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c([cH]1)C(F)(F)F",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c([cH]1)S(=O)(=O)c2[cH][cH]c(Cl)[cH][cH]2",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c([cH]1)S(=O)(=O)c2[cH][cH]c(Cl)c(Cl)[cH]2",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c2[cH][cH][cH]nc12",
                        "[!#1]S(=O)(=O)c1[cH][cH][cH]c2nsnc12",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([cH][cH]1)[CH]2[CH2][CH2][CH2][CH2][CH2]2",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([cH][cH]1)[N+](=O)[O-]",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([cH][cH]1)C([CH3])([CH3])[CH3]",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([cH][cH]1)C(=O)[OH]",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([CH3])[cH][cH]1",
                        "[!#1]S(=O)(=O)c1[cH][cH]c([CH3])c([cH]1)[N+](=O)[O-]",
                        "[!#1]S(=O)(=O)c1[cH][cH]c(Br)[cH][cH]1",
                        "[!#1]S(=O)(=O)c1[cH][cH]c(Cl)[cH][cH]1",
                        "[!#1]S(=O)(=O)c1[cH][cH]c(Cl)c([cH]1)[N+](=O)[O-]",
                        "[!#1]S(=O)(=O)c1[cH][cH]c(Cl)c(Cl)[cH]1",
                        "[!#1]S(=O)(=O)c1[cH][cH]c(S(c2[cH][cH]c([cH][cH]2)S(=O)(=O)[!#1]))[cH][cH]1", // [!#1]S(=O)(=O)c1[cH][cH]c(Sc2[cH][cH]c([cH][cH]2)S(=O)(=O)[!#1])[cH][cH]1
                        "[!#1]S(=O)(=O)c1[cH][cH]c2[cH][cH][cH][cH]c2[cH]1",
                        "[!#1]S(=O)(=O)c1c([cH]c([cH]c1[CH]([CH3])[CH3])[CH]([CH3])[CH3])[CH]([CH3])[CH3]",
                        "[!#1]S(=O)(=O)c1c([CH3])[cH]c([CH3])[cH]c1[CH3]",
                        "[!#1]S(=O)(=O)N([CH2][CH]([CH3])[CH3])[CH2][CH]([CH3])[CH3]",
                        "[!#1]S(=O)(=O)N([CH2][CH2][CH2][CH3])[CH2][CH2]C(=O)[NH2]",
                        "[!#1]S(=O)(=O)N([CH2][CH2][CH3])[CH2][CH2][CH3]",
                        "[!#1]S(=O)(=O)N([CH2][CH2][OH])[CH2][CH2][OH]",
                        "[!#1]S(=O)(=O)N([CH2][CH3])[CH2][CH3]",
                        "[!#1]S(=O)(=O)N([CH3])[CH3]",
                        "[!#1]S(=O)(=O)N1[CH2][CH2][CH2][CH2][CH2]1",
                        "[!#1]S(=O)(=O)N1[CH2][CH2]O[CH2][CH2]1",
                        "[!#1]S(=O)(=O)O[CH2][CH2]S(=O)(=O)[CH2][CH3]",
                        "[!#1]S(=O)(=O)O[CH3]",
                        "[!#1]S(=O)(=O)O[K]",
                        "[!#1]S(=O)(=O)O[Na]",
                        "[!#1]S[!#1]",
                        "[!#1]S[CH]([!#1])[!#1]",
                        "[!#1]S[CH]([!#1])[CH2]C(=O)[!#1]",
                        "[!#1]S[CH]([!#1])C(=O)[OH]",
                        "[!#1]S[CH]([NH]C(=O)[!#1])C(=O)[!#1]",
                        "[!#1]S[CH]([NH]C(=O)[!#1])C(Cl)(Cl)Cl",
                        "[!#1]S[CH2][CH2][CH2]S(=O)(=O)[OH]",
                        "[!#1]S[CH2][CH2][NH2]",
                        "[!#1]S[CH2][CH2][OH]",
                        "[!#1]S[CH2][CH2]C(F)(F)F",
                        "[!#1]S[CH2][CH2]S(=O)(=O)[!#1]",
                        "[!#1]S[CH2][CH2]S[!#1]",
                        "[!#1]S[CH2][CH2]SC(=[NH])[NH2]",
                        "[!#1]S[CH2][CH3]",
                        "[!#1]S[CH2][NH]C(=O)[!#1]",
                        "[!#1]S[CH2]C(=O)[!#1]",
                        "[!#1]S[CH2]C(=O)[CH3]",
                        "[!#1]S[CH2]C(=O)[NH]N=[CH][!#1]",
                        "[!#1]S[CH2]C(=O)[NH2]",
                        "[!#1]S[CH2]C(=O)[OH]",
                        "[!#1]S[CH2]C(=O)O[CH2][CH3]",
                        "[!#1]S[CH3]",
                        "[!#1]SC([CH3])([CH3])[CH3]",
                        "[!#1]SC(=[NH])[NH]N=[CH][!#1]",
                        "[!#1]SC(=[NH])[NH2]",
                        "[!#1]SC(=C(Cl)Cl)[NH]C(=O)[!#1]",
                        "[!#1]SC(=N[CH2][CH3])[NH][CH2][CH3]",
                        "[!#1]SC(=O)[!#1]",
                        "[!#1]SC(F)(F)C(F)(F)C(F)(F)F",
                        "[!#1]SC(F)(F)F",
                        "[!#1]S(c1[cH][cH][cH][cH][cH]1)", // [!#1]Sc1[cH][cH][cH][cH][cH]1
                        "[!#1]S(c1[cH][cH]c([!#1])[cH][cH]1)", // [!#1]Sc1[cH][cH]c([!#1])[cH][cH]1
                        "[!#1]S(c1nc2[cH][cH][cH][cH]c2s1)", // [!#1]Sc1nc2[cH][cH][cH][cH]c2s1
                        "[Na]OS(=O)=O",
                        "[O-][N+](=O)c1cc([N+](=O)[O-])c2ccccc2c1",
                        "[O-][N+](=O)c1cc(C=O)cc(c1)[N+](=O)[O-]",
                        "[O-][N+](=O)c1cc(C=O)ccc1Br",
                        "[O-][N+](=O)c1cc(C=O)ccc1Cl",
                        "[O-][N+](=O)c1cc(cc(c1)C(F)(F)F)[N+](=O)[O-]",
                        "[O-][N+](=O)c1cc(ccc1Cl)S(=O)=O",
                        "[O-][N+](=O)c1cc(NC=O)ccc1Cl",
                        "[O-][N+](=O)c1cc2ccccc2oc1=O",
                        "[O-][N+](=O)c1cc2OCOc2cc1C=N",
                        "[O-][N+](=O)c1cc2OCOc2cc1C=NNC=O",
                        "[O-][N+](=O)c1ccc(C=N)cc1",
                        "[O-][N+](=O)c1ccc(C=N)s1",
                        "[O-][N+](=O)c1ccc(C=NNC=O)cc1",
                        "[O-][N+](=O)c1ccc(C=NNC=O)o1",
                        "[O-][N+](=O)c1ccc(C=O)c(C=O)c1",
                        "[O-][N+](=O)c1ccc(C=O)c(c1)[N+](=O)[O-]",
                        "[O-][N+](=O)c1ccc(C=O)cc1",
                        "[O-][N+](=O)c1ccc(cc1)C(=O)CCC(Cl)(Cl)Cl",
                        "[O-][N+](=O)c1ccc(cc1)C(=O)NN=Cc2ccccc2",
                        "[O-][N+](=O)c1ccc(cc1)N2CCNCC2",
                        "[O-][N+](=O)c1ccc(cc1)N2N=C(CC2=O)c3ccccc3",
                        "[O-][N+](=O)c1ccc(cc1)S(=O)=O",
                        "[O-][N+](=O)c1ccc(CCC=O)cc1",
                        "[O-][N+](=O)c1ccc(Cl)c(C=O)c1",
                        "[O-][N+](=O)c1ccc(Cl)cc1",
                        "[O-][N+](=O)c1ccc(NC(=S)NCC(Cl)(Cl)Cl)cc1",
                        "[O-][N+](=O)c1ccc(NC=O)cc1",
                        "[O-][N+](=O)c1ccc(NN=C(C=O)C=O)cc1",
                        "[O-][N+](=O)c1ccc2C(=O)NC(=O)c2c1",
                        "[O-][N+](=O)c1ccc2nc3c(cc2c1)[nH]c4ccccc43",
                        "[O-][N+](=O)c1ccc2nonc2c1",
                        "[O-][N+](=O)c1cccc(Br)c1",
                        "[O-][N+](=O)c1cccc(C=N)c1",
                        "[O-][N+](=O)c1cccc(C=NNC=O)c1",
                        "[O-][N+](=O)c1cccc(C=O)c1",
                        "[O-][N+](=O)c1cccc(C=O)c1C=O",
                        "[O-][N+](=O)c1cccc(c1)[N+](=O)[O-]",
                        "[O-][N+](=O)c1cccc(c1)C(F)(F)F",
                        "[O-][N+](=O)c1cccc(c1)S(=O)=O",
                        "[O-][N+](=O)c1cccc(Cl)c1",
                        "[O-][N+](=O)c1cccc(NC(=S)NCC(Cl)(Cl)Cl)c1",
                        "[O-][N+](=O)c1cccc(NC=O)c1",
                        "[O-][N+](=O)c1cccc(NS(=O)=O)c1",
                        "[O-][N+](=O)c1cccc2nonc12",
                        "[O-][N+](=O)c1cccc2nsnc12",
                        "[O-][N+](=O)c1ccccc1",
                        "[O-][N+](=O)c1ccccc1C=N",
                        "[O-][N+](=O)c1ccccc1C=NNC=O",
                        "[O-][N+](=O)c1ccccc1C=O",
                        "[O-][N+](=O)c1ccccc1Cl",
                        "[O-][N+](=O)c1ccccc1NC(=S)NCC(Cl)(Cl)Cl",
                        "[O-][N+](=O)c1ccccc1NC=O",
                        "[O-][N+](=O)c1ccccc1S(=O)=O",
                        "[O-][N+](=O)c1cn[nH]c1C=O",
                        "[O-][N+](=O)c1nc[nH]c1C=O",
                        "[O-][N+](=O)CCCl",
                        "[O-][N+](=O)NC(=N)NN=C",
                        "[O-][n+]1ccc(C=O)cc1",
                        "[O-][NH]=N",
                        "[O-][NH]=O",
                        "[OH]",
                        "Br",
                        "Brc1c[nH]nc1C=O",
                        "Brc1cc(Br)c2cccnc2c1",
                        "Brc1cc(Br)cc(Br)c1",
                        "Brc1cc2OCOc2cc1C=NNC=O",
                        "Brc1ccc(C=N)cc1",
                        "Brc1ccc(C=N)s1",
                        "Brc1ccc(C=NNC=O)cc1",
                        "Brc1ccc(C=NOC=O)cc1",
                        "Brc1ccc(C=O)c(C=O)c1",
                        "Brc1ccc(C=O)cc1",
                        "Brc1ccc(C=O)o1",
                        "Brc1ccc(cc1)N2C(=O)CCC2=O",
                        "Brc1ccc(cc1)S(=O)=O",
                        "Brc1ccc(NC=O)cc1",
                        "Brc1ccc(NS(=O)=O)cc1",
                        "Brc1cccc(Br)c1",
                        "Brc1cccc(C=O)c1",
                        "Brc1cccc2ccccc12",
                        "Brc1ccccc1",
                        "Brc1ccccc1C=O",
                        "Brc1ccccc1NC=O",
                        "Brc1cccnc1",
                        "Brc1ccco1",
                        "BrCCC=O",
                        "C",
                        "C#C",
                        "C#N",
                        "C(#Cc1ccccc1)c2ccccc2",
                        "C(c1ccccc1)c2ccccc2",
                        "C(c1nnn[nH]1)c2ccccc2",
                        "C(Cc1ccccc1)c2ccccc2",
                        "C(Cc1ccncc1)S(c2ccccc2)", // C(Cc1ccncc1)Sc2ccccc2
                        "C(NCc1ccccc1)c2ccccc2",
                        "C[N+](=O)[O-]",
                        "C[NH](C)C",
                        "C=C",
                        "C=C(C#N)C#N",
                        "C=C(NC=O)C=O",
                        "C=c1[nH]c(=O)c(=C)[nH]c1=O",
                        "C=C1C(=O)c2ccccc2C1=O",
                        "C=C1C(=O)N(N=C1c2ccccc2)c3ccccc3",
                        "C=C1C(=O)NC(=O)N(C1=O)c2cccc3ccccc23",
                        "C=C1C(=O)NC(=O)NC1=O",
                        "C=C1C(=O)OCOC1=O",
                        "C=C1C=NN(C1=O)c2ccccc2",
                        "C=C1CNCC(=C)C1=O",
                        "C=C1N=C(OC1=O)c2ccccc2",
                        "C=C1Nc2ccccc2C=C1",
                        "C=C1OC(=O)c2c1cc[nH]c2=O",
                        "C=C1SC(=N)NC1=O",
                        "C=C1SC(=O)NC1=O",
                        "C=C1SC(=S)N(C1=O)c2ccccc2",
                        "C=C1SC(=S)NC1=O",
                        "C=CC(=O)NC=S",
                        "C=CC(=O)NNC=O",
                        "C=CC=C1SC(=S)N(C1=O)c2ccccc2",
                        "C=CC=C1SC(=S)NC1=O",
                        "C=CC=N",
                        "C=CC=NNC=O",
                        "C=CC=O",
                        "C=CC1CN2CCC1CC2",
                        "C=CCNC=O",
                        "C=N",
                        "C=NC=NNC=O",
                        "C=NCCCCCCN=C",
                        "C=NCCN=C",
                        "C=NCCNC=O",
                        "C=NN=C",
                        "C=NNC(=O)C(=O)NN=C",
                        "C=NNC(=O)CC(=O)NN=C",
                        "C=NNC(=O)CNC=O",
                        "C=NNC=O",
                        "C=NNS(=O)=O",
                        "C=NOC=O",
                        "C=O",
                        "c1[nH]c2ccccc2[nH+]1",
                        "c1[nH]c2ccccc2c1c3ccccc3",
                        "c1[nH+]c2c(ccc3ccccc23)s1",
                        "c1[nH+]c2ccccc2o1",
                        "c1[nH+]c2ccccc2s1",
                        "C1C(N(N=C1c2ccccc2)c3ccccc3)c4ccccc4",
                        "c1c(nc2ccccn12)c3ccccc3",
                        "C1C(NN=C1c2ccccc2)c3ccccc3",
                        "c1c[nH]cn1",
                        "c1c[nH+]on1",
                        "C1C=NN(C1c2ccccc2)c3ccccc3",
                        "C1C=NNC1(c2ccccc2)c3ccccc3",
                        "C1C2CC3CC1CC(C2)(C3)c4ccccc4",
                        "C1C2CC3CC1CC(C2)(C3)c4cscn4",
                        "C1C2CC3CC1CC(C2)C3",
                        "C1C2CC3CC1CC(C2)CC3",
                        "C1C2CCCCC12",
                        "C1c2ccccc2-c3ccccc13",
                        "c1c2ccccc2n3cnc4ccccc4c13",
                        "C1c2ccccc2Oc3ccccc13",
                        "c1cc([nH]n1)c2ccccc2",
                        "C1CC(=NN1)c2ccccc2",
                        "C1CC(=NN1c2ccccc2)c3ccccc3",
                        "C1CC(CCN1)c2ccccc2",
                        "C1CC(CN1)c2ccccc2",
                        "c1cc(cs1)c2ccccc2",
                        "c1cc(n[nH]1)c2ccccc2",
                        "c1cc[n+]2cccnc2c1",
                        "c1cc[nH]c1",
                        "c1cc[nH+]cc1",
                        "C1CC=CC=C1",
                        "C1CC=CCN1",
                        "C1CC1",
                        "C1CC1(c2ccccc2)c3ccccc3",
                        "C1CC12CCC2",
                        "C1CC1C2CC2c3ccco3",
                        "C1CC1c2ccccc2",
                        "C1Cc2[nH]cnc2C(N1)c3ccccc3",
                        "C1Cc2c([nH]c3ccccc23)C(N1)c4ccccc4",
                        "C1Cc2c([nH]c3ccccc23)-c4cnn(c14)c5ccccc5",
                        "C1Cc2c(CN1)[nH]c3ccccc23",
                        "c1cc2c(n[nH]c(c3ccccc3)c2c1)c4ccccc4",
                        "c1cc2c[nH+]ccn2c1",
                        "C1CC2c3ccccc3C1c4ccccc24",
                        "C1CC2CC1C=C2",
                        "C1Cc2cc3CCCCc3nc2C1",
                        "C1Cc2cc3ccccc3nc2N1",
                        "C1Cc2cc3ccccc3nc2N1c4ccccc4",
                        "C1CC2CCC1C2",
                        "c1cc2ccc3ccccc3c2o1",
                        "C1CC2CCCC1N2",
                        "C1Cc2cccc3cccc1c23",
                        "c1cc2ccccc2[nH]1",
                        "C1Cc2ccccc2C(N1)c3ccccc3",
                        "C1Cc2ccccc2C3=NNC(C13)c4ccccc4",
                        "C1Cc2ccccc2CN1",
                        "C1Cc2ccccc2N1",
                        "c1cc2ccccc2n1c3ccccc3",
                        "C1Cc2ccccc2Nc3ccccc13",
                        "c1cc2ccccc2o1",
                        "c1cc2ccccc2s1",
                        "c1cc2cccnc2s1",
                        "C1CC2CNCCN2C1",
                        "c1cc2cncnc2s1",
                        "C1CC2Nc3ccccc3C2CN1",
                        "c1cc2nc3ccccc3nc2n1c4ccccc4",
                        "C1Cc2nccn2C1",
                        "C1CC2NCCn3c2c(C1)c4ccccc34",
                        "C1Cc2sc3ncncc3c2C1",
                        "C1CCC(C1)c2nnn[nH]2",
                        "c1ccc(cc1)C(c2ccccc2)c3ccccc3",
                        "c1ccc(cc1)C2(c3ccccc3-c4ccccc42)c5ccccc5",
                        "c1ccc(cc1)c2cc(nc(n2)c3ccccc3)c4ccccc4",
                        "c1ccc(cc1)c2cc(ncn2)c3ccccc3",
                        "C1CCC(CC1)c2ccc3[nH]c4CCCCc4c3c2",
                        "c1ccc(cc1)c2ccc3c(ccc4ccccc43)n2",
                        "c1ccc(cc1)c2ccc3ccccc3n2",
                        "c1ccc(cc1)c2cccc(n2)c3ccccc3",
                        "C1CCC(CC1)c2ccccc2",
                        "c1ccc(cc1)c2ccccn2",
                        "c1ccc(cc1)c2ccnc(n2)c3ccccc3",
                        "c1ccc(cc1)c2ccncn2",
                        "c1ccc(cc1)c2cnc3ccccc3n2",
                        "c1ccc(cc1)c2n[nH]c(n2)c3ccccc3",
                        "c1ccc(cc1)c2nc(c3ccccc3)c4ccccc4n2",
                        "c1ccc(cc1)c2nc3ccccc3[nH]2",
                        "c1ccc(cc1)c2nc3ccccc3nc2c4ccccc4",
                        "c1ccc(cc1)c2nc3ccccc3o2",
                        "c1ccc(cc1)c2nc3ccccc3s2",
                        "c1ccc(cc1)c2ncccn2",
                        "c1ccc(cc1)c2ncncn2",
                        "C1CCC(CC1)c2nnn[nH]2",
                        "C1CCC(CC1)c2nnnn2c3ccccc3",
                        "c1ccc(cc1)n2nc3ccccc3n2",
                        "C1CCC=CC1",
                        "C1CCC1",
                        "c1ccc2[nH]nnc2c1",
                        "c1ccc2[nH+]c3ccccc3nc2c1",
                        "c1ccc2[nH+]cccc2c1",
                        "c1ccc2c(c1)[nH]c3cc4ccccc4nc32",
                        "C1CCc2c(C1)[nH]c3ccc(cc23)c4ccccc4",
                        "C1CCc2c(C1)[nH]c3ccccc23",
                        "c1ccc2c(c1)[nH]c3ccccc32",
                        "c1ccc2c(c1)[nH]c3ncnnc23",
                        "C1CCc2c(C1)nc3ccccn23",
                        "c1ccc2c(c1)oc3ccccc32",
                        "C1CCc2c(C1)sc3ncncc23",
                        "C1CCC2C(NCCC2C1)c3ccccc3",
                        "c1ccc2c[nH+]ccc2c1",
                        "c1ccc2c3[nH]c4ccccc4c3[nH]c2c1",
                        "c1ccc2C3c4ccccc4C(c2c1)c5ccccc35",
                        "c1ccc2cc3ccccc3cc2c1",
                        "c1ccc2cc3ncccc3cc2c1",
                        "c1ccc2ccccc2c1",
                        "c1ccc2n[nH]nc2c1",
                        "c1ccc2nc3ccccc3cc2c1",
                        "c1ccc2nc3ccccc3nc2c1",
                        "c1ccc2ncccc2c1",
                        "c1ccc2nccnc2c1",
                        "c1ccc2ncncc2c1",
                        "c1ccc2nonc2c1",
                        "c1ccc2nsnc2c1",
                        "C1CCc2sccc2C1",
                        "C1CCCC1",
                        "C1CCCCC1",
                        "C1CCCCCC1",
                        "C1CCCCCCC1",
                        "C1CCCNCC1",
                        "c1ccn(c1)c2ccccc2",
                        "C1CCN(CC1)c2ncncn2",
                        "C1CCNC1",
                        "C1CCNCC1",
                        "c1ccnnc1",
                        "c1ccoc1",
                        "C1CCOCC1",
                        "c1ccsc1",
                        "C1CN(C(N1c2ccccc2)c3ccccc3)c4ccccc4",
                        "C1CN(CCN1)c2ccccc2",
                        "C1CN(CCN1)c2ccccn2",
                        "C1CN(CCO1)c2ccccc2",
                        "C1CN(CCO1)c2ncnc(n2)N3CCOCC3",
                        "C1CN(CCO1)c2ncncn2",
                        "c1cn(nc1c2ccccc2)c3ccccc3",
                        "c1cn[nH]c1",
                        "c1cn2c(n1)[nH]c3ccccc32",
                        "C1CN2CCC1CC2",
                        "C1Cn2cccc2C=[NH+]1",
                        "C1Cn2cccc2C=N1",
                        "C1Cn2cccc2CN1",
                        "c1cn2ccccc2n1",
                        "C1CNC(N1)c2ccccc2",
                        "C1CNc2ccccc2C1",
                        "c1cnc2nonc2n1",
                        "C1CNCCN1",
                        "c1cncnc1",
                        "c1cnn(c1)c2ccccc2",
                        "c1cnoc1",
                        "c1cnon1",
                        "c1coc(c1)c2ccccc2",
                        "C1COC(C1)n2cnc3cncnc23",
                        "C1COC(N1)c2ccccc2",
                        "C1COC=CO1",
                        "C1COC2(CCCCC2)O1",
                        "C1COC2C(C1)COc3ccccc23",
                        "C1COc2ccccc2O1",
                        "C1COCCN1",
                        "C1COCCO1",
                        "C1COCCOCCNCCOCCOCCN1",
                        "C1COCCOCCOCCOCCOCCN1",
                        "c1cocn1",
                        "C1COCO1",
                        "c1csc(c1)c2ccccc2",
                        "C1CSC(N1)c2ccccc2",
                        "c1csc[nH+]1",
                        "c1cscn1",
                        "c1n[nH]c2cccn[n+]12",
                        "c1n[nH+]c[nH]1",
                        "c1nc(cs1)c2ccccc2",
                        "c1nc(oc1c2ccccc2)c3ccccc3",
                        "c1nc[nH]n1",
                        "c1nc2ccccc2[nH]1",
                        "c1nc2ccccc2o1",
                        "c1nc2ccccc2s1",
                        "c1nc2cnccc2[nH]1",
                        "c1nc2cncnc2[nH]1",
                        "c1nc2nc(cc(c3ccccc3)n2n1)c4ccccc4",
                        "c1nc2ncccn2n1",
                        "c1nc2ncncc2[nH]1",
                        "c1ncc(s1)c2ccccc2",
                        "c1ncncn1",
                        "c1nnc[nH]1",
                        "c1nncn1c2ccccc2",
                        "c1nnco1",
                        "c1nncs1",
                        "c1nnn[nH]1",
                        "c1nnnn1c2ccccc2",
                        "C1Oc2ccccc2O1",
                        "CBr",
                        "CC",
                        "CC#C",
                        "CC#CC(O)(c1ccccc1)c2ccccc2",
                        "CC#CCCO",
                        "CC(=C)C(=O)N",
                        "CC(=N)C",
                        "CC(=N)CC=O",
                        "CC(=NN)C",
                        "CC(=NNC(=O)c1ccccc1)c2ccccc2",
                        "CC(=NNC(=O)c1ccccc1O)c2ccccc2",
                        "CC(=NNC(=O)CO)C",
                        "CC(=NNC(=O)CO)C=C",
                        "CC(=NNC(=O)CO)C=Cc1ccco1",
                        "CC(=NNC(=O)CO)c1ccc(Br)s1",
                        "CC(=NNC(=O)CO)c1cccs1",
                        "CC(=NNC=O)C",
                        "CC(=NNC=O)C(=O)O",
                        "CC(=NNC=O)C=C",
                        "CC(=NNC=O)C=Cc1ccccc1",
                        "CC(=NNC=O)c1cc(O)ccc1O",
                        "CC(=NNC=O)C1CC1",
                        "CC(=NNC=O)c1cc2ccc(O)cc2oc1=O",
                        "CC(=NNC=O)c1ccc(Br)cc1",
                        "CC(=NNC=O)c1ccc(cc1)[N+](=O)[O-]",
                        "CC(=NNC=O)c1ccc(cc1)c2ccccc2",
                        "CC(=NNC=O)c1ccc(Cl)s1",
                        "CC(=NNC=O)c1ccc(F)cc1",
                        "CC(=NNC=O)c1ccc(N)cc1",
                        "CC(=NNC=O)c1ccc(O)cc1",
                        "CC(=NNC=O)c1cccc(c1)[N+](=O)[O-]",
                        "CC(=NNC=O)c1cccc(N)c1",
                        "CC(=NNC=O)c1ccccc1",
                        "CC(=NNC=O)c1ccccc1O",
                        "CC(=NNC=O)c1ccco1",
                        "CC(=NNC=O)c1cccs1",
                        "CC(=NNC=O)CC(=O)N",
                        "CC(=NNC=O)CCC=C",
                        "CC(=NNc1ccc(cc1[N+](=O)[O-])[N+](=O)[O-])c2ccccc2",
                        "CC(=NNc1ccccc1)c2ccccc2",
                        "CC(=NNc1ccccc1)CC=O",
                        "CC(=NO)c1ccccc1",
                        "CC(=NOC(=O)N)C",
                        "CC(=NOC=O)C(C)(C)C",
                        "CC(=NOC=O)c1ccccc1",
                        "CC(=O)C",
                        "CC(=O)C1(C(C=O)C(C=O)C2c3ccccc31)c4ccccc24",
                        "CC(=O)C1(CC2CC3CC(C2)C1)C3",
                        "CC(=O)c1c(C)[nH]c2ccc(O)cc12",
                        "CC(=O)c1c(C)[nH]c2ccccc12",
                        "CC(=O)c1c(C)cc(C)[nH]c1=O",
                        "CC(=O)c1c(O)cc(C)oc1=O",
                        "CC(=O)c1ccc(Br)cc1",
                        "CC(=O)c1ccc(C)cc1",
                        "CC(=O)c1ccc(cc1)c2ccccc2",
                        "CC(=O)c1ccc(Cl)c(Cl)c1",
                        "CC(=O)c1ccc(Cl)cc1",
                        "CC(=O)c1ccc(N)cc1",
                        "CC(=O)c1ccc(O)cc1",
                        "CC(=O)c1cccc(c1)[N+](=O)[O-]",
                        "CC(=O)c1ccccc1",
                        "CC(=O)c1ccccc1C(=O)C",
                        "CC(=O)c1ccccc1O",
                        "CC(=O)c1ccncc1",
                        "CC(=O)CC(=NNC=O)C",
                        "CC(=O)CC(=O)C",
                        "CC(=O)CC(=O)N",
                        "CC(=O)CC(C)(C)S(=O)=O",
                        "CC(=O)CC=O",
                        "CC(=O)CCS(=O)=O",
                        "CC(=O)CO",
                        "CC(=O)CS(=O)=O",
                        "CC(=O)N",
                        "CC(=O)n1ccc2ccccc12",
                        "CC(=O)N1CCOCC1",
                        "CC(=O)NC(=C)C(=O)N",
                        "CC(=O)NC(=Cc1ccccc1)C(=O)N",
                        "CC(=O)NC(N)C(Cl)(Cl)Cl",
                        "CC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CC(=O)NCC(=O)N",
                        "CC(=O)NN",
                        "CC(=O)NN=C",
                        "CC(=O)NN=C(C)c1ccccc1",
                        "CC(=O)NN=C(C=O)c1cccc(Br)c1",
                        "CC(=O)NN=C(C=O)c1cccc(c1)[N+](=O)[O-]",
                        "CC(=O)NN=C1CCCc2c1non2=O",
                        "CC(=O)NN=Cc1c(Cl)cccc1Cl",
                        "CC(=O)NN=Cc1c(O)ccc2ccccc12",
                        "CC(=O)NN=Cc1c[nH]c2ccccc12",
                        "CC(=O)NN=Cc1cc(ccc1O)[N+](=O)[O-]",
                        "CC(=O)NN=Cc1cc(N=Nc2ccccc2)ccc1O",
                        "CC(=O)NN=Cc1cc2ccccc2nc1Cl",
                        "CC(=O)NN=Cc1cc2OCOc2cc1[N+](=O)[O-]",
                        "CC(=O)NN=Cc1ccc(Br)cc1",
                        "CC(=O)NN=Cc1ccc(cc1)[N+](=O)[O-]",
                        "CC(=O)NN=Cc1ccc(Cl)cc1",
                        "CC(=O)NN=Cc1ccc2OCOc2c1",
                        "CC(=O)NN=Cc1cccc(c1)[N+](=O)[O-]",
                        "CC(=O)NN=Cc1ccccc1",
                        "CC(=O)NN=Cc1ccccc1O",
                        "CC(=O)NN=Cc1ccco1",
                        "CC(=O)NN=Cc1cccs1",
                        "CC(=O)NNC=O",
                        "CC(=O)NO",
                        "CC(=O)NS(=O)=O",
                        "CC(=O)O",
                        "CC(=O)O[Na]",
                        "CC(=O)OC(=N)c1ccccc1",
                        "CC(=O)OCC=O",
                        "CC(=O)OCCNC=O",
                        "CC(Br)(Br)Br",
                        "CC(Br)C(=O)N",
                        "CC(C(C=O)C(C=O)C(C)c1ccccc1)c2ccccc2",
                        "CC(C)(C)C",
                        "CC(C)(C)C(=O)N",
                        "CC(C)(C)C(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CC(C)(C)C=O",
                        "CC(C)(C)c1cc(Br)cc(C=N)c1O",
                        "CC(C)(C)c1cc(C=N)cc(c1O)C(C)(C)C",
                        "CC(C)(C)c1cc(C=O)cc(c1)C(C)(C)C",
                        "CC(C)(C)c1ccc(C=O)cc1",
                        "CC(C)(C)c1ccc(cc1)S(=O)=O",
                        "CC(C)(C)c1ccc(O)c(c1)C(C)(C)C",
                        "CC(C)(C)c1ccc(O)cc1",
                        "CC(C)(C)c1cccc(c1)C(C)(C)C",
                        "CC(C)(C)c1cccc(c1O)C(C)(C)C",
                        "CC(C)(C)c1ccccc1",
                        "CC(C)(C)c1ncccc1O",
                        "CC(C)(C)CC=C",
                        "CC(C)(C)CC=Cc1ccc(Cl)cc1Cl",
                        "CC(C)(C)N",
                        "CC(C)(C)NC(NC=O)C(Cl)(Cl)Cl",
                        "CC(C)(C)NC=O",
                        "CC(C)(C)NCC(=O)N",
                        "CC(C)(C)NCC(O)CO",
                        "CC(C)(C)NS(=O)(=O)N",
                        "CC(C)(C)NS(=O)=O",
                        "CC(C)(C)O",
                        "CC(C)(C)OC=O",
                        "CC(C)(C)S",
                        "CC(C)(C)S(=O)=O",
                        "CC(C)(c1ccc(O)cc1)c2ccc(O)cc2",
                        "CC(C)(CCC(=O)N)C(=O)N",
                        "CC(C)(CCC=O)C=O",
                        "CC(C)(N)CO",
                        "CC(C)(O)C#C",
                        "CC(C)C",
                        "CC(C)C(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CC(C)C(N)C(=O)O",
                        "CC(C)C(NC(=S)SCC=O)C(=O)O",
                        "CC(C)C(NC=O)C(=O)O",
                        "CC(C)C(NS(=O)=O)C(=O)O",
                        "CC(C)C=O",
                        "CC(C)c1cc(C(C)C)c(S(=O)=O)c(c1)C(C)C",
                        "CC(C)c1cc(cc(c1)C(C)C)C(C)C",
                        "CC(C)c1ccc(C)c(O)c1",
                        "CC(C)c1ccc(C)cc1",
                        "CC(C)C1CCC(C)CC1O",
                        "CC(C)c1ccc(O)cc1",
                        "CC(C)c1ccccc1",
                        "CC(C)c1nnn[nH]1",
                        "CC(C)CC(=NNC=O)C",
                        "CC(C)CC(=O)N",
                        "CC(C)CC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CC(C)CC(=O)O",
                        "CC(C)CC(C)(C)C",
                        "CC(C)CC(C)O",
                        "CC(C)CC=O",
                        "CC(C)Cc1ccc(cc1)C(C)C=O",
                        "CC(C)CCC(=O)O",
                        "CC(C)CCC=O",
                        "CC(C)CCCC(C)C",
                        "CC(C)CCO",
                        "CC(C)CN",
                        "CC(C)CN(CC(C)C)S(=O)=O",
                        "CC(C)CNC=O",
                        "CC(C)CO",
                        "CC(C)COC=O",
                        "CC(C)COP(=O)(N)OCC(C)C",
                        "CC(C)N",
                        "CC(C)N(C=O)C(C)C",
                        "CC(C)NC=O",
                        "CC(C)NCC(=O)N",
                        "CC(C)NCC(O)CO",
                        "CC(C)NS(=O)=O",
                        "CC(C)O",
                        "CC(C)OC(=O)N",
                        "CC(C)OC=O",
                        "CC(C)OP(=O)(N)OC(C)C",
                        "CC(CC=O)c1ccccc1",
                        "CC(Cl)(Cl)Cl",
                        "CC(N)C(=O)O",
                        "CC(N)c1ccccc1",
                        "CC(NC(=O)CO)C(=O)O",
                        "CC(NC(=O)OC(C)(C)C)C(=O)O",
                        "CC(NC=O)C(=O)N",
                        "CC(NC=O)C(=O)O",
                        "CC(NS(=O)=O)C(=O)O",
                        "CC(O)C(=O)NN",
                        "CC(O)C(=O)NN=C",
                        "CC(O)C(=O)NN=Cc1cc(ccc1O)[N+](=O)[O-]",
                        "CC(O)C(=O)NN=Cc1ccccc1",
                        "CC(O)C(=O)O",
                        "CC(O)C(O)C(O)C(C)O",
                        "CC(O)C(O)C(O)C(O)CO",
                        "CC(O)C(O)C(O)CO",
                        "CC(O)c1ccc(cc1)[N+](=O)[O-]",
                        "CC(O)c1ccccc1",
                        "CC(O)CBr",
                        "CC(O)CCC(=O)NN=C",
                        "CC(O)CCl",
                        "CC(O)CN",
                        "CC(O)CN(C)C",
                        "CC(O)CO",
                        "CC(OC=O)C(=C(Cl)Cl)Cl",
                        "CC[n+]1c(C)oc2ccccc12",
                        "CC[n+]1c2ccccc2nc3ccccc13",
                        "CC=C",
                        "CC=CC(=O)C",
                        "CC=CC(=O)N",
                        "CC=N",
                        "CC=NN",
                        "CC=NN=CC",
                        "CC=NNC(=O)C",
                        "CC=NNC(=O)CO",
                        "CC=NNC(=O)N",
                        "CC=NNC(=S)N",
                        "CC=NNC=O",
                        "CC=NNS(=O)=O",
                        "CC=NO",
                        "CC=NOC=O",
                        "CC=NOCON=CC",
                        "CC=O",
                        "CC1(C)C(CCC1(C)C(=O)O)C(=O)N",
                        "CC1(C)C(CCC1(C)C(=O)O)C=O",
                        "CC1(C)C2CCC1(C)C(=O)C2",
                        "CC1(C)CC(=CC(=O)C1)O",
                        "CC1(C)CC(=O)c2cc3ccccc3nc2C1",
                        "CC1(C)CC(=O)c2cncnc2C1",
                        "CC1(C)CC(=O)CC(=NNC=O)C1",
                        "CC1(C)CC(=O)CC(=O)C1",
                        "CC1(C)CC(=O)CC(=O)C1C=O",
                        "CC1(C)CC(O)c2cc3ccccc3nc2C1",
                        "CC1(C)CC=CC(=O)C1",
                        "CC1(C)CC1",
                        "CC1(C)CC1C=O",
                        "CC1(C)CCCC(C)(C)N1",
                        "CC1(C)CCCC1(C)C(=O)O",
                        "CC1(C)CN(C(=O)N1)c2cccc3ccccc23",
                        "CC1(C)OC(=O)CC(=O)O1",
                        "CC1(CC2CC3CC(C2)C1)C3",
                        "CC1(O)CCCCC1",
                        "Cc1[nH][nH]c(=O)c1C=N",
                        "Cc1[nH]c2ccc(C=O)cc2c1C",
                        "Cc1[nH]c2ccc(O)cc2c1C=O",
                        "Cc1[nH]c2ccccc2c1C",
                        "CC1=CC(NC(=O)N1)c2ccccc2",
                        "CC1=NN(C(=O)C1)c2c(F)c(F)c(F)c(F)c2F",
                        "CC1=NN(C(=O)C1)c2ccc(cc2)[N+](=O)[O-]",
                        "CC1C(=O)c2ccccc2C1=O",
                        "CC1C(=O)CC(C)(C)CC1=O",
                        "CC1C(C=O)C(C=O)C(C)C(C=O)C1C=O",
                        "Cc1c(C=O)oc2c(O)cccc12",
                        "Cc1c(cc(C=O)cc1[N+](=O)[O-])[N+](=O)[O-]",
                        "Cc1c(cc(cc1[N+](=O)[O-])C(=O)N)[N+](=O)[O-]",
                        "Cc1c(cccc1[N+](=O)[O-])[N+](=O)[O-]",
                        "Cc1c(O)ccc2ccccc12",
                        "Cc1c[nH]c2ccccc12",
                        "Cc1cc(=O)[nH][nH]1",
                        "Cc1cc(=O)c2ccc(O)cc2o1",
                        "Cc1cc(=O)c2ccccc2o1",
                        "Cc1cc(=O)n(c2ccccc2)n1C",
                        "Cc1cc(=O)oc2cc(O)ccc12",
                        "Cc1cc(=O)oc2ccccc12",
                        "Cc1cc(Br)cc(Br)c1O",
                        "Cc1cc(Br)cc(C(=O)O)c1O",
                        "Cc1cc(Br)cc(C)c1O",
                        "Cc1cc(C)[nH]c(=O)n1",
                        "Cc1cc(C)[nH]n1",
                        "Cc1cc(C)c(C)c(C)c1C",
                        "Cc1cc(C)c(C=NO)c(C)c1",
                        "CC1CC(C)C(C=O)C1C=O",
                        "CC1CC(C)C(C1C=O)C(=O)O",
                        "Cc1cc(C)c(O)c(n1)C(C)(C)C",
                        "Cc1cc(C)c(O)cn1",
                        "Cc1cc(C)c(S(=O)=O)c(C)c1",
                        "Cc1cc(C)cc(Br)c1",
                        "Cc1cc(C)cc(C)c1",
                        "Cc1cc(C)n2ncnc2n1",
                        "Cc1cc(C)nc(N)n1",
                        "Cc1cc(C)nc(NC=O)n1",
                        "Cc1cc(C)nc(NS(=O)=O)n1",
                        "Cc1cc(C)ncn1",
                        "Cc1cc(cc(c1)[N+](=O)[O-])[N+](=O)[O-]",
                        "Cc1cc(ccc1O)[N+](=O)[O-]",
                        "Cc1cc(CO)c(C=O)c(=O)[nH]1",
                        "Cc1cc(O)c2[nH]nc[n+]2n1",
                        "Cc1cc(O)cc(O)c1",
                        "Cc1cc[nH]n1",
                        "Cc1cc2cc(ccc2[nH]1)[N+](=O)[O-]",
                        "Cc1cc2ccccc2[nH]1",
                        "Cc1cc2ccccc2n1C",
                        "Cc1ccc(Br)cc1",
                        "Cc1ccc(Br)s1",
                        "Cc1ccc(C)[nH]1",
                        "Cc1ccc(C)c(C)c1",
                        "Cc1ccc(C)cc1",
                        "Cc1ccc(C)n1c2ccccc2",
                        "Cc1ccc(C)o1",
                        "Cc1ccc(C=N)o1",
                        "Cc1ccc(C=NNC=O)o1",
                        "Cc1ccc(C=O)cc1",
                        "Cc1ccc(C=O)cc1S(=O)=O",
                        "Cc1ccc(cc1)[N+](=O)[O-]",
                        "Cc1ccc(cc1)C(=O)O",
                        "Cc1ccc(cc1)C(F)(F)F",
                        "Cc1ccc(cc1)C2(CC2C=O)c3ccc(C)cc3",
                        "Cc1ccc(cc1)c2ccccc2",
                        "Cc1ccc(cc1)S(=O)(=O)C",
                        "Cc1ccc(cc1)S(=O)(=O)N",
                        "Cc1ccc(cc1)S(=O)=O",
                        "Cc1ccc(cc1[N+](=O)[O-])S(=O)=O",
                        "Cc1ccc(CCC=O)o1",
                        "Cc1ccc(Cl)cc1",
                        "Cc1ccc(Cl)cc1Cl",
                        "Cc1ccc(F)cc1",
                        "Cc1ccc(F)cc1F",
                        "Cc1ccc(N)cc1",
                        "Cc1ccc(NC(=S)NCC(Cl)(Cl)Cl)cc1",
                        "Cc1ccc(NC(=S)SCC=O)cc1",
                        "Cc1ccc(NC=O)cc1",
                        "Cc1ccc(O)c(C)c1",
                        "Cc1ccc(O)c(C)n1",
                        "Cc1ccc(O)c(C=NNC=O)c1",
                        "Cc1ccc(O)c(c1)[N+](=O)[O-]",
                        "Cc1ccc(O)c(CCc2ccccc2)n1",
                        "Cc1ccc(O)c(O)c1",
                        "Cc1ccc(O)cc1",
                        "Cc1ccc(O)cc1C",
                        "Cc1ccc(O)cn1",
                        "Cc1ccc(o1)[N+](=O)[O-]",
                        "Cc1ccc[nH]1",
                        "Cc1ccc[nH]c1=N",
                        "Cc1ccc2[nH]c3C(=O)CCCc3c2c1",
                        "Cc1ccc2[nH]c3CCCCc3c2c1",
                        "Cc1ccc2ccccc2c1",
                        "Cc1ccc2ccccc2n1",
                        "Cc1ccc2n3CCNC4CCCc(c43)c2c1",
                        "Cc1ccc2ncsc2c1",
                        "Cc1ccc2OCOc2c1",
                        "Cc1cccc(Br)c1",
                        "Cc1cccc(C)c1",
                        "Cc1cccc(C)c1Cl",
                        "Cc1cccc(C)c1n2cnnn2",
                        "Cc1cccc(C)c1NC=O",
                        "Cc1cccc(C)n1",
                        "Cc1cccc(C=O)c1",
                        "Cc1cccc(c1)[N+](=O)[O-]",
                        "Cc1cccc(c1)C(=O)N",
                        "Cc1cccc(c1)C(=O)O",
                        "Cc1cccc(c1)C(C)(C)C",
                        "Cc1cccc(c1)c2cccc(C)c2",
                        "Cc1cccc(Cl)c1",
                        "Cc1cccc(F)c1",
                        "Cc1cccc(N)c1",
                        "Cc1cccc(N=Nc2ccccc2C)c1",
                        "Cc1cccc(NC(=S)NCC(Cl)(Cl)Cl)c1",
                        "Cc1cccc(NC=O)c1",
                        "Cc1cccc(O)c1",
                        "Cc1cccc2ccccc12",
                        "CC1CCCCC1",
                        "Cc1ccccc1[N+](=O)[O-]",
                        "Cc1ccccc1Br",
                        "Cc1ccccc1C",
                        "Cc1ccccc1C(F)(F)F",
                        "Cc1ccccc1C=O",
                        "Cc1ccccc1Cl",
                        "Cc1ccccc1F",
                        "Cc1ccccc1I",
                        "Cc1ccccc1N",
                        "Cc1ccccc1N=Nc2ccc(NC(=S)NCC(Cl)(Cl)Cl)c(C)c2",
                        "Cc1ccccc1NC(=S)NCC(Cl)(Cl)Cl",
                        "Cc1ccccc1NS(=O)=O",
                        "Cc1ccccc1O",
                        "Cc1ccccc1S(=O)(=O)O",
                        "Cc1ccccn1",
                        "Cc1cccnc1",
                        "Cc1ccco1",
                        "Cc1cccs1",
                        "Cc1ccn[nH]1",
                        "Cc1ccnc(C)c1",
                        "Cc1ccnc(N)c1",
                        "Cc1ccnc2ccc3ccccc3c12",
                        "Cc1ccncc1",
                        "Cc1ccncn1",
                        "Cc1ccoc1",
                        "Cc1ccsc1",
                        "Cc1ccsc1C",
                        "Cc1ccsc1C=N",
                        "CC1COC2(CCCCC2)O1",
                        "Cc1csc[nH+]1",
                        "Cc1csc2CCCCc12",
                        "Cc1cscn1",
                        "Cc1n[nH]cc1[N+](=O)[O-]",
                        "Cc1nc2ccccc2[nH]1",
                        "Cc1nc2ccccc2c(=O)[nH]1",
                        "Cc1nc2ccccc2c3cc4ccccc4n13",
                        "Cc1nc2ccccc2s1",
                        "Cc1ncc([nH]1)[N+](=O)[O-]",
                        "Cc1ncc[nH]1",
                        "Cc1ncc2c3CCCCc3sc2n1",
                        "Cc1nncs1",
                        "CC1OCC(O)C(O)C1O",
                        "CC1OCCO1",
                        "Cc1sc2ccccc2[n+]1CCCS(=O)(=O)O",
                        "Cc1sc2ncncc2c1C",
                        "Cc1scc(C=O)c1C",
                        "CCC",
                        "CCC#N",
                        "CCC(=NNC(=S)N)CC",
                        "CCC(=O)C",
                        "CCC(=O)C1(CC2CC3CC(C2)C1)C3",
                        "CCC(=O)c1ccccc1",
                        "CCC(=O)CC",
                        "CCC(=O)N",
                        "CCC(=O)NC",
                        "CCC(=O)NC(C)C",
                        "CCC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CCC(=O)NN",
                        "CCC(=O)NN=C",
                        "CCC(=O)NNC=O",
                        "CCC(=O)O",
                        "CCC(=O)OC",
                        "CCC(=O)OCC=O",
                        "CCC(C)(C)C",
                        "CCC(C)(C)CC(=O)C",
                        "CCC(C)C",
                        "CCC(C)CC",
                        "CCC(C)N",
                        "CCC(C)NC=O",
                        "CCC(C=O)C(CC)C=O",
                        "CCC(CC)(C=O)C=O",
                        "CCC(CC)Cc1ccccc1",
                        "CCC(CCC(O)c1ccnc2ccccc12)C(C)C",
                        "CCC(N)C(=O)O",
                        "CCC=C(C)C",
                        "CCC=NNC=O",
                        "CCC=NO",
                        "CCC=O",
                        "CCC1(CC2CC3CC(C2)C1)C3",
                        "CCC1C(C=O)C(C=O)C(C)(CC=O)C(C=O)C1C=O",
                        "CCc1c[nH]c2ccc(O)cc12",
                        "CCc1c[nH]c2ccccc12",
                        "CCC1CC1",
                        "CCc1cc2c(=O)ccoc2cc1O",
                        "CCc1ccc(C)nc1",
                        "CCc1ccc(cc1)c2nc3ccccc3o2",
                        "CCc1ccc(O)c(O)c1",
                        "CCc1ccc(O)cc1",
                        "CCc1ccccc1",
                        "CCC1CCCCN1",
                        "CCc1cnc2ccc(Br)cc2c1",
                        "CCc1cnc2ccccc2c1",
                        "CCc1nc(C)ccc1O",
                        "CCc1nc2ccccc2[nH]1",
                        "CCc1nc2ccccc2cc1C",
                        "CCc1ncccc1O",
                        "CCc1nnc(N)s1",
                        "CCc1nncs1",
                        "CCCC",
                        "CCCC(=O)N",
                        "CCCC(=O)NC(N)C(Cl)(Cl)Cl",
                        "CCCC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CCCC(=O)NS(=O)=O",
                        "CCCC(=O)O",
                        "CCCC(CCC)C(=O)N",
                        "CCCC(O)CO",
                        "CCCC=NNC=O",
                        "CCCC=O",
                        "CCCc1c[nH]c2ccccc12",
                        "CCCc1ccc(O)cc1",
                        "CCCc1ccccc1",
                        "CCCc1nc2ccccc2cc1CC",
                        "CCCCC",
                        "CCCCC(=O)N",
                        "CCCCC(=O)O",
                        "CCCCC=O",
                        "CCCCc1ccccc1",
                        "CCCCc1nc2ccccc2cc1CCC",
                        "CCCCCC",
                        "CCCCCC(=O)N",
                        "CCCCCC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CCCCCC(=O)NN=C",
                        "CCCCCC(=O)O",
                        "CCCCCC(C)NC=O",
                        "CCCCCC=O",
                        "CCCCCCC",
                        "CCCCCCC(=O)NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "CCCCCCC=O",
                        "CCCCCCCC",
                        "CCCCCCCC(=O)NN=C",
                        "CCCCCCCC(=O)NNC=O",
                        "CCCCCCCC=O",
                        "CCCCCCNC=O",
                        "CCCCCCO",
                        "CCCCCCOC=O",
                        "CCCCCN",
                        "CCCCCO",
                        "CCCCCOC=O",
                        "CCCCl",
                        "CCCCN",
                        "CCCCN(CCCC)CC(=O)N",
                        "CCCCNC=O",
                        "CCCCNS(=O)=O",
                        "CCCCO",
                        "CCCCOC=O",
                        "CCCCS",
                        "CCCN",
                        "CCCN(C)C",
                        "CCCNC=O",
                        "CCCNS(=O)=O",
                        "CCCO",
                        "CCCOC(=O)CO",
                        "CCCOC=O",
                        "CCCS(=O)(=O)O",
                        "CCCS(=O)(=O)O[Na]",
                        "CCl",
                        "CCN",
                        "CCN(C)C",
                        "CCN(C)CC",
                        "CCN(C)CC(=O)N",
                        "CCN(CC(O)CO)S(=O)(=O)O",
                        "CCN(CC)C(=S)N",
                        "CCN(CC)C=O",
                        "CCN(CC)CC",
                        "CCN(CC)CC(=O)N",
                        "CCN(CC)CC(C)O",
                        "CCN(CC)CC=O",
                        "CCN(CC)CCC=O",
                        "CCN(CC)CCCC(C)N",
                        "CCN(CC)CCN",
                        "CCN(CC)CCNC=O",
                        "CCN(CC)CCOC=O",
                        "CCN(CC)S(=O)=O",
                        "CCN(CCO)C=O",
                        "CCN=C",
                        "CCN1C(=O)c2cccc3cccc1c23",
                        "CCN1C(=O)c2ccccc2C1=O",
                        "CCn1c2ccccc2c3cc(C=NNC=O)ccc13",
                        "CCN1CCOCC1",
                        "CCNC",
                        "CCNC(=NCC)S",
                        "CCNC(=O)C",
                        "CCNC(=O)C=C",
                        "CCNC(=O)CC",
                        "CCNC(=O)CO",
                        "CCNC(=O)N",
                        "CCNC(=S)NC(CC=O)c1ccccc1",
                        "CCNC=O",
                        "CCNCC",
                        "CCNCC(=O)N",
                        "CCNCC(O)CO",
                        "CCNCC=O",
                        "CCNCCO",
                        "CCNS(=O)=O",
                        "CCO",
                        "CCOC",
                        "CCOC(=O)C",
                        "CCOC(=O)C(=C)C#N",
                        "CCOC(=O)C(C)NC(=O)C",
                        "CCOC(=O)C(C)NC=O",
                        "CCOC(=O)C=CC",
                        "CCOC(=O)CC",
                        "CCOC(=O)CC(=O)N",
                        "CCOC(=O)CC(=O)OCC",
                        "CCOC(=O)CC=O",
                        "CCOC(=O)CCC(=O)N",
                        "CCOC(=O)CN",
                        "CCOC(=O)CNC=O",
                        "CCOC(=O)CS",
                        "CCOC(=O)N",
                        "CCOC(=O)NC(N)C(Cl)(Cl)Cl",
                        "CCOC(=O)NN=C",
                        "CCOC=O",
                        "CCOP(=O)(CN)OCC",
                        "CCOP(=O)(N)OCC",
                        "CCS",
                        "CCS(=O)(=O)C(=C(N)N)S(=O)(=O)CC",
                        "CCS(=O)(=O)CCC(=O)N",
                        "CCS(=O)(=O)CCC=O",
                        "CCS(=O)(=O)O",
                        "CCS(=O)=O",
                        "CCS=O",
                        "CCSC",
                        "CCSC(=N)N",
                        "CCSC(C)C",
                        "CCSC=S",
                        "CCSCC",
                        "Cl",
                        "ClC(=C(Cl)COC=O)Cl",
                        "ClC(=C)Cl",
                        "ClC(Cl)(Cl)C=O",
                        "ClC(Cl)(Cl)CNC(=S)Nc1ccc(cc1)S(=O)=O",
                        "ClC(Cl)(Cl)CNC(=S)Nc1ccc(N=Nc2ccccc2)cc1",
                        "ClC(Cl)(Cl)CNC(=S)Nc1cccc2ccccc12",
                        "ClC(Cl)(Cl)CNC(=S)Nc1cccc2cccnc12",
                        "ClC(Cl)(Cl)CNC(=S)Nc1ccccc1",
                        "ClC(Cl)(Cl)CNC(=S)Nc1ccccc1C=O",
                        "ClC(Cl)(Cl)CNC(=S)Nc1sc2CCCCc2c1C=O",
                        "ClC(Cl)(Cl)CNC=O",
                        "ClC(Cl)(Cl)CNS(=O)=O",
                        "ClC(Cl)Cl",
                        "Clc1c(C=O)sc2ccccc12",
                        "Clc1cc(Cl)cc(C=O)c1",
                        "Clc1cc(Cl)cc(Cl)c1",
                        "Clc1ccc(C=C2SC(=S)NC2=O)cc1",
                        "Clc1ccc(C=N)c(Cl)c1",
                        "Clc1ccc(C=N)cc1",
                        "Clc1ccc(C=NNC=O)c(Cl)c1",
                        "Clc1ccc(C=NNC=O)cc1",
                        "Clc1ccc(C=O)c(Cl)c1",
                        "Clc1ccc(C=O)cc1",
                        "Clc1ccc(C=O)cc1Cl",
                        "Clc1ccc(cc1)N2C(=O)CCC2=O",
                        "Clc1ccc(cc1)N2CCNCC2",
                        "Clc1ccc(cc1)S(=O)(=O)c2cccc(c2)S(=O)=O",
                        "Clc1ccc(cc1)S(=O)=O",
                        "Clc1ccc(cc1Cl)S(=O)(=O)c2cccc(c2)S(=O)=O",
                        "Clc1ccc(cc1Cl)S(=O)=O",
                        "Clc1ccc(Cl)c(Cl)c1",
                        "Clc1ccc(Cl)c(NC(=S)NCC(Cl)(Cl)Cl)c1",
                        "Clc1ccc(Cl)c(NC=O)c1",
                        "Clc1ccc(Cl)cc1",
                        "Clc1ccc(NC=O)c(Cl)c1",
                        "Clc1ccc(NC=O)cc1",
                        "Clc1ccc(NC=O)cc1Cl",
                        "Clc1ccc(NS(=O)=O)cc1",
                        "Clc1ccc2[nH]c3ccc(Cl)cc3c2c1",
                        "Clc1ccc2ocnc2c1",
                        "Clc1cccc(Br)c1",
                        "Clc1cccc(C=N)c1",
                        "Clc1cccc(C=O)c1",
                        "Clc1cccc(c1)N2C(=O)CCC2=O",
                        "Clc1cccc(Cl)c1",
                        "Clc1cccc(NC=O)c1",
                        "Clc1cccc2ccccc12",
                        "Clc1ccccc1",
                        "Clc1ccccc1Br",
                        "Clc1ccccc1C=NNC=O",
                        "Clc1ccccc1C=O",
                        "Clc1ccccc1Cl",
                        "Clc1ccccc1NC=O",
                        "Clc1ccccc1S(=O)=O",
                        "Clc1cccnc1",
                        "Clc1csc2ccccc12",
                        "Clc1ncnc(Cl)n1",
                        "Clc1ncncn1",
                        "ClCC=O",
                        "ClCCl",
                        "CN",
                        "CN(C(=O)CCC(=O)O)C(C)(C)C",
                        "CN(C)C",
                        "CN(C)C(=N)C",
                        "CN(C)C(=N)NC(=N)N",
                        "CN(C)C(=O)N",
                        "CN(C)C=N",
                        "CN(C)C=O",
                        "CN(C)c1ccc(C=NNC=O)cc1",
                        "CN(C)c1ccc2ccccc2n1",
                        "CN(C)c1ccccc1",
                        "CN(C)CC(=O)N",
                        "CN(C)CC=O",
                        "CN(C)CCC=O",
                        "CN(C)CCCNC(=O)C(=C)NC=O",
                        "CN(C)CCCNC=O",
                        "CN(C)CCCOC=O",
                        "CN(C)CCOC=O",
                        "CN(C)N1C(=O)CCC1=O",
                        "CN(C)S(=O)=O",
                        "CN(C=O)C(C)(C)C",
                        "CN(C=O)c1ccc(I)cc1",
                        "CN(CC(O)CO)S(=O)(=O)O",
                        "CN(CCO)CCO",
                        "CN(S(=O)=O)C(C)(C)C",
                        "CN=C",
                        "CN=c1cc[nH]cc1",
                        "CN1C(=O)C(=NNC(=O)CO)c2cc(Br)ccc12",
                        "CN1C(=O)c2ccccc2C1=O",
                        "CN1C2CCC1CCC2",
                        "Cn1cc(Br)c(n1)C(=O)N",
                        "CN1CCc2cc3ccccc3nc12",
                        "CN1CCCC1",
                        "CN1CCCCC1",
                        "Cn1cccn1",
                        "CN1CCN(CC1)c2ccc(Cl)cc2",
                        "CN1CCN(CC1)c2ccc(F)cc2",
                        "CN1CCN(CC1)c2ccccc2",
                        "CN1CCN(CC1)c2ccccn2",
                        "CN1CCNCC1",
                        "CN1CCOCC1",
                        "Cn1cnc(c1)[N+](=O)[O-]",
                        "Cn1ncc([N+](=O)[O-])c1C(=O)N",
                        "Cn1nnc2ccccc12",
                        "CNC",
                        "CNC(=N)NC(=N)N",
                        "CNC(=O)C",
                        "CNC(=O)C(=C)NC=O",
                        "CNC(=O)CCC(=O)O",
                        "CNC(=O)CCl",
                        "CNC(=O)CO",
                        "CNC(=O)N",
                        "CNC(=O)O",
                        "CNC(=S)NC",
                        "CNC(C)(C)C",
                        "CNC(C)C",
                        "CNC(C)C(=O)O",
                        "CNC(NC=O)C(Cl)(Cl)Cl",
                        "CNC=C",
                        "CNC=C1C(=O)NC(=O)NC1=O",
                        "CNC=O",
                        "CNc1ccccc1",
                        "CNc1ncncn1",
                        "CNCC(=O)N",
                        "CNCC(C)O",
                        "CNCC(O)CO",
                        "CNCCO",
                        "CNN",
                        "CNN=C",
                        "CNN=C1c2n[nH]nc2C(=NNC)c3n[nH]nc13",
                        "CNn1cnnc1",
                        "CNNC(=O)C",
                        "CNS(=O)(=O)NC(=O)N",
                        "CNS(=O)=O",
                        "CO",
                        "COC",
                        "COC(=N)c1ccc(C)cc1",
                        "COC(=O)C",
                        "COC(=O)C(C)NC(=O)CO",
                        "COC(=O)C(C)NC=O",
                        "COC(=O)C(O)C(F)(F)F",
                        "COC(=O)CCC(=O)N",
                        "COC(=O)CCC(=O)O",
                        "COC(=O)CCS(=O)=O",
                        "COC(=O)CN",
                        "COC(=O)CO",
                        "COC(=O)N",
                        "COC(=O)O",
                        "COC=NC(NC(=S)N)C(Cl)(Cl)Cl",
                        "COC=O",
                        "COc1c(Cl)cc(Cl)cc1C=NNC=O",
                        "COc1cc(C=NNC=O)ccc1O",
                        "COc1cc(cc(OC)c1OC)C(=O)N",
                        "COc1cc(N)nc(OC)n1",
                        "COc1ccc(C(=NNC=O)C)c(OC)c1",
                        "COc1ccc(C=C2SC(=S)NC2=O)cc1",
                        "COc1ccc(C=CC(=O)NC(=S)N)cc1OC",
                        "COc1ccc(C=NNC(=O)CO)cc1[N+](=O)[O-]",
                        "COc1ccc(C=NNC=O)c(OC)c1",
                        "COc1ccc(C=NNC=O)cc1",
                        "COc1ccc(C=NNC=O)cc1OC",
                        "COc1ccc(cc1)[N+](=O)[O-]",
                        "COc1ccc(cc1)C(=NNC=O)C",
                        "COc1ccc(cc1)C(=O)N",
                        "COc1ccc(cc1)N2C(=O)CCC2=O",
                        "COc1ccc(Cl)cc1Cl",
                        "COc1ccc(N)nn1",
                        "COc1ccc(OC)cc1",
                        "COc1ccc2[nH]ccc2c1",
                        "COc1ccc2ccccc2c1",
                        "COc1ccc2ccccc2c1C=NNC(=O)CO",
                        "COc1ccc2sc(C)[nH+]c2c1",
                        "COc1cccc(Br)c1",
                        "COc1cccc(C=NNC(=O)CO)c1",
                        "COc1cccc(c1)[N+](=O)[O-]",
                        "COc1cccc(c1)C(=O)O",
                        "COc1cccc(OC)c1",
                        "COc1cccc(OC)c1OC",
                        "COc1ccccc1",
                        "COc1ccccc1C=NNC(=O)CO",
                        "COc1ccccc1C=NNC=O",
                        "COc1ccccc1Cl",
                        "COc1ccccc1N2CCNCC2",
                        "COc1ccccc1O",
                        "COc1ccccc1OC",
                        "COc1cccnn1",
                        "COc1ccnc(OC)n1",
                        "COc1cnccn1",
                        "COc1nc(C)nc(NC=O)n1",
                        "COc1nccnc1N",
                        "COc1ncnc(C)n1",
                        "COc1ncnc(OC)n1",
                        "COc1ncncn1",
                        "COCC(C)O",
                        "COCC(O)CNC(C)C",
                        "COP(=O)(CN)OC",
                        "COS(=O)=O",
                        "CS",
                        "CS(=O)(=O)c1ccccc1",
                        "CS(=O)(=O)N",
                        "CS(=O)(=O)O",
                        "CS(=O)=O",
                        "CSC(=N)N",
                        "CSC(=S)NN=C",
                        "CS(c1ccc(C)cc1)", // CSc1ccc(C)cc1
                        "CS(c1ccc(O)cc1)", // CSc1ccc(O)cc1
                        "CS(c1ccccc1)", // CSc1ccccc1
                        "CS(c1nc2ccccc2[nH]1)", // CSc1nc2ccccc2[nH]1
                        "CSCC(=O)NN=C",
                        "CSCCCC(=O)O",
                        "F",
                        "FC(F)(C=O)C1(F)OC(F)(F)C(F)(F)C1(F)F",
                        "FC(F)(F)C(F)(F)C(F)(F)OC(F)(C=O)C(F)(F)F",
                        "FC(F)(F)C(F)(F)C(F)(F)S",
                        "FC(F)(F)C(F)(F)C=O",
                        "FC(F)(F)C(Oc1ncnc(OC(C(F)(F)F)C(F)(F)F)n1)C(F)(F)F",
                        "FC(F)(F)C(Oc1ncncn1)C(F)(F)F",
                        "FC(F)(F)C=O",
                        "FC(F)(F)c1ccc(Cl)c(NC(=S)NCC(Cl)(Cl)Cl)c1",
                        "FC(F)(F)c1ccc(Cl)cc1",
                        "FC(F)(F)c1ccc(S(c2ccccc2))cc1", // FC(F)(F)c1ccc(Sc2ccccc2)cc1
                        "FC(F)(F)c1ccc2S(c3ccccc3Nc2c1)", // FC(F)(F)c1ccc2Sc3ccccc3Nc2c1
                        "FC(F)(F)c1cccc(c1)S(=O)=O",
                        "FC(F)(F)c1cccc(NC=O)c1",
                        "FC(F)(F)c1ccccc1",
                        "FC(F)(F)CCS",
                        "FC(F)(F)COc1ncncn1",
                        "FC(F)(F)OC(F)(F)C(F)(F)OC(F)(F)C=O",
                        "FC(F)(F)S",
                        "FC(F)(F)S(=O)=O",
                        "FC(F)C(F)F",
                        "FC(F)F",
                        "Fc1cc(F)c(F)c(F)c1F",
                        "Fc1cc(F)c(F)cc1F",
                        "Fc1ccc(C=C2SC(=S)NC2=O)cc1",
                        "Fc1ccc(C=NNC=O)cc1",
                        "Fc1ccc(C=O)c(C=O)c1",
                        "Fc1ccc(C=O)cc1",
                        "Fc1ccc(C=O)cc1F",
                        "Fc1ccc(cc1)N2CCNCC2",
                        "Fc1ccc(NC=O)cc1",
                        "Fc1ccc2c(Cl)csc2c1",
                        "Fc1cccc(C=O)c1",
                        "Fc1cccc(F)c1",
                        "Fc1cccc(F)c1C=O",
                        "Fc1ccccc1",
                        "Fc1ccccc1C=N",
                        "Fc1ccccc1C=NNC=O",
                        "Fc1ccccc1C=O",
                        "Fc1ccccc1Cl",
                        "FC1OC(F)(F)C(F)(F)C1(F)F",
                        "FCC=O",
                        "I",
                        "Ic1ccc(NC=O)cc1",
                        "Ic1cccc(C=O)c1",
                        "Ic1ccccc1",
                        "Ic1ccccc1C=O",
                        "Ic1cn[nH]c1",
                        "N",
                        "N#Cc1ccccc1",
                        "N#CCC#N",
                        "N(=Nc1ccccc1)c2ccccc2",
                        "N(=Nc1ccccc1)c2nc3ccccc3s2",
                        "N(N=Cc1ccco1)c2ncncn2",
                        "N=[N+]=[N-]",
                        "N=C(C=O)c1ccccc1",
                        "N=C(c1ccccc1)c2ccccc2",
                        "N=C(Nc1ccccc1)SCC=O",
                        "N=c1[nH]c(cs1)c2ccccc2",
                        "N=c1[nH]c2ccccc2[nH]1",
                        "N=c1[nH]c2CCCCc2s1",
                        "N=c1[nH]ccs1",
                        "N=C1C(=O)Nc2ccccc12",
                        "N=c1c2CCCc2[nH]c3ccccc13",
                        "N=C1CC(=O)c2ccccc12",
                        "N=C1CC(=O)NC(=O)N1",
                        "N=c1cc[nH]c2ccccc12",
                        "N=c1cc[nH]cc1",
                        "N=c1cccc[nH]1",
                        "N=C1CCCc2ccccc2N1",
                        "N=C1NC(=O)CS1",
                        "N=c1nccc[nH]1",
                        "N=c1ncccn1CC=O",
                        "N=Cc1c[nH]c2ccccc12",
                        "N=Cc1c2ccccc2cc3ccccc13",
                        "N=Cc1ccc(C#Cc2ccccc2)cc1",
                        "N=Cc1ccc(C=N)cc1",
                        "N=Cc1ccc[nH]1",
                        "N=Cc1ccc2[nH]c3ccccc3c2c1",
                        "N=Cc1ccc2OCOc2c1",
                        "N=Cc1cccc2ccccc12",
                        "N=Cc1ccccc1",
                        "N=Cc1cccnc1",
                        "N=Cc1ccco1",
                        "N=N",
                        "N=O",
                        "N1C(Nc2ccccc12)c3ccccc3",
                        "N1C=CC2C=CC=CC12",
                        "N1c2ccccc2C=Cc3ccccc13",
                        "N1c2ccccc2S(c3ccccc13)", // N1c2ccccc2Sc3ccccc13
                        "NC(=N)N",
                        "NC(=N)NC(=N)N",
                        "NC(=N)NC(=O)N",
                        "NC(=N)NCCCC(NC=O)C(=O)N",
                        "NC(=N)NN=C",
                        "NC(=N)S",
                        "NC(=N)SCC=O",
                        "NC(=Nc1ccccc1)S",
                        "NC(=O)C(=C)C#N",
                        "NC(=O)C(=O)NN=C1C(=O)Nc2ccccc12",
                        "NC(=O)C(C(C(=O)O)C(=O)O)C(=O)O",
                        "NC(=O)C(C=O)S(=O)=O",
                        "NC(=O)C(Cl)(Cl)Cl",
                        "NC(=O)C(F)(F)C(F)(F)F",
                        "NC(=O)C(F)(F)F",
                        "NC(=O)C(F)(F)OC(F)(F)C(F)(F)OC(F)(F)F",
                        "NC(=O)C(F)(OC(F)(F)C(F)(F)C(F)(F)F)C(F)(F)F",
                        "NC(=O)C=C",
                        "NC(=O)C=CC(=O)O",
                        "NC(=O)C=Cc1cccc(c1)[N+](=O)[O-]",
                        "NC(=O)C=Cc1ccccc1",
                        "NC(=O)C1(CC2CC3CC(C2)C1)C3",
                        "NC(=O)C1C(C2CC1C=C2)C(=O)O",
                        "NC(=O)c1c(cccc1[N+](=O)[O-])C(=O)O",
                        "NC(=O)C1C2CCCCC12",
                        "NC(=O)c1cc(cc(c1)[N+](=O)[O-])[N+](=O)[O-]",
                        "NC(=O)c1cc(ccc1Cl)[N+](=O)[O-]",
                        "NC(=O)C1CC1(c2ccccc2)c3ccccc3",
                        "NC(=O)C1CC1c2ccccc2",
                        "NC(=O)C1CC21CCC2",
                        "NC(=O)c1cc2ccccc2oc1=O",
                        "NC(=O)c1ccc(Br)cc1",
                        "NC(=O)c1ccc(Br)o1",
                        "NC(=O)c1ccc(cc1)[N+](=O)[O-]",
                        "NC(=O)c1ccc(cc1)c2ccccc2",
                        "NC(=O)c1ccc(cc1)N2C(=O)c3ccccc3C2=O",
                        "NC(=O)c1ccc(cc1C(=O)O)[N+](=O)[O-]",
                        "NC(=O)c1ccc(Cl)cc1",
                        "NC(=O)c1ccc(Cl)cc1Cl",
                        "NC(=O)c1ccc(F)c(F)c1",
                        "NC(=O)c1ccc(F)cc1",
                        "NC(=O)c1ccc(N)cc1",
                        "NC(=O)C1CCC=CC1",
                        "NC(=O)c1ccc2C(=O)N(C(=O)c2c1)c3ccccc3",
                        "NC(=O)c1cccc(Br)c1",
                        "NC(=O)c1cccc(c1)[N+](=O)[O-]",
                        "NC(=O)c1cccc2ccccc12",
                        "NC(=O)C1CCCCC1",
                        "NC(=O)c1ccccc1[N+](=O)[O-]",
                        "NC(=O)c1ccccc1Br",
                        "NC(=O)c1ccccc1C(=O)O",
                        "NC(=O)c1ccccc1Cl",
                        "NC(=O)c1ccccc1F",
                        "NC(=O)c1cccnc1",
                        "NC(=O)c1ccco1",
                        "NC(=O)c1cccs1",
                        "NC(=O)c1ccncc1",
                        "NC(=O)c1csc2CCCCc12",
                        "NC(=O)c1nccnc1C(=O)O",
                        "NC(=O)CC(=O)N",
                        "NC(=O)CC=O",
                        "NC(=O)CCC(=O)O",
                        "NC(=O)CCC(=O)OCC(=C(Cl)Cl)Cl",
                        "NC(=O)CCCC(=O)O",
                        "NC(=O)CCCC(=O)OCC#C",
                        "NC(=O)CCCCCCC(=O)N",
                        "NC(=O)CCCO",
                        "NC(=O)CCl",
                        "NC(=O)CCNC(=O)C(F)(F)F",
                        "NC(=O)CO",
                        "NC(=O)CS",
                        "NC(=O)N",
                        "NC(=O)NC(=O)C(Cl)(Cl)Cl",
                        "NC(=O)NC(=O)N",
                        "NC(=O)NC(CC=O)C(Cl)(Cl)Cl",
                        "NC(=O)NC=O",
                        "NC(=O)NN=C",
                        "NC(=O)NN=C1C(=O)Nc2ccccc12",
                        "NC(=O)NN=Cc1ccccc1",
                        "NC(=O)NNC=O",
                        "NC(=O)NO",
                        "NC(=O)NS(=O)(=O)N",
                        "NC(=O)NS(=O)=O",
                        "NC(=O)O",
                        "NC(=O)OCCNS(=O)=O",
                        "NC(=O)ON=C",
                        "NC(=O)SCC=O",
                        "NC(=S)N",
                        "NC(=S)NC(=O)C=C",
                        "NC(=S)NC(=O)C=Cc1ccc(F)cc1",
                        "NC(=S)NC(=O)C=Cc1ccccc1",
                        "NC(=S)NC(=O)C=Cc1ccco1",
                        "NC(=S)NC(NC(=O)C=C)C(Cl)(Cl)Cl",
                        "NC(=S)NC(NC(=O)C=Cc1ccccc1)C(Cl)(Cl)Cl",
                        "NC(=S)NC(NC(=O)CF)C(Cl)(Cl)Cl",
                        "NC(=S)NC(NC=O)C(Cl)(Cl)Cl",
                        "NC(=S)NC=O",
                        "NC(=S)Nc1ccc(cc1)S(=O)=O",
                        "NC(=S)NCC=O",
                        "NC(=S)NN=C",
                        "NC(=S)NN=C1C(=O)Nc2ccccc12",
                        "NC(=S)NNC=O",
                        "NC(=S)SCC=O",
                        "NC(CO)CO",
                        "NC(NC(=O)CF)C(Cl)(Cl)Cl",
                        "NC(NC(=O)N)C(Cl)(Cl)Cl",
                        "NC(NC=O)C(Br)(Br)Br",
                        "NC(NC=O)C(Cl)(Cl)Cl",
                        "NC(NC=O)C=O",
                        "NC=C",
                        "NC=C1C(=O)CCCC1=O",
                        "NC=C1C(=O)CNC1=O",
                        "NC=C1C(=O)N(C(=O)c2ccccc12)c3ccccc3",
                        "NC=C1C(=O)NC(=O)NC1=O",
                        "NC=C1SC(=S)NC1=O",
                        "NC=O",
                        "NC=S",
                        "NC1=CC(=O)c2ccccc2C1=O",
                        "Nc1ccc([N+](=O)[O-])c2nonc12",
                        "Nc1ccc(Br)cc1",
                        "Nc1ccc(Br)cc1C=O",
                        "Nc1ccc(C=O)cc1",
                        "Nc1ccc(cc1)[N+](=O)[O-]",
                        "Nc1ccc(cc1)C(=O)O",
                        "Nc1ccc(cc1)S(=O)(=O)N",
                        "Nc1ccc(cc1)S(=O)=O",
                        "Nc1ccc(cc1[N+](=O)[O-])[N+](=O)[O-]",
                        "Nc1ccc(Cl)c(Cl)c1",
                        "Nc1ccc(Cl)cc1",
                        "Nc1ccc(Cl)cc1C=O",
                        "Nc1ccc(F)cc1",
                        "Nc1ccc(I)cc1",
                        "Nc1ccc(O)cc1",
                        "Nc1ccc2ccccc2c1",
                        "Nc1cccc(c1)[N+](=O)[O-]",
                        "Nc1cccc(c1)C(=O)O",
                        "Nc1cccc(c1)C(F)(F)F",
                        "Nc1cccc(Cl)c1",
                        "Nc1cccc(O)c1",
                        "NC1CCCC1",
                        "Nc1cccc2ccccc12",
                        "Nc1cccc2cccnc12",
                        "NC1CCCCC1",
                        "Nc1ccccc1[N+](=O)[O-]",
                        "Nc1ccccc1C(=O)O",
                        "Nc1ccccc1Cl",
                        "Nc1ccccc1O",
                        "Nc1ccccn1",
                        "Nc1cnc2ccccc2n1",
                        "Nc1cnon1",
                        "Nc1nc(Cl)nc(Cl)n1",
                        "Nc1nc(cs1)c2ccccc2",
                        "Nc1ncccn1",
                        "Nc1nccs1",
                        "Nc1ncn[nH]1",
                        "Nc1ncnc(Cl)n1",
                        "Nc1ncnc(n1)N2CCOCC2",
                        "Nc1ncncn1",
                        "Nc1nncs1",
                        "NCC(=O)N",
                        "NCC(=O)NN=C",
                        "NCC(=O)O",
                        "NCC(O)CO",
                        "NCC=C",
                        "NCC=O",
                        "NCc1ccccc1",
                        "NCc1ccco1",
                        "NCc1ccncc1",
                        "NCCC(=O)O",
                        "NCCC=O",
                        "NCCCC(=O)O",
                        "NCCCO",
                        "NCCN",
                        "NCCO",
                        "NCCS",
                        "NCN1C(=O)c2ccccc2C1=O",
                        "NCN1C(=O)CCC1=O",
                        "NCn1cnc2ccccc12",
                        "NCn1nnc2ccccc12",
                        "NN",
                        "NN=C",
                        "NN=C1C(=O)NC(=O)NC1=O",
                        "NN=C1C(=O)NC(=S)NC1=O",
                        "NN=C1C(=O)Nc2ccccc12",
                        "NN=C1C(C(=NN)c2ccccc12)c3ccccc3",
                        "NN=C1C=NN(C1=O)c2ccccc2",
                        "NN=C1C=NN(C1=O)c2nc(cs2)c3ccccc3",
                        "NN=C1C=NNC1=O",
                        "NN=CN=N",
                        "NN=N",
                        "Nn1cnnc1",
                        "NNC(=O)c1ccccc1",
                        "NNC(=O)CO",
                        "NNC(=O)N",
                        "NNC(=S)N",
                        "NNC=O",
                        "NNc1ccccc1",
                        "NNS(=O)=O",
                        "NS",
                        "NS(=O)(=O)c1ccc(Br)cc1",
                        "NS(=O)(=O)c1ccc(cc1)[N+](=O)[O-]",
                        "NS(=O)(=O)c1ccc(cc1)c2ccccc2",
                        "NS(=O)(=O)c1ccc(Cl)cc1",
                        "NS(=O)(=O)c1cccc2nsnc12",
                        "NS(=O)(=O)c1ccccc1",
                        "NS(=O)(=O)c1ccccc1[N+](=O)[O-]",
                        "NS(=O)=O",
                        "NS=O",
                        "NS(c1ccccc1[N+](=O)[O-])", // NSc1ccccc1[N+](=O)[O-]
                        "O",
                        "O[NH2]=O",
                        "O=[SH2]=O",
                        "O=C(C(=O)c1ccccc1)c2ccccc2",
                        "O=C(C=Cc1ccccc1)c2ccccc2",
                        "O=C(c1ccccc1)c2ccccc2",
                        "O=C(c1ccccc1)c2cnncc2",
                        "O=C(NN=Cc1ccccc1)c2ccccc2",
                        "O=C(NNC(=O)c1ccccc1)c2ccccc2",
                        "O=c1[nH][nH]c(=O)c2ccccc12",
                        "O=c1[nH]c(=O)[nH]c(=O)[nH]1",
                        "O=c1[nH]c(=O)c2[nH]cnc2[nH]1",
                        "O=c1[nH]c(=O)c2cc3c(=O)[nH]c(=O)c3cc12",
                        "O=c1[nH]c(=O)c2nc3ccccc3nc2[nH]1",
                        "O=c1[nH]c(nc2ccccc12)c3ccccc3",
                        "O=c1[nH]c2ccccc2[nH]1",
                        "O=c1[nH]c2ccccc2o1",
                        "O=c1[nH]cnc2ccccc12",
                        "O=c1[nH]cnc2n(cnc12)C3CCCO3",
                        "O=c1[nH]cnc2sc3CCCCc3c12",
                        "O=c1[nH]ncc2ccccc12",
                        "O=C1C(=Cc2ccccc12)c3ccccc3",
                        "O=C1C(C(=O)c2ccccc12)C3=CC(C(N=N3)c4ccccc4)c5ccccc5",
                        "O=C1C(C(=O)c2ccccc12)c3ccccc3",
                        "O=c1c(coc2ccccc12)c3ccc4OCCOc4c3",
                        "O=c1c(coc2ccccc12)c3ccccc3",
                        "O=c1c(coc2ccccc12)c3nc4ccccc4[nH]3",
                        "O=C1C=C(C(=O)c2ccccc12)c3ccccc3",
                        "O=C1C=CC(=O)C=C1",
                        "O=C1C=CC(=O)c2ccccc12",
                        "O=C1C=CC(=O)N1c2ccccc2",
                        "O=C1C2C(C(C=CC2c3ccccc3)c4ccccc4)C(=O)N1c5ccccc5",
                        "O=C1C2C(C3C=CC2C4C3C(=O)N(C4=O)c5ccccc5)C(=O)N1c6ccccc6",
                        "O=C1C2C(C3c4ccccc4C2c5ccccc35)C(=O)N1c6ccccc6",
                        "O=C1C2C3CC(C=C3)C2C(=O)N1c4ccccc4",
                        "O=C1C2C3OC(C=C3)C2C(=O)N1c4ccccc4",
                        "O=c1c2cccc3cccc(c4nc5ccccc5n14)c32",
                        "O=C1c2ccccc2C(=O)c3ccccc13",
                        "O=C1c2ccccc2C(c3ccccc3)(c4ccccc4)c5ccccc15",
                        "O=C1c2ccccc2-c3ccccc13",
                        "O=C1c2ccccc2-c3ncnc4cccc1c34",
                        "O=C1C2CN3CC1CN(C2)C3",
                        "O=C1CC(=O)c2ccccc12",
                        "O=C1CC(=O)NC(=O)N1",
                        "O=C1CC(CN1)c2ccccc2",
                        "O=C1CC(N2CCCC2)C(=O)N1c3ccccc3",
                        "O=C1CC(N2CCCCC2)C(=O)N1c3ccccc3",
                        "O=C1CC(N2CCN(CC2)C3CC(=O)N(C3=O)c4ccccc4)C(=O)N1c5ccccc5",
                        "O=C1CC(N2CCN(CC2)c3ccccc3)C(=O)N1c4ccccc4",
                        "O=C1CC(N2CCN(CC2)c3ncccn3)C(=O)N1c4ccccc4",
                        "O=C1CC(N2CCNCC2)C(=O)N1c3ccccc3",
                        "O=C1CC(N2CCOCC2)C(=O)N1c3ccccc3",
                        "O=c1cc[nH]c(=O)[nH]1",
                        "O=c1cc[nH]cn1",
                        "O=c1cc[nH]n1c2ccccc2",
                        "O=C1CC=NN1c2ccccc2",
                        "O=C1Cc2ccccc2N1",
                        "O=C1CCC(=O)N1",
                        "O=C1CCC(=O)N1c2cccc3ccccc23",
                        "O=C1CCC(=O)N1c2ccccc2",
                        "O=C1CCC(O1)c2ccccc2",
                        "O=c1ccc2c(c3ccccc3)c4ccccc4oc2c1",
                        "O=c1ccc2ccccc2[nH]1",
                        "O=c1ccc2ccccc2o1",
                        "O=c1ccc2ccccc2s1",
                        "O=C1CCCC(=O)C1",
                        "O=c1cccc[nH]1",
                        "O=C1CCCC=C1",
                        "O=C1CCCC1",
                        "O=C1CCCc2[nH]ncc12",
                        "O=C1CCCC2=C1C(C=CN2)c3ccccc3",
                        "O=C1CCCC2=C1C(C=CO2)c3ccccc3",
                        "O=C1CCCC2=C1C(Nc3ccc4ccccc4c23)c5ccccc5",
                        "O=C1CCCC2=C1C(Nc3ccc4ncccc4c23)c5ccccc5",
                        "O=C1CCCc2c1[nH]c3ccccc23",
                        "O=C1CCCc2ccsc12",
                        "O=C1CCCc2nc3ccccc3cc12",
                        "O=C1CCCCC1",
                        "O=C1CCCCCN1",
                        "O=c1cccco1",
                        "O=C1CCCN1",
                        "O=C1CCCN1c2ccccc2",
                        "O=C1CCCO1",
                        "O=c1ccn(C2CCCO2)c(=O)[nH]1",
                        "O=C1CCN2C(=C1)Nc3ccccc23",
                        "O=c1ccnc[nH]1",
                        "O=c1ccnc2ccccn12",
                        "O=c1ccoc2ccccc12",
                        "O=c1cn[nH]c(=O)[nH]1",
                        "O=c1cn[nH]c(=S)[nH]1",
                        "O=c1cnc2ccccc2[nH]1",
                        "O=C1CNc2ccccc2N1",
                        "O=C1CNCC(=O)N1",
                        "O=C1CSC(=S)N1",
                        "O=C1CSC(N1)c2ccccc2",
                        "O=C1CS(c2ccccc12)", // O=C1CSc2ccccc12
                        "O=C1CS(c2ccccc2N1)", // O=C1CSc2ccccc2N1
                        "O=C1N(C(=O)c2cccc3cccc1c23)c4ccccc4",
                        "O=C1N(C(=O)c2ccccc12)c3ccccc3",
                        "O=c1n(c2ccccc2)c(=O)c3cc4c(=O)n(c5ccccc5)c(=O)c4cc13",
                        "O=c1n(cnc2ccccc12)c3ccccc3",
                        "O=C1NC(=O)C=C1",
                        "O=C1NC(=O)C2(CCCCC2)N1",
                        "O=C1NC(=O)C2C1C3C=CC2C4C3C(=O)NC4=O",
                        "O=C1NC(=O)C2C1C3c4ccccc4C2c5ccccc35",
                        "O=C1NC(=O)C2C3CC(C=C3)C21",
                        "O=C1NC(=O)C2C3OC(C=C3)C21",
                        "O=C1NC(=O)c2ccc(N3CCOCC3)c4cccc1c24",
                        "O=C1NC(=O)c2cccc3cccc1c23",
                        "O=C1NC(=O)c2ccccc12",
                        "O=C1NC(=S)SC1=C2C(=O)Nc3ccccc23",
                        "O=C1NC(=S)SC1=C2Nc3ccccc3S2",
                        "O=C1NC(=S)SC1=C2SC(=S)NC2=O",
                        "O=C1NC(=S)SC1=Cc2ccccc2",
                        "O=C1NC(c2ccccc12)(c3ccccc3)c4ccccc4",
                        "O=c1nc[nH]c2ccccc12",
                        "O=C1NC=CC(N1)c2ccccc2",
                        "O=C1Nc2cccc3cccc1c23",
                        "O=C1Nc2ccccc2C1=C3SC(=S)N(C3=O)c4ccccc4",
                        "O=C1Nc2ccccc2C1=O",
                        "O=C1NC2NC(=O)NC2N1",
                        "O=C1NCc2ccccc12",
                        "O=c1nccc[nH]1",
                        "O=C1NCCc2c1[nH]c3ccccc23",
                        "O=c1ncccn1c2ccccc2",
                        "O=C1NCCN1c2cccc3ccccc23",
                        "O=C1NCCN1c2ccccc2",
                        "O=C1NN=C(CC1c2c[nH]c3ccccc23)c4ccccc4",
                        "O=C1OC(=O)c2ccccc12",
                        "O=C1OC(c2ccccc12)(c3ccccc3)c4ccccc4",
                        "O=c1oc(nc2ccccc12)c3ccccc3",
                        "O=C1OC2(CCCCC2)C=C1",
                        "O=c1oc2ccccc2c3[nH]nnc13",
                        "O=C1OCc2ccccc12",
                        "O=c1occcc1C2=Nc3ccccc3SC(C2)c4ccccc4",
                        "O=c1occcc1C2=NCCSC(C2)c3ccccc3",
                        "O=c1ocnc2ccccc12",
                        "O=CC(=O)c1ccccc1",
                        "O=CC(C=O)C1CCCCC1",
                        "O=CC(c1ccccc1)c2ccccc2",
                        "O=CC(Cc1ccccc1)C=O",
                        "O=CC=O",
                        "O=CC1(CC2CC3C1)CC(C2)CC3",
                        "O=CC1(CC2CC3CC(C2)C1)C3",
                        "O=CC1C(C=O)C2c3ccccc3C1c4ccccc24",
                        "O=CC1C(C=O)N2C(C(C=O)C(C=O)N2C1c3ccccc3)c4ccccc4",
                        "O=Cc1c[nH]c2nc3ccccc3nc12",
                        "O=CC1C2CCCCC12",
                        "O=CC1CC1",
                        "O=CC1CC1(c2ccccc2)c3ccccc3",
                        "O=CC1CC1c2ccccc2",
                        "O=CC1CC21CCC2",
                        "O=Cc1cc2ccccc2oc1=O",
                        "O=Cc1ccc(C=O)c(C=O)c1",
                        "O=Cc1ccc(C=O)cc1",
                        "O=Cc1ccc(cc1)c2ccccc2",
                        "O=Cc1ccc(cc1)S(=O)=O",
                        "O=Cc1ccc(cc1C=O)C(=O)c2ccc(C=O)c(C=O)c2",
                        "O=Cc1ccc2ccccc2c1",
                        "O=Cc1cccc(C=O)c1",
                        "O=Cc1cccc(c1)S(=O)=O",
                        "O=CC1CCCC1",
                        "O=Cc1cccc2cccc(C=O)c12",
                        "O=Cc1cccc2ccccc12",
                        "O=CC1CCCCC1",
                        "O=Cc1ccccc1C=O",
                        "O=Cc1ccccc1S(=O)=O",
                        "O=Cc1ccccn1",
                        "O=Cc1cccnc1",
                        "O=Cc1ccco1",
                        "O=Cc1cccs1",
                        "O=Cc1ccn[nH]1",
                        "O=Cc1ccncc1",
                        "O=Cc1ccsc1",
                        "O=Cc1cn[nH]c1",
                        "O=Cc1cncs1",
                        "O=Cc1csc2C(=O)CCCc12",
                        "O=Cc1csc2CCCCc12",
                        "O=CCC#N",
                        "O=CCC(NC=O)c1ccccc1",
                        "O=CCC(S(c1ccccc1))C=O", // O=CCC(Sc1ccccc1)C=O
                        "O=CCC=O",
                        "O=CCC1(C(=O)c2ccccc2C1=O)c3ccccc3",
                        "O=CCC1(CC2CC3CC(C2)C1)C3",
                        "O=CCc1cccc2ccccc12",
                        "O=CCc1ccccc1",
                        "O=CCc1ccccc1C=O",
                        "O=CCCC(=O)OCC=O",
                        "O=CCCC=O",
                        "O=CCCc1c[nH]c2ccccc12",
                        "O=CCCc1ccccc1",
                        "O=CCCCC=O",
                        "O=CCCCc1ccccc1",
                        "O=CCCCCC=O",
                        "O=CCCCCCCC=O",
                        "O=CCCCNC(=S)SCC=O",
                        "O=CCCNC(=S)SCC=O",
                        "O=CCn1ccc(=NCc2ccccc2)cc1",
                        "O=CCNC(=O)SCC=O",
                        "O=CCNC(=S)SCC=O",
                        "O=CCNC=O",
                        "O=CCOC(=O)CCS(=O)=O",
                        "O=CCOC=O",
                        "O=CCSC(=S)Nc1ccccc1",
                        "O=CCSC(=S)NCc1ccccc1",
                        "O=CCSC(CC=O)C=O",
                        "O=CN1CCc2ccccc12",
                        "O=CN1CCCC1",
                        "O=CN1CCCCC1",
                        "O=CN1CCCCCC1",
                        "O=CN1CCNCC1",
                        "O=CN1CCOCC1",
                        "O=Cn1cnc2ccccc12",
                        "O=Cn1nnc2ccccc12",
                        "O=CNC=S",
                        "O=CNc1cc2CCCCc2s1",
                        "O=CNc1ccc(cc1)S(=O)=O",
                        "O=CNc1ccc(CCc2ccccc2)cc1",
                        "O=CNc1ccc(S(c2ccccc2))cc1", // O=CNc1ccc(Sc2ccccc2)cc1
                        "O=CNc1ccc2ccccc2c1",
                        "O=CNc1cccc2ccccc12",
                        "O=CNC1CCCCC1",
                        "O=CNc1ccccc1c2nc3ccccc3s2",
                        "O=CNc1nc2ccccc2s1",
                        "O=CNCCCCCCNC=O",
                        "O=CNCCCCNC=O",
                        "O=CNCCNC=O",
                        "O=CNCCOC=O",
                        "O=CNCNC=O",
                        "O=CNCOC=O",
                        "O=CNN=C1C(=O)Nc2ccccc12",
                        "O=CNN=C1CCCC1",
                        "O=CNN=C1CCCCC1",
                        "O=CNN=CC=Cc1ccccc1",
                        "O=CNN=CC=NNC=O",
                        "O=CNN=Cc1c[nH]c2ccccc12",
                        "O=CNN=Cc1ccc(cc1)c2ccccc2",
                        "O=CNN=Cc1ccc[nH]1",
                        "O=CNN=Cc1ccc2OCOc2c1",
                        "O=CNN=Cc1cccc2ccccc12",
                        "O=CNN=Cc1ccccc1",
                        "O=CNN=Cc1cccnc1",
                        "O=CNN=Cc1ccco1",
                        "O=CNN=Cc1cccs1",
                        "O=CNN=Cc1ccncc1",
                        "O=CNN=Cc1nc2ccccc2[nH]1",
                        "O=CNn1cnnc1",
                        "O=CNNC(=S)NC=O",
                        "O=CNNC=O",
                        "O=CNNS(=O)=O",
                        "O=CNS(=O)=O",
                        "O=COc1ccc2ccccc2c1",
                        "O=COc1ccccc1",
                        "O=COCC#C",
                        "O=P1OCCCO1",
                        "O=S(=O)(c1ccccc1)c2ccccc2",
                        "O=S(=O)c1ccc(cc1)C2CCCCC2",
                        "O=S(=O)c1ccc(S(c2ccc(cc2)S(=O)=O))cc1", // O=S(=O)c1ccc(Sc2ccc(cc2)S(=O)=O)cc1
                        "O=S(=O)c1ccc2ccccc2c1", "O=S(=O)c1cccc2nsnc12", "O=S(=O)c1ccccc1", "O=S(=O)C1CCS(=O)(=O)C1",
                        "O=S(=O)N1CCCCC1", "O=S(=O)N1CCNCC1", "O=S(=O)N1CCOCC1", "O=S(=O)n1cnc2ccccc12",
                        "O=S(=O)Nc1cccc2cccnc12", "O=S(=O)NC1CCCCC1", "O=S(=O)Nc1ccccn1", "O=S(=O)Nc1cnc2ccccc2n1",
                        "O=S(=O)Nc1nccs1", "O=S(=O)Oc1ccccc1", "O=S1(=O)c2ccccc2-c3ccccc31",
                        "O=S1(=O)CC(CS(=O)(=O)C1)c2ccccc2", "O=S1(=O)CCC=C1", "O=S1(=O)CCCC1",
                        "O1C=CC(c2cn[nH]c12)c3ccccc3", "OC(=O)C(F)(F)F", "OC(=O)C(F)(OC(F)(F)C(F)(F)C(F)(F)F)C(F)(F)F",
                        "OC(=O)C=C", "OC(=O)C=CC(=O)NNC=O", "OC(=O)C=Cc1ccccc1", "OC(=O)C1(CC2CC3CC(C2)C1)C3",
                        "OC(=O)C1C(C=O)C2c3ccccc3C1c4ccccc24", "OC(=O)C1C2CCCCC12",
                        "OC(=O)c1cc(cc(c1)[N+](=O)[O-])[N+](=O)[O-]", "OC(=O)c1cc(ccc1C=O)[N+](=O)[O-]",
                        "OC(=O)C1CC1c2ccccc2", "OC(=O)C1CC2c3ccccc3C1c4ccccc24", "OC(=O)C1CC2CC1C=C2",
                        "OC(=O)c1cc2ccccc2[nH]1", "OC(=O)c1ccc(C=O)c(C=O)c1", "OC(=O)c1ccc(C=O)cc1",
                        "OC(=O)c1ccc(cc1)[N+](=O)[O-]", "OC(=O)c1ccc(cc1)C(=O)O", "OC(=O)c1ccc(cc1)c2ccccc2",
                        "OC(=O)c1ccc(cc1)S(=O)=O", "OC(=O)c1ccc(Cl)cc1", "OC(=O)c1ccc(Cl)cc1Cl",
                        "OC(=O)c1ccc(NC(=S)NCC(Cl)(Cl)Cl)cc1", "OC(=O)c1ccc(NC(=S)SCC=O)cc1", "OC(=O)c1ccc(NC=O)cc1",
                        "OC(=O)c1ccc(O)cc1", "OC(=O)c1ccc(O)cc1C(=O)O", "OC(=O)C1CCC=CC1",
                        "OC(=O)c1ccc2C(=O)N(C(=O)c2c1)c3ccccc3", "OC(=O)c1cccc([N+](=O)[O-])c1C=O",
                        "OC(=O)c1cccc(Br)c1", "OC(=O)c1cccc(c1)[N+](=O)[O-]", "OC(=O)c1cccc(c1)C(=O)O",
                        "OC(=O)c1cccc(NC(=S)NCC(Cl)(Cl)Cl)c1", "OC(=O)c1cccc(NC=O)c1", "OC(=O)c1cccc(NS(=O)=O)c1",
                        "OC(=O)c1cccc2ccccc12", "OC(=O)c1ccccc1", "OC(=O)c1ccccc1C(=O)O", "OC(=O)c1ccccc1C=O",
                        "OC(=O)c1ccccc1NC(=S)NCC(Cl)(Cl)Cl", "OC(=O)c1ccccc1NC=O", "OC(=O)c1ccccc1O", "OC(=O)C1CCCN1",
                        "OC(=O)c1ccco1", "OC(=O)c1cccs1", "OC(=O)c1cnccn1", "OC(=O)c1csc2CCCCc12", "OC(=O)c1nccnc1C=O",
                        "OC(=O)CC(=O)O", "OC(=O)CC1(CC2CC3CC(C2)C1)C3", "OC(=O)Cc1ccccc1", "OC(=O)CCC(=O)NNC=O",
                        "OC(=O)CCC(=O)O", "OC(=O)CCC=NNC=O", "OC(=O)CCC=O", "OC(=O)CCc1c[nH]c2ccccc12",
                        "OC(=O)CCc1ccccc1", "OC(=O)CCCC(=O)O", "OC(=O)CCCC=O", "OC(=O)CCCCC=O", "OC(=O)CCCCCNC=O",
                        "OC(=O)CCCCCNS(=O)=O", "OC(=O)CCCNC=O", "OC(=O)CCCNS(=O)=O", "OC(=O)CCNC(=S)SCC=O",
                        "OC(=O)CCNC=O", "OC(=O)CCNS(=O)=O", "OC(=O)CCS(=O)=O", "OC(=O)CNC(=S)SCC=O", "OC(=O)CNC=O",
                        "OC(=O)CNCC(=O)O", "OC(=O)CNS(=O)=O", "OC(=O)CS", "OC(=O)CS(=O)=O", "OC(=O)CSC(CC=O)C=O",
                        "OC(=O)NC(=O)CCBr", "OC(C(F)(F)F)C(F)(F)F", "OC(C=O)(c1ccc(Br)cc1)c2ccc(Br)cc2",
                        "OC(C=O)(c1ccccc1)C(F)(F)F", "OC(C=O)(c1ccccc1)c2ccccc2", "OC(CC=C)CC=C", "OC(F)(F)C(F)Cl",
                        "OC(F)(F)C(F)F", "OC(F)F", "OC(NC=O)C(Br)(Br)Br", "OC(NC=O)C(Cl)(Cl)Cl", "OC=O",
                        "OC1(CC2CC3CC(C2)C1)C3", "OC1C(=O)Nc2ccccc12", "Oc1c(Br)cccc1Br", "Oc1c(C=O)c(=O)oc2ccccc12",
                        "Oc1c(CC=C)cccc1C=NNC=O", "Oc1c(Cl)cc(Cl)cc1C=N", "Oc1c(F)c(F)c(O)c(F)c1F",
                        "Oc1c(F)c(F)cc(F)c1F", "Oc1cc(=O)[nH]cn1", "Oc1cc(=O)oc2ccccc12", "Oc1cc(=O)sc2ccccc12",
                        "Oc1cc(cc2ccccc12)S(=O)(=O)O", "Oc1cc(O)cc(O)c1", "Oc1ccc(Br)cc1", "Oc1ccc(Br)cc1Br",
                        "Oc1ccc(Br)cc1C=N", "Oc1ccc(C=N)c(O)c1", "Oc1ccc(C=N)cc1", "Oc1ccc(C=N)cc1O",
                        "Oc1ccc(C=NNC=O)c(O)c1", "Oc1ccc(C=NNC=O)cc1", "Oc1ccc(C=O)cc1", "Oc1ccc(C=O)cc1O",
                        "Oc1ccc(cc1)[N+](=O)[O-]", "Oc1ccc(cc1)C(=O)c2ccccc2", "Oc1ccc(cc1)C(=O)NN=Cc2ccccc2",
                        "Oc1ccc(cc1)C(c2ccccc2)(c3ccccc3)c4ccc(O)cc4", "Oc1ccc(cc1)C(O)(c2ccccc2)c3ccccc3",
                        "Oc1ccc(cc1)S(=O)(=O)c2ccc(O)cc2", "Oc1ccc(cc1)S(=O)=O", "Oc1ccc(cc1C=N)[N+](=O)[O-]",
                        "Oc1ccc(cc1C=NNC=O)[N+](=O)[O-]", "Oc1ccc(CCC=O)cc1", "Oc1ccc(Cl)cc1", "Oc1ccc(Cl)cc1C=N",
                        "Oc1ccc(Cl)cc1C=NNC=O", "Oc1ccc(Cl)cc1C=O", "Oc1ccc(Cl)cc1Cl", "Oc1ccc(F)cc1",
                        "Oc1ccc(NC=O)cc1", "Oc1ccc(O)cc1", "Oc1ccc2[nH]c3CCCCc3c2c1", "Oc1ccc2c(=O)ccoc2c1",
                        "Oc1ccc2C(=O)OC(=O)c2c1", "Oc1ccc2ccccc2c1", "Oc1ccc2ccccc2c1C=N",
                        "Oc1ccc2ccccc2c1C=Nc3ccccc3", "Oc1ccc2ccccc2c1C=NNC=O", "Oc1ccc2ccccc2c1Cc3c(O)ccc4ccccc34",
                        "Oc1ccc2ccccc2c1Cc3ccccc3", "Oc1cccc(C=N)c1", "Oc1cccc(C=O)c1", "Oc1cccc(c1)[N+](=O)[O-]",
                        "Oc1cccc(CC=O)c1", "Oc1cccc(NC(=S)NCC(Cl)(Cl)Cl)c1", "Oc1cccc(NC=O)c1", "Oc1cccc(O)c1",
                        "Oc1cccc(O)c1O", "OC1CCCC1", "Oc1cccc2ccccc12", "Oc1cccc2cccnc12", "OC1CCCCC1",
                        "Oc1ccccc1[N+](=O)[O-]", "Oc1ccccc1Br", "Oc1ccccc1C=N", "Oc1ccccc1C=Nc2ccccc2",
                        "Oc1ccccc1C=NNC=O", "Oc1ccccc1C=O", "Oc1ccccc1Cc2ccccc2", "Oc1ccccc1Cl", "Oc1ccccc1F",
                        "Oc1ccccc1I", "Oc1ccccc1NC(=S)NCC(Cl)(Cl)Cl", "Oc1ccccc1NC=O", "Oc1ccccc1O",
                        "Oc1ccccc1S(=O)(=O)O", "Oc1cccnc1", "OC1CCS(=O)(=O)C1", "OCC#C", "OCC(=O)c1ccc(Br)cc1",
                        "OCC(=O)c1ccc(cc1)[N+](=O)[O-]", "OCC(=O)c1ccc(Cl)cc1", "OCC(=O)c1ccccc1", "OCC(=O)NC(=O)O",
                        "OCC(=O)NN=C", "OCC(=O)NN=C1C(=O)Nc2ccc(cc12)[N+](=O)[O-]", "OCC(=O)NN=C1C(=O)Nc2ccccc12",
                        "OCC(=O)NN=CC=C", "OCC(=O)NN=CC=Cc1cccc(c1)[N+](=O)[O-]", "OCC(=O)NN=Cc1c(Cl)cccc1Cl",
                        "OCC(=O)NN=Cc1c(O)ccc2ccccc12", "OCC(=O)NN=Cc1cc(ccc1O)[N+](=O)[O-]",
                        "OCC(=O)NN=Cc1cc(I)ccc1O", "OCC(=O)NN=Cc1cc(N=Nc2ccccc2)ccc1O", "OCC(=O)NN=Cc1cc2ccccc2nc1Cl",
                        "OCC(=O)NN=Cc1cc2OCOc2cc1[N+](=O)[O-]", "OCC(=O)NN=Cc1ccc(O)c(c1)[N+](=O)[O-]",
                        "OCC(=O)NN=Cc1ccc(O)cc1", "OCC(=O)NN=Cc1ccc(s1)[N+](=O)[O-]",
                        "OCC(=O)NN=Cc1cccc(c1)[N+](=O)[O-]", "OCC(=O)NN=Cc1cccc(O)c1", "OCC(=O)NN=Cc1cccc2ccccc12",
                        "OCC(=O)NN=Cc1ccccc1", "OCC(=O)NN=Cc1ccccc1[N+](=O)[O-]", "OCC(=O)NN=Cc1ccccc1Cl",
                        "OCC(=O)NN=Cc1ccccc1O", "OCC(=O)NNC=O", "OCC(=O)O", "OCC(=O)OCC=O", "OCC(c1ccccc1)c2ccccc2",
                        "OCC(Cl)(Cl)Cl", "OCC(CO)(CO)NC=O", "OCC(F)(F)F", "OCC(O)CNS(=O)(=O)O", "OCC=C", "OCC=O",
                        "OCc1cccc(Br)c1", "OCc1ccccc1", "OCc1ccccc1C(=O)Cc2ccccc2", "OCc1ccccc1C=O",
                        "OCc1nc2ccccc2[nH]1", "OCC1OCC(O)C(O)C1O", "OCC1OCC(O)C1O", "OCCC(O)c1ccc(cc1)[N+](=O)[O-]",
                        "OCCc1ccccc1", "OCCCC=O", "OCCCl", "OCCCNC=O", "OCCF", "OCCN(CCO)S(=O)=O", "OCCNC=O",
                        "OCCNCCO", "OCCNS(=O)=O", "OCCO", "OCCOC=O", "OCCS", "OCCS(=O)=O", "ON(=O)c1ccccc1", "ON=C",
                        "ONC=O", "OP(=O)(O)O", "OS(=O)(=O)c1ccc(NN=C(C=O)C=O)cc1", "OS(=O)(=O)c1ccc(NN=Cc2ccccc2)cc1",
                        "OS(=O)(=O)c1ccccc1", "OS(=O)(=O)CCCS", "OS(=O)(=O)CCS", "OS(=O)=O", "S",
                        "S=C(Nc1ccccc1)Nc2ccccc2", "S=c1[nH]c2ccccc2[nH]1", "S=c1[nH]c2ccccc2o1", "S=c1[nH]c2ccccc2s1",
                        "S=C1NC=CC(N1)c2ccccc2", "SC(=N)NN=C", "SC(=O)c1ccccc1", "SC(NC=O)C(Cl)(Cl)Cl", "SC=O",
                        "S(c1ccccc1)", // Sc1ccccc1
                        "S(c1nc2ccccc2s1)", // Sc1nc2ccccc2s1
                        "SCC(=O)NN=C", "SCC=O", "SCc1ccccc1", "SCCC=O", "SCCS", "SCCS(=O)=O"});
    }

}
