# search, a bzr plugin for searching within bzr branches/repositories.
# Copyright (C) 2008 Robert Collins
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
# 

"""Tests for error formatting."""

from bzrlib.plugins.search import errors
from bzrlib.tests import TestCaseWithTransport


class TestErrors(TestCaseWithTransport):

    def test_cannot_index(self):
        error = errors.CannotIndex('a branch')
        self.assertEqualDiff(
            "Cannot index 'a branch', it is not a known control dir type.",
            str(error))
    
    def test_no_index_error(self):
        error = errors.NoSearchIndex('a url')
        self.assertEqualDiff(
            "No search index present for 'a url'. Please see 'bzr help index'.",
            str(error))

    def test_no_match(self):
        error = errors.NoMatch(['a', 'search', 'here'])
        self.assertEqualDiff(
            "No matches were found for the search ['a', 'search', 'here'].",
            str(error))
