//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_8.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root8(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[8] = {1.638181097086517e+00,5.487420203051165e-01,3.315036043679075e+00,5.640313098679648e+00,8.715661629230398e+00,
    1.271773901227562e+01,1.799242472404181e+01,2.543190237470182e+01};
  constexpr double aw[8] = {2.802190264084516e-01,9.502528014008031e-02,2.180034910767602e-01,6.372428458829667e-02,7.384734624342899e-03,
    3.097897070242660e-04,3.582194458958683e-06,5.350153581677309e-09};
  constexpr double x[3072] = {  1.102271273123242e-01, -2.749069960333320e-03,  4.841546244464399e-05, -6.910866941131087e-07,  7.920427451020146e-09,
 -6.212316167716514e-11, -2.057159952330138e-14,  1.267271620916242e-14, -3.005475583837377e-16,  4.613010127875826e-18, -4.744380023372131e-20,  1.364196080293415e-22,
  3.150331026324857e-01, -7.042724106217383e-03,  9.638205114153620e-05, -7.382465664909713e-07, -2.808894254150959e-09,  1.889632489341102e-10, -2.866799576350930e-12,
  1.087197853738361e-14,  4.803715405377412e-16, -1.207876269268649e-17,  1.130069498517191e-19,  9.861531949343199e-22,  5.960706075260608e-01, -1.118508212004153e-02,
  9.179555452622905e-05,  4.375067421864664e-07, -2.029346847029135e-08,  1.287487107957086e-10,  3.267958045203323e-12, -7.001396340152578e-14, -4.995797654254940e-17,
  2.019544397415487e-17, -2.328300406652561e-19, -3.129799268596494e-21,  9.238885756519245e-01, -1.340507519831332e-02,  2.250641183362693e-05,  1.584667134693416e-06,
 -7.751784833426387e-09, -3.264548475040003e-10,  2.720412181424182e-12,  7.972645009661044e-14, -9.862671965418536e-16, -2.072944958553861e-17,  3.585880912617776e-19,
  5.488345529971987e-21,  1.262524054299651e+00, -1.266987020407752e-02, -6.623030363887620e-05,  1.166812263500743e-06,  1.912385278487053e-08, -1.319816424992224e-10,
 -5.613511377613136e-12, -3.276385627028552e-15,  1.563182613733401e-15,  1.214734971680790e-17, -3.919101122863461e-19, -6.707307208267835e-21,  1.572867585904419e+00,
 -9.220704376438118e-03, -1.079669112270580e-04, -3.275070444619374e-07,  1.406840230040159e-08,  2.761925302685632e-10,  9.072872743465616e-13, -5.601540378392208e-14,
 -1.147764756797767e-15, -2.983879377379419e-18,  2.852825027989271e-19,  5.687873834074840e-21,  1.817155603788980e+00, -4.591573301593388e-03, -7.768301760980314e-05,
 -9.674522287113306e-07, -7.337453516210333e-09,  2.686096774211396e-11,  2.126251307524927e-12,  4.170515899076708e-14,  4.449875851671580e-16, -1.006398440019099e-19,
 -1.187381648019424e-19, -2.826601117697609e-21,  1.964297973793433e+00, -9.732005389809309e-04, -1.956489785747143e-05, -3.404093420894796e-07, -5.366646717812873e-09,
 -7.743014630882264e-11, -1.015887846129698e-12, -1.173680305227611e-14, -1.089281840112881e-16, -5.076760744342432e-19,  9.185948504938057e-21,  3.591268820896712e-22,
  9.995588965448664e-02, -2.392858141320305e-03,  4.084198157877880e-05, -5.742234547598079e-07,  6.696756804034691e-09, -5.930488887693957e-11,  2.220663036115373e-13,
  5.362657438019835e-15, -1.664823396530883e-16,  2.907612904860437e-18, -3.670977326476882e-20,  2.955919896282977e-22,  2.883474825170867e-01, -6.307603991032847e-03,
  8.736639232129447e-05, -7.565631365803783e-07,  3.143869316992799e-10,  1.251808570524128e-10, -2.406024394534547e-12,  2.020623715497795e-14,  1.317953302432946e-16,
 -7.276686590727506e-18,  1.156888880560280e-19, -5.913159369245170e-22,  5.528247546089657e-01, -1.043501709394284e-02,  9.519442885836247e-05,  1.370106051935039e-07,
 -1.709130960255146e-08,  1.840768629299222e-10,  1.380545403631271e-12, -6.195868348249578e-14,  4.894984897430889e-16,  9.553057469778517e-18, -2.680653859573629e-19,
  1.125970914787344e-21,  8.707452145338717e-01, -1.315153805058404e-02,  4.057617915337385e-05,  1.412640271748167e-06, -1.346812889048588e-08, -2.385242569257816e-10,
  4.420609363931582e-12,  3.934764600765724e-14, -1.434332259300693e-15, -3.570132720000182e-18,  4.482239117307775e-19, -1.427299088743655e-21,  1.210880585837531e+00,
 -1.313875185373597e-02, -5.050331743107280e-05,  1.444431338866010e-06,  1.516003810332552e-08, -2.618712045909804e-10, -4.963708739965434e-12,  5.022499952140602e-14,
  1.660710997251743e-15, -7.860380682201826e-18, -5.591852456861795e-19, -1.749118108670167e-23,  1.534238369131534e+00, -1.009590885233805e-02, -1.103619475427068e-04,
 -5.764703815050985e-08,  1.966141394706445e-08,  2.749874632659991e-10, -1.172980515185999e-12, -9.177799896944601e-14, -9.910229898488700e-16,  1.318413851009362e-17,
  5.066756574655933e-19,  3.375726240901339e-21,  1.797470117411855e+00, -5.261410007083645e-03, -8.996897668449240e-05, -1.077355532323374e-06, -6.187185235008509e-09,
  9.347029810777210e-11,  3.484710769854838e-12,  5.469632062351193e-14,  3.212717544415921e-16, -7.841443407776946e-18, -2.799675196866655e-19, -4.391713044961426e-21,
  1.960064034646503e+00, -1.147645982758338e-03, -2.422072581967597e-05, -4.401082359390113e-07, -7.187777008052855e-09, -1.061623524943296e-10, -1.395343578431513e-12,
 -1.540531269423001e-14, -1.155614022655197e-16,  3.162213463616930e-19,  3.632994074311966e-20,  9.585694366995149e-22,  9.099674315080364e-02, -2.091951545267618e-03,
  3.455610148913419e-05, -4.762331876751836e-07,  5.573381778360895e-09, -5.268822937559571e-11,  3.114989996485730e-13,  1.451905226791412e-15, -8.513683016896363e-17,
  1.694193622164269e-18, -2.427871512995483e-20,  2.543395044500032e-22,  2.644577771360143e-01, -5.644731498701056e-03,  7.839081223723576e-05, -7.344433247154970e-07,
  2.287933407527132e-09,  7.449054571948369e-11, -1.814569377226958e-12,  2.106368495200103e-14, -5.470799733953334e-17, -3.328063216120605e-18,  7.946293232112969e-20,
 -9.166961176635039e-22,  5.126120270586005e-01, -9.671245284522303e-03,  9.532358500367617e-05, -1.057524533106010e-07, -1.320872685908941e-08,  1.984088566234609e-10,
 -9.728225194051142e-14, -4.272267544925364e-14,  6.584979076074876e-16,  4.571282131644135e-19, -1.760109931145310e-19,  2.614887703978758e-21,  8.188900410859004e-01,
 -1.276310884175560e-02,  5.609696663146985e-05,  1.165031737353258e-06, -1.711530095860026e-08, -1.243953784177469e-10,  4.883892700354428e-12, -5.371571362112757e-15,
 -1.270381374114744e-15,  1.150464207061325e-17,  2.740547068886166e-19, -5.712833396571350e-21,  1.157632549215047e+00, -1.346975945893185e-02, -3.190702320563281e-05,
  1.639201216193713e-06,  8.874606379097930e-09, -3.585323916234223e-10, -2.885955211231287e-12,  9.468071456645780e-14,  9.990755138303487e-16, -2.760563892880837e-17,
 -3.655619084828759e-19,  8.420157818788013e-21,  1.492092644353624e+00, -1.097582011825460e-02, -1.089922066258060e-04,  2.984728464482265e-07,  2.465536247152750e-08,
  2.129984332646373e-10, -4.086401297682248e-12, -1.118155421472946e-13, -1.347765025608083e-16,  3.423885189398797e-17,  4.799983016190130e-19, -5.627962158066891e-21,
  1.774900946596863e+00, -6.034383547265650e-03, -1.034133389299694e-04, -1.156313750723760e-06, -3.352812599222246e-09,  1.962953561325906e-10,  5.100048423893875e-12,
  5.791155092188669e-14, -2.103226428215248e-16, -2.298021306204696e-17, -4.716809318278735e-19, -3.579301124720510e-21,  1.955049482206436e+00, -1.364666005943825e-03,
 -3.026843062136205e-05, -5.740720975669326e-07, -9.682916704732411e-09, -1.452217402201611e-10, -1.874187557514526e-12, -1.854004360924478e-14, -6.502369272124872e-17,
  2.936894033031850e-18,  1.044346062008639e-19,  2.304251917086300e-21,  8.314767884661962e-02, -1.836923365162705e-03,  2.934291531213462e-05, -3.950740576886108e-07,
  4.596295246903682e-09, -4.498209713411250e-11,  3.219636553540831e-13, -4.635575287040378e-16, -3.914284703450327e-17,  9.233511334959066e-19, -1.484871895410857e-20,
  1.749264020815875e-22,  2.430782961163444e-01, -5.052137133115292e-03,  6.983916961923721e-05, -6.880883518760586e-07,  3.388601614456266e-09,  3.772975839391270e-11,
 -1.263381855316179e-12,  1.793244691774463e-14, -1.267203251980689e-16, -9.182309861007987e-19,  4.249258368807256e-20, -7.216251121821362e-22,  4.754395082603921e-01,
 -8.917026584588520e-03,  9.291604808057812e-05, -2.858376406881458e-07, -9.348580921307786e-09,  1.840725883769087e-10, -1.004422809408522e-12, -2.252229306127475e-14,
  5.756607810752292e-16, -4.334990718685623e-18, -6.731437421515920e-20,  2.130173675787081e-21,  7.688169294672886e-01, -1.226321522231633e-02,  6.837248053072078e-05,
  8.775240188088728e-07, -1.846513878265304e-08, -1.313470400260931e-11,  4.238767411277705e-12, -3.778955295529262e-14, -7.215892238582363e-16,  1.727232293562312e-17,
  1.819000463937778e-20, -5.223715082710699e-21,  1.103370242571097e+00, -1.364448481683120e-02, -1.163087612731697e-05,  1.721020209945580e-06,  1.240534770419536e-09,
 -3.933693947528325e-10,  4.782714540448105e-14,  1.087436439389101e-13, -1.555221653810752e-16, -3.349716748767004e-17,  8.809690379966700e-20,  1.073449510344624e-20,
  1.446478016986213e+00, -1.182644094451646e-02, -1.029231950865525e-04,  7.206522416835219e-07,  2.768374404150316e-08,  7.812295661554852e-11, -7.069735782901097e-12,
 -9.339587370192340e-14,  1.351803559701602e-15,  4.499602624615187e-17, -2.461360539067802e-20, -1.671298133278814e-20,  1.749020082690258e+00, -6.917761063746693e-03,
 -1.174584269928694e-04, -1.171374515396543e-06,  1.920780870020792e-09,  3.364935642306148e-10,  6.475649334405715e-12,  3.408335785653504e-14, -1.400987864246836e-15,
 -4.330378773541350e-17, -4.847683622941154e-19,  4.704545874877414e-21,  1.949058863464935e+00, -1.637240168225106e-03, -3.819110777622389e-05, -7.548573377537577e-07,
 -1.307988317635926e-08, -1.965347123530038e-10, -2.399464904710462e-12, -1.788675292116295e-14,  1.462126131171339e-16,  9.809010021742671e-18,  2.583983087000369e-19,
  4.948534504693477e-21,  7.624112463427049e-02, -1.619959081239697e-03,  2.501492534836462e-05, -3.283172323016733e-07,  3.772258278230600e-09, -3.752529864048837e-11,
  2.957093095715754e-13, -1.285028621451203e-15, -1.491337294209030e-17,  4.647191419287041e-19, -8.463772564746066e-21,  1.230481054112157e-22,  2.239362439260500e-01,
 -4.525482858512275e-03,  6.192742623750762e-05, -6.293192292080409e-07,  3.878196213646212e-09,  1.295542196811464e-11, -8.210076704640375e-13,  1.361990589271671e-14,
 -1.359954626100969e-16,  2.394991852235394e-19,  1.780840585798556e-20, -3.912890175042378e-22,  4.412331022128542e-01, -8.189690859117372e-03,  8.870527781939840e-05,
 -4.074520459290543e-07, -5.949179117511797e-09,  1.543219818902206e-10, -1.403340148797363e-12, -6.951775757918967e-15,  3.910814815728181e-16, -5.443186349918436e-18,
  4.832874587707338e-21,  1.174255982679138e-21,  7.209176460180140e-01, -1.167912274808108e-02,  7.713827109446391e-05,  5.851082228988384e-07, -1.780729741515424e-08,
  7.385846522308639e-11,  2.949497826061061e-12, -5.119222255852988e-14, -1.345585664908665e-16,  1.425247352109288e-17, -1.455499759046378e-19, -2.025097752838948e-21,
  1.048736701546475e+00, -1.365517789641475e-02,  8.883809905298307e-06,  1.679003294802544e-06, -6.376219603063607e-09, -3.573141990125607e-10,  2.851587510382333e-12,
  8.601253491812470e-14, -1.194498055799074e-15, -2.175968306707326e-17,  4.567251304037657e-19,  5.085021704224140e-21,  1.397590958444375e+00, -1.260765035862131e-02,
 -9.159820674237256e-05,  1.166090503725951e-06,  2.736911327351290e-08, -1.165912461374379e-10, -8.845889634555452e-12, -2.594680806036787e-14,  2.763144708615756e-15,
  2.804756452325270e-17, -8.228544273822432e-19, -1.655118826794316e-20,  1.719382161605900e+00, -7.912564499215260e-03, -1.310804628494742e-04, -1.078145122011452e-06,
  1.024937443393408e-08,  4.967360148363300e-10,  6.545007110994364e-12, -3.874703316114397e-14, -3.215251735615136e-15, -5.358317691177594e-17,  1.131016375296298e-19,
  2.408985576001354e-20,  1.941836032807048e+00, -1.982879761743498e-03, -4.864534453154149e-05, -9.988657244734739e-07, -1.762260199576484e-08, -2.591937823914935e-10,
 -2.764699727709354e-12, -5.072534830480288e-15,  7.477994979647333e-16,  2.560704165604337e-17,  5.606239041333852e-19,  8.905059121170575e-21,  7.013795142950748e-02,
 -1.434627448608981e-03,  2.141370236237522e-05, -2.735925692999857e-07,  3.089587309870416e-09, -3.090059326413926e-11,  2.551562714269682e-13, -1.549634572118371e-15,
 -3.015044262563920e-18,  2.304589717171418e-19, -3.267926803290867e-21,  1.196641885516316e-22,  2.067788302212999e-01, -4.059202557295377e-03,  5.475331825755334e-05,
 -5.661448576512685e-07,  3.968660633089355e-09, -2.652069742765348e-12, -4.984642290445869e-13,  9.516065627401117e-15, -1.177485798912864e-16,  7.120022470508469e-19,
  8.379151496924343e-21, -4.190106148431082e-23,  4.098606663790521e-01, -7.501002064375802e-03,  8.334053228967504e-05, -4.798203764457219e-07, -3.208755330689952e-09,
  1.195427081156091e-10, -1.451455232397381e-12,  2.553391061079066e-15,  2.091995729870178e-16, -4.412467289262312e-18,  4.288458844424239e-20,  6.472660464175962e-22,
  6.754731741060879e-01, -1.103864015179678e-02,  8.250993420165183e-05,  3.153645105916882e-07, -1.573901228585141e-08,  1.273900080703114e-10,  1.524249826859256e-12,
 -4.852527468661931e-14,  2.615317994598967e-16,  7.655622116026323e-18, -1.609587001712534e-19,  1.152843516227824e-21,  9.943826056240649e-01, -1.350576482823005e-02,
  2.819798278536092e-05,  1.524265146436110e-06, -1.266795385492877e-08, -2.648846568842147e-10,  4.634035922597366e-12,  3.908119977515591e-14, -1.615879716276939e-15,
 -1.277913796939304e-18,  5.150057528194683e-19, -1.996871518292412e-21,  1.345793589680787e+00, -1.327727189292515e-02, -7.509222218656002e-05,  1.573748888271689e-06,
  2.291009548198343e-08, -3.269444013351075e-10, -8.235113339820472e-12,  7.109270054002446e-14,  3.043076136531387e-15, -1.497239849497829e-17, -1.185718601800213e-18,
  2.736615366394889e-21,  1.685557674907458e+00, -9.009363608004981e-03, -1.426803322477328e-04, -8.267427856837830e-07,  2.159966895715056e-08,  6.274785053664696e-10,
  3.749891533860801e-12, -1.691492931141779e-13, -4.746602955477130e-15, -2.131059347787639e-17,  1.642363477628547e-18,  4.290429167393083e-20,  1.933042958437004e+00,
 -2.425198816746323e-03, -6.250623666795261e-05, -1.325890585363891e-06, -2.346329237165159e-08, -3.235201819196315e-10, -2.397515852365955e-12,  3.876487193821877e-14,
  2.177111933391377e-15,  5.683786532089048e-17,  1.015792202003939e-18,  1.073644157552557e-20,  6.472239494749189e-02, -1.275654786224798e-03,  1.840783472003593e-05,
 -2.287854007916108e-07,  2.529272110035927e-09, -2.530140021769298e-11,  2.115435885364434e-13, -1.528150223407082e-15,  4.217573209884396e-18,  2.066733398712279e-19,
  2.028858156954405e-21,  1.104806139913744e-22,  1.913765599190686e-01, -3.647279323066065e-03,  4.833694530671187e-05, -5.036373573821880e-07,  3.815478696222141e-09,
 -1.181758811568096e-11, -2.804466967356509e-13,  6.224389101911752e-15, -8.577424389153721e-17,  1.089449670347629e-18,  1.194656236929042e-20,  1.509786305411840e-22,
  3.811526324069130e-01, -6.858012387578644e-03,  7.734750983418328e-05, -5.138901611829414e-07, -1.157125333399722e-09,  8.618854973076321e-11, -1.307456549001716e-12,
  7.088859973025870e-15,  8.747247496895595e-17, -2.194980532818202e-18,  6.625371783480177e-20,  3.909607007417457e-22,  6.326569652221554e-01, -1.036749986109263e-02,
  8.487266398740778e-05,  8.546824023438203e-08, -1.292963106777851e-08,  1.488266318657537e-10,  3.160486742903852e-13, -3.685163220902259e-14,  4.391213366153106e-16,
  2.820432632022793e-18, -7.048157750017216e-20,  2.547209154263591e-21,  9.409212140649086e-01, -1.321082386504168e-02,  4.511855633365563e-05,  1.285506860283619e-06,
 -1.679472053741822e-08, -1.462856283631676e-10,  5.024443257995721e-12, -9.635781673487700e-15, -1.323506363898744e-15,  1.639975129414712e-17,  3.486740273190236e-19,
 -4.822756893153421e-21,  1.291610690881235e+00, -1.379680076875861e-02, -5.425612916743598e-05,  1.878126007794761e-06,  1.460962553090106e-08, -4.905072634701952e-10,
 -5.023909117112547e-12,  1.513829508002073e-13,  1.748051087000540e-15, -5.254056619693042e-17, -5.237029422995905e-19,  2.539541025803929e-20,  1.647184083207660e+00,
 -1.018363853804445e-02, -1.501028548176090e-04, -3.777846577853008e-07,  3.457581698993270e-08,  6.433143008516792e-10, -3.116272435694670e-12, -3.169543979256777e-13,
 -3.882398869668603e-15,  8.068352692239955e-17,  3.315925752961588e-18,  2.282629524076230e-20,  1.922231614900682e+00, -2.995783035635571e-03, -8.089164215937011e-05,
 -1.755655040687223e-06, -3.037138205043690e-08, -3.579708886073913e-10,  3.164392572786748e-14,  1.498328648603360e-13,  5.050690131339252e-15,  1.046073164288294e-16,
  1.266202921814936e-18, -4.503891561093480e-21,  5.989783617537415e-02, -1.138722582404081e-03,  1.588937578583010e-05, -1.921035965885189e-07,  2.070659441358460e-09,
 -2.071491623736519e-11,  1.719233351934140e-13, -1.250417312911495e-15,  1.405551471105244e-17,  3.566995657772872e-19,  4.432336900370542e-21, -3.352347647888632e-23,
  1.775239961147354e-01, -3.283740608994693e-03,  4.265074831658480e-05, -4.447920399093968e-07,  3.524500445671202e-09, -1.672724280684024e-11, -1.379699238077146e-13,
  4.210458448108180e-15, -3.669428491832834e-17,  1.653233371856413e-18,  1.387190926739320e-20, -1.776818548259986e-22,  3.549188022271175e-01, -6.264093489432225e-03,
  7.112130204077756e-05, -5.202464954119098e-07,  2.703272490621744e-10,  5.745367798285295e-11, -1.077867191412778e-12,  9.158516141892625e-15,  5.865026975531335e-17,
  6.025061241594361e-19,  6.671446222623685e-20, -5.679777890994517e-22,  5.925467586496467e-01, -9.687705661289715e-03,  8.475571135638621e-05, -9.750267560711967e-08,
 -9.952275562853146e-09,  1.456971681485286e-10, -5.064577174876551e-13, -2.150983694942815e-14,  5.151479231534595e-16,  1.998854949648377e-18,  1.707662353908477e-20,
  8.512086420406285e-22,  8.888908243792917e-01, -1.279291981431331e-02,  5.885657929794354e-05,  9.997675185217554e-07, -1.855852278212285e-08, -3.309117634472101e-11,
  4.267188142609689e-12, -4.027814017800196e-14, -5.352051600539772e-16,  2.587935243637138e-17,  1.184841746400866e-19, -5.859699909613097e-21,  1.235702709999635e+00,
 -1.413750653323761e-02, -3.065688813538675e-05,  2.028379213211217e-06,  3.961987206906260e-09, -5.557304436588187e-10, -3.017786162459114e-13,  1.753493347373134e-13,
 -2.312617170545344e-16, -4.943823298118020e-17,  6.581914388017472e-19,  2.246028221943586e-20,  1.604033685489151e+00, -1.139225483985753e-02, -1.509143269783900e-04,
  2.710687085642699e-07,  4.591760886875945e-08,  4.516149380695325e-10, -1.310547993017369e-11, -3.683440895370948e-13,  1.464772640847148e-15,  2.119044808599417e-16,
  2.596157416166410e-18, -6.520653789022836e-20,  1.908808417468581e+00, -3.735983897255045e-03, -1.051064901421080e-04, -2.297028417503340e-06, -3.707302913406594e-08,
 -2.847986886555422e-10,  7.119456239937350e-12,  3.802970410907122e-13,  9.552878283225520e-15,  1.362220645540060e-16, -2.000500214068353e-19, -7.615417190543732e-20,
  5.558333137330453e-02, -1.020295414347799e-03,  1.376994032168789e-05, -1.620740708577623e-07,  1.695103758314634e-09, -1.694514345037725e-11,  1.453423075219158e-13,
 -5.687823317657031e-16,  2.896777739455304e-17,  4.182042073704261e-19, -3.760068520733791e-21, -3.596140106797321e-22,  1.650389601052309e-01, -2.962952378688466e-03,
  3.764007849530226e-05, -3.912178708178883e-07,  3.165951741228670e-09, -1.869830354507413e-11, -2.696213788628708e-14,  4.066187591674011e-15,  2.872931058328783e-17,
  1.802592658386075e-18, -1.349615064181370e-20, -1.138959211291524e-21,  3.309610383560883e-01, -5.719942728198748e-03,  6.493791034466511e-05, -5.080427810805022e-07,
  1.182726788430111e-09,  3.491087220849981e-11, -7.886595312935452e-13,  1.181639797752406e-14,  1.173706968401192e-16,  2.208940193085333e-18, -2.082539455317710e-21,
 -2.696922185363505e-21,  5.551410810072527e-01, -9.016830826241105e-03,  8.272380477520341e-05, -2.342583148651785e-07, -7.198737765654877e-09,  1.282494076027482e-10,
 -8.661045007727443e-13, -3.738802488760881e-15,  5.975398881401635e-16,  2.199929493631605e-18, -4.156737664751783e-20, -3.831653756363112e-21,  8.387296830303114e-01,
 -1.227914241031394e-02,  6.906724873743257e-05,  7.026939538770202e-07, -1.829384455467704e-08,  5.473275495086396e-11,  3.043044607674810e-12, -4.213883198198410e-14,
  4.115240398031229e-16,  2.451640150317238e-17, -2.168990858339363e-19, -9.963537245307016e-21,  1.178816744929641e+00, -1.428516088271090e-02, -6.299560381331280e-06,
  2.004095947869572e-06, -6.837864301687941e-09, -5.063151643600046e-10,  4.282045823201210e-12,  1.460260036289996e-13, -1.371239274156897e-15, -1.162889349754480e-17,
  9.874064106271363e-19, -1.055319775988145e-20,  1.556089015276830e+00, -1.257350983368680e-02, -1.430198469881507e-04,  1.057603919854712e-06,  5.102853168911914e-08,
  2.620734222073766e-11, -2.151508589082256e-11, -1.868850166544967e-13,  9.985200792797755e-15,  2.276345119070697e-16, -2.465198188443151e-18, -1.523875292356484e-19,
  1.891993498224166e+00, -4.697528930135705e-03, -1.363762255538379e-04, -2.922183088191696e-06, -4.000091789798130e-08,  5.266105357293503e-11,  2.272385622352235e-11,
  7.538957152397809e-13,  1.312156730139872e-14,  1.744196445846906e-17, -7.021519191010566e-18, -2.510486660816335e-19,  5.171076962153824e-02, -9.174789228910397e-04,
  1.197720166020342e-05, -1.374774764637292e-07,  1.390386841769506e-09, -1.353129943549701e-11,  1.442406606630215e-13,  5.329669762834537e-16,  3.658530953166534e-17,
 -1.465061196456979e-19, -2.646332849865483e-20, -6.229367564657725e-22,  1.537608375008251e-01, -2.679777517223625e-03,  3.323705247460251e-05, -3.435482412661231e-07,
  2.795505805105206e-09, -1.782181009014122e-11,  1.081146467675503e-13,  5.803012835605690e-15,  6.904401303733266e-17, -3.662327890897399e-20, -8.450714210869588e-20,
 -1.938411418645717e-21,  3.090821791908390e-01, -5.224456821628067e-03,  5.897497631752426e-05, -4.844408123653565e-07,  1.720947958769751e-09,  2.044417099975092e-11,
 -3.949210630712805e-13,  1.655643588973105e-14,  1.608129901841103e-16, -8.850660077362956e-19, -1.654586753663262e-19, -4.395528254700013e-21,  5.203770183757622e-01,
 -8.368055258485642e-03,  7.930261035616881e-05, -3.300435853098693e-07, -4.838689893924232e-09,  1.084192428515177e-10, -6.958251180298714e-13,  1.591023396903668e-14,
  5.928840605936647e-16, -4.255272067325283e-18, -3.104666433464924e-19, -7.725095559086448e-21,  7.907647091735814e-01, -1.169774391080197e-02,  7.579133414516054e-05,
  4.223530986482797e-07, -1.655356998226503e-08,  1.158279097330080e-10,  2.162833700148479e-12, -1.747421509249518e-14,  1.018274542822424e-15,  5.579178855700170e-18,
 -7.594953947600639e-19, -1.379708546177744e-20,  1.121724032999905e+00, -1.424194745116213e-02,  1.678065315857784e-05,  1.820561902428675e-06, -1.563167253409809e-08,
 -3.595887511401113e-10,  7.739369717177338e-12,  1.015093498239475e-13, -1.288794896033260e-15,  8.096857386853839e-18, -2.206787445732943e-19, -3.999436550799453e-20,
  1.503606446885741e+00, -1.365317218675356e-02, -1.255065480555806e-04,  1.849156069710180e-06,  4.618040180304128e-08, -5.102782279199411e-10, -2.125487892686599e-11,
  2.315408673963149e-13,  1.479390573591387e-14, -1.882978091708147e-18, -8.589485931230002e-18, -9.452491986282155e-20,  1.870784312188180e+00, -5.939372157502305e-03,
 -1.751301346336507e-04, -3.516125674300261e-06, -3.154544284659577e-08,  8.968278280636853e-10,  4.927578985491152e-11,  1.104313665300833e-12,  5.477935017261208e-15,
 -5.430820983202705e-16, -2.211008359195817e-17, -3.903106538853116e-19,  4.822254924116148e-02, -8.279013544361478e-04,  1.045264698670392e-05, -1.172008957276105e-07,
  1.156219560362067e-09, -9.771645526592964e-12,  1.729987293834810e-13,  1.362687082295055e-15,  5.922454872495518e-18, -1.710220265027275e-18, -4.885784487912691e-20,
 -2.136320403775496e-22,  1.435484498734568e-01, -2.429636916963301e-03,  2.937169762125703e-05, -3.014711972237552e-07,  2.479365327362396e-09, -1.305621164017038e-11,
  2.957304025805507e-13,  7.176243866799030e-15, -1.281361661517561e-17, -4.987122007695190e-18, -1.541007022849703e-19, -6.646389055087310e-22,  2.890918326245295e-01,
 -4.775413520744952e-03,  5.333917656271694e-05, -4.539823746939979e-07,  2.075284442016463e-09,  1.702616653399882e-11,  1.246532848290037e-13,  1.954687866681096e-14,
 -3.479105367193303e-17, -1.106349542394935e-17, -3.238656226772063e-19, -1.599927750131783e-21,  4.881469086769575e-01, -7.750632789772765e-03,  7.494669144360204e-05,
 -3.908356492424203e-07, -2.791104590198355e-09,  9.896549104770814e-11, -2.866890693650620e-14,  2.937929463172975e-14,  1.366382627858975e-16, -2.303919070493903e-17,
 -5.951263017053622e-19, -2.919802556025452e-21,  7.452123916569808e-01, -1.107544903353107e-02,  7.935571637077382e-05,  1.787487598122408e-07, -1.373860238275656e-08,
  1.654939519314313e-10,  2.111474802073184e-12,  1.132455367146893e-14,  5.353253187493339e-16, -3.563776658579093e-17, -1.231311687845353e-18, -3.839617556202080e-21,
  1.065156461221161e+00, -1.402504361101850e-02,  3.692456158722579e-05,  1.523897766442400e-06, -2.075922004767172e-08, -1.442756762872969e-10,  1.001556605399409e-11,
  5.972043690814661e-14, -1.585628919911672e-15, -3.570644094777016e-17, -1.858712628258247e-18, -2.435585401164961e-20,  1.447142690980395e+00, -1.455684493007755e-02,
 -9.930163229900926e-05,  2.481823009345895e-06,  3.166588031900938e-08, -8.916824183343540e-10, -8.659283789432289e-12,  6.324790879662366e-13,  8.014031162471793e-15,
 -3.751865414046726e-16, -8.608852805193068e-18,  1.035084098998663e-19,  1.843947789708745e+00, -7.515934348204320e-03, -2.195230122569257e-04, -3.802532706055417e-06,
  7.228733949729249e-10,  2.445370291720662e-09,  7.831887308443857e-11,  7.667802506111927e-13, -3.338097528110178e-14, -1.670555032000120e-15, -2.931954341481138e-17,
  3.114553632661344e-19,  4.506970523626906e-02, -7.496046540437505e-04,  9.151549290883604e-06, -1.000267594790921e-07,  1.005216812412307e-09, -5.210808080561400e-12,
  2.018697478620730e-13,  1.954182467444594e-16, -8.930016783961699e-17, -3.409467328465678e-18, -2.166811826040552e-20,  1.770652661944186e-21,  1.342778670236475e-01,
 -2.208476578987837e-03,  2.598487356770356e-05, -2.634397740966051e-07,  2.304392943437500e-09, -3.802342395505496e-12,  4.554740583103724e-13,  2.720689476786031e-15,
 -2.986175926056780e-16, -1.036380989026647e-17, -7.001303884773652e-20,  5.483445620253814e-21,  2.708099361592992e-01, -4.369898953456758e-03,  4.810287010734258e-05,
 -4.177128657184789e-07,  2.487516534536480e-09,  2.600177999863276e-11,  5.786429228762802e-13,  9.582787617859409e-15, -6.578797102921010e-16, -2.246263685494596e-17,
 -1.496073406736843e-19,  1.166829386716842e-20,  4.583129489988040e-01, -7.170426979600821e-03,  7.005467464323797e-05, -4.194190917863881e-07, -7.533452164447290e-10,
  1.077112474450396e-10,  6.976644872475709e-13,  1.592878644616143e-14, -1.105639695707250e-15, -4.395940039241639e-17, -2.723387236375092e-19,  2.164261282821178e-20,
  7.021889511982606e-01, -1.043549020906504e-02,  8.030027906610258e-05, -1.171237012501610e-08, -9.892549109401937e-09,  2.203859120739314e-10,  2.408349758372967e-12,
 -1.381037442886734e-15, -1.591254236280854e-15, -7.849933213892812e-17, -5.944473468177949e-19,  3.985232591068179e-20,  1.009754745072575e+00, -1.366227864602204e-02,
  5.316679467278917e-05,  1.182171285151601e-06, -2.114220453791441e-08,  1.086969200435248e-10,  1.067491446279035e-11, -2.693864695699363e-14, -4.294537074248973e-15,
 -1.113299242617583e-16, -1.276290781462244e-18,  6.441993023557170e-20,  1.387525422290512e+00, -1.522491469343040e-02, -6.708760356358209e-05,  2.840877797247149e-06,
  1.327752411827561e-08, -8.725827327087088e-10,  1.020531350792947e-11,  6.188383549982474e-13, -1.005481061280703e-14, -5.700365810656221e-16,  2.206162988339884e-19,
  2.901194260164795e-19,  1.810088736112874e+00, -9.450038185994237e-03, -2.631262243155434e-04, -3.293233488007140e-06,  6.928063279223991e-08,  4.399559403401839e-09,
  7.449717901241794e-11, -1.429384637490612e-12, -1.060335350569504e-13, -1.963531269933813e-15,  3.240009625513913e-17,  2.688125726654348e-18,  4.221048706738013e-02,
 -6.809263548739697e-04,  8.045130433958774e-06, -8.451920535075515e-08,  9.477357878232971e-10, -7.377975016221572e-13,  1.488413024728644e-13, -4.586173176889764e-15,
 -2.005184999031333e-16, -1.802464599264955e-18,  1.236696954235619e-19,  4.612193665757550e-21,  1.258405794344448e-01, -2.012617791435514e-03,  2.304424657644406e-05,
 -2.265819409681443e-07,  2.336763257695350e-09,  6.614127614881302e-12,  3.414972611584223e-13, -1.270305181681982e-14, -6.380293741337367e-16, -5.491295380871482e-18,
  3.812055154169306e-19,  1.435486948606821e-20,  2.540692538845046e-01, -4.004404935436192e-03,  4.334884765822582e-05, -3.729590696593121e-07,  3.152644357853911e-09,
  3.997326475903249e-11,  4.300489768027321e-13, -2.419029079988672e-14, -1.394325213812768e-15, -1.200638002215505e-17,  8.196485546900660e-19,  3.101452856534834e-20,
  4.307201745311457e-01, -6.630156582454236e-03,  6.502356043002536e-05, -4.132683632529976e-07,  1.577489933795721e-09,  1.243306079033505e-10,  4.096126196882644e-13,
 -4.432199126949694e-14, -2.549370893553467e-15, -2.421456671512977e-17,  1.538400797377576e-18,  5.831426999394406e-20,  6.617275725847104e-01, -9.795986158182545e-03,
  7.936531366350306e-05, -1.317418199166879e-07, -4.951035728232058e-09,  2.693004541185820e-10,  1.225120506323832e-12, -9.744690617287581e-14, -4.234736525028241e-15,
 -4.650465508041817e-17,  2.696849304955450e-18,  1.060442189777378e-19,  9.560383542628612e-01, -1.318569766902755e-02,  6.543854808173823e-05,  8.746222639696865e-07,
 -1.656406601057975e-08,  3.364407146174172e-10,  7.367930500773330e-12, -2.303653141072501e-13, -8.166197513916453e-15, -6.467547742084906e-17,  4.611350265551624e-18,
  1.968986032616679e-19,  1.325771758931813e+00, -1.562285600305835e-02, -3.224122131281148e-05,  2.932012913141568e-06, -5.873262740782362e-10, -4.743119368877705e-10,
  2.011439326332430e-11, -1.656010856275830e-15, -2.689797638931891e-14, -2.578849546289921e-16,  1.645800790976020e-17,  4.302885413991229e-19,  1.767864374915583e+00,
 -1.168705845998785e-02, -2.928310406389732e-04, -1.404873859691439e-06,  1.697036844875524e-07,  5.273856778955909e-09, -2.035159617018642e-11, -5.437048147018295e-12,
 -1.200029174311701e-13,  2.154096883476597e-15,  1.731227193350687e-16,  2.442775743400654e-18,  3.960944398663818e-02, -6.203645807580627e-04,  7.121872816066020e-06,
 -6.933645059753412e-08,  9.544548648510227e-10,  5.524370567188040e-13, -7.004828280256132e-14, -1.069229915602182e-14, -1.288210337698488e-16,  6.891079249639943e-18,
  2.813076171746793e-19,  3.652720485824982e-22,  1.181425092649727e-01, -1.838491979004960e-03,  2.055496745809851e-05, -1.878536577011675e-07,  2.509978796753770e-09,
  8.188118486089935e-12, -3.015808961862871e-13, -3.211149413039564e-14, -4.128940627984723e-16,  2.146089640484601e-17,  8.750820726832395e-19,  1.279177479671263e-21,
  2.387181642837246e-01, -3.674595788742627e-03,  3.920333828801008e-05, -3.158836170996999e-07,  3.973745478120033e-09,  3.701827204014425e-11, -8.762417342176445e-13,
 -6.673334315178948e-14, -9.145107666652862e-16,  4.621767193231955e-17,  1.897786533245675e-18,  3.208746922788981e-21,  4.052093726790420e-01, -6.129186239147523e-03,
  6.029800315109204e-05, -3.681944349097488e-07,  4.012779254391891e-09,  1.097957457375444e-10, -1.990529508157407e-12, -1.229425242846896e-13, -1.704700417581762e-15,
  8.553903963201660e-17,  3.594181031428352e-18,  7.184377161780962e-21,  6.238021051513782e-01, -9.168319988052493e-03,  7.748880259101252e-05, -1.674866287429569e-07,
  4.257422003831752e-10,  2.500757393214279e-10, -3.450183286693304e-12, -2.297321470199510e-13, -2.852937128692214e-15,  1.498936035945251e-16,  6.502417902679988e-18,
  1.625638789457597e-20,  9.044034280048855e-01, -1.262415212430180e-02,  7.458973832274656e-05,  6.702995250700868e-07, -8.745132261697035e-09,  4.058915231599388e-10,
 -2.736390090889815e-12, -4.760611588512239e-13, -5.074545044756501e-15,  2.874432928357143e-16,  1.190546874935911e-17,  3.804603301713202e-20,  1.262986338149384e+00,
 -1.574076686183304e-02,  2.654076001203045e-06,  2.871131234783708e-06, -5.769481800688768e-09, -9.252191607257300e-11,  7.736749316548699e-12, -8.483212681626852e-13,
 -2.007082780162371e-14,  7.319573514959286e-16,  2.991457688929336e-17, -2.071456666630791e-20,  1.716399246259960e+00, -1.404342146129639e-02, -2.901604126977723e-04,
  2.069509822028836e-06,  2.562110970000427e-07,  2.647056182827865e-09, -2.045546817057126e-10, -6.618052818404803e-12,  8.758196253388244e-14,  8.818513219304562e-15,
  8.246667194983773e-17, -7.878956303143285e-18,  3.723703228647861e-02, -5.664584167909242e-04,  6.381241403588179e-06, -5.417462159126606e-08,  9.232798484692840e-10,
 -4.883878526582273e-12, -3.753634420009398e-13, -8.885910378093572e-15,  2.878143367750545e-16,  1.419611193963423e-17, -3.145502265838334e-20, -1.481159255706302e-20,
  1.111041190376233e-01, -1.682378197657085e-03,  1.854493648372289e-05, -1.470982758782682e-07,  2.524695173543642e-09, -1.038779638145234e-11, -1.224401323461547e-12,
 -2.685611060133366e-14,  8.853453424454190e-16,  4.427897110828071e-17, -9.508402896424061e-20, -4.619064061402433e-20,  2.246246141025338e-01, -3.375005104880515e-03,
  3.581311928118855e-05, -2.481934881708711e-07,  4.343739762311523e-09, -7.702285137503888e-12, -2.806249238291142e-12, -5.609577690951050e-14,  1.893719375903411e-15,
  9.603535429019493e-17, -1.946506876968635e-19, -1.004174369856254e-19,  3.816311452515051e-01, -5.663240150311393e-03,  5.632558774673254e-05, -2.902536751883112e-07,
  5.435851796176807e-09,  1.834711497659404e-11, -5.547321607519024e-12, -1.029710851475317e-13,  3.553987860427777e-15,  1.808042553697104e-16, -3.343401888451833e-19,
 -1.906155473824485e-19,  5.883565310576097e-01, -8.555993575226798e-03,  7.566406238299243e-05, -1.274532356340586e-07,  4.052379269868402e-09,  8.647932628020294e-11,
 -1.001090228940961e-11, -1.887529741048268e-13,  6.514705908553973e-15,  3.242723704838454e-16, -5.497099163875086e-19, -3.477222437393270e-19,  8.551485957371801e-01,
 -1.199706806221315e-02,  8.203728313735014e-05,  5.870436757974980e-07, -2.406323716525082e-09,  1.746492240607309e-10, -1.616133824287155e-11, -3.884288854989110e-13,
  1.257291597953940e-14,  6.067593964602984e-16, -1.259832912377291e-18, -6.616210842424634e-19,  1.200281569908508e+00, -1.558340841527304e-02,  3.650102455310760e-05,
  2.765112593847637e-06, -7.930222090961715e-09, -2.323404393067738e-10, -1.953160815236396e-11, -8.649338556472266e-13,  2.368522932189701e-14,  1.467041736415063e-15,
 -5.367649802629900e-18, -1.621161188176018e-18,  1.655841445005408e+00, -1.619366467368391e-02, -2.399970872760187e-04,  6.272195514714086e-06,  2.479499313047722e-07,
 -3.873192873019170e-09, -3.031325831615451e-10,  1.058273319150654e-12,  3.577537244003782e-13,  2.987624061436287e-15, -3.804348067718985e-16, -8.249164523309039e-18,
  3.506952155861898e-02, -5.177686627731405e-04,  5.814798368779965e-06, -4.073321382909438e-08,  7.226035437116009e-10, -1.540800116183218e-11, -4.281148127701321e-13,
  6.875695747587377e-15,  6.060966030893028e-16, -9.446275996169886e-19, -6.689281744680218e-19, -6.755066910635878e-21,  1.046610801644168e-01, -1.540419841459190e-03,
  1.700957923074858e-05, -1.101421238324689e-07,  1.984532399868427e-09, -4.425520253792749e-11, -1.370267012070638e-12,  2.192742728295576e-14,  1.879419781794214e-15,
 -2.913625015308461e-18, -2.088943262241647e-18, -2.118450154049907e-20,  2.116803610198548e-01, -3.099269438265978e-03,  3.323378152446094e-05, -1.839576372417209e-07,
  3.436976912178281e-09, -8.414320887696882e-11, -3.073827201273970e-12,  4.890812837937753e-14,  4.052276171393555e-15, -6.386871223463564e-18, -4.547816818681497e-18,
 -4.638456696683454e-20,  3.598593951902619e-01, -5.225111854771696e-03,  5.335110045057204e-05, -2.082546375602526e-07,  4.328088951774486e-09, -1.310536655817372e-10,
 -5.981581706392694e-12,  9.440551906504638e-14,  7.615347775455238e-15, -1.296229604845975e-17, -8.640610923336555e-18, -8.853646274457933e-20,  5.553351095966822e-01,
 -7.955656689915781e-03,  7.453483919299415e-05, -6.307548041170504e-08,  3.115642203761339e-09, -1.838161940313659e-10, -1.084184263562764e-11,  1.694634759089432e-13,
  1.375103562936381e-14, -2.826235072122126e-17, -1.577241760809467e-17, -1.605212189375352e-19,  8.085167713997611e-01, -1.131313185483242e-02,  8.889020279248347e-05,
  5.527750845366694e-07, -3.358596099971661e-09, -2.799702727776019e-10, -1.855084537891601e-11,  2.911595476898713e-13,  2.580624017024268e-14, -7.297835594595377e-17,
 -3.012004231312893e-17, -2.876292592992630e-19,  1.138738341934809e+00, -1.516138303907254e-02,  6.866771830391735e-05,  2.569473344234595e-06, -1.859383406663693e-08,
 -8.624436256304906e-10, -2.635957812629337e-11,  5.472326992444503e-13,  5.435358232307256e-14, -2.230161712341261e-16, -7.097497877695957e-17, -4.730989775388362e-19,
  1.587787910300583e+00, -1.775344347028632e-02, -1.446802216199896e-04,  9.257893227623998e-06,  1.068219361564190e-07, -9.515706178495719e-09, -1.203095616070981e-10,
  1.095420018000781e-11,  1.622856546349310e-13, -1.287595943762103e-14, -2.328640790920069e-16,  1.506429513246650e-17,  3.308863056905369e-02, -4.730354910465877e-04,
  5.383661254577045e-06, -3.209246786445709e-08,  3.377970040884938e-10, -2.140016171653599e-11, -6.371319188720295e-15,  2.059397052956647e-14,  1.127224049163781e-16,
 -2.329281883201567e-17, -2.003542598738873e-19,  2.545529590001858e-20,  9.876384384337422e-02, -1.409167602682238e-03,  1.584424272429917e-05, -8.693327860786694e-08,
  8.528631745755914e-10, -6.366164189531128e-11, -4.624715504719457e-14,  6.436230655105494e-14,  3.402945563828617e-16, -7.264306056016663e-17, -6.192958326732624e-19,
  7.980759535497739e-20,  1.998021653998527e-01, -2.841444899944601e-03,  3.128959672651245e-05, -1.457232831960251e-07,  1.197477723733467e-09, -1.283186840122073e-10,
 -1.764183389658276e-13,  1.400151276342933e-13,  7.018507642610634e-16, -1.578990065471062e-16, -1.321393998648753e-18,  1.749325315787890e-19,  3.397980812725773e-01,
 -4.807365529697974e-03,  5.115936762280491e-05, -1.664090789323083e-07,  6.171679679602876e-10, -2.182114095447411e-10, -4.768752062659573e-13,  2.644095175651094e-13,
  1.230539057879893e-15, -2.995579078376340e-16, -2.413073212726970e-18,  3.359861894939444e-19,  5.247009727481190e-01, -7.361917930523556e-03,  7.391636762793534e-05,
 -5.432136163039927e-08, -2.541551004096660e-09, -3.427176824153294e-10, -9.638849101494669e-13,  4.727221374871456e-13,  1.985691550105422e-15, -5.458415627903702e-16,
 -4.046680810795559e-18,  6.235547825837543e-19,  7.647264738679662e-01, -1.057695306712475e-02,  9.494931914940452e-05,  4.343886868886717e-07, -1.230857243556136e-08,
 -5.448586940527958e-10, -8.885676179876749e-13,  8.472768884981792e-13,  2.974927788501169e-15, -1.032809812640941e-15, -6.205259956958193e-18,  1.217745400484495e-18,
  1.079377671125974e+00, -1.449525902177217e-02,  9.705798681924011e-05,  2.108067356059472e-06, -4.001429698901905e-08, -1.141336046957297e-09,  8.321866851258384e-12,
  1.642343775282417e-12,  1.276920970058811e-15, -2.275376535946115e-15, -5.265431559279578e-18,  2.912052432550585e-18,  1.515184177637749e+00, -1.845239355460672e-02,
 -2.982151600341787e-05,  9.396649938503054e-06, -8.642821693479018e-08, -8.593088484479297e-09,  1.848740998204165e-10,  8.363626106154883e-12, -2.930883240766708e-13,
 -7.892270637819759e-15,  4.182467782078034e-16,  6.855339050003069e-18,  3.128027609896293e-02, -4.314463726927502e-04,  5.017360565738478e-06, -2.992668414280120e-08,
 -4.623075014531511e-11, -1.500013711871503e-11,  4.966979419031320e-13,  1.147015441969073e-14, -5.997367031048897e-16, -9.842633893610367e-18,  7.309352108411077e-19,
  7.029440815757959e-21,  9.337427750399246e-02, -1.286448613898405e-03,  1.484236540753692e-05, -8.293000389165926e-08, -2.894476876708196e-10, -4.432763683676408e-11,
  1.521922833708478e-12,  3.561963331169098e-14, -1.874462173651371e-15, -3.026918219677502e-17,  2.288495450639616e-18,  2.147136952919738e-20,  1.889261531897219e-01,
 -2.597987102019913e-03,  2.957404339198691e-05, -1.460138782816250e-07, -1.102946429277134e-09, -8.820374750873877e-11,  3.220437027592392e-12,  7.661461995563831e-14,
 -4.084171516432754e-15, -6.418328870855523e-17,  5.004437923906881e-18,  4.486904908013080e-20,  3.213743316551705e-01, -4.406233701484298e-03,  4.908246282727652e-05,
 -1.896011505222636e-07, -3.281175101329641e-09, -1.462620617838590e-10,  5.894759532047763e-12,  1.418628754733186e-13, -7.756879885143827e-15, -1.166876538147264e-16,
  9.573590584828304e-18,  7.901403311173499e-20,  4.964301883543156e-01, -6.774392758189388e-03,  7.280235549461874e-05, -1.466811430827975e-07, -8.594738958809585e-09,
 -2.177561202226324e-10,  1.030016663691562e-11,  2.444658286598129e-13, -1.408726240787953e-14, -1.967580330631873e-16,  1.763415465403945e-17,  1.232295650912123e-19,
  7.239650843579817e-01, -9.800652193115754e-03,  9.863855093533673e-05,  1.569390613219836e-07, -2.158537209938478e-08, -3.042017912465887e-10,  1.884267505376917e-11,
  4.028939707324084e-13, -2.629270887055047e-14, -3.153330025066993e-16,  3.382302574571664e-17,  1.521555924503448e-19,  1.023092303246240e+00, -1.363008142848981e-02,
  1.178361601013163e-04,  1.310859255109655e-06, -5.740208898260598e-08, -4.563157104744594e-10,  4.365911990205388e-11,  5.656420864937536e-13, -5.678863439262913e-14,
 -3.858295315501572e-16,  7.608789773881183e-17, -1.273828602444565e-19,  1.441563548945296e+00, -1.827462038099904e-02,  6.991736191442370e-05,  6.938362746987880e-06,
 -2.011011014993075e-07, -2.547049757306124e-09,  2.691396404380264e-10, -2.213138272084182e-12, -2.737685937405825e-13,  7.394724500671506e-15,  2.009489423910014e-16,
 -1.220365309386647e-17,  2.963245189969034e-02, -3.927747606809975e-04,  4.646199518134701e-06, -3.235070538403846e-08, -2.128640469479890e-10, -1.517770424937925e-12,
  5.362066640815470e-13, -7.834020897457380e-15, -4.561554900479763e-16,  1.471391188527324e-17,  2.923311487015865e-19, -1.998766124493637e-20,  8.845947590942403e-02,
 -1.171822382104937e-03,  1.379720829468722e-05, -9.245845199658470e-08, -7.669280976553073e-10, -2.981684124118073e-12,  1.641570557342876e-12, -2.444954722845177e-14,
 -1.411172043232492e-15,  4.614397517929212e-17,  8.953496737349250e-19, -6.264454313503794e-20,  1.789957295667185e-01, -2.368807719493763e-03,  2.767270398458543e-05,
 -1.731241234467908e-07, -2.000663328138635e-09, -6.868147064302816e-13,  3.462744588355161e-12, -5.329780018414118e-14, -3.021348931146050e-15,  1.011363761651030e-16,
  1.883782130647557e-18, -1.371625511611788e-19,  3.045188220229902e-01, -4.023735148599433e-03,  4.642304238465910e-05, -2.569927979105677e-07, -4.621698725494517e-09,
  1.358659230835180e-11,  6.281311091606701e-12, -1.019494828308800e-13, -5.576093671978991e-15,  1.939648187470987e-16,  3.374669363756298e-18, -2.626117614380624e-19,
  4.704826898913910e-01, -6.201588416504041e-03,  7.012094218403466e-05, -3.042317584490503e-07, -1.019676766948659e-08,  5.891651361067449e-11,  1.071773904304371e-11,
 -1.896360435385220e-13, -9.642646116423966e-15,  3.579779863955267e-16,  5.521870381507372e-18, -4.830286952607655e-19,  6.863439371819811e-01, -9.010172777199586e-03,
  9.833469397515291e-05, -2.104474672496362e-07, -2.273600727913041e-08,  1.868853320346858e-10,  1.841638291914323e-11, -3.776193304193505e-13, -1.635112842598998e-14,
  6.866162522694344e-16,  8.218178016136430e-18, -9.176740793106993e-19,  9.705345052409164e-01, -1.264039622922325e-02,  1.279449755487849e-04,  3.780680427763447e-07,
 -5.581132893408000e-08,  5.827948436868729e-10,  3.574969800335843e-11, -9.650399858528973e-13, -2.707050116833262e-14,  1.549041978984786e-15,  6.931729134779828e-18,
 -1.977747384267586e-18,  1.370031406389092e+00, -1.743869581765416e-02,  1.332349505665347e-04,  3.628788866402656e-06, -1.964200138810453e-07,  2.455010145032875e-09,
  1.297799059473593e-10, -6.150370128087241e-12,  1.943173273948668e-14,  6.309357337341982e-15, -1.794447895784290e-16, -2.637678659940006e-18,  2.813315376896384e-02,
 -3.572141291767763e-04,  4.238558751106106e-06, -3.539768409859868e-08, -1.385843858291074e-10,  7.598584943386210e-12,  1.987211676236805e-13, -1.330928605214717e-14,
  9.194154955021920e-17,  1.148881876453828e-17, -3.336698541856748e-19, -4.680669624742226e-21,  8.398563014697535e-02, -1.066083406205583e-03,  1.261823671714646e-05,
 -1.033692729033028e-07, -5.074111461134333e-10,  2.475193671811798e-11,  5.941184745103827e-13, -4.114428747382663e-14,  2.953909891892187e-16,  3.548511807089709e-17,
 -1.047940621376856e-18, -1.407485236247713e-20,  1.699493680068756e-01, -2.156255091772159e-03,  2.541556467833249e-05, -2.013872143249831e-07, -1.345421191242685e-09,
  5.719038635815243e-11,  1.203259117380121e-12, -8.812363780607039e-14,  6.739656958591410e-16,  7.578659008649567e-17, -2.301959416301940e-18, -2.863648576336821e-20,
  2.891454309093721e-01, -3.665875687504795e-03,  4.292761064960660e-05, -3.218211035161938e-07, -3.148833484035903e-09,  1.167722564115573e-10,  2.041481932713074e-12,
 -1.633391689733639e-13,  1.375235607442584e-15,  1.393866397891233e-16, -4.427860613563381e-18, -4.825430094443005e-20,  4.467714532634947e-01, -5.657828126938967e-03,
  6.556933334217700e-05, -4.462504155282031e-07, -7.003531471223448e-09,  2.300242706842823e-10,  3.107048332538557e-12, -2.868555837296041e-13,  2.788646030153712e-15,
  2.399275595736700e-16, -8.197949811136873e-18, -6.954700258485546e-20,  6.518524219179604e-01, -8.239361932094076e-03,  9.381607522573388e-05, -5.246653298236690e-07,
 -1.564102984618418e-08,  4.661917136383423e-10,  4.275011414376017e-12, -5.108951772299309e-13,  6.188951445702036e-15,  4.044049763978811e-16, -1.573687231554611e-17,
 -7.001304037677366e-20,  9.220288295206711e-01, -1.161273161716075e-02,  1.276316350840813e-04, -3.853477708829942e-07, -3.805643310314086e-08,  1.068441724183097e-09,
  4.534630383413519e-12, -1.023454855082809e-12,  1.778996750414123e-14,  6.656173026456906e-16, -3.489649499633326e-17,  1.232190409518381e-19,  1.302614710642932e+00,
 -1.624750724783247e-02,  1.599404971711019e-04,  9.929976134672846e-07, -1.290556562880827e-07,  3.731842880216370e-09, -9.815970908736254e-12, -3.317501454672400e-12,
  1.170542444997727e-13, -3.456346829677638e-16, -1.076900788372954e-16,  3.649217165142256e-18,  2.676938737864757e-02, -3.250298001774662e-04,  3.806013883882149e-06,
 -3.625689908759711e-08,  3.388526862330553e-11,  8.514628598486170e-12, -8.967000918369629e-14, -6.409965861974398e-15,  2.624718662246149e-16, -1.120124908929481e-18,
 -2.136726737026007e-19,  6.669225521822721e-21,  7.991519111505127e-02, -9.701964201830613e-04,  1.134694286340696e-05, -1.071131199080930e-07,  4.633585707074690e-11,
  2.713456331436070e-11, -2.932584268249668e-13, -1.956378930629116e-14,  8.145229881384100e-16, -3.745842160618415e-18, -6.578118812287490e-19,  2.089504164983818e-20,
  1.617152972970684e-01, -1.962869886357205e-03,  2.291045662537194e-05, -2.129636917619264e-07, -9.179249003702379e-11,  6.076176289729235e-11, -6.823269463149947e-13,
 -4.100162545006847e-14,  1.754854910319519e-15, -9.051098056199034e-18, -1.397108493913118e-18,  4.570319400734372e-20,  2.751433493890508e-01, -3.338571096777735e-03,
  3.884523366727908e-05, -3.522752206773758e-07, -6.530655458451986e-10,  1.192472998202782e-10, -1.409163366423989e-12, -7.338231296993163e-14,  3.278878844135491e-15,
 -1.983043504412319e-17, -2.546388233869500e-18,  8.727209630353515e-20,  4.251531245096285e-01, -5.156235015828968e-03,  5.970008223925254e-05, -5.199211454069118e-07,
 -2.230276772227654e-09,  2.240002438537733e-10, -2.827322671893640e-12, -1.216323822172857e-13,  5.816482502249878e-15, -4.353005942792325e-17, -4.316712142432377e-18,
  1.594993731898389e-19,  6.203511035970483e-01, -7.517548839769398e-03,  8.633226706122426e-05, -6.990875181466077e-07, -6.292745780536619e-09,  4.287111259009291e-10,
 -5.906977455506101e-12, -1.950369157590527e-13,  1.047066237781567e-14, -1.043955793611026e-16, -7.068144559893399e-18,  2.984046371301176e-19,  8.775782461081413e-01,
 -1.061890709378126e-02,  1.200549713066526e-04, -8.257787785073795e-07, -1.752701884956514e-08,  9.109234466034608e-10, -1.429776845439645e-11, -3.078607754349824e-13,
  2.102917924599510e-14, -3.161349335528600e-16, -1.079647855201148e-17,  6.204444984801319e-19,  1.240216858088582e+00, -1.494996039465575e-02,  1.618199187154402e-04,
 -5.119451096875453e-07, -6.224415952395381e-08,  2.771053757150288e-09, -5.634475333902636e-11, -3.105142443482083e-13,  6.196811525850444e-14, -1.919554052446183e-15,
  1.094440544167906e-17,  1.349455317141544e-18,  2.552743770354144e-02, -2.963008576538617e-04,  3.379297339597964e-06, -3.451421635465355e-08,  1.726965086745897e-10,
  5.075596578159726e-12, -1.661487605501252e-13,  2.462200950719745e-16,  1.348089068883265e-16, -4.391109265358439e-18,  2.126467586702133e-20,  3.016943234776912e-21,
  7.620788408097295e-02, -8.845116631244139e-04,  1.008231600164962e-05, -1.025489135186413e-07,  4.884470799394625e-10,  1.620558087197583e-11, -5.225195456415016e-13,
  9.860855217498974e-16,  4.132799971295483e-16, -1.364276465483891e-17,  7.101829960079879e-20,  9.236232348828487e-21,  1.542142772157529e-01, -1.789748378052952e-03,
  2.038249452914987e-05, -2.058833009469586e-07,  8.971117376229866e-10,  3.636282975425703e-11, -1.148137894454990e-12,  2.890697374703617e-15,  8.722847802431468e-16,
 -2.944096012850443e-17,  1.710341919205663e-19,  1.942962041243900e-20,  2.623837857274837e-01, -3.044729402929891e-03,  3.462656267399105e-05, -3.459814544462187e-07,
  1.283747249550087e-09,  7.144388246538317e-11, -2.200932581670890e-12,  7.512362640443447e-15,  1.577343232291519e-15, -5.511100422633592e-17,  3.720736109045709e-19,
  3.486055131311349e-20,  4.054434287628805e-01, -4.703884986005305e-03,  5.338050731664642e-05, -5.242595606201796e-07,  1.394569962021718e-09,  1.339915367283898e-10,
 -4.025816020666626e-12,  1.874958249398180e-14,  2.653485303809310e-15, -9.789178433751399e-17,  8.054138186569454e-19,  5.753349857703742e-20,  5.916074653621165e-01,
 -6.861563585742948e-03,  7.759355131616397e-05, -7.401148221626233e-07,  5.972101502396109e-10,  2.544391632675406e-10, -7.495220689110374e-12,  4.828864625263900e-14,
  4.350521615632582e-15, -1.759472992729442e-16,  1.879803228861745e-18,  8.942263867139713e-20,  8.369556688663924e-01, -9.701618106515651e-03,  1.089987982296816e-04,
 -9.808248227605660e-07, -3.096904563794439e-09,  5.280518848817439e-10, -1.553356248387414e-11,  1.445867615949031e-13,  7.147020978307917e-15, -3.484028160311863e-16,
  5.369612432490676e-18,  1.179708899049665e-19,  1.182948275934380e+00, -1.369317117677064e-02,  1.512919697985472e-04, -1.137651882138247e-06, -2.014500269812575e-08,
  1.479785765828151e-09, -4.659637173033056e-11,  7.264808593194893e-13,  9.010168137855470e-15, -9.262994873870704e-16,  2.709323232107825e-17, -2.539918653196881e-19,
  2.439375471304488e-02, -2.708698395305469e-04,  2.984377317747158e-06, -3.114629317810982e-08,  2.368281331152312e-10,  1.522890881238089e-12, -1.203633929020136e-13,
  2.371927887003545e-15,  1.174064286495253e-17, -2.184314092488266e-18,  6.364974475868834e-20, -4.565700611105149e-22,  7.282357539465348e-02, -8.086222831126236e-04,
  8.907186833957107e-06, -9.279145504863218e-08,  6.953085775945050e-10,  5.071459296978934e-12, -3.763637523098071e-13,  7.439145772718140e-15,  3.307201114513606e-17,
 -6.701081338964828e-18,  1.976297148778307e-19, -1.486690824816612e-21,  1.473661619866112e-01, -1.636280935730675e-03,  1.801735323534262e-05, -1.871361863387205e-07,
  1.367791314071471e-09,  1.203176071299031e-11, -8.194151392339881e-13,  1.628498583874204e-14,  5.947845249246108e-17, -1.415771482273879e-17,  4.259596762238763e-19,
 -3.450148522759644e-21,  2.507332120107117e-01, -2.783884189072885e-03,  3.063627529048364e-05, -3.167283724927469e-07,  2.223692973861738e-09,  2.517347822014578e-11,
 -1.549502256053595e-12,  3.108411157794786e-14,  7.802117431487833e-17, -2.563194024747078e-17,  7.954943849241786e-19, -7.151458389706853e-21,  3.874428960352856e-01,
 -4.301455051781445e-03,  4.729551875737545e-05, -4.854451195254092e-07,  3.187602074347010e-09,  5.032083540082620e-11, -2.777941282028542e-12,  5.662946603565944e-14,
  5.105619756184258e-17, -4.316856187011562e-17,  1.406490391212102e-18, -1.457588310917019e-20,  5.653471222173947e-01, -6.275851807417641e-03,  6.890756188947441e-05,
 -6.989489871580996e-07,  4.055449904599505e-09,  1.013061444974950e-10, -5.014256591751814e-12,  1.051897909515603e-13, -1.497346673128285e-16, -7.080462216465086e-17,
  2.502953039573004e-18, -3.153284077103818e-20,  7.998183477882391e-01, -8.876870377137294e-03,  9.721908612938846e-05, -9.644339688183804e-07,  4.154264742300619e-09,
  2.197042513805287e-10, -9.843485900625989e-12,  2.184756400615164e-13, -1.116718915415029e-15, -1.160306503124015e-16,  4.830662740354315e-18, -8.098502860999091e-20,
  1.130504577074300e+00, -1.254103208286614e-02,  1.365056479999076e-04, -1.276791982114726e-06, -2.202387131593169e-11,  6.141472035617984e-10, -2.589952238480429e-11,
  6.623342905525107e-13, -8.381067846818350e-15, -1.463056939124659e-16,  1.153189691270798e-17, -3.281003200895423e-19,  2.335575112026544e-02, -2.484240182572391e-04,
  2.633915828778945e-06, -2.724775811252291e-08,  2.437490990983235e-10, -5.828395194999718e-13, -5.732956232510197e-14,  1.923369381938288e-15, -2.846384711258837e-17,
 -2.871314520014601e-19,  2.902884075393917e-20, -8.020761375286294e-22,  6.972482267541320e-02, -7.416247823112420e-04,  7.862389875188156e-06, -8.127524236125093e-08,
  7.231397404103172e-10, -1.514761143146292e-12, -1.796649247812181e-13,  5.980665147109731e-15, -8.931686077486240e-17, -8.440370117043603e-19,  8.899061279527007e-20,
 -2.485980995553575e-21,  1.410956350805503e-01, -1.500740493576454e-03,  1.590792866590140e-05, -1.642410093961879e-07,  1.448212031384771e-09, -2.310366881223066e-12,
 -3.922664352248992e-13,  1.291318225882905e-14, -1.957243240791309e-16, -1.652852840392781e-18,  1.877714908220666e-19, -5.341792193267364e-21,  2.400646738909112e-01,
 -2.553365509802221e-03,  2.705987976516425e-05, -2.788499943427314e-07,  2.424359580633451e-09, -1.940380655568133e-12, -7.436890622884452e-13,  2.415185713032796e-14,
 -3.743198841344254e-16, -2.618948952304285e-18,  3.391985975657431e-19, -9.926399739498610e-21,  3.709582087525900e-01, -3.945469649728668e-03,  4.179911290726248e-05,
 -4.294870203307245e-07,  3.651905026219040e-09,  1.777613518006941e-12, -1.334432189467395e-12,  4.271475340433439e-14, -6.843525168289846e-16, -3.396712708444058e-18,
  5.690466705386612e-19, -1.740573903840352e-20,  5.412948285675868e-01, -5.756921430265829e-03,  6.095783856960598e-05, -6.234236982039233e-07,  5.106204967787736e-09,
  1.402698540513886e-11, -2.399112855256125e-12,  7.586189673033040e-14, -1.279098302146299e-15, -2.632165644266115e-18,  9.264686188981556e-19, -3.051657914401166e-20,
  7.657950172319208e-01, -8.144020106683875e-03,  8.615353783321270e-05, -8.736794596861629e-07,  6.648454336058618e-09,  5.012724066818734e-11, -4.629834266968267e-12,
  1.460920505950262e-13, -2.684744429615364e-15,  6.472204526337599e-18,  1.493436269887536e-18, -5.705600029321170e-20,  1.082428484189834e+00, -1.150953586633494e-02,
  1.214938009665151e-04, -1.206929765820702e-06,  7.379471799610688e-09,  1.824831595839380e-10, -1.141106894897539e-11,  3.744232175474103e-13, -8.249689107684736e-15,
  8.938847000873733e-17,  1.782684718308728e-18, -1.225754216300986e-19,  2.240221879233610e-02, -2.285955727071516e-04,  2.329761251659021e-06, -2.349938212273220e-08,
  2.221470424794144e-10, -1.418526355043596e-12, -1.654436396586529e-14,  1.010172769133389e-15, -2.517679020528901e-17,  3.053181232066624e-19,  4.157588055736921e-21,
 -3.265940263783861e-22,  6.687821791429051e-02, -6.824337470397886e-04,  6.954890944104641e-06, -7.013068342806451e-08,  6.615744941100655e-10, -4.148541640990036e-12,
 -5.300705733631045e-14,  3.134556741443383e-15, -7.811669912387074e-17,  9.595792891875364e-19,  1.232096992131803e-20, -9.997993321020284e-22,  1.353352656266671e-01,
 -1.380972996571923e-03,  1.407318770964654e-05, -1.418408694215765e-07,  1.333411844265305e-09, -8.107197239579931e-12, -1.193836899851072e-13,  6.743491733906048e-15,
 -1.681169932312304e-16,  2.108207550243644e-18,  2.449560343928437e-20, -2.104564140192403e-21,  2.302638977296563e-01, -2.349620054395173e-03,  2.394256510167086e-05,
 -2.411352497121580e-07,  2.254756567416521e-09, -1.304011098518338e-11, -2.350567864782913e-13,  1.253754352450516e-14, -3.130650283852532e-16,  4.047485184248703e-18,
  3.995472171286614e-20, -3.787224855095670e-21,  3.558138688445954e-01, -3.630705571617987e-03,  3.699239149175749e-05, -3.721502725409989e-07,  3.451265260716263e-09,
 -1.836053277019791e-11, -4.397582575352873e-13,  2.195610294302777e-14, -5.506438783411898e-16,  7.440966071596902e-18,  5.540525348541885e-20, -6.313892301491253e-21,
  5.191970553245122e-01, -5.297789925669148e-03,  5.396784855793588e-05, -5.419686303321033e-07,  4.959479763237197e-09, -2.257702567137164e-11, -8.245649079958380e-13,
  3.832994819983406e-14, -9.713166381517612e-16,  1.401617895603793e-17,  5.675873521830079e-20, -1.016739218428922e-20,  7.345336054211732e-01, -7.494876853932004e-03,
  7.632455573624748e-05, -7.640990519558709e-07,  6.823072485983313e-09, -2.108816635988506e-11, -1.649045993038498e-12,  7.137384296094960e-14, -1.854122335293494e-15,
  2.972080987376464e-17, -2.920133398533288e-20, -1.602081478473579e-20,  1.038245611662020e+00, -1.059331451197100e-02,  1.077998486443485e-04, -1.071471965752424e-06,
  8.999208658327475e-09,  7.844843471875084e-12, -4.089736596504784e-12,  1.676421113404843e-13, -4.676574248253438e-15,  9.192078097895023e-17, -8.984253999363788e-19,
 -1.764869491611072e-20,  2.152340906452069e-02, -2.110272837981443e-04,  2.068111302863281e-06, -2.018545191253437e-08,  1.916718359786435e-10, -1.556480189907592e-12,
  2.212444356737349e-15,  3.909238345535166e-16, -1.368170810344044e-17,  2.870675240541798e-19, -3.033091501991622e-21, -4.560747434553909e-23,  6.425467657234486e-02,
 -6.299875698937518e-04,  6.173942189698335e-06, -6.025319249560005e-08,  5.716733971853738e-10, -4.616396114377573e-12,  5.238377997541056e-15,  1.216845769968082e-15,
 -4.229953559458444e-17,  8.897645081651162e-19, -9.546349310494422e-21, -1.352410959999994e-22,  1.300262595864651e-01, -1.274846225419147e-03,  1.249340090662677e-05,
 -1.219049123213557e-07,  1.155078452637766e-09, -9.241279736869479e-12,  6.042250975097060e-15,  2.629224791578219e-15, -9.049759221109368e-17,  1.911856757732314e-18,
 -2.102068969628425e-20, -2.692137796871488e-22,  2.212310100916389e-01, -2.169062028122503e-03,  2.125608035926961e-05, -2.073513070741114e-07,  1.960715230049046e-09,
 -1.546180069815485e-11, -1.645649168972928e-15,  4.912655295477588e-15, -1.669884306711313e-16,  3.552539027788147e-18, -4.048528233938926e-20, -4.403050524563099e-22,
  3.418559263048171e-01, -3.351721638789467e-03,  3.284442613335588e-05, -3.202647280442912e-07,  3.019088968419040e-09, -2.327665115045115e-11, -3.081882597701320e-14,
  8.642533608251253e-15, -2.895898386114064e-16,  6.230774881268992e-18, -7.474225881913603e-20, -6.149611299439843e-22,  4.988300439068105e-01, -4.890752379951922e-03,
  4.792280924505926e-05, -4.669968167265383e-07,  4.380802821317122e-09, -3.253532362173541e-11, -1.113977912294508e-13,  1.511710235940198e-14, -4.992768578315001e-16,
  1.094929539243086e-17, -1.415165035101358e-19, -6.496716480906972e-22,  7.057197831504519e-01, -6.919144384891362e-03,  6.779109157328517e-05, -6.598831327661159e-07,
  6.136843334577765e-09, -4.243383863336938e-11, -3.279004944622798e-13,  2.796859630891083e-14, -9.144594073094090e-16,  2.078090067491828e-17, -3.015744245032523e-19,
  1.897976307643538e-22,  9.975191554349123e-01, -9.779914500673059e-03,  9.579772011441164e-05, -9.302342300025258e-07,  8.479379303066173e-09, -4.810490727072407e-11,
 -1.047828043958602e-12,  6.323518631548394e-14, -2.091928164297291e-15,  5.169221561692201e-17, -9.283930409428524e-19,  8.573685412096922e-21,  2.071092614093109e-02,
 -1.954014921737298e-04,  1.843276719998718e-06, -1.736190924104451e-08,  1.617414310240822e-10, -1.412848439232126e-12,  8.403550683978013e-15,  9.323608519119771e-17,
 -5.706225119670097e-18,  1.572972402095747e-19, -2.932780337021340e-21,  2.845921404186649e-23,  6.182914051067460e-02, -5.833396154241607e-04,  5.502785631725661e-06,
 -5.182902640064903e-08,  4.826874395782231e-10, -4.207970634028477e-12,  2.461509791683207e-14,  2.968826691945055e-16, -1.763503277740948e-17,  4.854415896552897e-19,
 -9.084165870607682e-21,  8.961666237677689e-23,  1.251179295472038e-01, -1.180450165169752e-03,  1.113541164393067e-05, -1.048744852041331e-07,  9.762225280515780e-10,
 -8.482602816259947e-12,  4.824177460499685e-14,  6.625820838292381e-16, -3.769471441833377e-17,  1.035711465470832e-18, -1.949935118530638e-20,  1.974751722563290e-22,
  2.128798227135462e-01, -2.008456256344113e-03,  1.894598630612163e-05, -1.784185931264660e-07,  1.659564609225509e-09, -1.434794754282753e-11,  7.799826984206592e-14,
  1.288892931566862e-15, -6.941777100701088e-17,  1.903793340558567e-18, -3.618000071706132e-20,  3.806733089984066e-22,  3.289513232203687e-01, -3.103553045523579e-03,
  2.927577400062761e-05, -2.756578724903397e-07,  2.561151270136624e-09, -2.197347979070599e-11,  1.109364606699594e-13,  2.374075703647137e-15, -1.198919474980996e-16,
  3.284625673552273e-18, -6.332555449229433e-20,  7.034080533333517e-22,  4.799999241472819e-01, -4.528643974681559e-03,  4.271778509240969e-05, -4.021391740410491e-07,
  3.729718398015433e-09, -3.160993070271494e-11,  1.396630888322359e-13,  4.360267457278618e-15, -2.049575961338285e-16,  5.624025741640275e-18, -1.109426284961948e-19,
  1.332218342184775e-21,  6.790799813264183e-01, -6.406886990111837e-03,  6.043284156162276e-05, -5.686958148941925e-07,  5.258450641708961e-09, -4.360246893068716e-11,
  1.419696419348244e-13,  8.454919469183306e-15, -3.683835785669935e-16,  1.019890490959399e-17, -2.094355875536051e-19,  2.832086679291107e-21,  9.598647147169992e-01,
 -9.055957083032294e-03,  8.541411503774102e-05, -8.031417475190664e-07,  7.376552522110290e-09, -5.808722145482345e-11,  1.886696784341061e-14,  1.970640539697264e-14,
 -7.994909750085052e-16,  2.290125912523246e-17, -5.134523833811099e-19,  8.577491843617035e-21,  1.995755246552233e-02, -1.814467296139192e-04,  1.649565665889597e-06,
 -1.498856791219377e-08,  1.356255983502399e-10, -1.195982270277776e-12,  9.162788187892645e-15, -1.877393138424080e-17, -1.829912466498581e-18,  6.703412946745461e-20,
 -1.595871500673858e-21,  2.726791308363899e-23,  5.958006480729709e-02, -5.416800102104048e-04,  4.924507388043605e-06, -4.474534174816700e-08,  4.048394574324109e-10,
 -3.567381498677347e-12,  2.720197190054827e-14, -4.973030438906295e-17, -5.682698222218139e-18,  2.065386518635175e-19, -4.919770193390085e-21,  8.441278782504009e-23,
  1.205666834250509e-01, -1.096147776895041e-03,  9.965252634218756e-06, -9.054498655676199e-08,  8.190748115076386e-10, -7.208964858200196e-12,  5.454253892709227e-14,
 -7.966105862611279e-17, -1.223171873483499e-17,  4.394232808958478e-19, -1.047886084812281e-20,  1.810270924029039e-22,  2.051361830633296e-01, -1.865022159757702e-03,
  1.695516545040155e-05, -1.540510473876170e-07,  1.393186248093936e-09, -1.223975095074465e-11,  9.149760781457980e-14, -8.104981520160466e-17, -2.272307467001301e-17,
  8.040596727420508e-19, -1.921553160210646e-20,  3.354263976213972e-22,  3.169855141593560e-01, -2.881914173187939e-03,  2.619976186044377e-05, -2.380345064762906e-07,
  2.151855220654578e-09, -1.885352816822596e-11,  1.383490531601235e-13,  2.560007327184583e-18, -3.962994605797789e-17,  1.377030106689516e-18, -3.304259978879035e-20,
  5.859004507823213e-22,  4.625396407844273e-01, -4.205236595364916e-03,  3.822998133879927e-05, -3.473088540711911e-07,  3.137789299505059e-09, -2.737478762080101e-11,
  1.949256304170408e-13,  2.989836645699384e-16, -6.838196826350924e-17,  2.328274670621363e-18, -5.631041147512300e-20,  1.023162412613532e-21,  6.543780717170282e-01,
 -5.949356115378494e-03,  5.408529575779922e-05, -4.912915218679596e-07,  4.434013517116013e-09, -3.839908490925815e-11,  2.587098439899734e-13,  1.158799986331736e-15,
 -1.235367573444239e-16,  4.122605089112197e-18, -1.013662268302602e-19,  1.920017654061788e-21,  9.249491907627969e-01, -8.409275926884259e-03,  7.644671137626348e-05,
 -6.942421658150051e-07,  6.251861098973941e-09, -5.326695343957068e-11,  3.120890519360669e-13,  4.018288459856063e-15, -2.644534461092017e-16,  8.734056266201684e-18,
 -2.241050690886538e-19,  4.632252229696031e-21,  1.925706924627093e-02, -1.689345069333974e-04,  1.481971543193945e-06, -1.299824033565244e-08,  1.138362786411513e-10,
 -9.871570609609797e-13,  8.104751113383697e-15, -4.891947189623351e-17, -3.111537009976969e-19,  2.338665426292142e-20, -6.803484107919647e-22,  1.457625389925720e-23,
  5.748888483397173e-02, -5.043268067256556e-04,  4.424186288436409e-06, -3.880398723071470e-08,  3.398260645655641e-10, -2.946112938885149e-12,  2.414927704622250e-14,
 -1.440356627565340e-16, -1.002643748381912e-18,  7.212833634380206e-20, -2.092774711126952e-21,  4.490090413419113e-23,  1.163349555929124e-01, -1.020559628795030e-03,
  8.952812817266003e-06, -7.852349293220701e-08,  6.876291198606386e-10, -5.958857938871053e-12,  4.871625938226605e-14, -2.848342645378701e-16, -2.273658098791782e-18,
  1.536529796256043e-19, -4.441174199498479e-21,  9.551871002070336e-23,  1.979361806128332e-01, -1.736414177812563e-03,  1.523260199747824e-05, -1.336010687928116e-07,
  1.169838512314874e-09, -1.013110466046170e-11,  8.249495349277736e-14, -4.674722554092531e-16, -4.503482395890346e-18,  2.814934593484293e-19, -8.097483963867085e-21,
  1.748419080050116e-22,  3.058597530300570e-01, -2.683183923825247e-03,  2.353806191902129e-05, -2.064430277675927e-07,  1.807418528111436e-09, -1.563775732259306e-11,
  1.265661105586929e-13, -6.824367354684292e-16, -8.445801247582394e-18,  4.822984149416873e-19, -1.380078137889860e-20,  2.998799696191465e-22,  4.463051307630111e-01,
 -3.915254050140939e-03,  3.434625782390414e-05, -3.012307552923454e-07,  2.636754409099081e-09, -2.277948004378666e-11,  1.826247893351641e-13, -9.046669264963129e-16,
 -1.574937602828813e-17,  8.140016579675394e-19, -2.318107206696247e-20,  5.090936936193972e-22,  6.314103023365472e-01, -5.539105838035753e-03,  4.859122631854813e-05,
 -4.261492951069782e-07,  3.728933807741687e-09, -3.213452797585835e-11,  2.534017323952655e-13, -1.057172421753704e-15, -3.077741032067220e-17,  1.429985883033970e-18,
 -4.065563275502379e-20,  9.106109060119098e-22,  8.924847694925883e-01, -7.829403544053048e-03,  6.868221626481064e-05, -6.023039023042515e-07,  5.266631059466826e-09,
 -4.514545104293181e-11,  3.430884809311856e-13, -8.012579398916240e-16, -7.070295008531059e-17,  2.943703205985210e-18, -8.466361971341812e-20,  1.984527619136845e-21,
  1.860409671544276e-02, -1.576731208361994e-04,  1.336302349948691e-06, -1.132471402494218e-08,  9.592422091469731e-11, -8.095872822270649e-13,  6.691102576470652e-15,
 -4.958340099880982e-17,  1.685756305483714e-19,  6.123497219523918e-21, -2.440691152452904e-22,  6.149738518798211e-24,  5.553954032306525e-02, -4.707077555959807e-04,
  3.989315469116900e-06, -3.380806831442920e-08,  2.863625772640043e-10, -2.416644965959169e-12,  1.996188329842386e-14, -1.474222788270447e-16,  4.801662102577474e-19,
  1.904414584744147e-20, -7.504502189690215e-22,  1.889688853700672e-23,  1.123902469083748e-01, -9.525278774054723e-04,  8.072808584990828e-06, -6.841412293548083e-08,
  5.794731840048101e-10, -4.889527115086469e-12,  4.035112769458403e-14, -2.963416640321799e-16,  8.953072593086033e-19,  4.106923473185942e-20, -1.591195946840777e-21,
  4.003578664687211e-23,  1.912245216200179e-01, -1.620662740368901e-03,  1.373534295609602e-05, -1.164016985877980e-07,  9.859034938388184e-10, -8.317121195366374e-12,
  6.854216329347978e-14, -4.991032273987682e-16,  1.326169944756588e-18,  7.643781007212605e-20, -2.896346434528777e-21,  7.282406685849046e-23,  2.954886006754462e-01,
 -2.504319806963460e-03,  2.122445276734089e-05, -1.798682038854722e-07,  1.523389701472654e-09, -1.284720820460812e-11,  1.056552855593677e-13, -7.594422540281543e-16,
  1.591245332587130e-18,  1.334501746046055e-19, -4.920556444816928e-21,  1.237091702607825e-22,  4.311717299069391e-01, -3.654258990102323e-03,  3.097032878005262e-05,
 -2.624586041390094e-07,  2.222743378571780e-09, -1.873576372309479e-11,  1.535888285375639e-13, -1.081517499758689e-15,  1.279131442511565e-18,  2.299577231967248e-19,
 -8.213409287170385e-21,  2.068287507905089e-22,  6.100003214078927e-01, -5.169863677600355e-03,  4.381524281755069e-05, -3.713089965010900e-07,  3.144253389196499e-09,
 -2.648133136183972e-11,  2.159072672803878e-13, -1.466039765436395e-15, -7.273082560847443e-19,  4.122866151018776e-19, -1.421537567326445e-20,  3.601561048824028e-22,
  8.622222311922928e-01, -7.307489644851016e-03,  6.193178964263454e-05, -5.248248632766016e-07,  4.443267188317916e-09, -3.735796887958688e-11,  3.010975859485342e-13,
 -1.879299097785945e-15, -8.849682896594152e-18,  8.582635223002764e-19, -2.859260856791807e-20,  7.395773808660604e-22,  1.799395967253076e-02, -1.475013730990391e-04,
  1.209107183639283e-06, -9.911194285205497e-09,  8.122969132790331e-11, -6.649035437757484e-13,  5.400613597902296e-15, -4.210644909156754e-17,  2.651868321421596e-19,
  3.632639146423957e-22, -7.231241195547814e-23,  2.217853262871543e-24,  5.371807425998362e-02, -4.403416395025401e-04,  3.609595044670034e-06, -2.958826583626514e-08,
  2.424971977483575e-10, -1.984895986004991e-12,  1.611897741290810e-14, -1.255305423800991e-16,  7.848425186854981e-19,  1.320114643715370e-21, -2.229704325221201e-22,
  6.807731313883398e-24,  1.087043139957488e-01, -8.910787738673344e-04,  7.304404353094973e-06, -5.987500760199922e-08,  4.907159808466102e-10, -4.016432282088631e-12,
  3.260637591458463e-14, -2.534601422059835e-16,  1.565690097298353e-18,  3.450172723278093e-21, -4.747065252247438e-22,  1.439659479115091e-23,  1.849531522394223e-01,
 -1.516111196984095e-03,  1.242795681288186e-05, -1.018732424771486e-07,  8.349123250243863e-10, -6.833134439997129e-12,  5.544662102782376e-14, -4.297991811348050e-16,
  2.606031136006262e-18,  7.878492508581136e-21, -8.685242640947778e-22,  2.610857952490161e-23,  2.857978030286925e-01, -2.342762164569301e-03,  1.920422745785045e-05,
 -1.574188284811481e-07,  1.290124766592814e-09, -1.055759011185297e-11,  8.560772203789575e-14, -6.608213860574583e-16,  3.893365659748215e-18,  1.683202257687462e-20,
 -1.484021855210476e-21,  4.413519709274366e-23,  4.170310899175881e-01, -3.418517014315929e-03,  2.802246429254622e-05, -2.297022864732675e-07,  1.882485897341553e-09,
 -1.540263185402303e-11,  1.247595487217718e-13, -9.568177726243062e-16,  5.380054607270788e-18,  3.513749681487964e-20, -2.490593797892299e-21,  7.317701573906670e-23,
  5.899948476435940e-01, -4.836347821403234e-03,  3.964477956578575e-05, -3.249702737337407e-07,  2.663152011189338e-09, -2.178432174706160e-11,  1.761334595233140e-13,
 -1.336034109909415e-15,  6.890890740275732e-18,  7.532666595094049e-20, -4.322115204017219e-21,  1.254455238472178e-22,  8.339449290102686e-01, -6.836072675783669e-03,
  5.603701090239243e-05, -4.593353995471945e-07,  3.764040433324443e-09, -3.077305930147803e-11,  2.478943304175938e-13, -1.836808026877062e-15,  7.587475727749927e-18,
  1.847244046676597e-19, -8.613383521693690e-21,  2.482491377648615e-22,  1.742257655933417e-02, -1.382831252989838e-04,  1.097553824699414e-06, -8.711245000653231e-09,
  6.913721788025721e-11, -5.484815097870605e-13,  4.339346416582130e-15, -3.381488683315043e-17,  2.443500224959914e-19, -1.142165592533653e-21, -1.393835125246505e-23,
  6.886362589335239e-25,  5.201230182071186e-02, -4.128220428747743e-04,  3.276570498640390e-06, -2.600601881677105e-08,  2.063977991756983e-10, -1.637386046416612e-12,
  1.295343937922079e-14, -1.009019971742064e-16,  7.275418386546410e-19, -3.340943380911497e-21, -4.376897928537314e-23,  2.115517686013445e-24,  1.052524995892208e-01,
 -8.353899049606228e-04,  6.630493533269431e-06, -5.262597304622409e-08,  4.176673728966192e-10, -3.313370403684084e-12,  2.620946176000326e-14, -2.040320238291943e-16,
  1.465924761767643e-18, -6.534010224246365e-21, -9.569873265769727e-23,  4.478636089178192e-24,  1.790801198745788e-01, -1.421360298208042e-03,  1.128134305565455e-05,
 -8.953956515503469e-08,  7.106311365528307e-10, -5.637334819032466e-12,  4.458545367375078e-14, -3.467535840492624e-16,  2.477957636614233e-18, -1.053505326419129e-20,
 -1.811836832736843e-22,  8.131169417158597e-24,  2.767225333060409e-01, -2.196348887195363e-03,  1.743243052043580e-05, -1.383604480956950e-07,  1.098093980555385e-09,
 -8.710731814397856e-12,  6.887674048214858e-14, -5.349200798860707e-16,  3.791847873778753e-18, -1.493798568737250e-20, -3.224788175883002e-22,  1.375464529899120e-23,
  4.037886172009696e-01, -3.204873372366876e-03,  2.543709272324426e-05, -2.018929963610645e-07,  1.602308922861744e-09, -1.270982481405093e-11,  1.004624451058366e-13,
 -7.785492684704621e-16,  5.449895446078696e-18, -1.878197763266725e-20, -5.668127462185402e-22,  2.278835873285682e-23,  5.712600558897857e-01, -4.534095461880317e-03,
  3.598713158560625e-05, -2.856279035263460e-07,  2.266843290920361e-09, -1.797956832065535e-11,  1.420335254076769e-13, -1.096783836806336e-15,  7.514169963538338e-18,
 -1.938538860312342e-20, -1.033981875046357e-21,  3.888169814401199e-23,  8.074637072558327e-01, -6.408845628232296e-03,  5.086702441674167e-05, -4.037281216934987e-07,
  3.204068686386126e-09, -2.540911022686878e-11,  2.004913017223481e-13, -1.536920557457157e-15,  1.005083645979279e-17, -6.107011269583135e-21, -2.164063621679383e-21,
  7.557455288260731e-23  };
  constexpr double w[3072] = {  9.808305001404527e-04, -8.525743404185991e-05,  4.631499868303499e-06, -1.996482652114272e-07,  7.432193517616773e-09,
 -2.489660184887804e-10,  7.684388694814938e-12, -2.218669654822303e-13,  6.054763500102830e-15, -1.573534673195986e-16,  3.916224737011773e-18, -9.369717439073596e-20,
  6.723353627528778e-03, -8.495905026384545e-04,  6.551889577844250e-05, -3.891050077391200e-06,  1.941296044106437e-07, -8.507539060237068e-09,  3.363535121904978e-10,
 -1.220950350737673e-11,  4.119699354442858e-13, -1.303876290165898e-14,  3.897709812953880e-16, -1.105677255086257e-17,  1.944557177544501e-02, -3.503239884730586e-03,
  3.666350386466737e-04, -2.847015132431598e-05,  1.804519289689331e-06, -9.814154262290005e-08,  4.721282329823701e-09, -2.050104104741271e-10,  8.151502980227251e-12,
 -2.999680769606017e-13,  1.030019351110188e-14, -3.318772245092534e-16,  3.593169837856226e-02, -8.687105732492007e-03,  1.171088719806077e-03, -1.134834239966909e-04,
  8.754972977839871e-06, -5.678308850367386e-07,  3.201851721005514e-08, -1.605519708867607e-09,  7.275878746873232e-11, -3.016237566709873e-12,  1.154579088448181e-13,
 -4.107173784884062e-15,  4.904083206121176e-02, -1.487470396072873e-02,  2.453310863736320e-03, -2.839986202353539e-04,  2.565607187496474e-05, -1.916048815758101e-06,
  1.226283141406150e-07, -6.892438700421062e-09,  3.462791244207687e-10, -1.575926327365122e-11,  6.564632219109115e-13, -2.520824562462372e-14,  5.202871259716935e-02,
 -1.858348169771923e-02,  3.566649954829269e-03, -4.726963163573836e-04,  4.817343155366666e-05, -4.006688675138010e-06,  2.823941587879965e-07, -1.730788279518821e-08,
  9.399829061292408e-10, -4.588660765880344e-11,  2.036128591869978e-12, -8.276041844264777e-14,  4.187420411558754e-02, -1.664618162098687e-02,  3.542303338690034e-03,
 -5.153934267705111e-04,  5.710105205330913e-05, -5.117490034186796e-06,  3.856074941846714e-07, -2.509131509431859e-08,  1.437802817172016e-09, -7.364936272009145e-11,
  3.412324045394392e-12, -1.441687871680229e-13,  2.036296397522538e-02, -8.570176077443970e-03,  1.930087801036888e-03, -2.957330404255410e-04,  3.432385434335261e-05,
 -3.206861078185185e-06,  2.508008214615873e-07, -1.687175636930078e-08,  9.960195697295673e-10, -5.239766467229015e-11,  2.486309021346224e-12, -1.073076110884904e-13,
  7.011574146652397e-04, -5.608941219395592e-05,  2.812402054979377e-06, -1.123233697450069e-07,  3.888251145697423e-09, -1.215178553157658e-10,  3.509514834773010e-12,
 -9.506369349508958e-14,  2.439764130946596e-15, -5.976133161758689e-17,  1.404775247089025e-18, -3.180799159811513e-20,  4.138066949909824e-03, -4.699730906655662e-04,
  3.300514663312932e-05, -1.801669382895131e-06,  8.319839338975404e-08, -3.393536522774374e-09,  1.254538679354738e-10, -4.275279081269928e-12,  1.359089614116876e-13,
 -4.065557961753755e-15,  1.152020777495650e-16, -3.106303965510583e-18,  9.671999831723035e-03, -1.562981555279303e-03,  1.491086526495961e-04, -1.066992562460802e-05,
  6.282856915553404e-07, -3.195057808270713e-08,  1.444939558766179e-09, -5.925555456257213e-11,  2.234115734029511e-12, -7.823799538793843e-14,  2.564899762304667e-15,
 -7.914019420189937e-17,  1.378768990825579e-02, -3.036415873746489e-03,  3.775920179350870e-04, -3.408536866929400e-05,  2.468437383984255e-06, -1.512243588190038e-07,
  8.096606281078761e-09, -3.872184204911035e-10,  1.680179849936768e-11, -6.692081468296862e-13,  2.468773930645330e-14, -8.487786424203650e-16,  1.422153858314795e-02,
 -4.028310865354925e-03,  6.249161748000097e-04, -6.853363869690987e-05,  5.900824691167826e-06, -4.221355659889673e-07,  2.599048433865025e-08, -1.410493171981754e-09,
  6.864185533235152e-11, -3.034493864578905e-12,  1.230930157230835e-13, -4.613484073716979e-15,  1.155377869975396e-02, -3.958129721014028e-03,  7.306643641088464e-04,
 -9.353284754777941e-05,  9.242220801062652e-06, -7.477891177412637e-07,  5.141776130553465e-08, -3.082041064338693e-09,  1.640540527266538e-10, -7.864051217430224e-12,
  3.432285720226763e-13, -1.374282993238014e-14,  7.488071122202851e-03, -2.919081379417599e-03,  6.094790039398399e-04, -8.716348282941126e-05,  9.509045338608037e-06,
 -8.405062269327044e-07,  6.255029514314417e-08, -4.024755343202023e-09,  2.283039902922616e-10, -1.158752180788225e-11,  5.324025522485959e-13, -2.232321978815835e-14,
  3.187688417065179e-03, -1.333473491858613e-03,  2.984524003535625e-04, -4.546504032522211e-05,  5.248718636598900e-06, -4.879841615086087e-07,  3.799215986664579e-08,
 -2.545176601779072e-09,  1.496768895209008e-10, -7.846031719067118e-12,  3.710681013432303e-13, -1.596580425248899e-14,  5.145438401601060e-04, -3.808301429297230e-05,
  1.770276644322768e-06, -6.574621106870046e-08,  2.122953235439563e-09, -6.206724261793716e-11,  1.681252883563803e-12, -4.281379687483642e-14,  1.035212650292806e-15,
 -2.393724637626641e-17,  5.321516680653985e-19, -1.141611780183009e-20,  2.675606720026927e-03, -2.740487601009562e-04,  1.756918264081370e-05, -8.831930735903987e-07,
  3.780384803624820e-08, -1.436690037427817e-09,  4.970024198769531e-11, -1.590812114088772e-12,  4.765523899341523e-14, -1.347339639425502e-15,  3.618156457275111e-17,
 -9.269450344900962e-19,  5.184724089973204e-03, -7.500064436494994e-04,  6.514866712774227e-05, -4.291527514340109e-06,  2.344989882655592e-07, -1.113652552317194e-08,
  4.728114568826005e-10, -1.828454753163289e-11,  6.526555477021075e-13, -2.171398607445564e-14,  6.784361891385214e-16, -2.000942074144287e-17,  5.806252549986384e-03,
 -1.156310213755966e-03,  1.319785613190113e-04, -1.105168936993599e-05,  7.484769169234301e-07, -4.316120582604826e-08,  2.186935918649046e-09, -9.943826692981507e-11,
  4.118723008375502e-12, -1.571520144505958e-13,  5.571499328491677e-15, -1.846250735597094e-16,  4.531746956632656e-03, -1.187204745859260e-03,  1.719556630956428e-04,
 -1.775607628525515e-05,  1.449337752673074e-06, -9.884711326240194e-08,  5.829545402837882e-09, -3.042688207364616e-10,  1.429119761549672e-11, -6.116470153041489e-13,
  2.408646981166877e-14, -8.785785196361179e-16,  2.765613730377150e-03, -9.011789923099632e-04,  1.588982099520473e-04, -1.953187303651132e-05,  1.861876265166118e-06,
 -1.459027402869827e-07,  9.749236499241630e-09, -5.695449955967521e-10,  2.962112130167916e-11, -1.390405797094134e-12,  5.953893481415901e-14, -2.343031365409571e-15,
  1.397541834172071e-03, -5.317682383159072e-04,  1.084830745089751e-04, -1.519495748386901e-05,  1.627249279748145e-06, -1.414762071260695e-07,  1.037420176041583e-08,
 -6.587254530927247e-10,  3.692235281434375e-11, -1.853857800979885e-12,  8.434784317921036e-14, -3.505370703430853e-15,  5.064029394230297e-04, -2.102794435428409e-04,
  4.671427691379498e-05, -7.067295445164711e-06,  8.107545570235797e-07, -7.494503894734578e-08,  5.804269199507269e-09, -3.869712712200383e-10,  2.265643945861494e-11,
 -1.182803869460137e-12,  5.572820746638632e-14, -2.389425686487812e-15,  3.862460922125064e-04, -2.658105614185915e-05,  1.150291634418956e-06, -3.986653110545278e-08,
  1.204440603594629e-09, -3.302974663993262e-11,  8.411406641037661e-13, -2.017996592931121e-14,  4.605689703870735e-16, -1.007017403099172e-17,  2.120359820279834e-19,
 -4.315177791470224e-21,  1.805485160014803e-03, -1.674329568350023e-04,  9.826755876138113e-06, -4.559265874108418e-07,  1.812143955641088e-08, -6.425791577443882e-10,
  2.082408762841511e-11, -6.265647792330210e-13,  1.769774254791261e-14, -4.730787619267316e-16,  1.204147028696986e-17, -2.930964762482494e-19,  2.972816266897444e-03,
 -3.846676329071865e-04,  3.041885486478690e-05, -1.844151268263180e-06,  9.347185175558365e-08, -4.143010219552769e-09,  1.649997275700831e-10, -6.011566518178053e-12,
  2.029267506123585e-13, -6.406358246965377e-15,  1.905114912293848e-16, -5.363208281688231e-18,  2.672337014816172e-03, -4.782596819824298e-04,  4.990110345305248e-05,
 -3.863255303366801e-06,  2.439307372978449e-07, -1.320186922029273e-08,  6.312792927081375e-10, -2.721558252270985e-11,  1.073187894320113e-12, -3.912442043152114e-14,
  1.329588056553807e-15, -4.235927627024986e-17,  1.591518018210293e-03, -3.818356029899470e-04,  5.126720611105449e-05, -4.954941625029050e-06,  3.814409557494600e-07,
 -2.468669510353471e-08,  1.388693906045329e-09, -6.943919450678309e-11,  3.136464873497294e-12, -1.295225967979094e-13,  4.936006683504878e-15, -1.747088944805450e-16,
  7.200150095717664e-04, -2.210162620835707e-04,  3.693595262054041e-05, -4.331570323209701e-06,  3.961315042411981e-07, -2.991987332384809e-08,  1.934558126769697e-09,
 -1.097271131493763e-10,  5.556792429877876e-12, -2.546256073808404e-13,  1.066761747340688e-14, -4.115523839382820e-16,  2.745354222440884e-04, -1.013597830449568e-04,
  2.009966735077265e-05, -2.745252309912578e-06,  2.875148903357360e-07, -2.450817016345716e-08,  1.765814724053928e-09, -1.103741954877511e-10,  6.099930037137845e-12,
 -3.024073455910671e-13,  1.360196270403763e-14, -5.594357171919511e-16,  8.188884305893429e-05, -3.369551294011158e-05,  7.418034918702392e-06, -1.112971439271849e-06,
  1.267221169956881e-07, -1.163451361482766e-08,  8.955070827667411e-10, -5.936854768497302e-11,  3.458088569066930e-12, -1.796838484797031e-13,  8.429204093683964e-15,
 -3.599724993137796e-16,  2.957009339377894e-04, -1.900863320754013e-05,  7.688117855905481e-07, -2.494932429062816e-08,  7.073238627849600e-10, -1.824190027461460e-11,
  4.377629024015037e-13, -9.915412182122255e-15,  2.140113163380789e-16, -4.432257301105445e-18,  8.852902909463904e-20, -1.711423065138877e-21,  1.264192884519159e-03,
 -1.066002033279936e-04,  5.745244915498598e-06, -2.466283904317474e-07,  9.120908794625682e-09, -3.022773474917718e-10,  9.189325514633968e-12, -2.601975320275059e-13,
  6.935723491332324e-15, -1.754041975470801e-16,  4.233699591280964e-18, -9.793356186379842e-20,  1.809751252845450e-03, -2.095498406386105e-04,  1.509525418922508e-05,
 -8.426427356212359e-07,  3.962561008728536e-08, -1.639175517852899e-09,  6.122303136207365e-11, -2.100564614784886e-12,  6.701511753666497e-14, -2.005982441947352e-15,
  5.672618807633952e-17, -1.522705578675459e-18,  1.336770570532007e-03, -2.139079124520843e-04,  2.034256397802884e-05, -1.452416885140769e-06,  8.530284445179461e-08,
 -4.323215142988793e-09,  1.946545399527683e-10, -7.939034372861059e-12,  2.973734160098198e-13, -1.033512250994737e-14,  3.359150004103517e-16, -1.026606460099585e-17,
  6.164965374775260e-04, -1.341528294250742e-04,  1.658570352271508e-05, -1.492165895740543e-06,  1.078167233354771e-07, -6.592912914245570e-09,  3.523362150183717e-10,
 -1.681564999229804e-11,  7.278761056350495e-13, -2.890726622520349e-14,  1.062786348534060e-15, -3.639500082592339e-17,  2.055937605910867e-04, -5.880708311103448e-05,
  9.236945114101702e-06, -1.026332912087976e-06,  8.951528809011249e-08, -6.483014177296676e-09,  4.037572505272210e-10, -2.214329038951579e-11,  1.087876194835860e-12,
 -4.849938572214474e-14,  1.981892042118843e-15, -7.474958539511506e-17,  5.732776943286320e-05, -2.038409591854247e-05,  3.904332280275545e-06, -5.172379893874091e-07,
  5.273961420026500e-08, -4.390680904443985e-09,  3.097970013874574e-10, -1.900664915029372e-11,  1.033054212949401e-12, -5.045329543351156e-14,  2.238929618681138e-15,
 -9.097143959629995e-17,  1.353228578373334e-05, -5.505177374168062e-06,  1.198506224854866e-06, -1.780090722519961e-07,  2.008494187804303e-08, -1.829071342984366e-09,
  1.397550629274960e-10, -9.203988300247761e-12,  5.328950756815162e-13, -2.753794183755383e-14,  1.285369628028476e-15, -5.464025132780253e-17,  2.303104574085524e-04,
 -1.388775135297188e-05,  5.269043515836638e-07, -1.606214986572803e-08,  4.285131455256520e-10, -1.041950791208000e-11,  2.361570578603132e-13, -5.060608216535502e-15,
  1.034905485812678e-16, -2.033575083562320e-18,  3.859787378169211e-20, -7.096719134408192e-22,  9.139538842382079e-04, -7.038782311627062e-05,  3.494799376149928e-06,
 -1.391659192293328e-07,  4.799197496332726e-09, -1.489256803653489e-10,  4.253641287831009e-12, -1.134926503918638e-13,  2.858008091809949e-15, -6.844243740613763e-17,
  1.567631525356103e-18, -3.447935111679267e-20,  1.161516828791688e-03, -1.205134924455762e-04,  7.918608294709257e-06, -4.074269059799747e-07,  1.778885978149766e-08,
 -6.870839413311511e-10,  2.407208710380312e-11, -7.777687190610815e-13,  2.344703869129173e-14, -6.652210429484204e-16,  1.787898903175652e-17, -4.573159419890254e-19,
  7.220270370635829e-04, -1.029127903253728e-04,  8.903541770096539e-06, -5.853295830440043e-07,  3.192693354564060e-08, -1.512806469004934e-09,  6.403169765015055e-11,
 -2.466380142954501e-12,  8.759920193867701e-14, -2.897090871157109e-15,  8.988951854653833e-17, -2.630268750582179e-18,  2.630197537780574e-04, -5.143910692793739e-05,
  5.821603872295000e-06, -4.851976141787738e-07,  3.276601563968384e-08, -1.885741612219070e-09,  9.539423315413884e-11, -4.330599774472290e-12,  1.790543453361070e-13,
 -6.817557123210956e-15,  2.410936283155130e-16, -7.965324713738922e-18,  6.484378250602621e-05, -1.707827676259066e-05,  2.499244205831940e-06, -2.612295912602237e-07,
  2.159675513419919e-08, -1.491751932685930e-09,  8.906018291694934e-11, -4.702440589540285e-12,  2.232488505280989e-13, -9.648852144027138e-15,  3.833359859146071e-16,
 -1.409222242186016e-17,  1.286951302366043e-05, -4.365886310362323e-06,  8.015502833291809e-07, -1.023469467498820e-07,  1.010590972855110e-08, -8.179704214349129e-10,
  5.629710425630059e-11, -3.378563719627095e-12,  1.800546407028029e-13, -8.640084245377254e-15,  3.773896220975119e-16, -1.511695858036055e-17,  2.297042552972073e-06,
 -9.210326109264885e-07,  1.977381563126632e-07, -2.900534013042961e-08,  3.236704200261143e-09, -2.918721825729603e-10,  2.210630388625012e-11, -1.444449546600222e-12,
  8.303897173906885e-14, -4.263596478375914e-15,  1.978469128756844e-16, -8.365589919057475e-18,  1.821151245758320e-04, -1.034099564772660e-05,  3.692993381817681e-07,
 -1.060732881712193e-08,  2.670046453892959e-10, -6.136208890055409e-12,  1.316350335825924e-13, -2.674098850134812e-15,  5.191927432388632e-17, -9.692068460020816e-19,
  1.751675695491942e-20, -3.068144586654015e-22,  6.793268647364366e-04, -4.799903939989981e-05,  2.202647113872399e-06, -8.158006295218443e-08,  2.629274183881316e-09,
 -7.654478798128921e-11,  2.057528064904497e-12, -5.180442511922505e-14,  1.233992639964368e-15, -2.801141091358065e-17,  6.093688953825106e-19, -1.275300648205366e-20,
  7.808685997083174e-04, -7.275439683144329e-05,  4.368328254796115e-06, -2.074692136848088e-07,  8.420052813699637e-09, -3.039181145363033e-10,  9.993848411990115e-12,
 -3.041894199129285e-13,  8.666712813499675e-15, -2.330511185651166e-16,  5.952114587169621e-18, -1.450252027428658e-19,  4.181402575111911e-04, -5.295021305472974e-05,
  4.163879062150919e-06, -2.518599382821752e-07,  1.274789365504142e-08, -5.641983899289631e-10,  2.242478989795407e-11, -8.147700187395063e-13,  2.740404485346554e-14,
 -8.612299172075810e-16,  2.547168150837508e-17, -7.125128351073474e-19,  1.231520270871323e-04, -2.146732978216459e-05,  2.213284248363573e-06, -1.702085099836406e-07,
  1.070489456749569e-08, -5.779272750602563e-10,  2.758723067187248e-11, -1.187656995759227e-12,  4.676832425955682e-14, -1.702393909048834e-15,  5.774861462375201e-17,
 -1.835793420063125e-18,  2.270481765888399e-05, -5.436890305475557e-06,  7.348048160224052e-07, -7.173887636922663e-08,  5.587756122399946e-09, -3.661371131003265e-10,
  2.085359515381785e-11, -1.055447235837452e-12,  4.822697701115907e-14, -2.013282368644239e-15,  7.749806568623008e-17, -2.768193268722731e-18,  3.144577417701750e-06,
 -1.006044550685656e-06,  1.754416902526479e-07, -2.143214330561549e-08,  2.036731189848361e-09, -1.594314522875180e-10,  1.065489722787619e-11, -6.230033388202941e-13,
  3.244178316520890e-14, -1.524860192968773e-15,  6.537900712912253e-17, -2.575547570381505e-18,  4.032396885718028e-07, -1.586789553863586e-07,  3.347099658295560e-08,
 -4.833936422068012e-09,  5.321136813113675e-10, -4.741144179261605e-11,  3.552996775484057e-12, -2.299723652886534e-13,  1.310932294436011e-14, -6.679865222011658e-16,
  3.078444803784287e-17, -1.293571896897246e-18,  1.459452727323113e-04, -7.831453260194324e-06,  2.640877249616743e-07, -7.167845695979918e-09,  1.706571928741025e-10,
 -3.715711126564316e-12,  7.560509400567212e-14, -1.458288300593390e-15,  2.695552564765113e-17, -4.783265179008854e-19,  8.240852965592085e-21, -1.381848151577811e-22,
  5.172485389924241e-04, -3.367961900867094e-05,  1.433090760500403e-06, -4.949919814147464e-08,  1.494334951921546e-09, -4.089551630432566e-11,  1.036343278101016e-12,
 -2.465977297657597e-14,  5.564133467029239e-16, -1.198571796614149e-17,  2.478928223857759e-19, -4.941285686325791e-21,  5.466923489611771e-04, -4.586571514725268e-05,
  2.521907324219167e-06, -1.107606422879477e-07,  4.184500852035141e-09, -1.413075206262061e-10,  4.365190143900175e-12, -1.252508789187114e-13,  3.374133896295160e-15,
 -8.602128156923978e-17,  2.087952969765945e-18, -4.845870897390697e-20,  2.577843533994979e-04, -2.896099005236756e-05,  2.070125757949816e-06, -1.152054675698572e-07,
  5.409985324578482e-09, -2.235592313453751e-10,  8.339414155045989e-12, -2.856126528663054e-13,  9.089197681518947e-15, -2.711753374249687e-16,  7.636750987395431e-18,
 -2.039723019075800e-19,  6.295011981355088e-05, -9.709953310608318e-06,  9.086625818902544e-07, -6.428363944093534e-08,  3.754929995494949e-09, -1.896615939429543e-10,
  8.521016885067819e-12, -3.470009533178644e-13,  1.298156660274638e-14, -4.506342379100978e-16,  1.462742142592676e-17, -4.463406447794421e-19,  8.847963146834648e-06,
 -1.901492239585922e-06,  2.353744501055470e-07, -2.132043195263895e-08,  1.555569781667420e-09, -9.619684605355267e-11,  5.202588483606533e-12, -2.513195883834482e-13,
  1.100883335796790e-14, -4.422614412473850e-16,  1.643806776815997e-17, -5.686765947939237e-19,  8.471088121714969e-07, -2.520181767906607e-07,  4.131082436730797e-08,
 -4.787846063506320e-09,  4.348510422751257e-10, -3.272449010179426e-11,  2.112703327647390e-12, -1.198175026077313e-13,  6.072335685092355e-15, -2.785919915570901e-16,
  1.168846461989702e-17, -4.515826005565667e-19,  7.386900407930270e-08, -2.835769411255108e-08,  5.847585806443984e-09, -8.280953162654817e-10,  8.962007853836350e-11,
 -7.867956807486706e-12,  5.820282370210073e-13, -3.724397359298048e-14,  2.101584977943003e-15, -1.061185045238109e-16,  4.850797182073705e-18, -2.023408095983523e-19,
  1.183589236336303e-04, -6.021459099853890e-06,  1.922895384843235e-07, -4.945568192418946e-09,  1.116244481706334e-10, -2.307602241997901e-12,  4.465332670338018e-14,
 -8.178514495155704e-16,  1.444900919101192e-17, -2.443197965402394e-19,  3.988069334731743e-21, -6.480181297964990e-23,  4.021992411724063e-04, -2.423881100808413e-05,
  9.593787707138478e-07, -3.098480167694313e-08,  8.781441536521099e-10, -2.263646319090857e-11,  5.418011452672790e-13, -1.220112532570734e-14,  2.611896241961330e-16,
 -5.346028310005178e-18,  1.051974308632413e-19, -1.999982170952977e-21,  3.965261618735165e-04, -3.005172903749035e-05,  1.516867762007985e-06, -6.173021148016045e-08,
  2.174649562495218e-09, -6.880017638723184e-11,  1.998822927011452e-12, -5.411594858498900e-14,  1.379333636174310e-15, -3.335741859529564e-17,  7.698040442856897e-19,
 -1.702069847575830e-20,  1.680112025887160e-04, -1.673893289511701e-05,  1.088473389730057e-06, -5.576611304748465e-08,  2.430550729803805e-09, -9.379093923723858e-11,
  3.283307878594432e-12, -1.059699407931917e-13,  3.189361864415133e-15, -9.028102631903606e-17,  2.419195988737855e-18, -6.164413339995544e-20,  3.489952346399021e-05,
 -4.734556102025465e-06,  4.012039672006826e-07, -2.605685995106808e-08,  1.410867909691350e-09, -6.654426204274575e-11,  2.808312269164929e-12, -1.079628744636279e-13,
  3.829311812571680e-15, -1.265055144011414e-16,  3.921113705970093e-18, -1.146070331732760e-19,  3.836059895410134e-06, -7.304154462383663e-07,  8.219997011288231e-08,
 -6.866866763478618e-09,  4.668818324639100e-10, -2.712090279565665e-11,  1.386765305135572e-12, -6.368049801283981e-14,  2.664001875563027e-15, -1.026222989579146e-16,
  3.670553404591801e-18, -1.225939511277225e-19,  2.546970649212931e-07, -6.930255855096122e-08,  1.055553509121283e-08, -1.150049825837284e-09,  9.906903237722191e-11,
 -7.120866768920142e-12,  4.416010603848354e-13, -2.417086238531368e-14,  1.186959689993802e-15, -5.294601688557476e-17,  2.166108093637245e-18, -8.181727330273847e-20,
  1.429098743564900e-08, -5.306837875781042e-09,  1.062531076838655e-09, -1.467451001333165e-10,  1.554556993482501e-11, -1.339915833808897e-12,  9.755031005582199e-14,
 -6.155690386310791e-15,  3.431027577205836e-16, -1.713677672033531e-17,  7.757526960306324e-19, -3.207826103611120e-20,  9.701252958470875e-05, -4.693332636260319e-06,
  1.423050470150314e-07, -3.477505666476766e-09,  7.457345573914517e-11, -1.465623209348982e-12,  2.709529032147958e-14, -4.702577976803049e-16,  7.948312063567928e-18,
 -1.300774607903908e-19,  1.966728928706892e-21, -3.114352607388673e-23,  3.185362091816383e-04, -1.784252818459786e-05,  6.589305677301750e-07, -1.995100608338259e-08,
  5.319950093566194e-10, -1.294090027917783e-11,  2.931767392563864e-13, -6.255642848065208e-15,  1.272290914112917e-16, -2.479929948948412e-18,  4.642071497481364e-20,
 -8.428939559556022e-22,  2.966134190838844e-04, -2.037821163372123e-05,  9.466875578473040e-07, -3.577520991578914e-08,  1.177368392266796e-09, -3.495219222815703e-11,
  9.561647516091104e-13, -2.445558586883114e-14,  5.902819697181244e-16, -1.354929312168676e-17,  2.975243767195683e-19, -6.269200717734763e-21,  1.150079945612314e-04,
 -1.016583739504116e-05,  6.022501352625960e-07, -2.843657432180190e-08,  1.151312713573009e-09, -4.151143111435944e-11,  1.364056681474482e-12, -4.149727066353056e-14,
  1.181080362381813e-15, -3.171133212150496e-17,  8.083126714576800e-19, -1.963923211873995e-20,  2.083342576179439e-05, -2.473503123655823e-06,  1.896001134296645e-07,
 -1.129162178949319e-08,  5.661004441219928e-10, -2.490193738352814e-11,  9.858045934867186e-13, -3.572630984953465e-14,  1.199530010114411e-15, -3.765132996690055e-17,
  1.112517068942104e-18, -3.109206380018691e-20,  1.844467536911082e-06, -3.073407217707254e-07,  3.125822634651173e-08, -2.396193604511393e-09,  1.511531857404558e-10,
 -8.214511557838624e-12,  3.956035919346068e-13, -1.720617581719829e-14,  6.850410852105022e-16, -2.522007806570915e-17,  8.653006687473980e-19, -2.781614801736900e-20,
  8.636245648408300e-08, -2.108872679011487e-08,  2.948722824751468e-09, -2.991440012548428e-10,  2.424746118741006e-11, -1.653291666782436e-12,  9.789737596353050e-14,
 -5.144013910717908e-15,  2.436070275282602e-16, -1.052006302149486e-17,  4.180744913285385e-19, -1.538502032413572e-20,  2.966385093251406e-09, -1.052627463703073e-09,
  2.027557440595796e-10, -2.711440958620127e-11,  2.795640998579742e-12, -2.354786926968761e-13,  1.680774570106630e-14, -1.042570387195953e-15,  5.724505802243405e-17,
 -2.821674875219626e-18,  1.262463455806537e-19, -5.166395018806157e-21,  8.027775281143197e-05, -3.703547051856770e-06,  1.068700712893875e-07, -2.487508162010789e-09,
  5.082927656069951e-11, -9.484453633691960e-13,  1.687946336761186e-14, -2.779715714234502e-16,  4.405387422850178e-18, -7.304209837440936e-20,  1.008007153137483e-21,
 -1.411223566895615e-23,  2.563738659797069e-04, -1.340148103868295e-05,  4.631425271336401e-07, -1.317954771787049e-08,  3.314207047420058e-10, -7.617764004310178e-12,
  1.637850673749213e-13, -3.316076857384555e-15,  6.404654452555412e-17, -1.194623951331106e-18,  2.126304553534145e-20, -3.676316820483614e-22,  2.279196823477963e-04,
 -1.424772150100015e-05,  6.108279528261572e-07, -2.148230323321783e-08,  6.617185964900498e-10, -1.846705891798385e-11,  4.762336329520280e-13, -1.152241934044310e-14,
  2.637337977148646e-16, -5.746744725532628e-18,  1.202062398767273e-19, -2.416713799914463e-21,  8.219087177025764e-05, -6.452866209231937e-06,  3.489814199887049e-07,
 -1.520849638060648e-08,  5.726334389104324e-10, -1.931382334585025e-11,  5.959445092469921e-13, -1.709812724450164e-14,  4.604163846451767e-16, -1.172195290633107e-17,
  2.842561766664027e-19, -6.585018886545876e-21,  1.329111380319688e-05, -1.375639333834224e-06,  9.540381680732838e-08, -5.208389251794990e-09,  2.416666036943008e-10,
 -9.909900916808768e-12,  3.676724876046453e-13, -1.254995251246538e-14,  3.984762309916657e-16, -1.186867496474576e-17,  3.338982084453082e-19, -8.910543594500971e-21,
  9.781155992546185e-07, -1.409765265249736e-07,  1.290430623427411e-08, -9.042288243271526e-10,  5.273727822721899e-11, -2.672672119846217e-12,  1.208408771978486e-13,
 -4.962693036674997e-15,  1.874734360138112e-16, -6.576564308936301e-18,  2.158201655913346e-19, -6.658616677070080e-21,  3.326003217990276e-08, -7.137625682912847e-09,
  9.055381086284378e-10, -8.473896329488478e-11,  6.412306427722311e-12, -4.119165437219573e-13,  2.314771346713506e-14, -1.161266357655672e-15,  5.277324819559002e-17,
 -2.196449000256286e-18,  8.444372511978165e-20, -3.016282849279554e-21,  6.742896020831880e-10, -2.246688002734652e-10,  4.112192796057641e-11, -5.275196315714439e-12,
  5.254881564385396e-13, -4.299909156269964e-14,  2.994434933695806e-15, -1.818473289799018e-16,  9.802889703782842e-18, -4.754900883929031e-19,  2.097528166923643e-20,
 -8.477075486782870e-22,  6.700221826833635e-05, -2.955472018630089e-06,  8.133830533160815e-08, -1.806368464316608e-09,  3.535394619419118e-11, -6.229844742261390e-13,
  1.072403684319925e-14, -1.722981898784435e-16,  2.382909839327043e-18, -4.181358996365442e-20,  6.272633165434028e-22, -3.949410140780496e-24,  2.092901512544330e-04,
 -1.024914551064251e-05,  3.323912134155136e-07, -8.909942304895743e-09,  2.119003585553955e-10, -4.604097058086147e-12,  9.417254482271434e-14, -1.817571329107211e-15,
  3.313591724367661e-17, -5.950711961258490e-19,  1.018883614838524e-20, -1.629465096224941e-22,  1.792909728602974e-04, -1.023677877539662e-05,  4.061254781223603e-07,
 -1.332322127154946e-08,  3.847642445953335e-10, -1.011781154727984e-11,  2.462377735525574e-13, -5.639305526513574e-15,  1.227702022511092e-16, -2.538762939527354e-18,
  5.053683074538695e-20, -9.748943074734320e-22,  6.099395174307727e-05, -4.260276288250301e-06,  2.108402384009593e-07, -8.496603876579133e-09,  2.978010876238609e-10,
 -9.414777073465663e-12,  2.729059798803296e-13, -7.385578542809408e-15,  1.885117811245699e-16, -4.548328098386230e-18,  1.048831270014394e-19, -2.321441615526746e-21,
  8.995428593229810e-06, -8.091293301405323e-07,  5.084215256216471e-08, -2.545696438165510e-09,  1.093014061264264e-10, -4.180276781708750e-12,  1.452813490953962e-13,
 -4.667779648158099e-15,  1.401270226023514e-16, -3.956392840011963e-18,  1.058710907607719e-19, -2.696038690528668e-21,  5.679050343629729e-07, -7.003245009086503e-08,
  5.757961734219753e-09, -3.678440532190658e-10,  1.978412123855604e-11, -9.329120053842762e-13,  3.950022897951139e-14, -1.527904473153851e-15,  5.463245567786791e-17,
 -1.821483552852361e-18,  5.702927708356162e-20, -1.684504478041151e-21,  1.458840020418658e-08, -2.690260120236536e-09,  3.065599447591436e-10, -2.623520315549620e-11,
  1.839819775347392e-12, -1.106318268191188e-13,  5.865447949531630e-15, -2.794381391690580e-16,  1.212602510799973e-17, -4.841993149577010e-19,  1.793306061787982e-20,
 -6.193451979705827e-22,  1.721679235049788e-10, -5.252678409176373e-11,  8.990940529826179e-12, -1.093290324124966e-12,  1.042507475239844e-13, -8.225773919512576e-15,
  5.555130289520771e-16, -3.286232741490868e-17,  1.731930391672164e-18, -8.237395679169748e-20,  3.571858992864123e-21, -1.421922445253907e-22,  5.635689173068332e-05,
 -2.382718641977852e-06,  6.268584699351785e-08, -1.327900117119045e-09,  2.511649306029127e-11, -4.161070373460626e-13,  6.774099853677454e-15, -1.155059881367321e-16,
  1.305204949287099e-18, -1.834702847714088e-20,  5.770505061403391e-22,  1.248647697441843e-25,  1.730077258828324e-04, -7.966334487833974e-06,  2.431308293782750e-07,
 -6.148767068342151e-09,  1.388420597668502e-10, -2.852131097785415e-12,  5.539471007029314e-14, -1.033301126617809e-15,  1.762571044358152e-17, -2.986922693882606e-19,
  5.280340665807530e-21, -7.299403554683213e-23,  1.439591114786817e-04, -7.536164121344297e-06,  2.774169681957577e-07, -8.511407757279884e-09,  2.306959381636143e-10,
 -5.731304812925904e-12,  1.319592861074156e-13, -2.853711467182725e-15,  5.935545848043350e-17, -1.171289413797897e-18,  2.189202126332873e-20, -4.101671891792409e-22,
  4.677857604434178e-05, -2.912693094765151e-06,  1.322425860012942e-07, -4.942016354587495e-09,  1.612248315023232e-10, -4.791554918218580e-12,  1.307384936493211e-13,
 -3.328158637320733e-15,  8.083808187530643e-17, -1.853344889860421e-18,  4.032442577097462e-20, -8.595401460839463e-22,  6.413826797024448e-06, -5.001674347425422e-07,
  2.853876799901498e-08, -1.313030637460049e-09,  5.212758713485791e-11, -1.862453030985977e-12,  6.066098173952836e-14, -1.831692797825201e-15,  5.204920417708605e-17,
 -1.392953073980652e-18,  3.536671284022416e-20, -8.606370593883496e-22,  3.580220114021329e-07, -3.738744049208330e-08,  2.761619967154363e-09, -1.606928876508453e-10,
  7.952088815569749e-12, -3.485533240841306e-13,  1.379689546711363e-14, -5.015558785071196e-16,  1.694781290114062e-17, -5.359339290770821e-19,  1.597186829545499e-20,
 -4.508429827583694e-22,  7.272839389132244e-09, -1.125703287751371e-09,  1.143804053258684e-10, -8.888402772983523e-12,  5.739204954872374e-13, -3.212482403986099e-14,
  1.598308324344318e-15, -7.194889283576847e-17,  2.967469867429215e-18, -1.131788263102045e-19,  4.021355012520729e-21, -1.337643601253900e-22,  5.083823452772505e-11,
 -1.371121413751564e-11,  2.152636353217834e-12, -2.445570563235931e-13,  2.207322235854497e-14, -1.664381841042000e-15,  1.081986929608097e-16, -6.196858758043486e-18,
  3.176513425301729e-19, -1.474987057997252e-20,  6.263508132865691e-22, -2.448290996214735e-23,  4.773694718152137e-05, -1.938719614849688e-06,  4.891339802754490e-08,
 -9.848008914109943e-10,  1.818054790739901e-11, -2.880710802791493e-13,  4.056826310111292e-15, -7.992312992057023e-17,  1.047617010853667e-18,  3.061226997842992e-21,
  4.166524218031037e-22, -1.032788407912260e-23,  1.446133112814794e-04, -6.282574149415970e-06,  1.810016741568605e-07, -4.320204820043981e-09,  9.304271895640286e-11,
 -1.814731614715868e-12,  3.300020509180490e-14, -6.060739393015053e-16,  1.001283822882329e-17, -1.401841242244569e-19,  2.831634942453634e-21, -4.698145111605495e-23,
  1.176846218407106e-04, -5.670341041471524e-06,  1.941357037198968e-07, -5.588958396170578e-09,  1.422312435407474e-10, -3.342190817054398e-12,  7.333500237208694e-14,
 -1.489899528355278e-15,  2.940399861210913e-17, -5.714706947154916e-19,  9.843993192672230e-21, -1.677739337651733e-22,  3.692162585793156e-05, -2.054429972124129e-06,
  8.573034744878132e-08, -2.985703065736518e-09,  9.050713488600988e-11, -2.531894388524820e-12,  6.558897594834638e-14, -1.559003331222062e-15,  3.589234656927442e-17,
 -8.012558543492779e-19,  1.613027860688723e-20, -3.223921566042892e-22,  4.786827725176528e-06, -3.230956908167598e-07,  1.677304118074112e-08, -7.124416867220899e-10,
  2.608938825088799e-11, -8.719672792804485e-13,  2.674099086121722e-14, -7.554720697062022e-16,  2.030829185558678e-17, -5.192614777041731e-19,  1.240676591365824e-20,
 -2.873394995663411e-22,  2.429234809522284e-07, -2.127759148691903e-08,  1.414123052167870e-09, -7.510066196311446e-11,  3.409248438461696e-12, -1.388877357904588e-13,
  5.141494949129002e-15, -1.751521873271546e-16,  5.587141702823245e-18, -1.675711369238620e-19,  4.737080468459592e-21, -1.275952022415421e-22,  4.094281978152021e-09,
 -5.192418341538101e-10,  4.687115975494781e-11, -3.292564239616050e-12,  1.946010372772604e-13, -1.009597983429603e-14,  4.693398941038150e-16, -1.987040574010954e-17,
  7.757656333464578e-19, -2.814841905093174e-20,  9.555472805371734e-22, -3.050245018057773e-23,  1.786677747977143e-11, -4.064684360278703e-12,  5.731412237149434e-13,
 -5.984821872900673e-14,  5.047450080758840e-15, -3.599522678540529e-16,  2.233108085289125e-17, -1.229280027031092e-18,  6.091388058552378e-20, -2.747017771403304e-21,
  1.137293568468138e-22, -4.348282205082987e-24,  4.069628128535419e-05, -1.590144756266324e-06,  3.866621887746897e-08, -7.354038924483310e-10,  1.323183909607322e-11,
 -2.135845011140351e-13,  2.321049227375239e-15, -4.263451718914994e-17,  1.299355596177657e-18,  5.420073489265008e-21, -4.000349955950836e-22, -2.310256578343647e-23,
  1.220831177672910e-04, -5.019127968343198e-06,  1.370186738832453e-07, -3.084017376970629e-09,  6.346341510458764e-11, -1.194143158924651e-12,  1.988951828305133e-14,
 -3.486228493428589e-16,  6.501311888381941e-18, -6.894773340463972e-20,  7.140698960284012e-22, -4.756126105347359e-23,  9.773329225670329e-05, -4.351360773041516e-06,
  1.387916908486572e-07, -3.764870405198328e-09,  9.008645547704603e-11, -1.993033989520019e-12,  4.216884306310293e-14, -8.140481157407307e-16,  1.451625124586284e-17,
 -2.854986398270804e-19,  5.250192815820015e-21, -5.850405296058518e-23,  2.987897907988383e-05, -1.490641075437866e-06,  5.716099551120867e-08, -1.869973114708896e-09,
  5.264671526174319e-11, -1.374590465346668e-12,  3.443229044035137e-14, -7.702080916673649e-16,  1.598136419418365e-17, -3.617416381404310e-19,  7.388285780176026e-21,
 -1.088344003733706e-22,  3.717186390681201e-06, -2.171421075801739e-07,  1.024888383589901e-08, -4.057187470952877e-10,  1.367145236770105e-11, -4.249598368833117e-13,
  1.243841051486613e-14, -3.290402582707759e-16,  8.181560759837149e-18, -2.044302552900002e-19,  4.702826501263673e-21, -9.621070145824752e-23,  1.758085364365811e-07,
 -1.281668994550697e-08,  7.664402285781703e-10, -3.743459547515325e-11,  1.552980200379929e-12, -5.863488853092882e-14,  2.041895413852922e-15, -6.503216443865545e-17,
  1.944989683824459e-18, -5.569888591290469e-20,  1.494272647554643e-21, -3.782392225988424e-23,  2.575579448955876e-09, -2.615229283308641e-10,  2.094408258037668e-11,
 -1.330819383617133e-12,  7.156734605388139e-14, -3.428811138739206e-15,  1.486654244793393e-16, -5.892994946859127e-18,  2.168791505906010e-19, -7.470379167484581e-21,
  2.413175389965840e-22, -7.358583485959299e-24,  7.629484143425253e-12, -1.382597822730783e-12,  1.717923748251941e-13, -1.622380545721296e-14,  1.260674303639072e-15,
 -8.409003896632296e-17,  4.931761830532045e-18, -2.587847373588812e-19,  1.230981551387224e-20, -5.359160571352006e-22,  2.151739983309797e-23, -8.010607663175063e-25,
  3.490314679553086e-05, -1.312821984440748e-06,  3.097956370004270e-08, -5.551618284107550e-10,  9.445004108521502e-12, -1.674811972727623e-13,  1.706394298660561e-15,
 -2.741756012756286e-18,  1.007455508113963e-18, -2.499279839596958e-20, -8.680377837245225e-22,  1.072021891045296e-23,  1.039866903434834e-04, -4.055410813830177e-06,
  1.053907201964544e-07, -2.236653842068164e-09,  4.367553618782051e-11, -8.126134856889930e-13,  1.268521282711540e-14, -1.784202210228038e-16,  4.104568718339665e-18,
 -7.286910183416264e-20, -5.453521279944958e-22,  1.777494818283103e-24,  8.229339245741248e-05, -3.399944688212349e-06,  1.011051243968143e-07, -2.594298043457464e-09,
  5.873593278114954e-11, -1.210170124588626e-12,  2.459690906273366e-14, -4.778162967740046e-16,  7.490557465028597e-18, -1.181830134624424e-19,  3.168264803969362e-21,
 -4.982648426597367e-23,  2.470666194911285e-05, -1.110622240602708e-06,  3.899578424307284e-08, -1.209088842137935e-09,  3.192619305877545e-11, -7.594114039585441e-13,
  1.842883588261208e-14, -4.179138155977659e-16,  7.352192245578704e-18, -1.390532405875022e-19,  4.055732338360364e-21, -6.461867193085070e-23,  2.986279735059958e-06,
 -1.514611200089929e-07,  6.457339895402389e-09, -2.414253699990361e-10,  7.539404048190044e-12, -2.130889969763113e-13,  6.002763072723131e-15, -1.554410182036816e-16,
  3.410347754269089e-18, -7.787725628083841e-20,  2.036605010153035e-21, -3.849736275719604e-23,  1.344572022695949e-07, -8.134075538914359e-09,  4.348054389491593e-10,
 -1.981866806879257e-11,  7.526094469980412e-13, -2.595552179685235e-14,  8.575815771610359e-16, -2.594198098467751e-17,  7.105671134144505e-19, -1.921344242268911e-20,
  5.136970534790794e-22, -1.201092856558903e-23,  1.785365502393014e-09, -1.425661510862165e-10,  1.008451233921556e-11, -5.851178009840863e-13,  2.850430900433606e-14,
 -1.251446564123021e-15,  5.073303311561333e-17, -1.882404826647228e-18,  6.471159531297275e-20, -2.112541464432351e-21,  6.523518130176230e-23, -1.881479182576319e-24,
  3.971176311399475e-12, -5.397575721601934e-13,  5.825823728655094e-14, -4.920334646901485e-15,  3.471389726181561e-16, -2.141085770858418e-17,  1.176667958920081e-18,
 -5.833741806879563e-20,  2.642355223651298e-21, -1.103575450354645e-22,  4.272709695630581e-24, -1.540004337737634e-25,  3.010864914601930e-05, -1.089304223158359e-06,
  2.512107139340621e-08, -4.285868815416974e-10,  6.513246365651962e-12, -1.248372781556522e-13,  1.907700177489498e-15,  1.020749741399378e-17, -2.729291187187823e-19,
 -3.670375082309129e-20,  5.034201242714488e-22,  3.896480587243431e-23,  8.929658210212850e-05, -3.308899854460928e-06,  8.225691436883506e-08, -1.652785762850084e-09,
  3.012901649746609e-11, -5.558216149379222e-13,  9.111259051142912e-15, -9.180663580561721e-17,  1.300215099472725e-18, -7.286552502804922e-20,  9.067488235893705e-22,
  4.832683944668589e-23,  7.013449560151571e-05, -2.701305654404149e-06,  7.490603237555934e-08, -1.820180127403305e-09,  3.947822307170402e-11, -7.564751500828442e-13,
  1.408180507006636e-14, -2.864078522415331e-16,  4.932811875887651e-18, -4.085985017921466e-20,  6.508188169563970e-22, -5.429084225967228e-23,  2.080712727548079e-05,
 -8.490244677239177e-07,  2.711843596081972e-08, -7.992939827040770e-10,  2.033444488643624e-11, -4.346017613767543e-13,  9.458117197839256e-15, -2.372682970684488e-16,
  4.539514116087491e-18, -3.800504748204354e-20,  9.460996541311475e-22, -6.857673975750007e-23,  2.467928524816792e-06, -1.096196863081479e-07,  4.165163509801122e-09,
 -1.483477437933116e-10,  4.420286923245661e-12, -1.110236400387871e-13,  2.851202982825335e-15, -7.845774218805794e-17,  1.708725601106062e-18, -2.573996937418514e-20,
  6.576888276539879e-22, -2.541075443564191e-23,  1.076164071654968e-07, -5.435468337542595e-09,  2.551447918001455e-10, -1.101922733751173e-11,  3.914932587895791e-13,
 -1.204013164860858e-14,  3.687472240868180e-16, -1.115938006705593e-17,  2.877181834771387e-19, -6.493594806410084e-21,  1.727280788729602e-22, -4.855166176911667e-24,
  1.340872071193354e-09, -8.376945648898926e-11,  5.147364122827193e-12, -2.775853848801174e-13,  1.234780223992453e-14, -4.879422446075978e-16,  1.841328877430950e-17,
 -6.516352957159743e-19,  2.082680195756418e-20, -6.248258274951462e-22,  1.869012470360612e-23, -5.308663614406419e-25,  2.470595831775531e-12, -2.402147101980319e-13,
  2.219163960063921e-14, -1.678529718575538e-15,  1.062482704035169e-16, -5.971298763235944e-18,  3.053318120731651e-19, -1.422236832863150e-20,  6.073573378165214e-22,
 -2.411920762844354e-23,  8.973438839688546e-25, -3.118040614948963e-26,  2.612306851005630e-05, -9.073094481091846e-07,  2.052915851837475e-08, -3.417955246776072e-10,
  4.487961242489740e-12, -7.761931579166831e-14,  1.916760693618143e-15, -1.306325560155427e-17, -9.219108273752998e-19,  5.362596120226929e-21,  1.185587753484959e-21,
 -1.490539193541177e-23,  7.726202951060760e-05, -2.722754915764518e-06,  6.498526867753205e-08, -1.248589125852266e-09,  2.100629331136774e-11, -3.653787949597467e-13,
  6.799615885971422e-15, -8.170933049120553e-17, -2.736969903296926e-19, -8.349310478892193e-21,  1.797217405075046e-21, -1.937022499382765e-23,  6.040321473330787e-05,
 -2.179730796810296e-06,  5.640727469336297e-08, -1.293624064328573e-09,  2.716552176984083e-11, -4.981879479763177e-13,  8.064018615808031e-15, -1.508805841548303e-16,
  3.490762447810314e-18, -4.690497780453364e-20, -4.874517743969198e-22,  6.825981383719522e-24,  1.779120415298669e-05, -6.655026538665811e-07,  1.922663573092055e-08,
 -5.331239165687375e-10,  1.345422827783586e-11, -2.720476463189151e-13,  4.664833071565436e-15, -1.115803491954287e-16,  3.271199914862561e-18, -4.339705153842485e-20,
 -6.741100518349119e-22,  2.676109143110282e-24,  2.086319270414046e-06, -8.236464290992273e-08,  2.746311683629126e-09, -9.231429757853283e-11,  2.734962633903129e-12,
 -6.350110184211489e-14,  1.305625149342402e-15, -3.540208426756535e-17,  1.035076786571765e-18, -1.620124032893642e-20, -1.805191063784497e-23, -3.684951319059592e-24,
  8.924896701557979e-08, -3.832383521324555e-09,  1.538580665539301e-10, -6.290801187910295e-12,  2.184847211971228e-13, -6.076779045162986e-15,  1.574587205626845e-16,
 -4.709811933671670e-18,  1.369692783938484e-19, -2.758744596725714e-21,  3.932928843049617e-23, -1.378241970520636e-24,  1.070983877260571e-09, -5.316780201290621e-11,
  2.743282179922559e-12, -1.391523341485307e-13,  5.846915609176160e-15, -2.062428299035503e-16,  6.926827845584126e-18, -2.372456045164349e-19,  7.520838593764985e-21,
 -2.020882427431705e-22,  5.139130934835026e-24, -1.523271352788964e-25,  1.768663139129163e-12, -1.213823022365993e-13,  9.304592339474023e-15, -6.399787735228840e-16,
  3.651752989767682e-17, -1.833975928615468e-18,  8.589083277931809e-20, -3.768462857710466e-21,  1.518449794513610e-22, -5.636920739247105e-24,  1.982890687027901e-25,
 -6.691398305615787e-27,  2.279790805458620e-05, -7.583642264403565e-07,  1.681485076855454e-08, -2.800869793951547e-10,  3.350541207801977e-12, -3.888177359100384e-14,
  1.220758462811694e-15, -3.239931094284407e-17, -1.465944900886344e-19,  2.851101652375546e-20, -1.386140965126646e-22, -3.010505473135753e-23,  6.732328334235077e-05,
 -2.257593034965231e-06,  5.180420778623897e-08, -9.628771838874978e-10,  1.514062331216077e-11, -2.304770478739111e-13,  4.427490328574784e-15, -8.419170120731340e-17,
  3.532879386081498e-19,  3.049874632704435e-20, -3.015815887023936e-23, -4.317938349263368e-23,  5.249800408057724e-05, -1.783872741526253e-06,  4.319351049545080e-08,
 -9.294006751391222e-10,  1.885314800285786e-11, -3.443893357153465e-13,  5.130010029967689e-15, -6.857542779390379e-17,  1.636929929409334e-18, -4.921947787246716e-20,
  4.864353294038279e-22,  2.282604771645447e-23,  1.540096783215486e-05, -5.339984366434345e-07,  1.395847363916571e-08, -3.561705019536251e-10,  8.934181453784305e-12,
 -1.873565431854768e-13,  2.741006301689882e-15, -3.577893246001604e-17,  1.409720878350781e-18, -5.216471745076769e-20,  4.342481964117104e-22,  2.975101913673590e-23,
  1.794720959174225e-06, -6.416821025522366e-08,  1.863926782402680e-09, -5.728919499390456e-11,  1.715031136989299e-12, -4.086358512084395e-14,  6.892755267350441e-16,
 -1.173044217192066e-17,  4.489452816697905e-19, -1.514485201231700e-20,  1.451173779600695e-22,  6.389852732664648e-24,  7.597622896491390e-08, -2.852142537160202e-09,
  9.589397226746547e-11, -3.599017132802117e-12,  1.262601816657289e-13, -3.467998010043841e-15,  7.371286497734174e-17, -1.687183966862114e-18,  5.777377737695784e-20,
 -1.732233647451083e-21,  2.345923687218527e-23,  1.868284124756155e-25,  8.935238200258329e-10, -3.657478913434098e-11,  1.522739400338546e-12, -7.141158503128790e-14,
  2.962745376362568e-15, -9.808639776319734e-17,  2.782281895504885e-18, -8.327861120950367e-20,  2.792740755625660e-21, -8.234686001427545e-23,  1.730199365745789e-24,
 -2.964495143537052e-26,  1.394455509290217e-12, -6.993670684440460e-14,  4.204326957934341e-15, -2.650885705088039e-16,  1.410837633864793e-17, -6.340350000761015e-19,
  2.618411803864938e-20, -1.060416743533558e-21,  4.132666929737428e-23, -1.466886862039027e-24,  4.706892710806539e-26, -1.451919697736537e-27,  2.001342200073433e-05,
 -6.364285363453840e-07,  1.375411267123434e-08, -2.314141792619073e-10,  2.793376921393371e-12, -2.014280420270677e-14,  3.825438565387669e-16, -2.371477592257862e-17,
  5.558683001275513e-19,  7.121093073933428e-21, -6.553933423816720e-22,  5.956135232406701e-24,  5.905399454427948e-05, -1.885575886140191e-06,  4.156766059755475e-08,
 -7.524963358515495e-10,  1.141335594025141e-11, -1.502994110797973e-13,  2.374218930429337e-15, -5.845047546204475e-17,  1.098790912515611e-18,  5.611172821127751e-21,
 -8.343865131068078e-22,  6.455966372958647e-24,  4.598957551451118e-05, -1.478290720612392e-06,  3.364340689215529e-08, -6.767287411762351e-10,  1.306529553690844e-11,
 -2.398553640513810e-13,  3.712398446641548e-15, -3.936499247752948e-17,  3.736854159729224e-19, -1.902080330574248e-20,  7.840781906527702e-22, -8.464380144296053e-24,
  1.346432351752607e-05, -4.372596853897202e-07,  1.042927652315878e-08, -2.398958909930504e-10,  5.783336756067767e-12, -1.300592987760127e-13,  2.124244949210813e-15,
 -1.540973255028181e-17,  6.489702694438238e-20, -1.939138107909101e-20,  9.109123054979291e-22, -8.410855999960998e-24,  1.564100445779511e-06, -5.159691875012421e-08,
  1.316793035459717e-09, -3.557648628539889e-11,  1.043016800767184e-12, -2.709121632376545e-14,  4.905852534196333e-16, -4.538587182138407e-18,  5.665768130830840e-20,
 -5.962508495574656e-21,  2.470601262247233e-22, -2.224073039637254e-24,  6.587067594907556e-08, -2.228114512704124e-09,  6.281291290302650e-11, -2.050587173637447e-12,
  7.162471275785083e-14, -2.107656786908243e-15,  4.435235150820772e-17, -6.418812872868742e-19,  1.373761499010785e-20, -7.060365968860840e-22,  2.426079465865229e-23,
 -2.535095468842757e-25,  7.671279866777735e-10, -2.714358998707690e-11,  8.954424979350011e-13, -3.671532586966690e-14,  1.522026741390378e-15, -5.150780894672223e-17,
  1.339430525310126e-18, -2.995315574752301e-20,  8.424006931140517e-22, -3.108550280050311e-23,  9.277222011914858e-25, -1.477780341507625e-26,  1.166207360354856e-12,
 -4.597180379115033e-14,  2.047549781870436e-15, -1.145805755276955e-16,  5.911160399587595e-18, -2.507936338095853e-19,  9.086776619919042e-21, -3.144778316714448e-22,
  1.138501042174754e-23, -4.119428596941712e-25,  1.329233064885627e-26, -3.630724255699223e-28,  1.767122136813602e-05, -5.367720617015643e-07,  1.123310181177726e-08,
 -1.896323590535054e-10,  2.439340958889835e-12, -1.684472610051464e-14, -2.533297414929077e-17, -6.048180795556015e-18,  4.492646906851578e-19, -9.412210170081486e-21,
 -1.323146816476258e-22,  1.184473432685573e-23,  5.212368769337605e-05, -1.586260803822592e-06,  3.354287047151181e-08, -5.913192268174585e-10,  8.865174733830862e-12,
 -1.090046748638113e-13,  1.219976286970711e-15, -2.546670173450924e-17,  8.360230339581488e-19, -1.548199707996272e-20, -1.562347079320437e-22,  1.595528876096062e-23,
  4.056784960307446e-05, -1.238407597322270e-06,  2.663332782776455e-08, -5.015765050844113e-10,  9.074896941629291e-12, -1.630727840441758e-13,  2.712236727796002e-15,
 -3.329837544529929e-17,  1.273367616153054e-19,  1.419390788887213e-21,  2.149510466308106e-22, -1.212938964625796e-23,  1.186590305201317e-05, -3.639478347442419e-07,
  8.028455751351737e-09, -1.655504390332614e-10,  3.656331916268282e-12, -8.443929810418133e-14,  1.660955137009580e-15, -1.856018283136426e-17, -1.182121725150604e-19,
  4.630470449645734e-21,  2.469891418355366e-22, -1.491380527504821e-23,  1.376428857731593e-06, -4.252377410113841e-08,  9.740833710077615e-10, -2.262453125390543e-11,
  6.090841374989595e-13, -1.677400460392423e-14,  3.686290782270404e-16, -4.536999100523009e-18, -1.684639961123899e-20,  6.824479230330183e-22,  7.366168595756772e-23,
 -3.933282236886432e-24,  5.783109967729281e-08, -1.807412922962051e-09,  4.386305147381889e-11, -1.189438576600547e-12,  3.883968784552246e-14, -1.226654589858235e-15,
  2.988911921661415e-17, -4.498509663351623e-19,  2.201369865136922e-21, -4.546392018749549e-23,  8.099148888905233e-24, -3.526490172939132e-25,  6.705843659948610e-10,
 -2.139657071126401e-11,  5.719642415878816e-13, -1.909885869921143e-14,  7.575862386049168e-16, -2.718900275810006e-17,  7.536284621333791e-19, -1.500214080028683e-20,
  2.367259083140589e-22, -6.612918554825628e-24,  3.226678262648052e-25, -1.106857684386380e-26,  1.008221941700822e-12, -3.380003027859259e-14,  1.106195365026661e-15,
 -5.067779237043870e-17,  2.528712604100026e-18, -1.078963371008423e-19,  3.734136051153983e-21, -1.099032775809490e-22,  3.180262618791933e-24, -1.055970947858456e-25,
  3.757199945319682e-27, -1.174501721908876e-28,  1.569035314649834e-05, -4.553720999980130e-07,  9.180369607712489e-09, -1.533636355973152e-10,  2.089655108341535e-12,
 -1.818809127296526e-14, -4.662996188115313e-17,  2.719670703773240e-18,  1.122989882266527e-19, -7.439354770706330e-21,  1.518732985969495e-22,  1.374031901639131e-24,
  4.627358771344578e-05, -1.344046193186715e-06,  2.723076031649301e-08, -4.655211631168357e-10,  6.933494902697510e-12, -8.578756436818927e-14,  7.958159637773094e-16,
 -7.710799796033418e-18,  2.974139221260162e-19, -1.191724729538979e-20,  2.270556598555147e-22,  1.764011151481233e-24,  3.600541767723863e-05, -1.047174704329438e-06,
  2.138858425544827e-08, -3.792407547130073e-10,  6.391579982137939e-12, -1.086228313799629e-13,  1.851300545471343e-15, -2.760515043420348e-17,  2.329739165527226e-19,
  2.478883108584025e-21, -8.500934788612959e-23, -1.900772805722167e-24,  1.052723661540507e-05, -3.067872638314091e-07,  6.343648210258451e-09, -1.185754975371750e-10,
  2.322682665454387e-12, -5.104561948296758e-14,  1.120608379311134e-15, -1.883130404254583e-17,  1.022097154617099e-19,  5.165433459837278e-21, -1.252081977841748e-22,
 -2.326633971281246e-24,  1.220403573040441e-06, -3.567400464145386e-08,  7.514275881526139e-10, -1.512619107586277e-11,  3.516166018907681e-13, -9.476586758622815e-15,
  2.401063936897868e-16, -4.396611890458107e-18,  2.771158919773740e-20,  1.131542489312134e-21, -2.673011711949163e-23, -6.938461361187000e-25,  5.122560942800301e-08,
 -1.504669157219057e-09,  3.262369321075238e-11, -7.294350608989613e-13,  2.050041917121040e-14, -6.524459051712837e-16,  1.832705306702634e-17, -3.685684367996112e-19,
  3.402945934298661e-21,  5.110851024360127e-23, -1.174693419539962e-24, -7.474540224852647e-26,  5.929416678282792e-10, -1.756713517339610e-11,  4.003869350286442e-13,
 -1.047451848036330e-14,  3.643993044358219e-16, -1.343828159663818e-17,  4.168365137448694e-19, -9.542387180307844e-21,  1.372190141942966e-22, -8.625285165978251e-25,
  2.611380712099101e-26, -2.851127662955179e-27,  8.876586004880175e-13, -2.683204248717004e-14,  6.829380190910311e-16, -2.348839824850333e-17,  1.065330197295632e-18,
 -4.639153057197611e-20,  1.668625985354200e-21, -4.801068297639104e-23,  1.142238335530696e-24, -2.666504851855458e-26,  8.160324377944771e-28, -3.047517272490728e-29,
  1.400486068557358e-05, -3.887501039138103e-07,  7.528494028404330e-09, -1.228696060055586e-10,  1.722074580113773e-12, -1.819209376724190e-14,  4.805280920638046e-17,
  3.208331688453502e-18, -4.766668617640133e-20, -1.795691418982222e-21,  1.048895864875255e-22, -2.211378790506254e-24,  4.130021416482638e-05, -1.146783172401160e-06,
  2.225669979010302e-08, -3.673320211004301e-10,  5.395358807822456e-12, -6.853631531608781e-14,  6.612620461026358e-16, -3.305811107055847e-18,  2.839858164061141e-20,
 -3.546949295927589e-21,  1.564180849012042e-22, -3.176130106522914e-24,  3.213236884010964e-05, -8.926817395043179e-07,  1.738673592681739e-08, -2.921878691358746e-10,
  4.605438354140374e-12, -7.256749892009653e-14,  1.191058394243441e-15, -1.943525922578009e-17,  2.563878113163086e-19, -1.004122360402384e-21, -6.397888430252249e-23,
  1.644229527587712e-24,  9.393374722065207e-06, -2.611668843860625e-07,  5.114293359209600e-09, -8.828938550348558e-11,  1.530512074725004e-12, -2.997380327409760e-14,
  6.597135407916214e-16, -1.361629665386768e-17,  1.931219010780768e-19,  1.345187654575705e-22, -9.423931765115431e-23,  2.190645227472830e-24,  1.088699154494552e-06,
 -3.030557066933415e-08,  5.983190185083257e-10, -1.074313092732913e-11,  2.103868992135725e-13, -5.061613119727042e-15,  1.339037934483894e-16, -3.088374787631702e-18,
  4.705670549021541e-20, -1.367784357274147e-23, -2.194643305552972e-23,  5.124637707671203e-25,  4.568021497577380e-08, -1.273969288848216e-09,  2.547629706116755e-11,
 -4.851908759252397e-13,  1.108337266543095e-14, -3.228538858291823e-16,  9.722041967950708e-18, -2.426297584392005e-19,  4.058106618976000e-21, -1.500233310510862e-23,
 -1.364467070399711e-24,  3.275306836901772e-26,  5.284001940555164e-10, -1.478501063735120e-11,  3.023390414709910e-13, -6.332949861334572e-15,  1.764865379180562e-16,
 -6.170140620685430e-18,  2.069115618011150e-19, -5.604817961098489e-21,  1.074912631817957e-22, -1.009626763684104e-24, -1.105656810999968e-26,  2.895023427485143e-28,
  7.898037990036880e-13, -2.226459142316581e-14,  4.786876953959676e-16, -1.208219652433689e-17,  4.473140163021336e-19, -1.905919195828182e-20,  7.249296168944723e-22,
 -2.245362589179336e-23,  5.473731398795251e-25, -1.041779021421403e-26,  1.785652464479831e-28, -4.792345488087085e-30,  1.256160358450668e-05, -3.339785962130928e-07,
  6.207648933643975e-09, -9.813756213315180e-11,  1.375988098469950e-12, -1.616859198418462e-14,  1.115119203140479e-16,  1.274783409353342e-18, -5.902098759864560e-20,
  6.190730255260211e-22,  2.333110984999588e-23, -1.258015713140508e-24,  3.704321277987334e-05, -9.849926993246567e-07,  1.832414509949106e-08, -2.911405687435287e-10,
  4.176003646128848e-12, -5.375553083307469e-14,  5.692941132917364e-16, -3.495931447993584e-18, -1.854989245724752e-20,  1.559548354375650e-22,  3.940970893493323e-23,
 -1.812806287545325e-24,  2.881925811122783e-05, -7.664612553136735e-07,  1.427927343210759e-08, -2.287274326509875e-10,  3.400459800374775e-12, -4.963282405422068e-14,
  7.535875611992283e-16, -1.216443879591897e-17,  1.909894019769452e-19, -2.214298390452314e-21, -2.208135897327075e-24,  9.325724512364504e-25,  8.424359850047210e-06,
 -2.241146928353514e-07,  4.184429549139009e-09, -6.785395893914169e-11,  1.062033794968663e-12, -1.803432708320352e-14,  3.615954928616920e-16, -7.901835376899009e-18,
  1.524947691948001e-19, -1.838640421772845e-21, -1.185432247862558e-23,  1.257492163134790e-24,  9.763054088910058e-07, -2.598415650223325e-08,  4.867504530784616e-10,
 -8.038584691280415e-12,  1.351460517955417e-13, -2.720877006053881e-15,  6.748365251096463e-17, -1.716186911329858e-18,  3.606657044379010e-20, -4.650006549371252e-22,
 -2.331325565998032e-24,  3.001781662145128e-25,  4.095878409263148e-08, -1.090852197186943e-09,  2.054029658402313e-11, -3.488913410584575e-13,  6.481881438513863e-15,
 -1.571780145995297e-16,  4.606960022282830e-18, -1.290547094806619e-19,  2.888208002043268e-21, -4.104903381140803e-23, -4.115025464490150e-26,  2.045311134499450e-26,
  4.736735949747895e-10, -1.263013929406701e-11,  2.399581061989315e-13, -4.273393969175815e-15,  9.188843845346035e-17, -2.734644711461626e-18,  9.224646910734242e-20,
 -2.799246173029454e-21,  6.729485069949424e-23, -1.106370594463529e-24,  5.831845015084085e-27,  2.827105946216508e-28,  7.076263615279749e-13, -1.891712498783644e-14,
  3.666193467527829e-16, -7.211501352428008e-18,  1.981012064657011e-19, -7.530978300112096e-21,  2.931533084282527e-22, -9.846152368913225e-24,  2.682336806472809e-25,
 -5.661870677059070e-27,  8.588996408120715e-29, -8.680970814057710e-31,  1.131805035164016e-05, -2.886773247789694e-07,  5.151917385546641e-09, -7.855471099471592e-11,
  1.081270753904749e-12, -1.325263429778188e-14,  1.248809810764349e-16, -1.635066870212388e-19, -2.999203083939707e-20,  7.961976289318709e-22, -7.082698372540153e-24,
 -2.485406844178105e-25,  3.337580334903131e-05, -8.513154678330666e-07,  1.519818714094008e-08, -2.322173773401890e-10,  3.229299074770157e-12, -4.132139608947309e-14,
  4.653613416372314e-16, -3.820444768724712e-18,  8.584236291923119e-22,  6.330987880179343e-22, -5.106230307603490e-24, -3.860014712839928e-25,  2.596571188989939e-05,
 -6.623506447922057e-07,  1.183112531519815e-08, -1.813829657748346e-10,  2.564335219738099e-12, -3.501597596438788e-14,  4.868159395932316e-16, -7.283143717016195e-18,
  1.168588809231813e-19, -1.772085636549279e-21,  1.821627881344949e-23,  1.002073543537861e-25,  7.590070179085326e-06, -1.936320579684115e-07,  3.461578609685084e-09,
 -5.334149191844350e-11,  7.727945164406265e-13, -1.152182656813416e-14,  1.985683300716487e-16, -4.087916200840035e-18,  8.757707002908825e-20, -1.582987285121769e-21,
  1.671431805437307e-23,  1.766248268183876e-25,  8.795929329523905e-07, -2.244288150811305e-08,  4.017112999765563e-10, -6.237781313863047e-12,  9.364005254879441e-14,
 -1.563070827335306e-15,  3.306447497373866e-17, -8.277975805438837e-19,  1.997257885502766e-20, -3.858381679534914e-22,  4.360872629458241e-24,  3.722065066134459e-26,
  3.689972093091198e-08, -9.417188143533802e-10,  1.688864093693197e-11, -2.653802547556297e-13,  4.199552447970252e-15, -8.087054332196259e-17,  2.071077441478700e-18,
 -5.924475267101435e-20,  1.536159341568312e-21, -3.127628751402080e-23,  3.912582760196463e-25,  1.596126061130083e-27,  4.266982369393870e-10, -1.089409494875179e-11,
  1.960201880058222e-13, -3.143155167307991e-15,  5.409488209294148e-17, -1.252652357917925e-18,  3.845701649080671e-20, -1.220365795966152e-21,  3.366547132522442e-23,
 -7.312913047925163e-25,  1.063642179366342e-26, -2.634076561902665e-29,  6.373393122395794e-13, -1.628580444407061e-14,  2.951479497634620e-16, -4.943044608695447e-18,
  9.980174811768397e-20, -2.999997759654103e-21,  1.113220337233663e-22, -3.927930795573163e-24,  1.181100738554787e-25, -2.886351503067728e-27,  5.407372188551719e-29,
 -6.657917310273661e-31,  1.024019153752502e-05, -2.509576067310351e-07,  4.304835350122819e-09, -6.321514641634915e-11,  8.453622451420138e-13, -1.039470928795748e-14,
  1.107062721353579e-16, -7.318692055230624e-19, -7.769984529051546e-21,  4.279375184703556e-22, -9.025983836383347e-24,  7.548365255416821e-26,  3.019722594151429e-05,
 -7.400570809119323e-07,  1.269618619724315e-08, -1.865892481298152e-10,  2.505991445328634e-12, -3.141421983117824e-14,  3.617895813226149e-16, -3.488412393350959e-18,
  1.771621869287267e-20,  2.790777080787683e-22, -9.306313364131266e-24,  7.626972720037665e-26,  2.349274155252090e-05, -5.757599412504224e-07,  9.879478978929691e-09,
 -1.453837883661674e-10,  1.966285670410203e-12, -2.541080961493610e-14,  3.266671608912277e-16, -4.422163839308687e-18,  6.621556585413009e-20, -1.060803186452706e-21,
  1.560136593376083e-23, -1.462521014958641e-25,  6.867148823438736e-06, -1.683056237709684e-07,  2.888809330894055e-09, -4.259518563832370e-11,  5.821736713153889e-13,
 -7.860892366925064e-15,  1.157356795514208e-16, -2.062194775061967e-18,  4.315676006369000e-20, -8.969161534833782e-22,  1.528697153696915e-23, -1.481203571942414e-25,
  7.958078525404338e-07, -1.950526464430319e-08,  3.349366678459063e-10, -4.953249239006398e-12,  6.875996214200613e-14, -9.870368507411760e-16,  1.699313460489037e-17,
 -3.762516152341290e-19,  9.295697380069713e-21, -2.116521951716577e-22,  3.805202321337211e-24, -3.952781486837072e-26,  3.338436471371199e-08, -8.183134751638403e-10,
  1.406128116405872e-11, -2.089023480939879e-13,  2.969521383418995e-15, -4.644814343590048e-17,  9.527075007656728e-19, -2.509874951099926e-20,  6.864724881003799e-22,
 -1.651000963223401e-23,  3.106238522580849e-25, -3.570224465673582e-27,  3.860379119840181e-10, -9.463719089046224e-12,  1.628040315559776e-13, -2.437624693852279e-15,
  3.604001635386935e-17, -6.394851352852187e-19,  1.597137102623542e-20, -4.868208056946003e-22,  1.437563794532398e-23, -3.635585861069271e-25,  7.259724401441373e-27,
 -9.679764315420333e-29,  5.765760964388192e-13, -1.413851608461463e-14,  2.438165231202253e-16, -3.711856525033301e-18,  5.946024671925040e-20, -1.303433608921687e-21,
  4.128750884185220e-23, -1.448523060835803e-24,  4.643656591929621e-26, -1.266911457896451e-27,  2.825999354631950e-29, -4.820044629225956e-31,  9.300739050676276e-06,
 -2.193382105635129e-07,  3.620995580805677e-09, -5.121545659800537e-11,  6.622844018653967e-13, -7.999834995444038e-15,  8.859581774440324e-17, -7.960542868183469e-19,
  2.096078994098525e-21,  1.482268529150982e-22, -4.880440485072406e-24,  9.021091888242768e-26,  2.742685882673878e-05, -6.468070899591445e-07,  1.067839745791282e-08,
 -1.510798484978389e-10,  1.956986578879722e-12, -2.383240178397481e-14,  2.730961849931328e-16, -2.824274833438925e-18,  2.211533729042018e-20, -2.773502854844881e-24,
 -4.616320913228337e-24,  1.049934462807532e-25,  2.133743166417654e-05, -5.032037514259819e-07,  8.308140085476438e-09, -1.176011766504071e-10,  1.527542473699138e-12,
 -1.884851167610447e-14,  2.275533732732646e-16, -2.806880106370712e-18,  3.765385459550845e-20, -5.694082822167273e-22,  9.107745478741878e-24, -1.305144256041474e-25,
  6.237118973448047e-06, -1.470924221121916e-07,  2.428808815902087e-09, -3.440439811698095e-11,  4.487495380137236e-13, -5.646026139161446e-15,  7.323789113312176e-17,
 -1.093272197248532e-18,  2.020822561577308e-20, -4.236296242511224e-22,  8.485553950056790e-24, -1.375845150203589e-25,  7.227939217689914e-07, -1.704619649613195e-08,
  2.815104594774756e-10, -3.991914410466797e-12,  5.239162485663114e-14, -6.780863761218068e-16,  9.666080713868078e-18, -1.748612354553329e-19,  3.980343681710594e-21,
 -9.540680763288257e-23,  2.049757030953846e-24, -3.473142216242418e-26,  3.032127085831039e-08, -7.151063854992034e-10,  1.181233637385913e-11, -1.677799118030548e-13,
  2.223070107056301e-15, -3.000520511687851e-17,  4.834295303789138e-19, -1.055289179443716e-20,  2.778403231134063e-22, -7.189891062307006e-24,  1.612479898723549e-25,
 -2.844072782356763e-27,  3.506153448412784e-10, -8.269346338483093e-12,  1.366470665012973e-13, -1.946311505054622e-15,  2.620331382703572e-17, -3.780525214250221e-19,
  7.165863883993820e-21, -1.881808728657856e-22,  5.540381918014812e-24, -1.519322435571162e-25,  3.554882454154965e-27, -6.623577510149260e-29,  5.236615858276110e-13,
 -1.235166911240307e-14,  2.042651163513545e-16, -2.926442744525432e-18,  4.072962927687165e-20, -6.666130578362826e-22,  1.601213982348343e-23, -5.113326528559107e-25,
  1.671243275928753e-26, -4.898785101392861e-28,  1.227097784960696e-29, -2.534695729240519e-31,  8.477668949047215e-06, -1.926598925298804e-07,  3.065063476991391e-09,
 -4.179074153814880e-11,  5.218010174744442e-13, -6.129667403783874e-15,  6.782040117060099e-17, -6.742306391324689e-19,  4.764815718283470e-21,  2.015509508464044e-23,
 -1.837511082439183e-24,  4.793317565918137e-26,  2.499970923908998e-05, -5.681334819350827e-07,  9.038664134367898e-09, -1.232505904784911e-10,  1.539885107004075e-12,
 -1.814823907222876e-14,  2.037031688829143e-16, -2.145654153976915e-18,  1.967093922958921e-20, -1.099929499941409e-22, -1.133827998893238e-24,  5.278507966943233e-26,
  1.944916029193557e-05, -4.419948410625637e-07,  7.032023611699029e-09, -9.590402119726594e-11,  1.199450659304308e-12, -1.421087239721225e-14,  1.631892675315895e-16,
 -1.869834288709418e-18,  2.248453897097998e-20, -3.028377233911483e-22,  4.638782271634686e-24, -7.386618588528350e-26,  5.685157221269591e-06, -1.291993112042370e-07,
  2.055593348728579e-09, -2.804152042279835e-11,  3.512520672209822e-13, -4.194605048475794e-15,  4.979092151667762e-17, -6.358124806948735e-19,  9.782003936623464e-21,
 -1.861713646436236e-22,  3.855692832733607e-24, -7.420589700194372e-26,  6.588287713235227e-07, -1.497243032899415e-08,  2.382263713840007e-10, -3.250979035788261e-12,
  4.081592705671224e-14, -4.931371849930143e-16,  6.133811639050410e-18, -8.930669127802318e-20,  1.699309495571639e-21, -3.892970503607145e-23,  8.960129738328038e-25,
 -1.820886413005435e-26,  2.763788958082386e-08, -6.280984022916050e-10,  9.994393855984203e-12, -1.364662898554756e-13,  1.719376510679647e-15, -2.114422528925855e-17,
  2.810974774312296e-19, -4.776760530916809e-21,  1.089698198526441e-22, -2.803802112098767e-24,  6.839559622272161e-26, -1.439078452363954e-27,  3.195857644716952e-10,
 -7.262987016539807e-12,  1.155834494448695e-13, -1.579689771210516e-15,  2.002052487209620e-17, -2.534676419050268e-19,  3.722657096739774e-21, -7.597458980609113e-23,
  2.031088050549469e-24, -5.686629713959393e-26,  1.451558731742924e-27, -3.168489797024165e-29,  4.773151918027582e-13, -1.084783695709843e-14,  1.726744392737044e-16,
 -2.364506902221681e-18,  3.033451788447344e-20, -4.070873877511362e-22,  7.095266001197643e-24, -1.826810977536580e-25,  5.688564776493390e-27, -1.724535291233487e-28,
  4.656447011429034e-30, -1.081376319235735e-31,  7.753083072382139e-06, -1.700121835422992e-07,  2.609891587298828e-09, -3.434033859905585e-11,  4.140457477938649e-13,
 -4.711036125953858e-15,  5.110528859627192e-17, -5.208367453296558e-19,  4.581563693215052e-21, -2.122497874364559e-23, -4.455692843119020e-25,  1.851022977463472e-26,
  2.286298389568912e-05, -5.013473043888753e-07,  7.696315784215757e-09, -1.012697141372992e-10,  1.221294006431155e-12, -1.391304665875846e-14,  1.518021785989602e-16,
 -1.584530146889582e-18,  1.533803704790500e-20, -1.213361791779375e-22,  3.041525671788661e-25,  1.670299513349873e-26,  1.778683835071319e-05, -3.900360954415774e-07,
  5.987587381079241e-09, -7.879020708008617e-11,  9.505394951721285e-13, -1.085022574417115e-14,  1.194905161869841e-16, -1.294505383951527e-18,  1.425937184576111e-20,
 -1.694038496553467e-22,  2.309892111961133e-24, -3.576988518710327e-26,  5.199245286800208e-06, -1.140109985165741e-07,  1.750242018647113e-09, -2.303318335156716e-11,
  2.780277070423713e-13, -3.183154153762199e-15,  3.554260874931968e-17, -4.057524682706546e-19,  5.202294533016295e-21, -8.300325996112711e-23,  1.605819579013362e-24,
 -3.250251832461486e-26,  6.025183434001199e-07, -1.321226584531020e-08,  2.028313018864853e-10, -2.669581746496828e-12,  3.224980024477907e-14, -3.708702477188308e-16,
  4.225190902523654e-18, -5.177634469791011e-20,  7.836284179535133e-22, -1.551014799842828e-23,  3.511573554605985e-25, -7.719074733658189e-27,  2.527565545746883e-08,
 -5.542559213308180e-10,  8.508981227778171e-12, -1.120122072947583e-13,  1.354822249208787e-15, -1.568595029138970e-17,  1.841311291324472e-19, -2.482177055927477e-21,
  4.476086219728938e-23, -1.041948205119607e-24,  2.582989557834673e-26, -5.938796109631384e-28,  2.922703110089458e-10, -6.409055807370862e-12,  9.839587442462781e-14,
 -1.295673767912061e-15,  1.570349425110837e-17, -1.838574374131931e-19,  2.263733762584957e-21, -3.483462964311651e-23,  7.557767640327813e-25, -2.001448573702437e-26,
  5.291225750861769e-28, -1.262020517048078e-29,  4.365178318526412e-13, -9.572252799438276e-15,  1.469697638999466e-16, -1.936467895513487e-18,  2.356730280531994e-20,
 -2.822643464438849e-22,  3.805470940713653e-24, -7.179179663831680e-26,  1.916046799772212e-27, -5.702807132986723e-29,  1.605091132650500e-30, -4.019523136973237e-32,
  7.112332807308035e-06, -1.506755179048043e-07,  2.234649648649637e-09, -2.840740140180546e-11,  3.309913230635944e-13, -3.643738814730818e-15,  3.844269774607302e-17,
 -3.886061165133581e-19,  3.647392874707000e-21, -2.756728977224614e-23,  3.304281203092725e-26,  5.274056663255498e-27,  2.097348186089489e-05, -4.443254652018693e-07,
  6.589743115361507e-09, -8.377128498406332e-11,  9.761417917823170e-13, -1.075065763970424e-14,  1.136733589079160e-16, -1.160178657790551e-18,  1.131253469757503e-20,
 -1.000997891596807e-22,  6.486027273802452e-25,  1.546114631128014e-27,  1.631685177943309e-05, -3.456743172585608e-07,  5.126668681152535e-09, -6.517325813377480e-11,
  7.595214325470266e-13, -8.370910999888368e-15,  8.882716468794839e-17, -9.206055687500159e-19,  9.507574530670675e-21, -1.018024020971587e-22,  1.207775386502838e-24,
 -1.672826582024596e-26,  4.769555384129912e-06, -1.010435868231199e-07,  1.498573919506969e-09, -1.905125296471706e-11,  2.220615233407720e-13, -2.450031504242001e-15,
  2.613735679057429e-17, -2.770447832746502e-19,  3.091751515242504e-21, -4.038033675873248e-23,  6.665715201464868e-25, -1.292741245937591e-26,  5.527233756656458e-07,
 -1.170951359581603e-08,  1.736641377902459e-10, -2.207862236415683e-12,  2.574177356722905e-14, -2.844622893157521e-16,  3.058606313433302e-18, -3.347771452709197e-20,
  4.125401880908665e-22, -6.532955845275286e-24,  1.323028436273661e-25, -2.920727543697809e-27,  2.318675319562859e-08, -4.912145353360645e-10,  7.285264317952885e-12,
 -9.262579752051138e-14,  1.080376921076609e-15, -1.196759048807423e-17,  1.302129441236656e-19, -1.493038102011094e-21,  2.083543887057205e-23, -3.956194937760350e-25,
  9.196072424177209e-27, -2.178587311050920e-28,  2.681156346139584e-10, -5.680071559841270e-12,  8.424273692923357e-14, -1.071172880141452e-15,  1.250239125721681e-17,
 -1.390423911545824e-19,  1.542411176237557e-21, -1.899045283698687e-23,  3.104138313238530e-25, -6.999178569684641e-27,  1.801835177121588e-28, -4.487057668238062e-30,
  4.004416864957483e-13, -8.483434602380736e-15,  1.258227773037252e-16, -1.600170361726598e-18,  1.870163512978514e-20, -2.096542741591033e-22,  2.416515492442358e-24,
 -3.376485873299855e-26,  6.856471347638763e-28, -1.839050302117862e-29,  5.179552619699191e-31, -1.357306123793459e-32,  6.543346355141556e-06, -1.340770765831672e-07,
  1.923283950661479e-09, -2.364788299062135e-11,  2.665257697100434e-13, -2.839395584136613e-15,  2.905043680523783e-17, -2.871738634375336e-19,  2.717795513283039e-21,
 -2.337222725894831e-23,  1.434530489093055e-25,  6.269823387380728e-28,  1.929560371605739e-05, -3.953784613381857e-07,  5.671553533361919e-09, -6.973524130459005e-11,
  7.859768948216677e-13, -8.374560592103241e-15,  8.575051160673887e-17, -8.508117797696136e-19,  8.175185710922920e-21, -7.457103850109062e-23,  5.966941851417065e-25,
 -2.835457949863499e-27,  1.501150382033808e-05, -3.075947067518671e-07,  4.412331499394554e-09, -5.425261634337371e-11,  6.114982161195326e-13, -6.517088121413691e-15,
  6.681774684567164e-17, -6.669244275876103e-19,  6.563524963765141e-21, -6.517943832928007e-23,  6.849974712814225e-25, -8.177391923816828e-27,  4.387990949966301e-06,
 -8.991256981933983e-08,  1.289763417010591e-09, -1.585864243842694e-11,  1.787581916417010e-13, -1.905825487660684e-15,  1.957783508498022e-17, -1.971503013533218e-19,
  2.008186389205177e-21, -2.221844390588037e-23,  2.981338570611425e-25, -5.049425832503218e-27,  5.085054955673975e-07, -1.041958407058112e-08,  1.494653640093335e-10,
 -1.837813740789213e-12,  2.071756863995304e-14, -2.209986821412364e-16,  2.276739169265655e-18, -2.322524466693061e-20,  2.481750202782900e-22, -3.123312524388309e-24,
  5.160127350864951e-26, -1.051189232668621e-27,  2.133181191398197e-08, -4.371017497044577e-10,  6.270086444282258e-12, -7.709778868988080e-14,  8.692314751812483e-16,
 -9.279820748324932e-18,  9.601565433819821e-20, -9.985367373811330e-22,  1.140699915000086e-23, -1.666163218306954e-25,  3.279948027744552e-27, -7.486445167047432e-29,
  2.466663607570899e-10, -5.054344413956125e-12,  7.250318808003072e-14, -8.915332531514777e-16,  1.005361916221291e-17, -1.074741359789404e-19,  1.119905389494363e-21,
 -1.201199969307438e-23,  1.512197837491530e-25, -2.624426660370289e-27,  6.006735424801131e-29, -1.485610627962466e-30,  3.684062848876460e-13, -7.548873356516158e-15,
  1.082871399158336e-16, -1.331621214183404e-18,  1.502259225782683e-20, -1.610169915453095e-22,  1.701612812437798e-24, -1.936133189706572e-26,  2.858407159556338e-28,
 -6.130345709202409e-30,  1.615066349935537e-31, -4.285411678549936e-33,  6.036110302951394e-06, -1.197574910063240e-07,  1.663337471355212e-09, -1.980245884702632e-11,
  2.161062901750219e-13, -2.229585137130843e-15,  2.210869067014008e-17, -2.125386828367218e-19,  1.981459427936274e-21, -1.758589244010474e-23,  1.371314577534964e-25,
 -6.059869013090863e-28,  1.779982074995303e-05, -3.531515799505606e-07,  4.904998502602325e-09, -5.839532009925833e-11,  6.372789955234766e-13, -6.575181875245184e-15,
  6.521801378578210e-17, -6.278159308848852e-19,  5.887409807469701e-21, -5.346836814005194e-23,  4.558090292845517e-25, -3.239398722689315e-27,  1.384782153015156e-05,
 -2.747432225988404e-07,  3.815968514793324e-09, -4.543019680433126e-11,  4.957942241763921e-13, -5.115809974203902e-15,  5.076562197193956e-17, -4.897654542945400e-19,
  4.636208965463177e-21, -4.363311723843782e-23,  4.197865082839713e-25, -4.365213178358195e-27,  4.047836650575900e-06, -8.030979490162706e-08,  1.115440513153745e-09,
 -1.327966891298751e-11,  1.449278870786095e-13, -1.495604561162685e-15,  1.485128975505976e-17, -1.437493666839207e-19,  1.379757824311002e-21, -1.365027479584181e-23,
  1.514748756735232e-25, -2.093158706104849e-27,  4.690864669619208e-07, -9.306758705240230e-09,  1.292636756050381e-10, -1.538929729258192e-12,  1.679558011591672e-14,
 -1.733548092168375e-16,  1.723107747085803e-18, -1.675877855698502e-20,  1.641056877165925e-22, -1.736147436219432e-24,  2.252952857198977e-26, -3.846341595751566e-28,
  1.967818302491916e-08, -3.904186573323395e-10,  5.422615763461138e-12, -6.455847916924407e-14,  7.046066415602885e-16, -7.274479320934529e-18,  7.241445829271200e-20,
 -7.094071215019895e-22,  7.153424922317505e-24, -8.275045642372978e-26,  1.267160916884948e-27, -2.540112172154486e-29,  2.275449340978064e-10, -4.514532325130084e-12,
  6.270344310532303e-14, -7.465163452999045e-16,  8.148177631856985e-18, -8.415904175961786e-20,  8.398017264657551e-22, -8.324135254578839e-24,  8.786957795213188e-26,
 -1.148480089006950e-27,  2.093928118187873e-29, -4.768010408524727e-31,  3.398476456097979e-13, -6.742639087617155e-15,  9.365030680257139e-17, -1.114971514506914e-18,
  1.217134154407617e-20, -1.258171536429394e-22,  1.261498154084790e-24, -1.279379599740325e-26,  1.468496625991024e-28, -2.305779606333571e-30,  5.102299271576300e-32,
 -1.300215643505454e-33  };
  int offset = -8;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 8;
    if (std::isnan(t)) {
      fill_n(rr+offset, 8, 0.5);
      fill_n(ww+offset, 8, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 8; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=8; ++j) {
        const int boxof = it*96+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
