subroutine vff3d(nno, poids, dfde, coor, jac)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
    implicit none
    integer :: nno
    real(kind=8) :: poids, dfde(nno), coor(3*nno), jac
! ......................................................................
!    - FONCTION REALISEE:  VALEUR DU POIDS D'INTEGRATION POUR UN SEGMENT
!                          A 2 OU 3 NOEUDS
!    - ARGUMENTS:
!        DONNEES:          NNO      -->  NOMBRE DE NOEUDS
!                          KP       -->  NUMERO DU POINTS DE GAUSS
!                          COOR     -->  COORDONNEES DES NOEUDS
!
!      RESULTATS:          JAC      <--  JACOBIEN ASSOCIE
! ......................................................................
!
    real(kind=8) :: dxds, dyds, dzds
    integer :: i
!
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
    dxds = 0.d0
    dyds = 0.d0
    dzds = 0.d0
    do 1 i = 1, nno
        dxds = dxds + dfde(i) * coor(3*i-2)
        dyds = dyds + dfde(i) * coor(3*i-1)
        dzds = dzds + dfde(i) * coor(3*i)
 1  end do
    jac = poids * sqrt(dxds**2 + dyds**2 + dzds**2)
end subroutine
