/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 19:12:52 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.MegaBlastComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class MegaBlastComparisonData_ESTest extends MegaBlastComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData();
      try { 
        megaBlastComparisonData0.makeMatchFromString("while reading MegaBlast data: second field (");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MegaBlast data: not enough fields in this line: while reading MegaBlast data: second field (
         //
         verifyException("uk.ac.sanger.artemis.MegaBlastComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        MegaBlastComparisonData.formatCorrect((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("internal error - unreachable code").when(linePushBackReader0).readLine();
      MegaBlastComparisonData megaBlastComparisonData0 = null;
      try {
        megaBlastComparisonData0 = new MegaBlastComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading MegaBlast data: not enough fields in this line: internal error - unreachable code
         //
         verifyException("uk.ac.sanger.artemis.MegaBlastComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("", (String) null).when(linePushBackReader0).readLine();
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = null;
      try {
        megaBlastComparisonData0 = new MegaBlastComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData();
      // Undeclared exception!
      try { 
        megaBlastComparisonData0.makeMatchFromString((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      boolean boolean0 = MegaBlastComparisonData.formatCorrect(">Ms badly forma,ted in thiP lIne: ");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData(linePushBackReader0);
      SimpleComparisonData simpleComparisonData0 = megaBlastComparisonData0.getNewSimpleComparisonData();
      assertFalse(simpleComparisonData0.equals((Object)megaBlastComparisonData0));
  }
}
