#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Incredible Adventures of Van Helsing
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251117.5

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='van-helsing-final-cut'
GAME_NAME='The Incredible Adventures of Van Helsing: Final Cut'

ARCHIVE_BASE_0_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988).exe'
ARCHIVE_BASE_0_MD5='11823fff68df72308f3f8ba8f9dfa820'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='07fcaf654ce6cfb9026d1e6e40b06bf3'
ARCHIVE_BASE_0_PART2_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='de5281e71e9d68bb196da32c09048ec9'
ARCHIVE_BASE_0_PART3_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='721981718e036fb2fb4e848543241be7'
ARCHIVE_BASE_0_PART4_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='dc7981e674f6400d1919d56b735854fd'
ARCHIVE_BASE_0_PART5_NAME='setup_the_incredible_adventures_of_van_helsing_-_final_cut_1.1.0b_(b)_(23988)-5.bin'
ARCHIVE_BASE_0_PART5_MD5='0d9cec82a419c8abb5a7a414817e1446'
ARCHIVE_BASE_0_SIZE='35870060'
ARCHIVE_BASE_0_VERSION='1.1.0b-gog23988'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_incredible_adventures_of_van_helsing_final_cut'

CONTENT_PATH_DEFAULT='.'
## vanhelsing_x64.exe requirements
CONTENT_LIBS_BIN_FILES='
PhysX3_x64.dll
PhysX3Common_x64.dll
PhysX3Cooking_x64.dll
Galaxy64.dll'
CONTENT_GAME_BIN_FILES='
vanhelsing_x64.exe'
CONTENT_GAME_L10N_FR_FILES='
strings/french
ui/loadingscreens/fr
videos/fr/*.srt'
CONTENT_GAME_L10N_EN_FILES='
strings/eng
ui/loadingscreens/eng
videos/eng/*.srt'
CONTENT_GAME_DATA_FILES='
cfg
cgshaders
commontextures
effects
models
sounds/ambient
sounds/effects
sounds/general
sounds/misc
sounds/music
sounds/options
sounds/shrines
sounds/skills
sounds/soldiers
sounds/soldiers_low
sounds/touchdown
sounds/treasurechests
sounds/languages/eng
sounds/sample.ogg
textures
ui
videos/eng/*.ogg
videos/eng/*.webm'
CONTENT_GAME0_DATA_PATH='app'
CONTENT_GAME0_DATA_FILES='
cfg/skills/monster/__gargoyle_zuhanas_effect.cfg
cfg/soldier/02_normal_ranged/atd_inkmachine_generalis.cfg'
CONTENT_GAME_DATA_TERRAINS_1_FILES='
terrains/barrikados
terrains/belvaros
terrains/bossc2
terrains/cave
terrains/city1*
terrains/clockwork_keep
terrains/csatorna_*
terrains/dark_carnival
terrains/dr_csont
terrains/driad_boss_arena
terrains/final_boss
terrains/floating_monastery
terrains/gasmachine
terrains/gergo_kezdoteszt
terrains/giantwoods
terrains/gorge_of_eternal_peril
terrains/gyarnegyed
terrains/haunted_forest_*
terrains/hf_arena'
CONTENT_GAME_DATA_TERRAINS_2_FILES='
terrains/ink*
terrains/kapubirtok
terrains/kisbarlang
terrains/kohok*
terrains/kristalyos_ink
terrains/kutatolabor
terrains/lair_01_03
terrains/memorial_perk
terrains/nagyerdo
terrains/nightmare_hollow_ring*'
CONTENT_GAME_DATA_TERRAINS_3_FILES='
terrains/ostrom2
terrains/pokol*
terrains/poksziklak
terrains/pvp_karacsony
terrains/steamhall
terrains/szerpentin
terrains/tetok2
terrains/tetok_final
terrains/touchdown
terrains/tutorial
terrains/vh*
terrains/viztisztito*
terrains/wolf_den
terrains/wormcave'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/NeocoreGames/Van Helsing Final Cut'
WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\NeoCore Games\Van Helsing Final Cut'
WINE_REGISTRY_INIT_L10N_FR='
[HKEY_CURRENT_USER\Software\NeoCore Games\Van Helsing Final Cut]
"Language"="FR"
'
WINE_REGISTRY_INIT_L10N_EN='
[HKEY_CURRENT_USER\Software\NeoCore Games\Van Helsing Final Cut]
"Language"="eng"
'

APP_MAIN_EXE='vanhelsing_x64.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_FR
PKG_L10N_EN
PKG_DATA
PKG_DATA_TERRAINS_1
PKG_DATA_TERRAINS_2
PKG_DATA_TERRAINS_3'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
deinterlace
video/x-ms-asf'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_FR_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_EN_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localisation'
PKG_L10N_EN_DESCRIPTION='English localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_TERRAINS_1
PKG_DATA_TERRAINS_2
PKG_DATA_TERRAINS_3'
## Easier upgrades from pre-20251115.1 packages
PKG_DATA_PROVIDES='
van-helsing-final-cut-l10n-common'

PKG_DATA_TERRAINS_ID="${PKG_DATA_ID}-terrains"
PKG_DATA_TERRAINS_1_ID="${PKG_DATA_TERRAINS_ID}-1"
PKG_DATA_TERRAINS_2_ID="${PKG_DATA_TERRAINS_ID}-2"
PKG_DATA_TERRAINS_3_ID="${PKG_DATA_TERRAINS_ID}-3"
PKG_DATA_TERRAINS_DESCRIPTION="$PKG_DATA_DESCRIPTION - terrains"
PKG_DATA_TERRAINS_1_DESCRIPTION="$PKG_DATA_TERRAINS_DESCRIPTION - 1"
PKG_DATA_TERRAINS_2_DESCRIPTION="$PKG_DATA_TERRAINS_DESCRIPTION - 2"
PKG_DATA_TERRAINS_3_DESCRIPTION="$PKG_DATA_TERRAINS_DESCRIPTION - 3"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write the localisations configuration.

## English
cat > "$(package_path 'PKG_L10N_EN')$(path_game_data)/strings/languages.xml" << EOF
<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
<Root>
	<LanguageName>
		<eng>English</eng>
	</LanguageName>
	<Languages>eng</Languages>
</Root>
EOF
## French
cat > "$(package_path 'PKG_L10N_FR')$(path_game_data)/strings/languages.xml" << EOF
<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
<Root>
	<LanguageName>
		<FR>French</FR>
	</LanguageName>
	<Languages>FR</Languages>
</Root>
EOF

# Write launchers.

## Set localisation of first launch.
for package in \
	'PKG_L10N_FR' \
	'PKG_L10N_EN'
do (
	set_current_package "$package"
	## TODO: Compatibility level 2.34 adds context support to WINE_REGISTRY_INIT.
	WINE_REGISTRY_INIT=$(context_value 'WINE_REGISTRY_INIT')
	# shellcheck disable=SC2218
	wine_registry_script_write "$package"
) done
wine_registry_script_write() { return 0; }
## A dummy value is set to trigger the integration of the registry script in the generated launcher.
WINE_REGISTRY_INIT='whatever'

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
case "$(messages_language)" in
	('fr')
		message='version %s :'
		lang_fr='française'
		lang_en='anglaise'
	;;
	('en'|*)
		message='%s version:'
		lang_fr='French'
		lang_en='English'
	;;
esac
printf '\n'
printf "$message" "$lang_fr"
print_instructions \
	'PKG_BIN' \
	'PKG_DATA' 'PKG_DATA_TERRAINS_1' 'PKG_DATA_TERRAINS_2' 'PKG_DATA_TERRAINS_3' \
	'PKG_L10N_FR'
printf "$message" "$lang_en"
print_instructions \
	'PKG_BIN' \
	'PKG_DATA' 'PKG_DATA_TERRAINS_1' 'PKG_DATA_TERRAINS_2' 'PKG_DATA_TERRAINS_3' \
	'PKG_L10N_EN'

# Clean up.

working_directory_cleanup

exit 0
