/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffTags;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class TDump
extends Dump {
    private static int _nIFDs;
    private static Map _tags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            System.err.println("usage: java TDump [-bs] file");
            System.exit(-1);
        }
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-b")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-s")) {
                bl2 = true;
                continue;
            }
            if (string != null) continue;
            string = stringArray[n];
        }
        _tags = new TreeMap();
        n = 0;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            boolean bl3 = true;
            int n2 = ModuleBase.readUnsignedByte(randomAccessFile);
            int n3 = ModuleBase.readUnsignedByte(randomAccessFile);
            if (n2 == 73 && n3 == n2) {
                bl3 = false;
            }
            int n4 = ModuleBase.readUnsignedShort(randomAccessFile, bl3);
            long l = ModuleBase.readUnsignedInt(randomAccessFile, bl3);
            _tags.put("00000000", "\"" + (char)n2 + (char)n3 + "\" (" + (bl3 ? "big" : "little") + " endian) " + n4 + " LONG @" + l);
            _nIFDs = 0;
            while ((l = TDump.readIFD(randomAccessFile, bl3, l, bl, bl2)) > 0L) {
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            n = -2;
        }
        finally {
            for (String string2 : _tags.keySet()) {
                System.out.println(string2 + ": " + (String)_tags.get(string2));
            }
            if (n != 0) {
                System.exit(n);
            }
        }
    }

    private static long readIFD(RandomAccessFile randomAccessFile, boolean bl, long l, boolean bl2, boolean bl3) throws Exception {
        int n;
        long l2;
        int n2;
        int n3 = ++_nIFDs;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        randomAccessFile.seek(l);
        int n4 = ModuleBase.readUnsignedShort(randomAccessFile, bl);
        _tags.put(TDump.leading(l, 8) + l, "IFD " + n3 + " with " + n4 + " entries");
        Object var11_10 = null;
        for (n2 = 0; n2 < n4; ++n2) {
            long l3;
            int n5;
            int n6;
            l2 = l + 2L + (long)(n2 * 12);
            randomAccessFile.seek(l2);
            int n7 = ModuleBase.readUnsignedShort(randomAccessFile, bl);
            n = ModuleBase.readUnsignedShort(randomAccessFile, bl);
            long l4 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
            StringBuffer stringBuffer = new StringBuffer(n7 + " (" + TiffTags.tagName(n7) + ") " + IFD.TYPE[n] + " " + l4);
            if (n == 2) {
                if (l4 > 4L) {
                    long l5 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l5);
                    stringBuffer.append(" @" + l5);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                n6 = 0;
                while ((long)n6 < l4 - 1L) {
                    stringBuffer2.append((char)ModuleBase.readUnsignedByte(randomAccessFile));
                    ++n6;
                }
                stringBuffer.append(" = \"" + stringBuffer2.toString() + "\"");
            } else if (n == 1 || n == 7) {
                if (l4 > 4L) {
                    long l6 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l6);
                    stringBuffer.append(" @" + l6);
                }
                stringBuffer.append(" =");
                long l7 = l4;
                if (bl2 && l4 > 8L) {
                    l7 = 8L;
                }
                n5 = 0;
                while ((long)n5 < l7) {
                    long l8 = ModuleBase.readUnsignedByte(randomAccessFile);
                    stringBuffer.append(" " + l8);
                    ++n5;
                }
                if (bl2 && l4 > 8L) {
                    stringBuffer.append(" ...");
                }
            } else if (n == 12) {
                long l9 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                randomAccessFile.seek(l9);
                stringBuffer.append(" @" + l9 + " =");
                n5 = 0;
                while ((long)n5 < l4) {
                    double d = ModuleBase.readDouble(randomAccessFile, bl);
                    stringBuffer.append(" " + d);
                    ++n5;
                }
            } else if (n == 11) {
                if (l4 > 1L) {
                    long l10 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l10);
                    stringBuffer.append(" @" + l10);
                }
                stringBuffer.append(" =");
                int n8 = 0;
                while ((long)n8 < l4) {
                    float f = ModuleBase.readFloat(randomAccessFile, bl);
                    stringBuffer.append(" " + f);
                    ++n8;
                }
            } else if (n == 4 || n == 13) {
                if (l4 > 1L) {
                    long l11 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l11);
                    stringBuffer.append(" @" + l11 + " = ");
                } else if (n7 == 330 || n7 == 34665 || n7 == 34853 || n7 == 40965) {
                    stringBuffer.append(" @");
                } else {
                    stringBuffer.append(" = ");
                }
                int n9 = 0;
                while ((long)n9 < l4) {
                    long l12 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    if (n9 > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(l12);
                    if (n7 == 330 || n7 == 34665 || n7 == 34853 || n7 == 40965) {
                        arrayList.add(new Long(l12));
                    } else if (n7 == 273) {
                        arrayList3.add(new Long(l12));
                    } else if (n7 == 279) {
                        arrayList2.add(new Long(l12));
                    }
                    ++n9;
                }
            } else if (n == 5) {
                long l13 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                randomAccessFile.seek(l13);
                stringBuffer.append(" @" + l13 + " =");
                n5 = 0;
                while ((long)n5 < l4) {
                    long l14 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    l3 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    stringBuffer.append(" " + l14 + "/" + l3);
                    ++n5;
                }
            } else if (n == 6) {
                if (l4 > 4L) {
                    long l15 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l15);
                    stringBuffer.append(" @" + l15);
                }
                stringBuffer.append(" =");
                int n10 = 0;
                while ((long)n10 < l4) {
                    long l16 = ModuleBase.readSignedByte(randomAccessFile);
                    stringBuffer.append(" " + l16);
                    ++n10;
                }
            } else if (n == 3) {
                if (l4 > 2L) {
                    long l17 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l17);
                    stringBuffer.append(" @" + l17);
                }
                stringBuffer.append(" =");
                int n11 = 0;
                while ((long)n11 < l4) {
                    n6 = ModuleBase.readUnsignedShort(randomAccessFile, bl);
                    stringBuffer.append(" " + n6);
                    if (n7 == 273) {
                        arrayList3.add(new Long(n6));
                    } else if (n7 == 279) {
                        arrayList2.add(new Long(n6));
                    }
                    ++n11;
                }
            } else if (n == 9) {
                if (l4 > 1L) {
                    long l18 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l18);
                    stringBuffer.append(" @" + l18);
                }
                stringBuffer.append(" =");
                int n12 = 0;
                while ((long)n12 < l4) {
                    n6 = ModuleBase.readSignedInt(randomAccessFile, bl);
                    stringBuffer.append(" " + n6);
                    ++n12;
                }
            } else if (n == 10) {
                long l19 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                randomAccessFile.seek(l19);
                stringBuffer.append(" @" + l19 + " =");
                n5 = 0;
                while ((long)n5 < l4) {
                    long l20 = ModuleBase.readSignedInt(randomAccessFile, bl);
                    l3 = ModuleBase.readSignedInt(randomAccessFile, bl);
                    stringBuffer.append(" " + l20 + "/" + l3);
                    ++n5;
                }
            } else if (n == 8) {
                if (l4 > 2L) {
                    long l21 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
                    randomAccessFile.seek(l21);
                    stringBuffer.append(" @" + l21);
                }
                stringBuffer.append(" =");
                int n13 = 0;
                while ((long)n13 < l4) {
                    n6 = ModuleBase.readSignedShort(randomAccessFile, bl);
                    stringBuffer.append(" " + n6);
                    ++n13;
                }
            }
            _tags.put(TDump.leading(l2, 8) + l2, stringBuffer.toString());
        }
        if (!bl3) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                l2 = (Long)arrayList.get(n2);
                while ((l2 = TDump.readIFD(randomAccessFile, bl, l2, bl2, bl3)) > 0L) {
                }
            }
        }
        long l22 = l + 2L + (long)(n4 * 12);
        randomAccessFile.seek(l22);
        long l23 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
        _tags.put(TDump.leading(l22, 8) + l22, "NextIFDOffset LONG @" + l23);
        n = arrayList3.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                long l24 = (Long)arrayList3.get(i);
                long l25 = (Long)arrayList2.get(i);
                long l26 = l24 + l25 - 1L;
                _tags.put(TDump.leading(l24, 8) + l24, "(Image " + n3 + ",strip " + (i + 1) + ") IMAGEDATA " + l25 + ": ... " + TDump.leading(l26, 8) + l26);
            }
        }
        return l23;
    }
}

