/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICFII.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateFileINI(char *fnam)

ob(ject): cfgCreateFileINI
ty: H
su(bsystem): inifile/1
sh(ort description): Open an INI file for writing
lo(ng description): Open an INI file named \para{name} for writing. Until cfgCreateCloseINI()
 is called, the file is kept as a temporary file. That reduces the case
 when the INI file would be corrupted, also the "old" INI file can be read
 during the write process.\par
 The filename is duplicated into dynamic memory (heap).
pr(erequistes):= \para{name} != NULL
fi(le): cfgicfii.c

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "dfn.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICFII.C 1.5 2001/02/27 01:27:24 ska Exp ska $";
#endif


int cfgCreateFileINI(const char * const fnam)
{	char *nam;
	int rv;

	DBG_ENTER("cfgCreateFileINI", Suppl_inifile1)

	chkHeap
	if(!fnam)			DBG_RETURN_I( CFG_ERR_ARG)

	DBG_ARGUMENTS( ("fnam=\"%s\"", fnam) )

	if((rv = cfgi_createFile(nam = dfnexpand(fnam, 0))) != CFG_ERR_NONE)
		free(nam);
	chkHeap

	DBG_RETURN_I( rv)
}
