/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_OS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_opSec(char * const name, int updName);

	Open a new section.

	name is already duplicated into the heap.
	On failure, name is free()'ed.
	If updName != 0, the found name will override the passed in name.

ob: cfgi_opSec
ty: L
su: inifile/2
sh: Open a section
lo: Opens a section.\par
	\para{name} must be dynamically allocated. It is deallocated, if this
	function fails.\par
	If \para{updName} is true, the name of section as it is written within
	the INI file is cached rather than the name passed into this function.
re: 
fi: cfgi_os.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"

#define dupKey() 													\
	!updName?	CFG_ERR_NONE										\
	: name?  (StrCpy(I(key), I(data))? CFG_ERR_NONE: CFG_ERR_MEM)	\
		:	(StrRepl(I(key), 0), CFG_ERR_NONE)

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_OS.C 1.5 2001/02/27 01:27:56 ska Exp ska $";
#endif

int cfgi_opSec(char * const name, int updName)
{	int rv;

	DBG_ENTER("cfgi_opSec", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", update=%d", name, updName) )

	chkHeap
	StrRepl(I(key), name);
	chkHeap

	rv = (usrini.cfgi_avail || sysini.cfgi_avail)
		? CFG_ERR_NONE
		: CFG_ERR_KEY;

	/* Both Has*Section() functions return the name of the INI file
		in data[] */

	if(!usrini.cfgi_avail && cfgHasUserSection(name) == CFG_ERR_NONE) {
		chkHeap
		usrini.cfgi_avail = 1;
		FFgetpos(usrini.cfgi_fp, usrini.cfgi_pos);
		Fposcpy(aS(usrini.cfgi_keypos), aS(I(curpos)));
		if(rv == CFG_ERR_KEY)		/* key not updated */
			rv = dupKey();
		chkHeap
	}
	if(!sysini.cfgi_avail && cfgHasSystemSection(name) == CFG_ERR_NONE) {
		chkHeap
		sysini.cfgi_avail = 1;
		FFgetpos(sysini.cfgi_fp, sysini.cfgi_pos);
		Fposcpy(aS(sysini.cfgi_keypos), aS(I(curpos)));
		if(rv == CFG_ERR_KEY)		/* key not updated */
			rv = dupKey();
		chkHeap
	}

	DBG_RETURN_I( rv)
}
