(* \chaptertitle{Paper}{Standard Media Sizes} *)

(* \intf Type for paper sizes --- unit, width, height. *)
type papersize = Paper of (Units.unit * float * float)

let make u w h = Paper (u, w, h)

let unit (Paper (u, _, _)) = u
let width (Paper (_, w, _)) = w
let height (Paper (_, _, h)) = h

(* \intf Make a paper size landscape *)
let landscape (Paper (u, w, h)) = Paper (u, h, w)

(* \intf European `A' sizes. *)
let a0 = Paper (Units.Millimetre, 841., 1189.)
and a1 = Paper (Units.Millimetre, 594., 841.)
and a2 = Paper (Units.Millimetre, 420., 594.)
and a3 = Paper (Units.Millimetre, 297., 420.)
and a4 = Paper (Units.Millimetre, 210., 297.)
and a5 = Paper (Units.Millimetre, 148., 210.)
and a6 = Paper (Units.Millimetre, 105., 148.)
and a7 = Paper (Units.Millimetre, 74., 105.)
and a8 = Paper (Units.Millimetre, 52., 74.)

(* \intf US Imperial sizes. *)
let usletter = Paper (Units.Inch, 8.5, 11.)
let uslegal = Paper (Units.Inch, 8.5, 14.)


