// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_2_0_autogen.cpp:
//   Defines the GL 2.0 entry points.

#include "libGL/entry_points_gl_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL2_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY AttachShader(GLuint program, GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT("glAttachShader", "context = %d, GLuint program = %u, GLuint shader = %u", CID(context),
          program, shader);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateAttachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->attachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(AttachShader, isCallValid, context, programPacked, shaderPacked);
    }
}

void GL_APIENTRY BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glBindAttribLocation",
        "context = %d, GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%016" PRIxPTR
        "",
        CID(context), program, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindAttribLocation(context, programPacked, index, name));
        if (isCallValid)
        {
            context->bindAttribLocation(programPacked, index, name);
        }
        ANGLE_CAPTURE(BindAttribLocation, isCallValid, context, programPacked, index, name);
    }
}

void GL_APIENTRY BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBlendEquationSeparate", "context = %d, GLenum modeRGB = %s, GLenum modeAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBlendEquationSeparate(context, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparate, isCallValid, context, modeRGB, modeAlpha);
    }
}

void GL_APIENTRY CompileShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompileShader", "context = %d, GLuint shader = %u", CID(context), shader);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompileShader(context, shaderPacked));
        if (isCallValid)
        {
            context->compileShader(shaderPacked);
        }
        ANGLE_CAPTURE(CompileShader, isCallValid, context, shaderPacked);
    }
}

GLuint GL_APIENTRY CreateProgram()
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateProgram", "context = %d", CID(context));

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateProgram(context));
        if (isCallValid)
        {
            returnValue = context->createProgram();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
        }
        ANGLE_CAPTURE(CreateProgram, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY CreateShader(GLenum type)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateShader", "context = %d, GLenum type = %s", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type));

    GLuint returnValue;
    if (context)
    {
        ShaderType typePacked                         = FromGL<ShaderType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateShader(context, typePacked));
        if (isCallValid)
        {
            returnValue = context->createShader(typePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
        }
        ANGLE_CAPTURE(CreateShader, isCallValid, context, typePacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY DeleteProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteProgram(context, programPacked));
        if (isCallValid)
        {
            context->deleteProgram(programPacked);
        }
        ANGLE_CAPTURE(DeleteProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY DeleteShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDeleteShader", "context = %d, GLuint shader = %u", CID(context), shader);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteShader(context, shaderPacked));
        if (isCallValid)
        {
            context->deleteShader(shaderPacked);
        }
        ANGLE_CAPTURE(DeleteShader, isCallValid, context, shaderPacked);
    }
}

void GL_APIENTRY DetachShader(GLuint program, GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDetachShader", "context = %d, GLuint program = %u, GLuint shader = %u", CID(context),
          program, shader);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDetachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->detachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(DetachShader, isCallValid, context, programPacked, shaderPacked);
    }
}

void GL_APIENTRY DisableVertexAttribArray(GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDisableVertexAttribArray", "context = %d, GLuint index = %u", CID(context), index);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->disableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(DisableVertexAttribArray, isCallValid, context, index);
    }
}

void GL_APIENTRY DrawBuffers(GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDrawBuffers", "context = %d, GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)bufs);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffers(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffers, isCallValid, context, n, bufs);
    }
}

void GL_APIENTRY EnableVertexAttribArray(GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT("glEnableVertexAttribArray", "context = %d, GLuint index = %u", CID(context), index);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->enableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(EnableVertexAttribArray, isCallValid, context, index);
    }
}

void GL_APIENTRY GetActiveAttrib(GLuint program,
                                 GLuint index,
                                 GLsizei bufSize,
                                 GLsizei *length,
                                 GLint *size,
                                 GLenum *type,
                                 GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetActiveAttrib",
          "context = %d, GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR
          ", GLenum *type = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveAttrib(context, programPacked, index, bufSize, length,
                                                    size, type, name));
        if (isCallValid)
        {
            context->getActiveAttrib(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveAttrib, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
}

void GL_APIENTRY GetActiveUniform(GLuint program,
                                  GLuint index,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLint *size,
                                  GLenum *type,
                                  GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetActiveUniform",
          "context = %d, GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei "
          "*length = 0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR
          ", GLenum *type = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetActiveUniform(context, programPacked, index, bufSize, length,
                                                     size, type, name));
        if (isCallValid)
        {
            context->getActiveUniform(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveUniform, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
}

void GL_APIENTRY GetAttachedShaders(GLuint program,
                                    GLsizei maxCount,
                                    GLsizei *count,
                                    GLuint *shaders)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetAttachedShaders",
        "context = %d, GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%016" PRIxPTR
        ", GLuint *shaders = 0x%016" PRIxPTR "",
        CID(context), program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        ShaderProgramID *shadersPacked                = FromGL<ShaderProgramID *>(shaders);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetAttachedShaders(context, programPacked, maxCount, count, shadersPacked));
        if (isCallValid)
        {
            context->getAttachedShaders(programPacked, maxCount, count, shadersPacked);
        }
        ANGLE_CAPTURE(GetAttachedShaders, isCallValid, context, programPacked, maxCount, count,
                      shadersPacked);
    }
}

GLint GL_APIENTRY GetAttribLocation(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetAttribLocation",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetAttribLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getAttribLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
        }
        ANGLE_CAPTURE(GetAttribLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetProgramInfoLog(GLuint program,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetProgramInfoLog",
        "context = %d, GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLchar *infoLog = 0x%016" PRIxPTR "",
        CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInfoLog(context, programPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramInfoLog(programPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramInfoLog, isCallValid, context, programPacked, bufSize, length,
                      infoLog);
    }
}

void GL_APIENTRY GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetProgramiv",
          "context = %d, GLuint program = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramPropertyARB, pname),
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetProgramiv(context, programPacked, pname, params));
        if (isCallValid)
        {
            context->getProgramiv(programPacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramiv, isCallValid, context, programPacked, pname, params);
    }
}

void GL_APIENTRY GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetShaderInfoLog",
          "context = %d, GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderInfoLog(context, shaderPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getShaderInfoLog(shaderPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetShaderInfoLog, isCallValid, context, shaderPacked, bufSize, length,
                      infoLog);
    }
}

void GL_APIENTRY GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetShaderSource",
          "context = %d, GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderSource(context, shaderPacked, bufSize, length, source));
        if (isCallValid)
        {
            context->getShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE(GetShaderSource, isCallValid, context, shaderPacked, bufSize, length, source);
    }
}

void GL_APIENTRY GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT("glGetShaderiv",
          "context = %d, GLuint shader = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), shader, GLenumToString(GLenumGroup::ShaderParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetShaderiv(context, shaderPacked, pname, params));
        if (isCallValid)
        {
            context->getShaderiv(shaderPacked, pname, params);
        }
        ANGLE_CAPTURE(GetShaderiv, isCallValid, context, shaderPacked, pname, params);
    }
}

GLint GL_APIENTRY GetUniformLocation(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformLocation",
          "context = %d, GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR "", CID(context),
          program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUniformLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getUniformLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
        }
        ANGLE_CAPTURE(GetUniformLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformfv",
          "context = %d, GLuint program = %u, GLint location = %d, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformfv(context, programPacked, location, params));
        if (isCallValid)
        {
            context->getUniformfv(programPacked, location, params);
        }
        ANGLE_CAPTURE(GetUniformfv, isCallValid, context, programPacked, location, params);
    }
}

void GL_APIENTRY GetUniformiv(GLuint program, GLint location, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetUniformiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLint *params = 0x%016" PRIxPTR
          "",
          CID(context), program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetUniformiv(context, programPacked, location, params));
        if (isCallValid)
        {
            context->getUniformiv(programPacked, location, params);
        }
        ANGLE_CAPTURE(GetUniformiv, isCallValid, context, programPacked, location, params);
    }
}

void GL_APIENTRY GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribPointerv",
          "context = %d, GLuint index = %u, GLenum pname = %s, void **pointer = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname),
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetVertexAttribPointerv(context, index, pname, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointerv, isCallValid, context, index, pname, pointer);
    }
}

void GL_APIENTRY GetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribdv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLdouble *params = 0x%016" PRIxPTR
          "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribdv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribdv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribdv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribfv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribfv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfv, isCallValid, context, index, pname, params);
    }
}

void GL_APIENTRY GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexAttribiv",
          "context = %d, GLuint index = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribiv, isCallValid, context, index, pname, params);
    }
}

GLboolean GL_APIENTRY IsProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsProgram", "context = %d, GLuint program = %u", CID(context), program);

    GLboolean returnValue;
    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsProgram(context, programPacked));
        if (isCallValid)
        {
            returnValue = context->isProgram(programPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgram, isCallValid, context, programPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY IsShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT("glIsShader", "context = %d, GLuint shader = %u", CID(context), shader);

    GLboolean returnValue;
    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsShader(context, shaderPacked));
        if (isCallValid)
        {
            returnValue = context->isShader(shaderPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
        }
        ANGLE_CAPTURE(IsShader, isCallValid, context, shaderPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY LinkProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT("glLinkProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLinkProgram(context, programPacked));
        if (isCallValid)
        {
            context->linkProgram(programPacked);
        }
        ANGLE_CAPTURE(LinkProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY ShaderSource(GLuint shader,
                              GLsizei count,
                              const GLchar *const *string,
                              const GLint *length)
{
    Context *context = GetValidGlobalContext();
    EVENT("glShaderSource",
          "context = %d, GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = "
          "0x%016" PRIxPTR ", const GLint *length = 0x%016" PRIxPTR "",
          CID(context), shader, count, (uintptr_t)string, (uintptr_t)length);

    if (context)
    {
        ShaderProgramID shaderPacked                  = FromGL<ShaderProgramID>(shader);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateShaderSource(context, shaderPacked, count, string, length));
        if (isCallValid)
        {
            context->shaderSource(shaderPacked, count, string, length);
        }
        ANGLE_CAPTURE(ShaderSource, isCallValid, context, shaderPacked, count, string, length);
    }
}

void GL_APIENTRY StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilFuncSeparate",
          "context = %d, GLenum face = %s, GLenum func = %s, GLint ref = %d, GLuint mask = %u",
          CID(context), GLenumToString(GLenumGroup::StencilFaceDirection, face),
          GLenumToString(GLenumGroup::StencilFunction, func), ref, mask);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilFuncSeparate(context, face, func, ref, mask));
        if (isCallValid)
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
        ANGLE_CAPTURE(StencilFuncSeparate, isCallValid, context, face, func, ref, mask);
    }
}

void GL_APIENTRY StencilMaskSeparate(GLenum face, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT("glStencilMaskSeparate", "context = %d, GLenum face = %s, GLuint mask = %u", CID(context),
          GLenumToString(GLenumGroup::StencilFaceDirection, face), mask);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask));
        if (isCallValid)
        {
            context->stencilMaskSeparate(face, mask);
        }
        ANGLE_CAPTURE(StencilMaskSeparate, isCallValid, context, face, mask);
    }
}

void GL_APIENTRY StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glStencilOpSeparate",
        "context = %d, GLenum face = %s, GLenum sfail = %s, GLenum dpfail = %s, GLenum dppass = %s",
        CID(context), GLenumToString(GLenumGroup::StencilFaceDirection, face),
        GLenumToString(GLenumGroup::StencilOp, sfail),
        GLenumToString(GLenumGroup::StencilOp, dpfail),
        GLenumToString(GLenumGroup::StencilOp, dppass));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass));
        if (isCallValid)
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
        ANGLE_CAPTURE(StencilOpSeparate, isCallValid, context, face, sfail, dpfail, dppass);
    }
}

void GL_APIENTRY Uniform1f(GLint location, GLfloat v0)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform1f", "context = %d, GLint location = %d, GLfloat v0 = %f", CID(context),
          location, v0);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateUniform1f(context, location, v0));
        if (isCallValid)
        {
            context->uniform1f(location, v0);
        }
        ANGLE_CAPTURE(Uniform1f, isCallValid, context, location, v0);
    }
}

void GL_APIENTRY Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform1fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform1fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform1fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform1i(GLint location, GLint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform1i", "context = %d, GLint location = %d, GLint v0 = %d", CID(context), location,
          v0);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateUniform1i(context, location, v0));
        if (isCallValid)
        {
            context->uniform1i(location, v0);
        }
        ANGLE_CAPTURE(Uniform1i, isCallValid, context, location, v0);
    }
}

void GL_APIENTRY Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glUniform1iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform1iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform1iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform2f", "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f",
          CID(context), location, v0, v1);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2f(context, location, v0, v1));
        if (isCallValid)
        {
            context->uniform2f(location, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2f, isCallValid, context, location, v0, v1);
    }
}

void GL_APIENTRY Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform2fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform2fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform2fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform2i(GLint location, GLint v0, GLint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform2i", "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d",
          CID(context), location, v0, v1);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2i(context, location, v0, v1));
        if (isCallValid)
        {
            context->uniform2i(location, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2i, isCallValid, context, location, v0, v1);
    }
}

void GL_APIENTRY Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glUniform2iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform2iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform2iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform3f",
          "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3f(location, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3f, isCallValid, context, location, v0, v1, v2);
    }
}

void GL_APIENTRY Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform3fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform3fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform3fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform3i",
          "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3i(location, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3i, isCallValid, context, location, v0, v1, v2);
    }
}

void GL_APIENTRY Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glUniform3iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform3iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform3iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform4f",
          "context = %d, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, "
          "GLfloat v3 = %f",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4f, isCallValid, context, location, v0, v1, v2, v3);
    }
}

void GL_APIENTRY Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform4fv",
          "context = %d, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
          "0x%016" PRIxPTR "",
          CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4fv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform4fv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform4fv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniform4i",
          "context = %d, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint "
          "v3 = %d",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4i, isCallValid, context, location, v0, v1, v2, v3);
    }
}

void GL_APIENTRY Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glUniform4iv",
        "context = %d, GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR
        "",
        CID(context), location, count, (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4iv(context, location, count, value));
        if (isCallValid)
        {
            context->uniform4iv(location, count, value);
        }
        ANGLE_CAPTURE(Uniform4iv, isCallValid, context, location, count, value);
    }
}

void GL_APIENTRY UniformMatrix2fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniformMatrix2fv",
          "context = %d, GLint location = %d, GLsizei count = %d, GLboolean transpose = %s, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformMatrix2fv(context, location, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2fv, isCallValid, context, location, count, transpose, value);
    }
}

void GL_APIENTRY UniformMatrix3fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniformMatrix3fv",
          "context = %d, GLint location = %d, GLsizei count = %d, GLboolean transpose = %s, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformMatrix3fv(context, location, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3fv(location, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3fv, isCallValid, context, location, count, transpose, value);
    }
}

void GL_APIENTRY UniformMatrix4fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUniformMatrix4fv",
          "context = %d, GLint location = %d, GLsizei count = %d, GLboolean transpose = %s, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateUniformMatrix4fv(context, location, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4fv(location, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4fv, isCallValid, context, location, count, transpose, value);
    }
}

void GL_APIENTRY UseProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUseProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUseProgram(context, programPacked));
        if (isCallValid)
        {
            context->useProgram(programPacked);
        }
        ANGLE_CAPTURE(UseProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY ValidateProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT("glValidateProgram", "context = %d, GLuint program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateValidateProgram(context, programPacked));
        if (isCallValid)
        {
            context->validateProgram(programPacked);
        }
        ANGLE_CAPTURE(ValidateProgram, isCallValid, context, programPacked);
    }
}

void GL_APIENTRY VertexAttrib1d(GLuint index, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1d", "context = %d, GLuint index = %u, GLdouble x = %f", CID(context),
          index, x);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1d(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1d(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1d, isCallValid, context, index, x);
    }
}

void GL_APIENTRY VertexAttrib1dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1dv",
          "context = %d, GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1dv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib1f(GLuint index, GLfloat x)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1f", "context = %d, GLuint index = %u, GLfloat x = %f", CID(context),
          index, x);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1f(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1f(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1f, isCallValid, context, index, x);
    }
}

void GL_APIENTRY VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1fv",
          "context = %d, GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1fv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib1s(GLuint index, GLshort x)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1s", "context = %d, GLuint index = %u, GLshort x = %d", CID(context),
          index, x);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1s(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1s(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1s, isCallValid, context, index, x);
    }
}

void GL_APIENTRY VertexAttrib1sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib1sv",
          "context = %d, GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1sv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2d", "context = %d, GLuint index = %u, GLdouble x = %f, GLdouble y = %f",
          CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2d(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2d(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2d, isCallValid, context, index, x, y);
    }
}

void GL_APIENTRY VertexAttrib2dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2dv",
          "context = %d, GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2dv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2f", "context = %d, GLuint index = %u, GLfloat x = %f, GLfloat y = %f",
          CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2f(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2f, isCallValid, context, index, x, y);
    }
}

void GL_APIENTRY VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2fv",
          "context = %d, GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2fv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib2s(GLuint index, GLshort x, GLshort y)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2s", "context = %d, GLuint index = %u, GLshort x = %d, GLshort y = %d",
          CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2s(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2s(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2s, isCallValid, context, index, x, y);
    }
}

void GL_APIENTRY VertexAttrib2sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib2sv",
          "context = %d, GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2sv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3d",
          "context = %d, GLuint index = %u, GLdouble x = %f, GLdouble y = %f, GLdouble z = %f",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3d(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3d(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3d, isCallValid, context, index, x, y, z);
    }
}

void GL_APIENTRY VertexAttrib3dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3dv",
          "context = %d, GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3dv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3f",
          "context = %d, GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3f(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3f, isCallValid, context, index, x, y, z);
    }
}

void GL_APIENTRY VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3fv",
          "context = %d, GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3fv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3s",
          "context = %d, GLuint index = %u, GLshort x = %d, GLshort y = %d, GLshort z = %d",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3s(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3s(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3s, isCallValid, context, index, x, y, z);
    }
}

void GL_APIENTRY VertexAttrib3sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib3sv",
          "context = %d, GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3sv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Nbv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nbv",
          "context = %d, GLuint index = %u, const GLbyte *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nbv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nbv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nbv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Niv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Niv",
          "context = %d, GLuint index = %u, const GLint *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Niv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Niv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Niv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Nsv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nsv",
          "context = %d, GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nsv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nsv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nsv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nub",
          "context = %d, GLuint index = %u, GLubyte x = %d, GLubyte y = %d, GLubyte z = %d, "
          "GLubyte w = %d",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nub(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4Nub(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4Nub, isCallValid, context, index, x, y, z, w);
    }
}

void GL_APIENTRY VertexAttrib4Nubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nubv",
          "context = %d, GLuint index = %u, const GLubyte *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nubv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nubv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nubv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Nuiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nuiv",
          "context = %d, GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nuiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nuiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nuiv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4Nusv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4Nusv",
          "context = %d, GLuint index = %u, const GLushort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nusv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nusv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nusv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4bv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4bv",
          "context = %d, GLuint index = %u, const GLbyte *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4bv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4bv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4bv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4d",
          "context = %d, GLuint index = %u, GLdouble x = %f, GLdouble y = %f, GLdouble z = %f, "
          "GLdouble w = %f",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4d(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4d(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4d, isCallValid, context, index, x, y, z, w);
    }
}

void GL_APIENTRY VertexAttrib4dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4dv",
          "context = %d, GLuint index = %u, const GLdouble *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4dv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4f",
          "context = %d, GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, "
          "GLfloat w = %f",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4f, isCallValid, context, index, x, y, z, w);
    }
}

void GL_APIENTRY VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4fv",
          "context = %d, GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4fv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4iv",
          "context = %d, GLuint index = %u, const GLint *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4iv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4s",
          "context = %d, GLuint index = %u, GLshort x = %d, GLshort y = %d, GLshort z = %d, "
          "GLshort w = %d",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4s(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4s(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4s, isCallValid, context, index, x, y, z, w);
    }
}

void GL_APIENTRY VertexAttrib4sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4sv",
          "context = %d, GLuint index = %u, const GLshort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4sv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4ubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4ubv",
          "context = %d, GLuint index = %u, const GLubyte *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4ubv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4ubv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4ubv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4uiv",
          "context = %d, GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4uiv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttrib4usv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttrib4usv",
          "context = %d, GLuint index = %u, const GLushort *v = 0x%016" PRIxPTR "", CID(context),
          index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4usv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4usv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4usv, isCallValid, context, index, v);
    }
}

void GL_APIENTRY VertexAttribPointer(GLuint index,
                                     GLint size,
                                     GLenum type,
                                     GLboolean normalized,
                                     GLsizei stride,
                                     const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexAttribPointer",
          "context = %d, GLuint index = %u, GLint size = %d, GLenum type = %s, GLboolean "
          "normalized = %s, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR "",
          CID(context), index, size, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                   = FromGL<VertexAttribType>(type);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexAttribPointer(context, index, size, typePacked,
                                                        normalized, stride, pointer));
        if (isCallValid)
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
        ANGLE_CAPTURE(VertexAttribPointer, isCallValid, context, index, size, typePacked,
                      normalized, stride, pointer);
    }
}
}  // namespace gl
