## RabbitMQ 3.7.9

RabbitMQ `3.7.9` is a maintenance release. It focuses on bug fixes and minor usability improvements.

### Compatibility Notes

CLI tools in this release will often produce an extra line of output, as they did in `3.6.x` releases,
when `-q` is not provided. Tools that parse CLI command output should use `-q --no-table-headers` to suppress all additional output meant for interactive use or
avoid parsing output entirely (e.g. use the HTTP API).

#### Upgrading to Erlang 21.0

When upgrading to this release **and upgrading Erlang to 21.0** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21, RabbitMQ **must be upgraded before Erlang**.

#### Documentation Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Queue deletion loaded bindings in an inefficient way.
 
   GitHub issue: [rabbitmq/rabbitmq-server#1690](https://github.com/rabbitmq/rabbitmq-server/issues/1690)

 * Heartbeat monitor now correctly sends heartbeats at half the negotiated timeout interval.
   It previously could fail to do so because it considered its own traffic to be on-the-wire
   activity from the peer.

   GitHub issue: [rabbitmq/rabbitmq-common#278](https://github.com/rabbitmq/rabbitmq-common/pull/278)

 * Nodes were using a [client] Syslog UDP socket even when [logging to Syslog](https://www.rabbitmq.com/logging.html#logging-to-syslog) was not enabled.

   GitHub issue: [rabbitmq/rabbitmq-server#1718](https://github.com/rabbitmq/rabbitmq-server/issues/1718)

 * `ERL_EPMD_PORT` was ignored when configured in `rabbitmq-env.conf`.

   GitHub issue: [rabbitmq/rabbitmq-server#1709](https://github.com/rabbitmq/rabbitmq-server/issues/1709)

 * Proxy Protocol dependency is now compatible with Erlang/OTP 21.

   GitHub issue: [rabbitmq/rabbitmq-common#269](https://github.com/rabbitmq/rabbitmq-common/issues/269)

#### Enhancements

 * It is now possible to configure [cipher suites](https://www.rabbitmq.com/ssl.html#configuring-ciphers) using new style config format.

   GitHub issue: [rabbitmq/rabbitmq-server#1712](https://github.com/rabbitmq/rabbitmq-server/issues/1712)

 * When a listener fails to start (bind to a server socket), error messages involve less context and are
   easier to read.

   GitHub issue: [rabbitmq/rabbitmq-server#1711](https://github.com/rabbitmq/rabbitmq-server/issues/1711)

 * Improved error reporting for when `erl` or `erl.exe` are no in node's `PATH`.

   GitHub issue: [rabbitmq/rabbitmq-common#275](https://github.com/rabbitmq/rabbitmq-common/pull/275)

 * 10 TLS connection acceptors are now used by default.

   GitHub issue: [rabbitmq/rabbitmq-server#1729](https://github.com/rabbitmq/rabbitmq-server/issues/1729)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl list_*` commands did not include table column headers.

   GitHub issue: [rabbitmq/rabbitmq-cli#264](https://github.com/rabbitmq/rabbitmq-cli/issues/264)

 * If `RABBITMQ_NODENAME` is configured, CLI tools will use its hostname part when generating its own
   Erlang node name.

   GitHub issue: [rabbitmq/rabbitmq-cli#270](https://github.com/rabbitmq/rabbitmq-cli/issues/270)

 * On Windows CLI tool batch scripts exited with a 0 exit code when it failed to connect to the node.

   Contributed by Artem Zinenko.

   GitHub issue: [rabbitmq/rabbitmq-server#1735](https://github.com/rabbitmq/rabbitmq-server/issues/1735).

#### Enhancements

 * `rabbitmqctl stop` now supports `--idempotent` that makes the command exit with a success when
   target node is not running.

   GitHub issue: [rabbitmq/rabbitmq-cli#272](https://github.com/rabbitmq/rabbitmq-cli/pull/272)

 * `rabbitmqctl add_vhost` is now idempotent (no longer returns an error when vhost already exists)

   GitHub issue: [rabbitmq/rabbitmq-cli#260](https://github.com/rabbitmq/rabbitmq-cli/issues/260)


### Management and Management Agent Plugins

#### Bug Fixes

 * Logo link now works better with a non-blank API endpoint prefix.

   GitHub issue: [rabbitmq/rabbitmq-management#604](https://github.com/rabbitmq/rabbitmq-management/issues/604)

 * Decimal headers and argument values are now serialised to JSON correctly.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#71](https://github.com/rabbitmq/rabbitmq-management-agent/pull/71)

#### Enhancements

 * It is now possible to configure both HTTPS and HTTP listeners using new syntax that's consistent with
   Web STOMP and Web MQTT plugins:

   ``` ini
   management.tcp.port = 15672

   management.ssl.port = 15671
   management.ssl.cacertfile = /path/to/ca_certificate.pem
   management.ssl.certfile = /path/to/server_certificate.pem
   management.ssl.keyfile = /path/to/server_key.pem   
   ```

   GitHub issue: [rabbitmq/rabbitmq-management#563](https://github.com/rabbitmq/rabbitmq-management/issues/563)

 * It is now possible to configure `Content-Security-Policy` (CSP) header set by the API.
 
   GitHub issue: [rabbitmq/rabbitmq-management#623](https://github.com/rabbitmq/rabbitmq-management/issues/623)
   
 * It is now possible to configure `Strict-Transport-Policy` (HSTS) header set by the API.
 
   GitHub issue: [rabbitmq/rabbitmq-management#624](https://github.com/rabbitmq/rabbitmq-management/issues/624)

 * `GET /api/nodes/{node}` endpoint aggregated data for other cluster nodes only to discard it later.

    GitHub issue: [rabbitmq/rabbitmq-management#615](https://github.com/rabbitmq/rabbitmq-management/issues/615)

 * When `Handle.exe` is used and returns no file handle information in its output, a warning will be logged.

    GitHub issue: [rabbitmq/rabbitmq-management-agent#67](https://github.com/rabbitmq/rabbitmq-management-agent/issues/67)


### LDAP Plugin

#### Enhancements

 * String matching queries now support multi-value results.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#100](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/100)

 * `ad_domain` and `ad_user` are new variables available in LDAP plugin queries. They are extracted from the username
   when it's in `Domain\User` format, which is typically specific to ActiveDirectory.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#98](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/98)

 * Search queries that return referrals will result in an error instead of an exception.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#97](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/97)


### Web STOMP Plugin

#### Enhancements

 * Advanced WebSocket options now can be configured. Compression is enabled by default.
   Compression won't be used with clients that do not support it.

   GitHub issues: [rabbitmq/rabbitmq-web-stomp#89](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/89), [rabbitmq/rabbitmq-web-stomp#90](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/90)


### Web MQTT Plugin

#### Bug Fixes

 * WebSocket `PING` frames are now ignored instead of being propagated to MQTT frame handler.

  GitHub issue: [rabbitmq/rabbitmq-web-mqtt#32](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/32)

#### Enhancements

* Advanced WebSocket options now can be configured. Compression is enabled by default.
  Compression won't be used with clients that do not support it.

  GitHub issues: [rabbitmq/rabbitmq-web-mqtt#34](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/34)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * EC2 API endpoint requests used an unreasonably low timeout (100 ms). The new value
   is 10 seconds.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-aws#24](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/issues/24)


### Consul Peer Discovery Plugin

#### Bug Fixes

 * It wasn't possible to specify Consul service tags via new style config format.

  GitHub issue: [rabbitmq/rabbitmq-peer-discovery-consul#18](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/18)

 * It wasn't possible to configure lock key prefix via new style config format.

  GitHub issues: [rabbitmq/rabbitmq-peer-discovery-consul#16](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/16)

#### Enhancements

* Lock acquisition timeout now can be configured using `cluster_formation.consul.lock_timeout` as well as `cluster_formation.consul.lock_wait_time` (an alias),
  to be consistent with the Etcd implementation.

  GitHub issue: [rabbitmq/rabbitmq-peer-discovery-consul#20](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/pull/20)


### Etcd Peer Discovery Plugin

#### Enhancements

 * Lock acquisition timeout now can be configured using `cluster_formation.etcd.lock_timeout` as well as `cluster_formation.etcd.lock_wait_time` (an alias),
   to be consistent with the Consul implementation.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-etcd#16](https://github.com/rabbitmq/rabbitmq-peer-discovery-etcd/pull/16)


### Event Exchange Plugin

#### Enhancements

 * Throughput optimizations reduce probability of high memory consumption by `rabbit_event` processes due to
   event backlog accumulation.

   GitHub issue: [rabbitmq/rabbitmq-server#1722](https://github.com/rabbitmq/rabbitmq-server/issues/1722)


### RPM Package

#### Bug Fixes

 * Post-installation script renamed `rabbitmq.conf` to `rabbitmq-env.conf`. A long time ago `rabbitmq.conf` was used to configure
   environment variables (like `rabbitmq-env.conf` today) and old post-installation steps were not removed when `rabbitmq.conf`
   was re-adopted for new style config files.

   GitHub issue: [rabbitmq/rabbitmq-server-release#87](https://github.com/rabbitmq/rabbitmq-server-release/issues/87)
