/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp.h"
#include "ntp_calendar.h"
#include "ntp_stdlib.h"
#include "ntp_leapsec.h"
#include "test-libntp.h"
#include <string.h>

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_ValidateGood(void);
extern void test_ValidateNoHash(void);
extern void test_ValidateBad(void);
extern void test_ValidateMalformed(void);
extern void test_ValidateMalformedShort(void);
extern void test_ValidateNoLeadZero(void);
extern void test_tableSelect(void);
extern void test_loadFileExpire(void);
extern void test_loadFileTTL(void);
extern void test_lsQueryPristineState(void);
extern void test_ls2009faraway(void);
extern void test_ls2009weekaway(void);
extern void test_ls2009houraway(void);
extern void test_ls2009secaway(void);
extern void test_ls2009onspot(void);
extern void test_ls2009nodata(void);
extern void test_ls2009limdata(void);
extern void test_qryJumpFarAhead(void);
extern void test_qryJumpAheadToTransition(void);
extern void test_qryJumpAheadOverTransition(void);
extern void test_addDynamic(void);
extern void test_taiEmptyTable(void);
extern void test_taiTableFixed(void);
extern void test_taiTableDynamic(void);
extern void test_taiTableDynamicDeadZone(void);
extern void test_ls2009seqInsElectric(void);
extern void test_ls2009seqInsDumb(void);
extern void test_ls2009seqDelElectric(void);
extern void test_ls2009seqDelDumb(void);
extern void test_ls2012seqInsElectric(void);
extern void test_ls2012seqInsDumb(void);
extern void test_lsEmptyTableDumb(void);
extern void test_lsEmptyTableElectric(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("leapsec.c");
  RUN_TEST(test_ValidateGood, 331);
  RUN_TEST(test_ValidateNoHash, 338);
  RUN_TEST(test_ValidateBad, 345);
  RUN_TEST(test_ValidateMalformed, 352);
  RUN_TEST(test_ValidateMalformedShort, 359);
  RUN_TEST(test_ValidateNoLeadZero, 366);
  RUN_TEST(test_tableSelect, 378);
  RUN_TEST(test_loadFileExpire, 414);
  RUN_TEST(test_loadFileTTL, 431);
  RUN_TEST(test_lsQueryPristineState, 463);
  RUN_TEST(test_ls2009faraway, 475);
  RUN_TEST(test_ls2009weekaway, 492);
  RUN_TEST(test_ls2009houraway, 509);
  RUN_TEST(test_ls2009secaway, 526);
  RUN_TEST(test_ls2009onspot, 543);
  RUN_TEST(test_ls2009nodata, 560);
  RUN_TEST(test_ls2009limdata, 577);
  RUN_TEST(test_qryJumpFarAhead, 598);
  RUN_TEST(test_qryJumpAheadToTransition, 620);
  RUN_TEST(test_qryJumpAheadOverTransition, 642);
  RUN_TEST(test_addDynamic, 668);
  RUN_TEST(test_taiEmptyTable, 846);
  RUN_TEST(test_taiTableFixed, 858);
  RUN_TEST(test_taiTableDynamic, 870);
  RUN_TEST(test_taiTableDynamicDeadZone, 896);
  RUN_TEST(test_ls2009seqInsElectric, 916);
  RUN_TEST(test_ls2009seqInsDumb, 959);
  RUN_TEST(test_ls2009seqDelElectric, 1007);
  RUN_TEST(test_ls2009seqDelDumb, 1050);
  RUN_TEST(test_ls2012seqInsElectric, 1092);
  RUN_TEST(test_ls2012seqInsDumb, 1135);
  RUN_TEST(test_lsEmptyTableDumb, 1184);
  RUN_TEST(test_lsEmptyTableElectric, 1209);

  return (UnityEnd());
}
