/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;

public final class SimpleContentOutputter
extends Outputter {
    private StringBuffer buffer;
    private int ignoreElements = 0;

    public SimpleContentOutputter(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (charSequence == null) {
            return;
        }
        if (this.ignoreElements == 0) {
            this.buffer.append(charSequence.toString());
        }
        this.previousAtomic = false;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        this.recoverableError();
        ++this.ignoreElements;
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws TransformerException {
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void startContent() {
    }

    public void endElement() throws TransformerException {
        --this.ignoreElements;
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void append(Item item) throws TransformerException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", 0);
            }
            this.characters(item.getStringValue(), 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item item2;
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2);
            }
        } else {
            Item item3;
            SequenceIterator sequenceIterator = item.getTypedValue();
            while ((item3 = sequenceIterator.next()) != null) {
                this.characters(item3.getStringValue(), 0);
            }
            this.previousAtomic = false;
        }
    }

    public void endDocument() throws TransformerException {
        this.previousAtomic = false;
    }

    private void recoverableError() throws TransformerException {
        throw new SkipInstructionException("Non-text output nodes are ignored when writing a text node, attribute, comment, or PI");
    }
}

