; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-linux -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X64

; VCVTTPD2DQS
define <8 x i32> @test_signed_v8i32_v8f64(<8 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v8i32_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dqs %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <8 x i32> @llvm.fptosi.sat.v8i32.v8f64(<8 x double> %f)
  ret <8 x i32> %x
}

; VCVTTPD2QQS
define <8 x i64> @test_signed_v8i64_v8f64(<8 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v8i64_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2qqs %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f64(<8 x double> %f)
  ret <8 x i64> %x
}

; VCVTTPD2UDQS
define <8 x i32> @test_unsigned_v8i32_v8f64(<8 x double> %f) nounwind {
; CHECK-LABEL: test_unsigned_v8i32_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2udqs %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <8 x i32> @llvm.fptoui.sat.v8i32.v8f64(<8 x double> %f)
 ret <8 x i32> %x
}

; VCVTTPD2UQQS
define <8 x i64> @test_unsigned_v8i64_v8f64(<8 x double> %f) nounwind {
; CHECK-LABEL: test_unsigned_v8i64_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2uqqs %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <8 x i64> @llvm.fptoui.sat.v8i64.v8f64(<8 x double> %f)
  ret <8 x i64> %x
}

; VCVTTPS2DQS
define <16 x i32> @test_signed_v16i32_v16f32(<16 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v16i32_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dqs %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <16 x i32> @llvm.fptosi.sat.v16i32.v16f32(<16 x float> %f)
  ret <16 x i32> %x
}

; VCVTTPS2UDQS
define <16 x i32> @test_unsigned_v16i32_v16f32(<16 x float> %f) nounwind {
; CHECK-LABEL: test_unsigned_v16i32_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2udqs %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <16 x i32> @llvm.fptoui.sat.v16i32.v16f32(<16 x float> %f)
  ret <16 x i32> %x
}
; VCVTTPS2QQS
define <8 x i64> @test_signed_v8i64_v8f32(<8 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v8i64_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2qqs %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <8 x i64> @llvm.fptosi.sat.v8i64.v8f32(<8 x float> %f)
  ret <8 x i64> %x
}

; VCVTTPS2UQQS
define <8 x i64> @test_unsigned_v8i64_v8f32(<8 x float> %f) nounwind {
; CHECK-LABEL: test_unsigned_v8i64_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2uqqs %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %x = call  <8 x i64> @llvm.fptoui.sat.v8i64.v8f32(<8 x float> %f)
  ret <8 x i64> %x
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X64: {{.*}}
; X86: {{.*}}
