/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: LayoutEngineChecksFactory.java 1094690 2011-04-18 18:36:05Z vhennebert $ */

package org.apache.fop.layoutengine;

import org.w3c.dom.Element;

import org.apache.fop.check.ChecksFactory;

/**
 * A factory class for creating {@link LayoutEngineCheck} instances.
 */
final class LayoutEngineChecksFactory extends ChecksFactory<LayoutEngineCheck> {

    LayoutEngineChecksFactory() {
        registerCheckFactory("true", new CheckFactory<LayoutEngineCheck>() {

            public LayoutEngineCheck createCheck(Element element) {
                return new TrueCheck(element);
            }

        });
        registerCheckFactory("eval", new CheckFactory<LayoutEngineCheck>() {

            public LayoutEngineCheck createCheck(Element element) {
                return new EvalCheck(element);
            }

        });
        registerCheckFactory("element-list", new CheckFactory<LayoutEngineCheck>() {

            public LayoutEngineCheck createCheck(Element element) {
                return new ElementListCheck(element);
            }

        });
        registerCheckFactory("result", new CheckFactory<LayoutEngineCheck>() {

            public LayoutEngineCheck createCheck(Element element) {
                return new ResultCheck(element);
            }

        });
    }

}
